/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.shortlink;

import cc.lechun.active.entity.active.MallUrlEntity;
import cc.lechun.active.iservice.shortlink.ShortLinkInterface;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.shortlink.UrlVisitMapper;
import cc.lechun.mall.entity.shortlink.UrlVisitEntity;
import cc.lechun.mall.iservice.shortlink.UrlVisitInterface;
import javax.annotation.Resource;
import nl.bitwalker.useragentutils.Browser;
import nl.bitwalker.useragentutils.OperatingSystem;
import nl.bitwalker.useragentutils.UserAgent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class UrlVisitService
extends BaseService<UrlVisitEntity, Integer>
implements UrlVisitInterface {
    @Resource
    private UrlVisitMapper urlVisitMapper;
    @Autowired
    private ShortLinkInterface shortLinkInterface;

    @Override
    @Async
    public void saveUrlVisit(String ua, String ip, String key, String referrer) {
        UserAgent userAgent = UserAgent.parseUserAgentString((String)ua);
        Browser browser = userAgent.getBrowser();
        OperatingSystem os = userAgent.getOperatingSystem();
        String system = os.getName();
        String browserName = browser.getName();
        this.logger.info("\u6d4f\u89c8\u5668:{},os:{} ,key={}", new Object[]{browserName, os.getName(), key});
        UrlVisitEntity urlVisitEntity = new UrlVisitEntity();
        MallUrlEntity result = this.shortLinkInterface.getMallUrlEntity(key);
        urlVisitEntity.setUrl(result != null ? result.getUrl() : "");
        urlVisitEntity.setUpdateTime(result.getUpdateTime());
        urlVisitEntity.setUrlName(result.getUrlName());
        urlVisitEntity.setBrowser(browserName);
        urlVisitEntity.setCreateTime(DateUtils.now());
        urlVisitEntity.setIp(ip);
        urlVisitEntity.setReferrer(StringUtils.isNotEmpty((String)referrer) ? referrer : "");
        urlVisitEntity.setOs(system);
        urlVisitEntity.setUrlKey(key);
        this.logger.info("\u4fdd\u5b58\u77ed\u8fde\u63a5\u8bbf\u95ee:{}", (Object)(this.urlVisitMapper.insert(urlVisitEntity) > 0 ? "\u4fdd\u5b58\u6210\u529f" : "\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u7a0d\u5019\u91cd\u8bd5"));
    }
}

