/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.trade.MallOrderGroupProductMapper;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.trade.MallOrderGroupProductEntity;
import cc.lechun.mall.iservice.trade.MallOrderGroupProductInterface;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallOrderGroupProductService
extends BaseService
implements MallOrderGroupProductInterface {
    @Autowired
    private MallOrderGroupProductMapper orderGroupProductMapper;

    @Override
    public MallOrderGroupProductEntity buildOrderGroupProductEntity(MallProductVO productVO, MallGroupVO groupVO, String orderMainNo, String orderNo, String orderProductNo) {
        MallOrderGroupProductEntity groupProductEntity = new MallOrderGroupProductEntity();
        int quantity = groupVO == null ? productVO.getCount() : productVO.getCount() * groupVO.getCount();
        groupProductEntity.setUnitPrice(productVO.getFactPrice());
        groupProductEntity.setGroupId(groupVO == null ? "" : groupVO.getGroupId());
        groupProductEntity.setGroupType(groupVO == null ? 4 : 2);
        groupProductEntity.setOrderGroupId(String.valueOf(IDGenerate.getUniqueID()));
        groupProductEntity.setOrderMainNo(orderMainNo);
        groupProductEntity.setOrderNo(orderNo);
        groupProductEntity.setOrderProductNo(orderProductNo);
        groupProductEntity.setProductId(productVO.getProId());
        groupProductEntity.setProductName(productVO.getProName());
        groupProductEntity.setQuantity(quantity);
        groupProductEntity.setOriginPrice(new BigDecimal(productVO.getProPrice()));
        groupProductEntity.setOriginPriceSum(PriceUtils.multiply((BigDecimal)groupProductEntity.getUnitPrice(), (Integer)quantity));
        return groupProductEntity;
    }

    @Override
    public boolean insertOrderGroupProduct(MallOrderGroupProductEntity orderGroupProductEntity) {
        int i = this.orderGroupProductMapper.insertSelective(orderGroupProductEntity);
        return i == 1;
    }

    @Override
    public List<MallOrderGroupProductEntity> getOrderGroupProductList(String orderProductNo) {
        MallOrderGroupProductEntity orderGroupProductEntity = new MallOrderGroupProductEntity();
        orderGroupProductEntity.setOrderProductNo(orderProductNo);
        return this.orderGroupProductMapper.getList(orderGroupProductEntity);
    }

    @Override
    public List<MallOrderGroupProductEntity> getOrderGroupProductListByOrderNo(String orderNo) {
        MallOrderGroupProductEntity orderGroupProductEntity = new MallOrderGroupProductEntity();
        orderGroupProductEntity.setOrderNo(orderNo);
        return this.orderGroupProductMapper.getList(orderGroupProductEntity);
    }

    @Override
    public List<MallOrderGroupProductEntity> getOrderGroupProductListByMianOrderNo(String orderMainNo) {
        MallOrderGroupProductEntity orderGroupProductEntity = new MallOrderGroupProductEntity();
        orderGroupProductEntity.setOrderMainNo(orderMainNo);
        List list = this.orderGroupProductMapper.getList(orderGroupProductEntity);
        if (list == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u8ba2\u5355\u5546\u54c1");
        }
        return list;
    }

    @Override
    public void deleteByOrderNo(String orderNo) {
        this.orderGroupProductMapper.deleteByOrderNo(orderNo);
    }

    @Override
    public MallOrderGroupProductEntity getOrderGroupProductByID(String orderGroupProductId) {
        return (MallOrderGroupProductEntity)this.orderGroupProductMapper.selectByPrimaryKey((Serializable)((Object)orderGroupProductId));
    }

    @Override
    public void updateOrderGroupProductByID(MallOrderGroupProductEntity orderProduct) {
        this.orderGroupProductMapper.updateByPrimaryKeySelective(orderProduct);
    }

    @Override
    public List<MallOrderGroupProductEntity> getOrderGroupProductListByOrderNoAndProductId(String orderNo, String productId) {
        MallOrderGroupProductEntity param = new MallOrderGroupProductEntity();
        param.setOrderNo(orderNo);
        param.setProductId(productId);
        return this.orderGroupProductMapper.getList(param);
    }

    @Override
    public Double getOrderGroupProductCardPrice(String orderGroupId) {
        if (StringUtils.isEmpty((String)orderGroupId)) {
            return 0.0;
        }
        MallOrderGroupProductEntity mallOrderGroupProductEntity = (MallOrderGroupProductEntity)this.orderGroupProductMapper.selectByPrimaryKey((Serializable)((Object)orderGroupId));
        return mallOrderGroupProductEntity == null ? 0.0 : mallOrderGroupProductEntity.getCardPrice().doubleValue();
    }
}

