/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.apiinvoke.oms.WxOrderClient;
import cc.lechun.common.enums.sales.TransportTypeEnum;
import cc.lechun.common.enums.trade.OrderClassEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.jqgridData.JqGridData;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.database.util.SpringContextUtil;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.sales.MallPromotionProductEntity;
import cc.lechun.mall.entity.trade.CancelOrderVo;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderMainMessageVo;
import cc.lechun.mall.entity.trade.MallOrderProductEntity;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.entity.trade.OrderListVo;
import cc.lechun.mall.favorstrategy.OrderFavorStrategy;
import cc.lechun.mall.favorstrategy.OrderFavorStrategyCollageNewUser;
import cc.lechun.mall.favorstrategy.OrderFavorStrategyDiscountCollageMulUser;
import cc.lechun.mall.favorstrategy.OrderFavorStrategyEnum;
import cc.lechun.mall.iservice.deliver.MallDeliverConfigClassInterface;
import cc.lechun.mall.iservice.deliver.MallDeliverConfigDetailInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionProductInterface;
import cc.lechun.mall.iservice.shoppingcart.MallPriceCalcInterface;
import cc.lechun.mall.iservice.trade.MallOrderGroupProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderSyncInfoInterface;
import cc.lechun.mall.iservice.trade.MallTradeCommonInterface;
import cc.lechun.mall.iservice.trade.MiniShopOrderInterface;
import cc.lechun.mall.service.trade.cache.MallOrderMainCacheService;
import cc.lechun.omsv2.entity.order.origin.vo.OriginOrderProductVO;
import cc.lechun.omsv2.entity.order.origin.vo.OriginOrderVO;
import cc.lechun.omsv2.entity.order.third.weixin.request.WxOrderRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MallOrderMainService
extends MallOrderMainCacheService
implements MallOrderMainInterface {
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private PlatFormInterface platFormInterface;
    @Autowired
    private MallOrderInterface orderInterface;
    @Autowired
    private MallOrderProductInterface orderProductInterface;
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    private MallPriceCalcInterface priceCalcInterface;
    @Autowired
    private MallPromotionProductInterface promotionProductInterface;
    @Autowired
    private MallDeliverConfigClassInterface deliverConfigClassInterface;
    @Autowired
    private MallDeliverConfigDetailInterface deliverConfigDetailInterface;
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private MallTradeCommonInterface tradeCommonInterface;
    @Autowired
    private MallOrderSyncInfoInterface orderSyncInfoService;
    @Autowired
    private MallOrderGroupProductInterface orderGroupProductService;
    @Autowired
    private MiniShopOrderInterface miniShopOrderInterface;
    @Autowired
    private WxOrderClient wxOrderClient;
    @Lazy
    @Autowired
    private MallOrderPayInterface orderPayInterface;

    @Override
    public List<MallOrderMainEntity> getMallOrderMainEntityList(Date date, int orderClass, int start, int end) {
        return this.mallOrderMainMapper.getMallOrderMainEntityList(date, orderClass, start, end);
    }

    @Override
    public List<MallOrderMainEntity> getMallOrderMainEntityList(String sourceOrderMainNo) {
        MallOrderMainEntity mallOrderMainEntity = new MallOrderMainEntity();
        mallOrderMainEntity.setSourceOrderNo(sourceOrderMainNo);
        return this.mallOrderMainMapper.getList(mallOrderMainEntity);
    }

    @Override
    public BaseJsonVo<List<MallOrderMainEntity>> updateOrderMainStatusBySourceOrderNo(String sourceOrderMainNo, Integer status) {
        MallOrderMainEntity mallOrderMainEntity = new MallOrderMainEntity();
        mallOrderMainEntity.setSourceOrderNo(sourceOrderMainNo);
        List orderMainEntityList = this.mallOrderMainMapper.getList(mallOrderMainEntity);
        this.logger.info("\u6839\u636e\u6e90\u5355\u67e5\u627e\u5230\u7684\u8ba2\u5355:{}", (Object)JsonUtils.toJson((Object)orderMainEntityList, (boolean)false));
        if (CollectionUtils.isNotEmpty((Collection)orderMainEntityList)) {
            for (MallOrderMainEntity orderMainEntity : orderMainEntityList) {
                this.updateOrderMainStatus(orderMainEntity, OrderStatusEnum.PAYCONFIRM.getName(), 1);
            }
        }
        return BaseJsonVo.success((Object)orderMainEntityList);
    }

    @Override
    public boolean updateOrderMain(MallOrderMainEntity orderMainEntity) {
        int i = this.mallOrderMainMapper.updateByPrimaryKeySelective(orderMainEntity);
        return i == 1;
    }

    @Override
    public boolean insertOrderMain(MallOrderMainEntity orderMainEntity) {
        int i = this.mallOrderMainMapper.insertSelective(orderMainEntity);
        return i == 1;
    }

    @Override
    public boolean deleteOrderMain(String orderMainNo, String customerId) {
        MallOrderMainEntity orderMainEntity = (MallOrderMainEntity)this.mallOrderMainMapper.selectByPrimaryKey((Serializable)((Object)orderMainNo));
        if (orderMainEntity.getStatus() == 0 || this.orderPayInterface.checkMilkCardOrder(orderMainNo)) {
            return this.updateOrderMainStatus(orderMainNo, OrderStatusEnum.DELETE.getName(), customerId, orderMainEntity.getStatus(), new Date());
        }
        return false;
    }

    @Override
    @Transactional
    public boolean cancelOrderMain(String orderMainNo, String customerId) {
        MallOrderMainEntity orderMainEntity = (MallOrderMainEntity)this.mallOrderMainMapper.selectByPrimaryKey((Serializable)((Object)orderMainNo));
        if (orderMainEntity.getStatus() != 1) {
            return false;
        }
        try {
            boolean b = this.updateOrderMainStatus(orderMainNo, OrderStatusEnum.CANCEL.getName(), customerId, orderMainEntity.getStatus(), new Date());
            if (!b) {
                throw new RuntimeException();
            }
            List<MallOrderEntity> orderEntities = this.orderInterface.getOrderList(orderMainNo);
            if (orderEntities != null) {
                for (MallOrderEntity o : orderEntities) {
                    if (this.orderInterface.cancelOrder(o.getOrderNo(), customerId)) continue;
                    throw new RuntimeException();
                }
            }
            return true;
        }
        catch (RuntimeException e) {
            this.logger.error(e.toString());
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean paySuccessOrderMain(String orderMainNo, boolean enbleDelivery) {
        MallOrderMainEntity orderMainEntity = (MallOrderMainEntity)this.mallOrderMainMapper.selectByPrimaryKey((Serializable)((Object)orderMainNo));
        String newStatusName = OrderStatusEnum.PAYCONFIRM.getName();
        if (orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.TEAM_BUY.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.COMMUNITY_GROUP.getValue()) {
            newStatusName = OrderStatusEnum.UNCONFIRM.getName();
        }
        this.logger.info("\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u4e2d\uff1a" + orderMainNo);
        boolean b = this.updateOrderMainStatus(orderMainNo, newStatusName, orderMainEntity.getCustomerId(), orderMainEntity.getStatus(), new Date());
        if (b) {
            List<MallOrderEntity> orderEntities = this.orderInterface.getOrderList(orderMainNo);
            for (MallOrderEntity o : orderEntities) {
                if (this.orderInterface.paySuccessOrder(o.getOrderNo(), newStatusName)) continue;
                throw new RuntimeException("\u66f4\u65b0\u5b50\u8ba2\u5355\u5f02\u5e38");
            }
        }
        return b;
    }

    @Override
    public boolean paySuccessOrderMain(String orderMainNo) {
        return this.paySuccessOrderMain(orderMainNo, true);
    }

    @Override
    public boolean updateOrderMainStatus(String orderMainNo, String orderStatus, int oldStatus) {
        MallOrderMainEntity orderMainEntity = (MallOrderMainEntity)this.mallOrderMainMapper.selectByPrimaryKey((Serializable)((Object)orderMainNo));
        return this.updateOrderMainStatus(orderMainEntity, orderStatus, oldStatus);
    }

    @Override
    public boolean updateOrderMainStatus(MallOrderMainEntity orderMainEntity, String orderStatus, int oldStatus) {
        this.logger.info("\u66f4\u65b0\u8ba2\u5355{}\u72b6\u6001\u4e2d\uff1a", (Object)orderMainEntity.getOrderMainNo());
        boolean b = this.updateOrderMainStatus(orderMainEntity.getOrderMainNo(), orderStatus, orderMainEntity.getCustomerId(), orderMainEntity.getStatus(), new Date());
        if (b) {
            List<MallOrderEntity> orderEntities = this.orderInterface.getOrderList(orderMainEntity.getOrderMainNo());
            for (MallOrderEntity o : orderEntities) {
                if (this.orderInterface.paySuccessOrder(o.getOrderNo(), orderStatus)) continue;
                throw new RuntimeException("\u66f4\u65b0\u5b50\u8ba2\u5355\u5f02\u5e38");
            }
        }
        return b;
    }

    @Override
    public boolean updateOrderMainStatus(String orderMainNo, String orderStatus, String customerId, int oldStatus, Date date) {
        this.logger.info("\u66f4\u6539\u8ba2\u5355\u72b6\u6001\uff1a\u8ba2\u5355\u53f7\uff1a" + orderMainNo + ",\u72b6\u6001\uff1a" + orderStatus + ",\u7528\u6237\uff1a" + customerId + ",\u8001\u72b6\u6001\uff1a" + oldStatus);
        Integer status = OrderStatusEnum.getValue(orderStatus);
        if (status == null) {
            return false;
        }
        MallOrderMainEntity orderMainEntity = this.tradeCommonInterface.getUpdateStatusOrderMainEntity(orderMainNo, status, oldStatus, date);
        if (orderMainEntity == null) {
            return false;
        }
        return this.updateOrderMain(orderMainEntity);
    }

    @Override
    public BaseJsonVo buildOrderMainEntity(MallMainOrderVo mainOrderVo) {
        String message = "";
        try {
            MallOrderMainEntity orderMainEntity = new MallOrderMainEntity();
            orderMainEntity.setCompleteTime(null);
            orderMainEntity.setPayTime(null);
            orderMainEntity.setCacheId(mainOrderVo.getOrderCacheVo().getCacheId());
            orderMainEntity.setConfirmPaytime(null);
            orderMainEntity.setCustomerId(mainOrderVo.getCustomerId());
            if (StringUtils.isNotEmpty((String)mainOrderVo.getOrderCacheVo().getBindCode())) {
                orderMainEntity.setBindCode(mainOrderVo.getOrderCacheVo().getBindCode());
                if (mainOrderVo.getOrderCacheVo().getBindCode().length() > 3) {
                    orderMainEntity.setActiveNo(StringUtils.isEmpty((String)mainOrderVo.getOrderCacheVo().getBindCode()) ? "" : this.activeInterface.getActiveNoByBindCode(mainOrderVo.getOrderCacheVo().getBindCode()));
                }
            }
            orderMainEntity.setBuyFlag(mainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.LONGPERIOD_BUY.getValue() ? 1 : 0);
            orderMainEntity.setBuyType((short)(mainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.PLEASE_MILK_CHANGE.getValue() ? 3 : 0));
            orderMainEntity.setCancelReason("");
            orderMainEntity.setCancelTime(null);
            orderMainEntity.setChannelId(mainOrderVo.getChannelId());
            orderMainEntity.setChannelOrderNo("");
            orderMainEntity.setCookieBindCode(mainOrderVo.getOrderCacheVo().getCookieBindCode());
            orderMainEntity.setCreateTime(DateUtils.now());
            orderMainEntity.setCustomerId(mainOrderVo.getCustomerId());
            orderMainEntity.setDeleteTime(null);
            orderMainEntity.setDeliverCount(mainOrderVo.getMallOrderVos().size());
            orderMainEntity.setDeliverPeriod(mainOrderVo.getMallOrderVos().get(0).getDeliverPeriod());
            orderMainEntity.setFreight(mainOrderVo.getFreight());
            orderMainEntity.setFxUserId("");
            orderMainEntity.setGiftType(mainOrderVo.getOrderCacheVo().getGiftType());
            orderMainEntity.setImportSensorFlag((short)0);
            orderMainEntity.setImportTime(null);
            orderMainEntity.setInvoiceContent("");
            orderMainEntity.setInvoiceFlag((short)2);
            orderMainEntity.setInvoiceTitle("");
            orderMainEntity.setInvoiceType(0);
            orderMainEntity.setOrderAmount(mainOrderVo.getOrderAmount());
            orderMainEntity.setOrderClass(this.tradeCommonInterface.orderSourceConvertOrderClass(mainOrderVo));
            orderMainEntity.setOrderMainNo(mainOrderVo.getMainOrderNo());
            orderMainEntity.setOrderType((short)1);
            orderMainEntity.setPayAmount(mainOrderVo.getPayAmount());
            orderMainEntity.setPayTime(null);
            orderMainEntity.setPlatformGroupId(this.platFormInterface.getPlatFormGroupId(mainOrderVo.getPlatFormId()));
            orderMainEntity.setOrderSource(mainOrderVo.getOrderCacheVo().getOrderSource());
            orderMainEntity.setPlatformId(mainOrderVo.getPlatFormId());
            orderMainEntity.setQuantity(mainOrderVo.getQuantity());
            orderMainEntity.setReleaseSystemId("");
            orderMainEntity.setRemark2("");
            orderMainEntity.setSoldDeptId(1);
            orderMainEntity.setSoldTypeId(1);
            orderMainEntity.setSourceOrderNo(mainOrderVo.getOrderCacheVo().getSourceOrderNo());
            orderMainEntity.setStatus(1);
            orderMainEntity.setSubBindCode("");
            orderMainEntity.setTotalAmount(mainOrderVo.getTotalAmount());
            orderMainEntity.setUserTerminal(mainOrderVo.getPlatFormId());
            orderMainEntity.setVersionDetailId(mainOrderVo.getOrderCacheVo().getVersionDetailId());
            orderMainEntity.setDeliverType(mainOrderVo.getMallOrderVos().get(0).getDeliverType());
            orderMainEntity.setMiniShop(this.miniShopOrderInterface.checkMiniShopScene(mainOrderVo.getPlatFormId(), mainOrderVo.getOrderCacheVo().getScene()) != false ? 1 : 0);
            orderMainEntity.setScene(mainOrderVo.getOrderCacheVo().getScene());
            orderMainEntity.setVipCutAmount(mainOrderVo.getVipDiffPrice());
            orderMainEntity.setVipLevel(mainOrderVo.getLevel());
            orderMainEntity.setRemark(mainOrderVo.getRemark());
            this.logger.info("*******checkMiniShopScene*******{}\u68c0\u6d4b\u573a\u666f\u503c{}\u7ed3\u679c\uff1a{},vipLevel:{},remark:{}", new Object[]{orderMainEntity.getOrderMainNo(), mainOrderVo.getOrderCacheVo().getScene(), orderMainEntity.getMiniShop(), mainOrderVo.getLevel(), mainOrderVo.getRemark()});
            orderMainEntity.setPromtionCutAmount(mainOrderVo.getPromotionDiffPrice());
            orderMainEntity.setExchangeCutAmount(mainOrderVo.getExchangeCutPrice());
            orderMainEntity.setFullCutAmount(mainOrderVo.getFullcutAmount());
            orderMainEntity.setNcpBat(mainOrderVo.getOrderCacheVo().getNcpBat());
            orderMainEntity.setChanId(mainOrderVo.getOrderCacheVo().getChanId());
            orderMainEntity.setIsshow(orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.SPLITE_CARD_ORDER.getValue() || orderMainEntity.getOrderClass().intValue() == OrderClassEnum.SPLITE_DELIVERY_ORDER.getValue() ? (short)0 : 1);
            if (orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.RECHANGE_CARD.getValue()) {
                orderMainEntity.setPoints(mainOrderVo.getCardOrderAmount());
                orderMainEntity.setPointCut(null);
                orderMainEntity.setCardCut(mainOrderVo.getUseCardCutSum());
            } else {
                orderMainEntity.setPoints(mainOrderVo.getUseCardPointPrice().compareTo(BigDecimal.ZERO) > 0 ? (orderMainEntity.getOrderClass().intValue() == OrderClassEnum.BUY_CARD_CUT_ORDER.getValue() || orderMainEntity.getOrderClass().intValue() == OrderClassEnum.SPLITE_DELIVERY_ORDER.getValue() ? mainOrderVo.getUseCardPointPrice() : BigDecimal.ZERO) : BigDecimal.ZERO);
                orderMainEntity.setPointCut(orderMainEntity.getOrderClass().intValue() == OrderClassEnum.BUY_CARD_CUT_ORDER.getValue() || orderMainEntity.getOrderClass().intValue() == OrderClassEnum.SPLITE_DELIVERY_ORDER.getValue() ? mainOrderVo.getUseCardCutAmount() : BigDecimal.ZERO);
            }
            this.logger.info("\u8ba2\u5355:{}\u652f\u4ed8\u70b9\u6570:{},\u70b9\u5361\u7701:{}", new Object[]{orderMainEntity.getOrderMainNo(), mainOrderVo.getCardOrderAmount(), orderMainEntity.getPointCut()});
            return BaseJsonVo.success((Object)orderMainEntity);
        }
        catch (Exception e) {
            message = "\u521b\u5efa\u8ba2\u5355\u5bf9\u8c61\u5f02\u5e38";
            this.logger.error(message, (Throwable)e);
            return BaseJsonVo.error((String)message);
        }
    }

    @Override
    public MallOrderMainEntity getLastOrder(String customerId) {
        return this.mallOrderMainMapper.getLastOrder(customerId);
    }

    @Override
    public MallMainOrderVo getMainOrderVo(int platFormId, String customerId, List<MallOrderVo> orderVosIn, MallOrderCacheVo orderCacheVo) {
        this.logger.info("\u7528\u6237:{} \u67e5\u8be2getMainOrderVo \u5f00\u59cb", (Object)customerId);
        MallMainOrderVo mallMainOrderVo = new MallMainOrderVo();
        mallMainOrderVo.setOrderCacheVo(orderCacheVo);
        for (MallOrderVo orderVo : orderVosIn) {
            orderVo.setTransportType(this.productInterface.getTransportType(orderVo));
            if (orderVo.getOrderSource() == OrderSourceEnum.PLEASE_MILK_CHANGE.getValue() && (orderVo.getDeliverCount() != 1 || orderVo.getDeliverPeriod() != 1)) {
                mallMainOrderVo.setBaseError("\u793c\u54c1\u5151\u6362\u53ea\u80fd\u914d\u9001\u4e00\u6b21");
                return mallMainOrderVo;
            }
            if (orderVo.getDeliverPeriod() > 30 || orderVo.getDeliverPeriod() < 0) {
                mallMainOrderVo.setBaseError("\u914d\u9001\u6570\u636e\u5f02\u5e38-\u914d\u9001\u95f4\u9694\u4e0d\u6b63\u786e");
                return mallMainOrderVo;
            }
            if (orderVo.getDeliverCount() > 100) {
                mallMainOrderVo.setBaseError("\u914d\u9001\u6570\u636e\u5f02\u5e38-\u914d\u9001\u6b21\u6570\u4e0d\u80fd\u8d85\u8fc7100\u6b21");
                return mallMainOrderVo;
            }
            if (orderVo.isBaseSuccess()) continue;
            mallMainOrderVo.setBaseError(orderVo.getBaseErrMsg());
            return mallMainOrderVo;
        }
        this.priceCalcInterface.totalOrderPrice(orderVosIn, null);
        mallMainOrderVo.setCustomerId(customerId);
        mallMainOrderVo.setPlatFormId(platFormId);
        mallMainOrderVo.setMallOrderVos(orderVosIn);
        if (orderCacheVo.getChannel() != null) {
            mallMainOrderVo.setChannelId(orderCacheVo.getChannel());
        } else {
            mallMainOrderVo.setChannelId(this.tradeCommonInterface.platformConvertChannel(platFormId));
        }
        if (mallMainOrderVo.getChannelId() == 0) {
            mallMainOrderVo.setBaseError("\u6e20\u9053\u6ca1\u6709\u5b9a\u4e49");
            return mallMainOrderVo;
        }
        mallMainOrderVo.setQuantity(orderVosIn.stream().mapToInt(e -> e.getQuantity()).sum());
        if (orderCacheVo.getOrderSource() == OrderSourceEnum.COLLAGE.getValue()) {
            ArrayList<OrderFavorStrategy> orderFavorStrategies = new ArrayList<OrderFavorStrategy>();
            OrderFavorStrategy collageNewUser = (OrderFavorStrategy)SpringContextUtil.getBean(OrderFavorStrategyCollageNewUser.class);
            collageNewUser.setStrategy(OrderFavorStrategyEnum.ORDER_FAVOR_STRATEGY_ENUM_COLLAGE_NEWUSER);
            collageNewUser.setShowText(OrderFavorStrategyEnum.ORDER_FAVOR_STRATEGY_ENUM_COLLAGE_NEWUSER.getName());
            OrderFavorStrategy collageMulUser = (OrderFavorStrategy)SpringContextUtil.getBean(OrderFavorStrategyDiscountCollageMulUser.class);
            collageMulUser.setStrategy(OrderFavorStrategyEnum.ORDER_FAVOR_STRATEGY_ENUM_COLLAGE_MULUSER);
            collageMulUser.setShowText(OrderFavorStrategyEnum.ORDER_FAVOR_STRATEGY_ENUM_COLLAGE_MULUSER.getName());
            orderFavorStrategies.add(collageNewUser);
            orderFavorStrategies.add(collageMulUser);
            mallMainOrderVo.setOrderFavorStrategies(orderFavorStrategies);
        }
        this.priceCalcInterface.totalMainOrderPrice(mallMainOrderVo);
        this.logger.info("\u7528\u6237:{} \u67e5\u8be2getMainOrderVo \u6784\u5efaMallMainOrderVo\u7ed3\u675f", (Object)customerId);
        return mallMainOrderVo;
    }

    @Override
    public List<OrderListVo> getOrderMainList(String customerId, int[] status, int statusClass, int orderSource, int pageSize, int pageCount) {
        pageCount = pageCount == 0 || pageCount == 1 ? 0 : (pageCount - 1) * pageSize;
        return this.mallOrderMainMapper.getCustomerOrderList(customerId, statusClass, status, orderSource, pageSize, pageCount);
    }

    @Override
    public BaseJsonVo iseditOrder(String orderNo, Date deliverDate, Date pickUpdate, int platformGroupId, int status) {
        int transportType;
        if (orderNo == null || orderNo.isEmpty()) {
            this.logger.error("iseditOrder-\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return BaseJsonVo.error((String)"\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (status == OrderStatusEnum.CANCEL.getValue() || status == OrderStatusEnum.DELETE.getValue()) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u5df2\u53d6\u6d88/\u5df2\u5220\u9664\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        if (status > OrderStatusEnum.DELIVING.getValue()) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u5df2\u53d1\u8d27/\u7b7e\u6536/\u9000\u6b3e\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        MallOrderEntity order = this.orderInterface.getmallOrder(orderNo);
        List<DictionaryEntity> dictionaryEntities = this.dictionaryInterface.getValidDictionaryList(platformGroupId, 16);
        MallOrderProductEntity orderProductEntity = new MallOrderProductEntity();
        orderProductEntity.setOrderNo(orderNo);
        List<MallOrderProductEntity> orderProductEntities = this.orderProductInterface.getOrderProductList(orderProductEntity);
        if (dictionaryEntities != null && dictionaryEntities.size() > 0) {
            String[] dicName = dictionaryEntities.get(0).getDictionaryName().split(",");
            if (orderProductEntities != null && dicName != null) {
                for (String d : dicName) {
                    if (orderProductEntities.stream().filter(c -> c.getProductId().equals(d)).count() <= 0L) continue;
                    this.logger.info("iseditOrder-\u8ba2\u5355-" + orderNo + "-\u5b58\u5728\u4e0d\u80fd\u4fee\u6539\u8ba2\u5355\u7684\u5546\u54c1");
                    return BaseJsonVo.error((String)("\u8ba2\u5355[" + orderNo + "]\u5b58\u5728\u4e0d\u80fd\u4fee\u6539\u8ba2\u5355\u7684\u5546\u54c1"));
                }
            }
        }
        if (orderProductEntities != null && (orderProductEntities = orderProductEntities.stream().filter(c -> c.getPromotionProductId() != null && !c.getPromotionProductId().isEmpty()).collect(Collectors.toList())) != null && orderProductEntities.size() > 0) {
            for (MallOrderProductEntity p : orderProductEntities) {
                MallPromotionProductEntity promotionProductEntity;
                if (!p.getPromotionProductId().isEmpty() && (promotionProductEntity = this.promotionProductInterface.getPromotionProduct(p.getPromotionProductId())) == null) continue;
            }
        }
        if ((transportType = this.productInterface.getTransportType(this.orderGroupProductService.getOrderGroupProductListByOrderNo(orderNo))) == TransportTypeEnum.NORMAL_CHAIN.getValue()) {
            this.logger.info("iseditOrder-\u8ba2\u5355-" + orderNo + "-\u4e3a\u5e38\u6e29\u8ba2\u5355\uff0c\u4e0d\u80fd\u4fee\u6539\u8ba2\u5355\u7684\u5546\u54c1");
            return BaseJsonVo.error((String)("\u8ba2\u5355[" + orderNo + "]\u4e3a\u5e38\u6e29\u8ba2\u5355\uff0c\u4e0d\u80fd\u4fee\u6539\u8ba2\u5355\u7684\u5546\u54c1"));
        }
        if (deliverDate == null || deliverDate != null && DateUtils.currentDate().before(pickUpdate) && status == OrderStatusEnum.PAYCONFIRM.getValue()) {
            return BaseJsonVo.success((Object)"\u53ef\u4ee5\u4fee\u6539");
        }
        this.logger.info("iseditOrder-\u8ba2\u5355-" + orderNo + "-\u5df2\u8fc7\u914d\u9001\u65e5\u671f\u6216\u8ba2\u5355\u72b6\u6001\u4e0d\u662f\u5df2\u652f\u4ed8");
        return BaseJsonVo.error((String)("\u8ba2\u5355[" + orderNo + "]\u5df2\u8fc7\u914d\u9001\u65e5\u671f\u6216\u8ba2\u5355\u72b6\u6001\u4e0d\u662f\u5df2\u652f\u4ed8"));
    }

    @Override
    public List<MallOrderProductEntity> getOrderProductList(String orderNo) {
        MallOrderProductEntity orderProductEntity = new MallOrderProductEntity();
        orderProductEntity.setOrderNo(orderNo);
        return this.orderProductInterface.getOrderProductList(orderProductEntity);
    }

    @Override
    public OrderListVo getOrderMainDetail(String customerId, String orderMainNo) {
        return this.mallOrderMainMapper.getCustomerOrderDetail(customerId, orderMainNo);
    }

    @Override
    public List<CancelOrderVo> getBacthCancelMainOrderList(String cancelTime, int size) {
        String fistTime = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)-3), (String)"yyyy-MM-dd HH:mm:ss");
        return this.mallOrderMainMapper.getBacthCancelMainOrderList(cancelTime, fistTime, size);
    }

    @Override
    public List<MallOrderMainMessageVo> getCustomerConfirmGoods(int days) {
        String edate;
        Date date = DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)(-days));
        String sdate = DateUtils.formatDate((Date)date, (String)"yyyy-MM-dd");
        List<MallOrderMainMessageVo> orderMainMessageVos = this.mallOrderMainMapper.getConfirmGoodsCustomerByDays(sdate, edate = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)date, (int)1), (String)"yyyy-MM-dd"));
        if (orderMainMessageVos == null) {
            return new ArrayList<MallOrderMainMessageVo>();
        }
        return orderMainMessageVos;
    }

    @Override
    public List<MallOrderMainEntity> getOrderMainList(MallOrderMainEntity mallOrderMainEntity) {
        return this.mallOrderMainMapper.getList(mallOrderMainEntity);
    }

    @Override
    public int updateOrderStatusByEdb(String orderMainNo, String orderStatus) {
        return this.mallOrderMainMapper.updateOrderStatusByEdb(orderMainNo, orderStatus);
    }

    @Override
    public int updateOrderStatusByForce(String orderMainNo, Integer orderStatus) {
        return this.mallOrderMainMapper.updateOrderStatusByForce(orderMainNo, orderStatus);
    }

    @Override
    public List<Map<String, Object>> getOrderInfo(Integer orderClass, String activeNo, String bindCode, String date) {
        return this.mallOrderMainMapper.getOrderInfo(orderClass, activeNo, bindCode, date);
    }

    @Override
    public List<Map<String, Object>> getOrderSum(Date start, Date end, int success) {
        return this.mallOrderMainMapper.getOrderSum(start, end, success);
    }

    @Override
    public List<Map<String, Object>> getPayOrderSum(Date start, Date end, int success) {
        return this.mallOrderMainMapper.getPayOrderSum(start, end, success);
    }

    @Override
    public List<Map<String, Object>> getOrderNumSum(Date start, Date end, int success) {
        return this.mallOrderMainMapper.getOrderNumSum(start, end, success);
    }

    @Override
    public Integer getOrderNum(String customerId) {
        return this.mallOrderMainMapper.getOrderNum(customerId);
    }

    @Override
    public BigDecimal getOrderAmount(String customerId) {
        return this.mallOrderMainMapper.getOrderAmount(customerId);
    }

    @Override
    public int getOrderNum(String customerId, Integer day) {
        return this.mallOrderMainMapper.getOrderNumByDay(customerId, day);
    }

    @Override
    public List<MallOrderMainEntity> getTeamSaleOrderList(Date date) {
        return this.mallOrderMainMapper.getTeamSaleOrderList(date);
    }

    @Override
    public boolean hasFreePrepayCard(String prepayId, String freeId) {
        List<String> orderMainNos = this.mallOrderMainMapper.findFreePrepayCardOrderMainNos(prepayId, freeId);
        return orderMainNos != null && orderMainNos.size() > 0;
    }

    @Override
    public List<Map<String, String>> getRebuildVipLevelBatch() {
        return this.mallOrderMainMapper.getRebuildVipLevelBatch();
    }

    @Override
    public List<Map<String, String>> getRebuildVipLevelEverydayBatch(String currentDate) {
        return this.mallOrderMainMapper.getRebuildVipLevelEverydayBatch(currentDate);
    }

    @Override
    public List<MallOrderMainEntity> getUnMarkOrder() {
        return this.mallOrderMainMapper.getUnMarkOrder();
    }

    @Override
    public BaseJsonVo<OriginOrderVO> getOriginOrder(String orderNo) {
        WxOrderRequest wxOrderRequest = new WxOrderRequest();
        wxOrderRequest.setPage(Integer.valueOf(1));
        wxOrderRequest.setRows(Integer.valueOf(1));
        wxOrderRequest.setExternalOrderNo(orderNo);
        BaseJsonVo orderInfoByPage = this.wxOrderClient.getOrderList(wxOrderRequest);
        if (!orderInfoByPage.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u539f\u5355\u5931\u8d25\uff1a{}", (Object)JsonUtils.toJson((Object)orderInfoByPage, (boolean)false));
            return orderInfoByPage;
        }
        JqGridData jqGridData = (JqGridData)JSONObject.parseObject((String)JSONObject.toJSONString((Object)orderInfoByPage.getValue()), JqGridData.class);
        List originOrderVOList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)jqGridData.getRows()), OriginOrderVO.class);
        if (originOrderVOList == null || originOrderVOList.size() == 0) {
            return BaseJsonVo.error((String)"\u539f\u5355\u4e0d\u5b58\u5728");
        }
        OriginOrderVO originOrderVO = (OriginOrderVO)originOrderVOList.get(0);
        return BaseJsonVo.success((Object)originOrderVO);
    }

    @Override
    public BaseJsonVo<List<OriginOrderProductVO>> getOriginOrderProduct(String externalOrderNo) {
        WxOrderRequest wxOrderRequest = new WxOrderRequest();
        wxOrderRequest.setExternalOrderNo(externalOrderNo);
        BaseJsonVo orderProductListRst = this.wxOrderClient.getOrderProductList(wxOrderRequest);
        if (!orderProductListRst.isSuccess()) {
            return BaseJsonVo.error((String)orderProductListRst.getError_msg());
        }
        List omsEcOrderProductVOList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)orderProductListRst.getValue()), OriginOrderProductVO.class);
        this.logger.info("\u83b7\u53d6\u8ba2\u5355\u5546\u54c1\u660e\u7ec6\uff0cparam:{}\uff0cresult:{}", (Object)externalOrderNo, (Object)JSON.toJSONString((Object)omsEcOrderProductVOList));
        return BaseJsonVo.success((Object)omsEcOrderProductVOList);
    }

    @Override
    public MallOrderMainEntity getOrderMainBySourceOrderNo(String sourceOrderNo) {
        MallOrderMainEntity mainEntity = new MallOrderMainEntity();
        mainEntity.setSourceOrderNo(sourceOrderNo);
        List lst = this.mallOrderMainMapper.getList(mainEntity);
        if (lst.size() == 0) {
            return null;
        }
        if (((MallOrderMainEntity)lst.get(0)).getStatus() >= 1) {
            return (MallOrderMainEntity)lst.get(0);
        }
        return null;
    }
}

