/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.active.iservice.collage.CollageInterface;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.trade.MallOrderProductMapper;
import cc.lechun.mall.entity.sales.MallExchangeProductVO;
import cc.lechun.mall.entity.sales.MallExchangeVO;
import cc.lechun.mall.entity.sales.MallFreeVO;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.sales.MallRecommendCardVO;
import cc.lechun.mall.entity.sales.OrderProductTypeEnum;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderGroupAndProductVo;
import cc.lechun.mall.entity.trade.MallOrderGroupProductEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderProductEntity;
import cc.lechun.mall.entity.trade.MallOrderProductShareVo;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.trade.MallOrderGroupProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MallOrderProductService
extends BaseService
implements MallOrderProductInterface {
    @Autowired
    private MallOrderProductMapper orderProductMapper;
    @Autowired
    @Lazy
    private MallOrderGroupProductInterface orderGroupProductInterface;
    @Autowired
    @Lazy
    private CollageInterface collageInterface;
    @Lazy
    @Autowired
    private MallOrderInterface orderInterface;
    @Lazy
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Lazy
    @Autowired
    private MallProductInterface productInterface;
    @Lazy
    @Autowired
    private MallPromotionInterface promotionInterface;
    @Lazy
    @Autowired
    private MallGroupInterface groupInterface;

    @Override
    public BaseJsonVo buildOrderProductEntities(MallMainOrderVo mainOrderVo) {
        String message = "";
        ArrayList<MallOrderProductEntity> orderProductEntities = new ArrayList<MallOrderProductEntity>();
        ArrayList<MallOrderGroupProductEntity> orderGroupProductEntities = new ArrayList<MallOrderGroupProductEntity>();
        try {
            String inviteId = "";
            BigDecimal[] total = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO};
            BigDecimal[] savedNew = new BigDecimal[]{BigDecimal.ZERO};
            BigDecimal[] savedMul = new BigDecimal[]{BigDecimal.ZERO};
            boolean buyCard = false;
            if (mainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.COLLAGE.getValue() && mainOrderVo.getMallOrderVos().get(0) != null && StringUtils.isNotEmpty((String)mainOrderVo.getMallOrderVos().get(0).getDefineField()) && StringUtils.isNotEmpty((String)(inviteId = JsonUtils.stringToMap((String)URLDecoder.decode(mainOrderVo.getMallOrderVos().get(0).getDefineField(), "utf-8")).get("inviteId").toString()))) {
                savedNew[0] = this.collageInterface.getNewUserCollageOrderReductionVo(inviteId);
                savedMul[0] = this.collageInterface.getDiscountCollageOrderReductionVo(inviteId);
                if (savedNew[0] == null) {
                    savedNew[0] = BigDecimal.ZERO;
                }
                if (savedMul[0] == null) {
                    savedMul[0] = BigDecimal.ZERO;
                }
            }
            for (MallOrderVo orderVo : mainOrderVo.getMallOrderVos()) {
                BigDecimal finalFareAmount;
                BigDecimal scale;
                MallOrderProductEntity orderProductEntity;
                if (orderVo.getProducts() != null && orderVo.getProducts().size() > 0) {
                    for (MallProductVO mallProductVO2 : orderVo.getProducts()) {
                        orderProductEntity = this.buildOrderProduct(mallProductVO2, mainOrderVo.getMainOrderNo(), orderVo.getOrderNo());
                        orderProductEntity.setOrderProductType(OrderProductTypeEnum.normal_product.getValue());
                        if (StringUtils.isNotEmpty((String)mallProductVO2.getFreeId()) && mallProductVO2.getFactPrice().compareTo(BigDecimal.ZERO) > 0) {
                            orderProductEntity.setOrderProductType(OrderProductTypeEnum.exchange.getValue());
                        }
                        total[0] = PriceUtils.add((BigDecimal)total[0], (BigDecimal)orderProductEntity.getTotalPrice());
                        orderProductEntities.add(orderProductEntity);
                        MallOrderGroupProductEntity entity2 = this.orderGroupProductInterface.buildOrderGroupProductEntity(mallProductVO2, null, mainOrderVo.getMainOrderNo(), orderVo.getOrderNo(), orderProductEntity.getOrderProductNo());
                        total[1] = PriceUtils.add((BigDecimal)total[1], (BigDecimal)PriceUtils.multiply((BigDecimal)entity2.getUnitPrice(), (Integer)entity2.getQuantity()));
                        entity2.setOriginPriceSum(PriceUtils.multiply((BigDecimal)entity2.getUnitPrice(), (Integer)entity2.getQuantity()));
                        entity2.setCardPrice(PriceUtils.multiply((BigDecimal)mallProductVO2.getCardFactPrice(), (Integer)entity2.getQuantity()));
                        orderGroupProductEntities.add(entity2);
                    }
                }
                if (orderVo.getGroups() != null && orderVo.getGroups().size() > 0) {
                    for (MallGroupVO mallGroupVO : orderVo.getGroups()) {
                        BigDecimal singleGroupTotal = BigDecimal.ZERO;
                        BigDecimal finalFareTotalAmount = BigDecimal.ZERO;
                        if (mallGroupVO.getProductList() != null) {
                            singleGroupTotal = singleGroupTotal.add(mallGroupVO.getProductList().stream().filter(mallProductVO -> new BigDecimal(mallProductVO.getProPrice()).compareTo(new BigDecimal(0)) > 0).map(mallProductVO -> new BigDecimal(mallProductVO.getProPrice()).multiply(new BigDecimal(mallProductVO.getCount()))).reduce(BigDecimal.ZERO, BigDecimal::add));
                        }
                        int num = mallGroupVO.getProductList().size();
                        int k = 0;
                        orderProductEntity = this.buildOrderProduct(mallGroupVO, mainOrderVo.getMainOrderNo(), orderVo.getOrderNo());
                        orderProductEntity.setOrderProductType(OrderProductTypeEnum.normal_product.getValue());
                        if (StringUtils.isNotEmpty((String)mallGroupVO.getFreeId()) && mallGroupVO.getFactPrice().compareTo(BigDecimal.ZERO) > 0) {
                            orderProductEntity.setOrderProductType(OrderProductTypeEnum.exchange.getValue());
                        }
                        total[0] = PriceUtils.add((BigDecimal)total[0], (BigDecimal)orderProductEntity.getTotalPrice());
                        orderProductEntities.add(orderProductEntity);
                        for (MallProductVO pp : mallGroupVO.getProductList()) {
                            BigDecimal fareAmount = BigDecimal.ZERO;
                            MallOrderGroupProductEntity entity3 = this.orderGroupProductInterface.buildOrderGroupProductEntity(pp, mallGroupVO, mainOrderVo.getMainOrderNo(), orderVo.getOrderNo(), orderProductEntity.getOrderProductNo());
                            total[1] = PriceUtils.add((BigDecimal)total[1], (BigDecimal)PriceUtils.multiply((BigDecimal)entity3.getUnitPrice(), (Integer)entity3.getQuantity()));
                            if (++k < num) {
                                scale = entity3.getOriginPrice().multiply(new BigDecimal(entity3.getQuantity())).divide(singleGroupTotal, 6, 4);
                                this.logger.info("\u5355\u54c1:{},\u5360\u6bd4:{}", (Object)pp.getProName(), (Object)scale);
                                fareAmount = mallGroupVO.getFactPrice().multiply(scale);
                                finalFareAmount = fareAmount.divide(new BigDecimal(pp.getCount()), 2, 5).multiply(new BigDecimal(pp.getCount())).setScale(2, 5);
                                this.logger.info("\u5957\u88c5{}, \u5355\u54c1:{},\u5206\u644a\u540e\u7684\u5b9e\u9645\u4ef7\u683c:{}", new Object[]{mallGroupVO.getGroupName(), pp.getProName(), finalFareAmount});
                                entity3.setOriginPriceSum(finalFareAmount);
                                finalFareTotalAmount = finalFareTotalAmount.add(finalFareAmount);
                            } else {
                                entity3.setOriginPriceSum(PriceUtils.multiply((BigDecimal)mallGroupVO.getFactPrice(), (Integer)mallGroupVO.getCount()).subtract(finalFareTotalAmount));
                                this.logger.info("\u5957\u88c5{},\u6700\u540e\u4e00\u4e2a\u5355\u54c1{},\u5206\u644a\u540e\u7684\u5b9e\u9645\u4ef7\u683c:{}", new Object[]{mallGroupVO.getGroupName(), pp.getProName(), entity3.getOriginPriceSum()});
                            }
                            orderGroupProductEntities.add(entity3);
                        }
                    }
                }
                if (orderVo.getPromotions() != null && orderVo.getPromotions().size() > 0) {
                    for (MallPromotionVO mallPromotionVO : orderVo.getPromotions()) {
                        if (Objects.equals(mainOrderVo.getOrderCacheVo().getOrderSource(), OrderSourceEnum.RECHANGE_CARD.getValue())) {
                            mallPromotionVO.setFactPrice(mallPromotionVO.getCardFactPrice());
                            mallPromotionVO.setOriginPrice(mallPromotionVO.getCardOriginPrice());
                        }
                        orderProductEntity = this.buildOrderProduct(mallPromotionVO, mainOrderVo.getMainOrderNo(), orderVo.getOrderNo());
                        orderProductEntity.setOrderProductType(OrderProductTypeEnum.normal_product.getValue());
                        if (StringUtils.isNotEmpty((String)mallPromotionVO.getFreeId()) && mallPromotionVO.getFactPrice().compareTo(BigDecimal.ZERO) > 0) {
                            orderProductEntity.setOrderProductType(OrderProductTypeEnum.exchange.getValue());
                        }
                        total[0] = PriceUtils.add((BigDecimal)total[0], (BigDecimal)orderProductEntity.getTotalPrice());
                        orderProductEntities.add(orderProductEntity);
                        BigDecimal singlePromotionTotal = BigDecimal.ZERO;
                        if (mallPromotionVO.getGroup() != null) {
                            singlePromotionTotal = singlePromotionTotal.add(mallPromotionVO.getGroup().getProductList().stream().filter(mallProductVO -> new BigDecimal(mallProductVO.getProPrice()).compareTo(BigDecimal.ZERO) > 0).map(mallProductVO -> new BigDecimal(mallProductVO.getProPrice()).multiply(new BigDecimal(mallProductVO.getCount()))).reduce(BigDecimal.ZERO, BigDecimal::add));
                        }
                        if (mallPromotionVO.getProduct() != null && mallPromotionVO.getProduct().getFactPrice().compareTo(BigDecimal.ZERO) > 0) {
                            singlePromotionTotal = singlePromotionTotal.add(mallPromotionVO.getProduct().getFactPrice().multiply(new BigDecimal(mallPromotionVO.getCount())));
                        }
                        if (mallPromotionVO.getGroup() != null) {
                            int num = mallPromotionVO.getGroup().getProductList().size();
                            int k = 0;
                            BigDecimal finalFareTotalAmount = BigDecimal.ZERO;
                            for (MallProductVO pp : mallPromotionVO.getGroup().getProductList()) {
                                ++k;
                                mallPromotionVO.getGroup().setCount(mallPromotionVO.getCount());
                                MallOrderGroupProductEntity entity4 = this.orderGroupProductInterface.buildOrderGroupProductEntity(pp, mallPromotionVO.getGroup(), mainOrderVo.getMainOrderNo(), orderVo.getOrderNo(), orderProductEntity.getOrderProductNo());
                                if (Objects.equals(mainOrderVo.getOrderCacheVo().getOrderSource(), OrderSourceEnum.RECHANGE_CARD.getValue())) {
                                    entity4.setCardPrice(PriceUtils.multiply((BigDecimal)entity4.getUnitPrice(), (Integer)entity4.getQuantity()));
                                }
                                total[1] = PriceUtils.add((BigDecimal)total[1], (BigDecimal)PriceUtils.multiply((BigDecimal)entity4.getUnitPrice(), (Integer)entity4.getQuantity()));
                                if (pp.getFactPrice().compareTo(BigDecimal.ZERO) > 0) {
                                    BigDecimal fareAmount = BigDecimal.ZERO;
                                    if (k < num) {
                                        scale = entity4.getOriginPrice().multiply(new BigDecimal(entity4.getQuantity())).divide(singlePromotionTotal, 6, 4);
                                        this.logger.info("\u5355\u54c1:{},\u5360\u6bd4:{}", (Object)pp.getProName(), (Object)scale);
                                        fareAmount = mallPromotionVO.getFactPrice().multiply(scale);
                                        finalFareAmount = fareAmount.divide(new BigDecimal(pp.getCount()), 2, 5).multiply(new BigDecimal(pp.getCount())).setScale(2, 5);
                                        this.logger.info("\u4fc3\u9500{}, \u5355\u54c1:{},\u5206\u644a\u540e\u7684\u5b9e\u9645\u4ef7\u683c:{}", new Object[]{mallPromotionVO.getPromotionName(), pp.getProName(), finalFareAmount});
                                        entity4.setOriginPriceSum(finalFareAmount);
                                        finalFareTotalAmount = finalFareTotalAmount.add(finalFareAmount);
                                    } else {
                                        entity4.setOriginPriceSum(PriceUtils.multiply((BigDecimal)mallPromotionVO.getFactPrice(), (Integer)mallPromotionVO.getCount()).subtract(finalFareTotalAmount));
                                        this.logger.info("\u4fc3\u9500{},\u6700\u540e\u4e00\u4e2a\u5355\u54c1{},\u5206\u644a\u540e\u7684\u5b9e\u9645\u4ef7\u683c:{}", new Object[]{mallPromotionVO.getPromotionName(), pp.getProName(), entity4.getOriginPriceSum()});
                                    }
                                }
                                orderGroupProductEntities.add(entity4);
                            }
                        }
                        if (mallPromotionVO.getProduct() == null) continue;
                        MallOrderGroupProductEntity entity5 = this.orderGroupProductInterface.buildOrderGroupProductEntity(mallPromotionVO.getProduct(), null, mainOrderVo.getMainOrderNo(), orderVo.getOrderNo(), orderProductEntity.getOrderProductNo());
                        entity5.setOriginPrice(mallPromotionVO.getOriginPrice());
                        if (Objects.equals(mainOrderVo.getOrderCacheVo().getOrderSource(), OrderSourceEnum.RECHANGE_CARD.getValue())) {
                            entity5.setCardPrice(PriceUtils.multiply((BigDecimal)entity5.getUnitPrice(), (Integer)entity5.getQuantity()));
                        }
                        orderGroupProductEntities.add(entity5);
                    }
                }
                if (CollectionUtils.isNotEmpty(orderVo.getFrees())) {
                    for (MallFreeVO mallFreeVO : orderVo.getFrees()) {
                        for (MallProductVO p : mallFreeVO.getProductList()) {
                            orderProductEntity = this.buildOrderProduct(p, mainOrderVo.getMainOrderNo(), orderVo.getOrderNo());
                            orderProductEntity.setOrderProductType(OrderProductTypeEnum.free.getValue());
                            orderProductEntities.add(orderProductEntity);
                            orderGroupProductEntities.add(this.orderGroupProductInterface.buildOrderGroupProductEntity(p, null, mainOrderVo.getMainOrderNo(), orderVo.getOrderNo(), orderProductEntity.getOrderProductNo()));
                        }
                    }
                }
                this.spliteExchange(mainOrderVo, orderProductEntities, orderGroupProductEntities, orderVo);
                buyCard = this.addBuyCardProduct(mainOrderVo, orderProductEntities, orderGroupProductEntities, buyCard, orderVo);
            }
            if (savedNew[0].compareTo(BigDecimal.ZERO) != 0 || savedMul[0].compareTo(BigDecimal.ZERO) != 0) {
                orderProductEntities.forEach(entity -> {
                    entity.setCollageNewAmount(PriceUtils.multiply((BigDecimal)savedNew[0], (BigDecimal)PriceUtils.divide((BigDecimal)entity.getTotalPrice(), (BigDecimal)total[0])));
                    entity.setCollageMulAmount(PriceUtils.multiply((BigDecimal)savedMul[0], (BigDecimal)PriceUtils.divide((BigDecimal)entity.getTotalPrice(), (BigDecimal)total[0])));
                });
            }
            MallOrderGroupAndProductVo orderGroupAndProductVo = new MallOrderGroupAndProductVo();
            orderGroupAndProductVo.setOrderGroupProductEntities(orderGroupProductEntities);
            orderGroupAndProductVo.setOrderProductEntities(orderProductEntities);
            return BaseJsonVo.success((Object)orderGroupAndProductVo);
        }
        catch (Exception e) {
            message = "\u521b\u5efa\u8ba2\u5355\u5bf9\u8c61\u5f02\u5e38";
            this.logger.error("\u521b\u5efa\u8ba2\u5355\u5bf9\u8c61\u5f02\u5e38[\u521b\u5efa\u8ba2\u5355\u5546\u54c1\u5931\u8d25]", (Throwable)e);
            return BaseJsonVo.error((String)message);
        }
    }

    private boolean addBuyCardProduct(MallMainOrderVo mainOrderVo, List<MallOrderProductEntity> orderProductEntities, List<MallOrderGroupProductEntity> orderGroupProductEntities, boolean buyCard, MallOrderVo orderVo) {
        if (CollectionUtils.isNotEmpty(mainOrderVo.getRecommendCardVOList()) && !buyCard) {
            for (MallRecommendCardVO f : mainOrderVo.getRecommendCardVOList()) {
                BaseJsonVo baseJsonVo;
                this.logger.info("\u67e5\u770b\u5361\u662f\u5426\u9009\u4e2d:{}", (Object)JsonUtils.toJson((Object)f, (boolean)false));
                if (f.getSelect() != 1 || !(baseJsonVo = this.promotionInterface.buildPromotionVO(f.getProId(), f.getCount(), true)).isSuccess()) continue;
                buyCard = true;
                this.logger.info("\u5df2\u6dfb\u52a0\u6dfb\u52a0\u8fc7\u5361\u4e86");
                ((MallPromotionVO)baseJsonVo.getValue()).setFactPrice(((MallPromotionVO)baseJsonVo.getValue()).getPromotionPrice());
                MallOrderProductEntity orderProductEntity = this.buildOrderProduct((MallPromotionVO)baseJsonVo.getValue(), mainOrderVo.getMainOrderNo(), orderVo.getOrderNo());
                orderProductEntity.setOrderProductType(OrderProductTypeEnum.normal_product.getValue());
                orderProductEntities.add(orderProductEntity);
                if (((MallPromotionVO)baseJsonVo.getValue()).getProduct() != null) {
                    orderGroupProductEntities.add(this.orderGroupProductInterface.buildOrderGroupProductEntity(((MallPromotionVO)baseJsonVo.getValue()).getProduct(), null, mainOrderVo.getMainOrderNo(), orderVo.getOrderNo(), orderProductEntity.getOrderProductNo()));
                }
                this.logger.info("\u5361\u4fc3\u9500\u62c6\u5206\u5b8c\u4e86");
            }
        }
        return buyCard;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void spliteExchange(MallMainOrderVo mainOrderVo, List<MallOrderProductEntity> orderProductEntities, List<MallOrderGroupProductEntity> orderGroupProductEntities, MallOrderVo orderVo) {
        if (!CollectionUtils.isNotEmpty(mainOrderVo.getMallOrderVos().get(0).getEnableExchanges())) return;
        for (MallExchangeVO f : mainOrderVo.getMallOrderVos().get(0).getEnableExchanges()) {
            this.logger.info("\u52a0\u8d2d\u540d\u79f0:{}", (Object)f.getFreeName());
            for (MallExchangeProductVO p : f.getProductList()) {
                MallOrderProductEntity orderProductEntity;
                block5: {
                    BaseJsonVo<MallGroupVO> baseJsonVo;
                    block6: {
                        block7: {
                            block4: {
                                this.logger.info("\u52a0\u8d2d\u540d\u79f0:{},\u8ba2\u5355\u914d\u9001\u7c7b\u578b:{},\u52a0\u8d2d\u7c7b\u578b:{},\u9009\u62e9\u6570\u91cf:{}", new Object[]{p.getProName(), orderVo.getTransportType(), p.getTransportType(), p.getQuantity()});
                                if (p.getQuantity() <= 0 || !Objects.equals(orderVo.getTransportType(), p.getTransportType())) continue;
                                orderProductEntity = new MallOrderProductEntity();
                                orderProductEntity.setOrderProductType(OrderProductTypeEnum.exchange.getValue());
                                this.logger.info("\u52a0\u8d2d\u540d\u79f0 \u5df2\u9009\u62e9\u5546\u54c1{}", (Object)p.getProName());
                                if (p.getProductType().intValue() != SalesTypeEnum.SALES_PRODUCT.getValue()) break block4;
                                baseJsonVo = this.productInterface.buildProductVO(p.getProId(), p.getQuantity(), false, true);
                                if (!baseJsonVo.isSuccess()) throw new RuntimeException("\u52a0\u8d2d\u5546\u54c1" + p.getProName() + baseJsonVo.getMessage());
                                ((MallProductVO)baseJsonVo.getValue()).setFactPrice(f.getFreePrice());
                                orderProductEntity = this.buildOrderProduct((MallProductVO)baseJsonVo.getValue(), mainOrderVo.getMainOrderNo(), orderVo.getOrderNo());
                                orderProductEntity.setUnitPrice(f.getFreePrice());
                                orderProductEntity.setTotalPrice(PriceUtils.multiply((BigDecimal)f.getFreePrice(), (Integer)p.getQuantity()));
                                orderGroupProductEntities.add(this.orderGroupProductInterface.buildOrderGroupProductEntity((MallProductVO)baseJsonVo.getValue(), null, mainOrderVo.getMainOrderNo(), orderVo.getOrderNo(), orderProductEntity.getOrderProductNo()));
                                break block5;
                            }
                            if (p.getProductType().intValue() != SalesTypeEnum.SALES_PROMOTION.getValue()) break block6;
                            baseJsonVo = this.promotionInterface.buildPromotionVO(p.getProId(), p.getQuantity(), true);
                            if (!baseJsonVo.isSuccess()) throw new RuntimeException("\u52a0\u8d2d\u5546\u54c1" + p.getProName() + baseJsonVo.getMessage());
                            ((MallPromotionVO)baseJsonVo.getValue()).setFactPrice(f.getFreePrice());
                            orderProductEntity = this.buildOrderProduct((MallPromotionVO)baseJsonVo.getValue(), mainOrderVo.getMainOrderNo(), orderVo.getOrderNo());
                            orderProductEntity.setUnitPrice(f.getFreePrice());
                            orderProductEntity.setTotalPrice(PriceUtils.multiply((BigDecimal)f.getFreePrice(), (Integer)p.getQuantity()));
                            if (SalesTypeEnum.SALES_PRODUCT.getValue() != Integer.valueOf(((MallPromotionVO)baseJsonVo.getValue()).getProductType()).intValue()) break block7;
                            ((MallPromotionVO)baseJsonVo.getValue()).getProduct().setFactPrice(f.getFreePrice());
                            orderGroupProductEntities.add(this.orderGroupProductInterface.buildOrderGroupProductEntity(((MallPromotionVO)baseJsonVo.getValue()).getProduct(), null, mainOrderVo.getMainOrderNo(), orderVo.getOrderNo(), orderProductEntity.getOrderProductNo()));
                            break block5;
                        }
                        if (SalesTypeEnum.SALES_GROUP.getValue() != Integer.valueOf(((MallPromotionVO)baseJsonVo.getValue()).getProductType()).intValue()) break block5;
                        ((MallPromotionVO)baseJsonVo.getValue()).getGroup().setCount(p.getQuantity());
                        ((MallPromotionVO)baseJsonVo.getValue()).getGroup().setFactPrice(p.getFactPrice());
                        orderGroupProductEntities.addAll(this.splitePromotionGroup(((MallPromotionVO)baseJsonVo.getValue()).getGroup(), mainOrderVo, orderVo, orderProductEntity));
                        break block5;
                    }
                    if (p.getProductType().intValue() == SalesTypeEnum.SALES_GROUP.getValue()) {
                        baseJsonVo = this.groupInterface.buildGroupVO(p.getProId(), p.getQuantity(), true);
                        if (!baseJsonVo.isSuccess()) throw new RuntimeException("\u52a0\u8d2d\u5546\u54c1" + p.getProName() + baseJsonVo.getMessage());
                        orderProductEntity = this.buildOrderProduct((MallGroupVO)baseJsonVo.getValue(), mainOrderVo.getMainOrderNo(), orderVo.getOrderNo());
                        orderProductEntity.setUnitPrice(f.getFreePrice());
                        orderProductEntity.setTotalPrice(PriceUtils.multiply((BigDecimal)f.getFreePrice(), (Integer)p.getQuantity()));
                        for (MallProductVO pp : ((MallGroupVO)baseJsonVo.getValue()).getProductList()) {
                            orderGroupProductEntities.add(this.orderGroupProductInterface.buildOrderGroupProductEntity(pp, null, mainOrderVo.getMainOrderNo(), orderVo.getOrderNo(), orderProductEntity.getOrderProductNo()));
                        }
                    }
                }
                orderProductEntity.setOrderProductType(OrderProductTypeEnum.exchange.getValue());
                orderProductEntities.add(orderProductEntity);
                this.logger.info("\u52a0\u8d2d\u5546\u54c1:{}\u62c6\u5206\u5b8c\u4e86", (Object)p.getProName());
            }
        }
    }

    private List<MallOrderGroupProductEntity> splitePromotionGroup(MallGroupVO p, MallMainOrderVo mainOrderVo, MallOrderVo orderVo, MallOrderProductEntity orderProductEntity) {
        ArrayList<MallOrderGroupProductEntity> orderGroupProductEntities = new ArrayList<MallOrderGroupProductEntity>();
        BigDecimal singleGroupTotal = BigDecimal.ZERO;
        BigDecimal finalFareTotalAmount = BigDecimal.ZERO;
        if (p.getProductList() != null) {
            singleGroupTotal = singleGroupTotal.add(p.getProductList().stream().filter(mallProductVO -> new BigDecimal(mallProductVO.getProPrice()).compareTo(new BigDecimal(0)) > 0).map(mallProductVO -> new BigDecimal(mallProductVO.getProPrice()).multiply(new BigDecimal(mallProductVO.getCount()))).reduce(BigDecimal.ZERO, BigDecimal::add));
            int num = p.getProductList().size();
            int k = 0;
            for (MallProductVO pp : p.getProductList()) {
                MallOrderGroupProductEntity entity = this.orderGroupProductInterface.buildOrderGroupProductEntity(pp, p, mainOrderVo.getMainOrderNo(), orderVo.getOrderNo(), orderProductEntity.getOrderProductNo());
                if (pp.getFactPrice().compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal fareAmount = BigDecimal.ZERO;
                    ++k;
                    this.logger.info("\u5546\u54c1:{},\u6570\u91cf:{},\u9500\u552e\u4ef7\u683c:{}", new Object[]{pp.getProName(), pp.getCount(), pp.getProPrice()});
                    BigDecimal scale = new BigDecimal(pp.getProPrice()).multiply(new BigDecimal(pp.getCount())).divide(singleGroupTotal, 6, 4);
                    this.logger.info("\u5355\u54c1:{},\u5360\u6bd4:{}", (Object)pp.getProName(), (Object)scale);
                    fareAmount = p.getFactPrice().multiply(scale);
                    pp.setFactPrice(fareAmount);
                    entity = this.orderGroupProductInterface.buildOrderGroupProductEntity(pp, p, mainOrderVo.getMainOrderNo(), orderVo.getOrderNo(), orderProductEntity.getOrderProductNo());
                    if (k < num) {
                        BigDecimal finalFareAmount = fareAmount.divide(new BigDecimal(pp.getCount()), 2, 5).multiply(new BigDecimal(pp.getCount())).setScale(2, 5);
                        this.logger.info("\u5957\u88c5{}, \u5355\u54c1:{},\u5206\u644a\u540e\u7684\u5b9e\u9645\u4ef7\u683c:{}", new Object[]{p.getGroupName(), pp.getProName(), finalFareAmount});
                        entity.setOriginPriceSum(PriceUtils.multiply((BigDecimal)finalFareAmount, (Integer)p.getCount()));
                        finalFareTotalAmount = finalFareTotalAmount.add(finalFareAmount);
                    } else {
                        entity.setOriginPriceSum(PriceUtils.multiply((BigDecimal)p.getFactPrice(), (Integer)p.getCount()).subtract(finalFareTotalAmount));
                        this.logger.info("\u5957\u88c5{},\u6700\u540e\u4e00\u4e2a\u5355\u54c1{},\u5206\u644a\u540e\u7684\u5b9e\u9645\u4ef7\u683c\u4e4b\u548c:{}", new Object[]{p.getGroupName(), pp.getProName(), entity.getOriginPriceSum()});
                    }
                }
                orderGroupProductEntities.add(entity);
            }
        }
        return orderGroupProductEntities;
    }

    private MallOrderProductEntity buildOrderProduct(MallProductVO p, String orderMainNo, String orderNo) {
        MallOrderProductEntity orderProductEntity = new MallOrderProductEntity();
        orderProductEntity.setActivityNo("");
        orderProductEntity.setChannelOrderproductNo("");
        orderProductEntity.setDeliverQuantity(0);
        orderProductEntity.setFullCutAmount(p.getFullcutAmount());
        orderProductEntity.setGroupId("");
        orderProductEntity.setGroupType(SalesTypeEnum.SALES_PRODUCT.getValue());
        orderProductEntity.setOrderMainNo(orderMainNo);
        orderProductEntity.setOrderNo(orderNo);
        orderProductEntity.setOrderProductNo(String.valueOf(IDGenerate.getUniqueID()));
        orderProductEntity.setOriginalPrice(new BigDecimal(p.getProPrice()));
        orderProductEntity.setQuantity(p.getCount());
        orderProductEntity.setProductId(p.getProId());
        orderProductEntity.setProductName(p.getProName());
        orderProductEntity.setPromotionProductId("");
        orderProductEntity.setTicketAmount(p.getCouponAmount());
        orderProductEntity.setTicketFlag((short)p.getUseCoupon().intValue());
        orderProductEntity.setTotalPrice(PriceUtils.multiply((BigDecimal)p.getFactPrice(), (Integer)p.getCount()));
        orderProductEntity.setUnitPrice(p.getFactPrice());
        orderProductEntity.setCardPrice(p.getCardFactPrice());
        return orderProductEntity;
    }

    private MallOrderProductEntity buildOrderProduct(MallGroupVO p, String orderMainNo, String orderNo) {
        MallOrderProductEntity orderProductEntity = new MallOrderProductEntity();
        orderProductEntity.setActivityNo("");
        orderProductEntity.setChannelOrderproductNo("");
        orderProductEntity.setDeliverQuantity(0);
        orderProductEntity.setFullCutAmount(p.getFullcutAmount());
        orderProductEntity.setGroupId(p.getGroupId());
        orderProductEntity.setGroupType(SalesTypeEnum.SALES_GROUP.getValue());
        orderProductEntity.setOrderMainNo(orderMainNo);
        orderProductEntity.setOrderNo(orderNo);
        orderProductEntity.setOrderProductNo(String.valueOf(IDGenerate.getUniqueID()));
        orderProductEntity.setOriginalPrice(p.getSalePrice());
        orderProductEntity.setQuantity(p.getCount());
        orderProductEntity.setProductId("");
        orderProductEntity.setProductName(p.getGroupName());
        orderProductEntity.setPromotionProductId("");
        orderProductEntity.setTicketAmount(p.getCouponAmount());
        orderProductEntity.setTicketFlag(p.getUseCoupon() == null ? (short)0 : (short)p.getUseCoupon().intValue());
        orderProductEntity.setTotalPrice(PriceUtils.multiply((BigDecimal)p.getFactPrice(), (Integer)p.getCount()));
        orderProductEntity.setUnitPrice(p.getFactPrice());
        return orderProductEntity;
    }

    private MallOrderProductEntity buildOrderProduct(MallPromotionVO p, String orderMainNo, String orderNo) {
        MallOrderProductEntity orderProductEntity = new MallOrderProductEntity();
        orderProductEntity.setActivityNo("");
        orderProductEntity.setChannelOrderproductNo("");
        orderProductEntity.setDeliverQuantity(0);
        orderProductEntity.setFullCutAmount(p.getFullcutAmount());
        if (p.getGroup() != null) {
            orderProductEntity.setGroupId(p.getGroup().getGroupId());
        } else {
            orderProductEntity.setProductId(p.getProduct().getProId());
        }
        orderProductEntity.setGroupType(SalesTypeEnum.SALES_PROMOTION.getValue());
        orderProductEntity.setOrderMainNo(orderMainNo);
        orderProductEntity.setOrderNo(orderNo);
        orderProductEntity.setOrderProductNo(String.valueOf(IDGenerate.getUniqueID()));
        orderProductEntity.setOriginalPrice(p.getOriginPrice());
        orderProductEntity.setQuantity(p.getCount());
        if (orderProductEntity.getProductId() == null) {
            orderProductEntity.setProductId("");
        }
        orderProductEntity.setProductName(p.getPromotionName());
        orderProductEntity.setPromotionProductId(p.getPromotionProductId());
        orderProductEntity.setTicketAmount(p.getCouponAmount());
        orderProductEntity.setTicketFlag(p.getUseCoupon() == null ? (short)0 : (short)p.getUseCoupon().intValue());
        orderProductEntity.setTotalPrice(PriceUtils.multiply((BigDecimal)p.getFactPrice(), (Integer)p.getCount()));
        orderProductEntity.setUnitPrice(p.getFactPrice());
        if (StringUtils.isNotEmpty((String)p.getPromotionId())) {
            orderProductEntity.setPromotionId(p.getPromotionId());
        }
        return orderProductEntity;
    }

    @Override
    public boolean insertOrderProduct(MallOrderProductEntity orderProductEntity) {
        int i = this.orderProductMapper.insertSelective(orderProductEntity);
        return i == 1;
    }

    @Override
    public boolean updateOrderProduct(MallOrderProductEntity orderProductEntity) {
        return this.orderProductMapper.updateByPrimaryKeySelective(orderProductEntity) >= 1;
    }

    @Override
    public List<MallOrderProductEntity> getOrderProductList(MallOrderProductEntity orderProductEntity) {
        return this.orderProductMapper.getList(orderProductEntity);
    }

    @Override
    public int getUserPromotionBuyCount(String promotionId, String customerId, Date start, Date end) {
        return this.orderProductMapper.getUserPromotionBuyCount(promotionId, customerId, start, end);
    }

    @Override
    public List<MallOrderProductEntity> getOrderProductInfoByOrderNo(String orderNo) {
        return this.orderProductMapper.getOrderProductInfoByOrderNo(orderNo);
    }

    @Override
    public List<MallOrderProductEntity> getOrderProductInfoByOrderMianNo(String orderMainNo) {
        return this.orderProductMapper.getOrderProductInfoByOrderMianNo(orderMainNo);
    }

    @Override
    @Transactional
    public void deleteByOrderNo(String orderNo) {
        this.orderProductMapper.deleteByOrderNo(orderNo);
        this.orderGroupProductInterface.deleteByOrderNo(orderNo);
    }

    @Override
    public List<MallOrderProductEntity> getOrderProductInfoByOrderMianNoPromotion(String orderMainNo) {
        return this.orderProductMapper.getOrderProductInfoByOrderMianNoPromotion(orderMainNo);
    }

    @Override
    public List<MallOrderProductShareVo> getOrderProductShareAmount(String orderNo) {
        ArrayList<MallOrderProductShareVo> productShareVos = new ArrayList<MallOrderProductShareVo>();
        if (StringUtil.isEmpty((String)orderNo)) {
            return productShareVos;
        }
        MallOrderEntity orderEntity = this.orderInterface.getmallOrder(orderNo);
        if (orderEntity == null) {
            return productShareVos;
        }
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderEntity.getOrderMainNo());
        if (orderMainEntity == null) {
            return productShareVos;
        }
        List<MallOrderProductEntity> lst = this.getOrderProductInfoByOrderNo(orderNo);
        double productTotalAmount = lst.stream().mapToDouble(c -> c.getTotalPrice().subtract(c.getFullCutAmount()).doubleValue()).sum();
        double productCouponAmount = lst.stream().mapToDouble(c -> c.getTicketAmount() == null ? 0.0 : c.getTicketAmount().doubleValue() * (double)c.getQuantity().intValue()).sum();
        for (MallOrderProductEntity p : lst) {
            MallOrderProductShareVo shareVo = new MallOrderProductShareVo();
            if (p.getTicketAmount() == null) {
                p.setTicketAmount(BigDecimal.ZERO);
            }
            if (StringUtil.isNotEmpty((String)orderMainEntity.getActiveNo())) {
                shareVo.setActiveNo(orderMainEntity.getActiveNo());
            }
            shareVo.setPromotionId(p.getPromotionId());
            shareVo.setProductId(p.getProductId());
            shareVo.setGroupId(p.getGroupId());
            shareVo.setGroupType(p.getGroupType());
            shareVo.setQuantity(p.getQuantity());
            if (productTotalAmount - productCouponAmount <= 0.0) {
                shareVo.setBalanceAmount(BigDecimal.ZERO);
            } else {
                shareVo.setBalanceAmount(orderEntity.getBalanceAmount().multiply(p.getTotalPrice().subtract(p.getFullCutAmount()).subtract(p.getTicketAmount().multiply(BigDecimal.valueOf(p.getQuantity().intValue())))).divide(BigDecimal.valueOf(productTotalAmount - productCouponAmount), 6));
            }
            shareVo.setCouponAmount(p.getTicketAmount().multiply(BigDecimal.valueOf(p.getQuantity().intValue())));
            if (productTotalAmount <= 0.0) {
                shareVo.setFreight(BigDecimal.ZERO);
            } else {
                shareVo.setFreight(orderEntity.getFreight().multiply(p.getTotalPrice().subtract(p.getFullCutAmount())).divide(BigDecimal.valueOf(productTotalAmount), 6));
            }
            shareVo.setOrderAmount(p.getTotalPrice().subtract(p.getFullCutAmount()));
            shareVo.setItemName(p.getProductName());
            shareVo.setOrderMainNo(p.getOrderMainNo());
            shareVo.setOrderNo(p.getOrderNo());
            shareVo.setOrderProductNo(p.getOrderProductNo());
            shareVo.setTotalAmount(shareVo.getOrderAmount().add(shareVo.getFreight()));
            shareVo.setPayAmount(shareVo.getTotalAmount().subtract(shareVo.getBalanceAmount().subtract(shareVo.getCouponAmount())));
            productShareVos.add(shareVo);
        }
        return productShareVos;
    }

    @Override
    public MallOrderProductEntity getOrderProductByID(String orderProductNo) {
        return (MallOrderProductEntity)this.orderProductMapper.selectByPrimaryKey((Serializable)((Object)orderProductNo));
    }

    @Override
    public void updateOrderProductByID(MallOrderProductEntity orderGroup) {
        this.orderProductMapper.updateByPrimaryKeySelective(orderGroup);
    }

    @Override
    public int getUserCategoryBuyCount(String customerId, Integer categoryId) {
        return this.orderProductMapper.getUserCategoryBuyCount(customerId, categoryId);
    }

    @Override
    public int getAddressCategoryBuyCount(String person, String phone, String province, String city, String area, String address, Integer categoryId) {
        return this.orderProductMapper.getAddressCategoryBuyCount(person, phone, province, city, area, address, categoryId);
    }

    @Override
    public boolean isExists(MallOrderProductEntity orderProductEntity) {
        int i = this.orderProductMapper.existsByEntity(orderProductEntity);
        return i > 0;
    }
}

