/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.common.enums.pay.PayTypeEnum;
import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.database.util.SpringContextUtil;
import cc.lechun.mall.dao.trade.MallOrderMainMapper;
import cc.lechun.mall.dao.trade.MallOrderMapper;
import cc.lechun.mall.dao.trade.MallOrderShipmentItemMapper;
import cc.lechun.mall.dao.trade.MallOrderShipmentMapper;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.entity.trade.MallOrderProductEntity;
import cc.lechun.mall.entity.trade.MallOrderShipmentEntity;
import cc.lechun.mall.entity.trade.MallOrderShipmentItemEntity;
import cc.lechun.mall.entity.trade.MallOrderShipmentVo;
import cc.lechun.mall.entity.weixin.WeiXinBaseEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderShipmentInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import cc.lechun.omsv2.entity.order.third.weixin.WxOrderProductVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Service;
import weixin.popular.api.DeliveryMessageAPI;
import weixin.popular.api.OrderAPI;
import weixin.popular.api.ShippingAPI;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.message.DeliverMessage;
import weixin.popular.bean.message.FollowWaybillResult;
import weixin.popular.bean.shipping.Contact;
import weixin.popular.bean.shipping.OrderKey;
import weixin.popular.bean.shipping.Payer;
import weixin.popular.bean.shipping.ShipOrder;
import weixin.popular.bean.shipping.ShipOrderItem;
import weixin.popular.bean.shipping.ShipOrderResult;
import weixin.popular.bean.shipping.Shipping;
import weixin.popular.bean.shipping.VerifyOrder;
import weixin.popular.bean.shipping.VerifyOrderResult;
import weixin.popular.bean.shipping.WxDeliverGoods;

@Service
public class MallOrderShipmentService
extends BaseService<MallOrderShipmentEntity, Integer>
implements MallOrderShipmentInterface {
    @Resource
    private MallOrderShipmentMapper mallOrderShipmentMapper;
    @Resource
    private MallOrderShipmentItemMapper shipmentItemMapper;
    @Autowired
    private WeiXinBaseInterface weiXinBaseService;
    @Autowired
    MallOrderPayInterface orderPayInterface;
    @Autowired
    CustomerInterface customerService;
    @Autowired
    MallProductInterface mallProductInterface;
    @Resource
    MallOrderMapper mallOrderMapper;
    @Lazy
    @Autowired
    MallOrderProductInterface orderProductService;
    @Lazy
    @Autowired
    private MallPromotionInterface promotionInterface;
    @Resource
    private MallOrderMainMapper mallOrderMainMapper;

    @Override
    public BaseJsonVo saveShipment(MallOrderMainEntity orderMainEntity, MallOrderEntity orderEntity, Date deliverdTime, List<WxOrderProductVO> productVOList, String logisticsOutCode, String logisticsName) {
        this.logger.info("\u8ba2\u5355\u53f7:{}, \u7269\u6d41\u5355\u53f7:{} \u53d1\u9001\u65f6\u95f4:{}, \u5546\u54c1\u6570:{},\u7269\u6d41\u516c\u53f8\u7f16\u7801:{}", new Object[]{orderEntity.getOrderNo(), orderEntity.getWaybillNo(), deliverdTime, productVOList != null ? productVOList.size() : 0, logisticsOutCode});
        long startTime = System.currentTimeMillis();
        Integer ShipmentStatus = orderMainEntity.getPayAmount().compareTo(BigDecimal.ZERO) > 0 && Objects.equals(orderMainEntity.getChannelId(), 86) ? 0 : 1;
        this.saveShipmentRecord(orderMainEntity, orderEntity, deliverdTime, null, productVOList, ShipmentStatus, logisticsOutCode, logisticsName);
        long endTime = System.currentTimeMillis();
        this.logger.info("\u8ba2\u5355:{}\u4fdd\u5b58\u53d1\u8d27\u5355\u8bb0\u5f55\u8017\u65f6:{}", (Object)orderEntity.getOrderNo(), (Object)(endTime - startTime));
        return BaseJsonVo.success((Object)"");
    }

    private BaseJsonVo processShipment(MallOrderMainEntity orderMainEntity, MallOrderEntity orderEntity, List<WxOrderProductVO> productVOList, String logisticsOutCode, String logisticsName) {
        WeiXinBaseEntity weiXinBaseEntity = this.weiXinBaseService.getAccessTokenByPlatformId(orderMainEntity.getPlatformId());
        String waybillToken = null;
        Integer ShipmentStatus = 1;
        Pair pair = Pair.of((Object)"", (Object)ShipmentStatus);
        if (orderMainEntity.getPayAmount().compareTo(BigDecimal.ZERO) > 0) {
            if (Objects.equals(orderMainEntity.getChannelId(), 86)) {
                this.logger.info("\u8ba2\u5355:{},\u4e0a\u4f20\u7269\u6d41\u5904\u7406\u4e2d", (Object)orderEntity.getOrderNo());
                long start = System.currentTimeMillis();
                Date date = DateUtils.getDateFromString((String)"2025-01-23 00:00:00");
                if (orderMainEntity.getCreateTime().after(date)) {
                    BaseJsonVo baseJsonVo = this.uploadShipOrder(orderMainEntity, weiXinBaseEntity, orderEntity, productVOList, logisticsOutCode, logisticsName, orderEntity.getWaybillNo());
                    ShipmentStatus = baseJsonVo.isSuccess() ? 1 : 0;
                }
                pair = StringUtils.isNotEmpty((String)(waybillToken = this.pushWeChatDeliveryMessage(orderMainEntity, orderEntity, weiXinBaseEntity, productVOList))) ? Pair.of((Object)waybillToken, (Object)ShipmentStatus) : Pair.of((Object)"", (Object)ShipmentStatus);
                long end = System.currentTimeMillis();
                this.logger.info("\u8ba2\u5355:{},\u4e0a\u4f20\u7269\u6d41\u7ec4\u4ef6:{},\u4e0a\u62a5\u7269\u6d41\u72b6\u6001:{},\u7269\u6d41\u4fe1\u606f\u4e0a\u4f20\u8017\u65f6:{}", new Object[]{orderEntity.getOrderNo(), waybillToken, ShipmentStatus, end - start});
            }
        } else {
            pair = Pair.of((Object)"", (Object)ShipmentStatus);
        }
        return BaseJsonVo.success((Object)pair);
    }

    private String pushWeChatDeliveryMessage(MallOrderMainEntity orderMainEntity, MallOrderEntity orderEntity, WeiXinBaseEntity weiXinBaseEntity, List<WxOrderProductVO> productVOList) {
        if (StringUtils.isEmpty((String)weiXinBaseEntity.getAccessToken()) || CollectionUtils.isEmpty(productVOList)) {
            this.logger.warn("\u8ba2\u5355:{} \u672a\u63a8\u9001\u5fae\u4fe1\u7269\u6d41, \u53ef\u80fd\u56e0 accessToken \u4e3a\u7a7a\u6216\u5546\u54c1\u5217\u8868\u4e3a\u7a7a", (Object)orderEntity.getOrderNo());
            return null;
        }
        Optional<MallOrderPayEntity> payEntityOptional = this.orderPayInterface.getList(orderMainEntity.getOrderMainNo()).stream().filter(pay -> Objects.equals(pay.getPaytypeId(), PayTypeEnum.WECHAT_PAY.getValue())).findFirst();
        if (!payEntityOptional.isPresent()) {
            this.logger.info("\u8ba2\u5355:{} \u975e\u5fae\u4fe1\u652f\u4ed8\u8ba2\u5355, \u65e0\u6cd5\u63a8\u9001\u7269\u6d41\u6d88\u606f", (Object)orderEntity.getOrderNo());
            return null;
        }
        CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(orderMainEntity.getCustomerId(), orderMainEntity.getPlatformId());
        DeliverMessage deliverMessage = this.buildDeliverMessage(orderEntity, payEntityOptional.get(), customerDetailVo, productVOList);
        this.logger.info("\u8ba2\u5355:{} \u8c03\u7528\u7269\u6d41\u7ec4\u4ef6\u53c2\u6570:{}", (Object)orderEntity.getOrderNo(), (Object)deliverMessage);
        FollowWaybillResult followWaybillResult = DeliveryMessageAPI.follow_waybill((String)weiXinBaseEntity.getAccessToken(), (DeliverMessage)deliverMessage);
        if (!followWaybillResult.isSuccess()) {
            this.logger.error("\u8ba2\u5355:{} \u8c03\u7528\u7269\u6d41\u7ec4\u4ef6\u5931\u8d25: {}", (Object)orderEntity.getOrderNo(), (Object)followWaybillResult.getErrmsg());
            return null;
        }
        this.logger.info("\u8ba2\u5355:{} \u7269\u6d41id:{} \u66f4\u65b0\u6210\u529f", (Object)orderEntity.getOrderNo(), (Object)followWaybillResult.getWaybill_token());
        return followWaybillResult.getWaybill_token();
    }

    private DeliverMessage buildDeliverMessage(MallOrderEntity orderEntity, MallOrderPayEntity payEntity, CustomerDetailVo customerDetailVo, List<WxOrderProductVO> productVOList) {
        DeliverMessage deliverMessage = new DeliverMessage();
        deliverMessage.setOpenid(customerDetailVo.getOpenId());
        deliverMessage.setReceiver_phone(orderEntity.getConsigneePhone());
        deliverMessage.setOrder_detail_path("account/pages/order_detail/index?orderMainNo=" + orderEntity.getOrderMainNo() + "&orderNo=" + orderEntity.getOrderNo());
        deliverMessage.setTrans_id(payEntity.getThirdTradeNo());
        deliverMessage.setWaybill_id(orderEntity.getWaybillNo());
        List detailList = productVOList.stream().map(product -> {
            MallProductEntity mallProductVO = this.mallProductInterface.getProductByBarcode(product.getProductCbarcode());
            DeliverMessage.Detail detail = new DeliverMessage.Detail();
            detail.setGoods_name(mallProductVO.getProName());
            detail.setGoods_img_url(this.mallProductInterface.getProductPicUrlMap(product.getProductId()).getOrDefault(ProductPicTypeEnum.PRO_SAMLL.getName(), Collections.singletonList("")).get(0));
            return detail;
        }).collect(Collectors.toList());
        DeliverMessage.GoodsInfo goodsInfo = new DeliverMessage.GoodsInfo();
        goodsInfo.setDetail_list(detailList);
        deliverMessage.setGoods_info(goodsInfo);
        return deliverMessage;
    }

    private void saveShipmentRecord(MallOrderMainEntity orderMainEntity, MallOrderEntity orderEntity, Date deliverdTime, String waybillToken, List<WxOrderProductVO> productVOList, Integer ShipmentStatus, String logisticsOutCode, String logisticsName) {
        MallOrderShipmentEntity entity = new MallOrderShipmentEntity();
        entity.setWaybillno(orderEntity.getWaybillNo());
        entity.setOrderno(orderEntity.getOrderNo());
        if (this.mallOrderShipmentMapper.getSingle(entity) == null) {
            entity.setCustomerId(orderMainEntity.getCustomerId());
            entity.setShipmentDate(deliverdTime);
            entity.setCreatedAt(new Date());
            entity.setWaybillToken(waybillToken);
            entity.setStatus(OrderStatusEnum.getName(orderEntity.getStatus()));
            entity.setShipmentStatus(ShipmentStatus);
            entity.setOrderMainNo(orderMainEntity.getOrderMainNo());
            entity.setLogisticsOutCode(logisticsOutCode);
            entity.setLogisticsName(logisticsName);
            this.mallOrderShipmentMapper.insert(entity);
            this.logger.info("\u8ba2\u5355:{} \u53d1\u8d27\u5355:{} \u4fdd\u5b58\u6210\u529f", (Object)orderEntity.getOrderNo(), (Object)entity.getWaybillno());
            this.saveShipmentItems(entity, productVOList);
        }
    }

    private void saveShipmentItems(MallOrderShipmentEntity entity, List<WxOrderProductVO> productVOList) {
        if (CollectionUtils.isEmpty(productVOList)) {
            this.logger.error("\u8ba2\u5355:{} \u53d1\u8d27\u5546\u54c1\u660e\u7ec6\u4e3a\u7a7a", (Object)entity.getOrderno());
            return;
        }
        List itemEntityList = productVOList.stream().map(product -> {
            MallOrderShipmentItemEntity itemEntity = new MallOrderShipmentItemEntity();
            itemEntity.setShipmentId(entity.getShipmentId());
            itemEntity.setBarcode(product.getProductCbarcode());
            itemEntity.setQuantity(product.getProductNum().intValue());
            itemEntity.setProductId(StringUtils.isNotEmpty((String)product.getProductId()) ? product.getProductId() : "");
            itemEntity.setCreatedAt(new Date());
            return itemEntity;
        }).collect(Collectors.toList());
        this.shipmentItemMapper.batchInsert(itemEntityList);
        this.logger.info("\u8ba2\u5355:{} \u53d1\u8d27\u5355:{} \u53d1\u8d27\u5546\u54c1\u660e\u7ec6\u4fdd\u5b58\u6210\u529f", (Object)entity.getOrderno(), (Object)entity.getWaybillno());
    }

    @Override
    public BaseJsonVo uploadShipOrder(MallOrderMainEntity orderMainEntity, WeiXinBaseEntity weiXinBaseEntity, MallOrderEntity orderEntity, List<WxOrderProductVO> productVOList, String logisticsOutCode, String logisticsName, String waybillNo) {
        if (Objects.equals(orderMainEntity.getChannelId(), 86) && orderMainEntity.getPayAmount().compareTo(BigDecimal.ZERO) > 0) {
            List<MallOrderPayEntity> payEntityList = this.orderPayInterface.getList(orderMainEntity.getOrderMainNo());
            List wechatPayList = payEntityList.stream().filter(p -> p.getPaytypeId().intValue() == PayTypeEnum.WECHAT_PAY.getValue()).collect(Collectors.toList());
            WxDeliverGoods wxDeliverGoods = new WxDeliverGoods();
            OrderKey orderKey = new OrderKey();
            orderKey.setOrder_number_type(Integer.valueOf(1));
            orderKey.setOut_trade_no(((MallOrderPayEntity)wechatPayList.get(0)).getTradeNo());
            orderKey.setTransaction_id(((MallOrderPayEntity)wechatPayList.get(0)).getThirdTradeNo());
            orderKey.setMchid(weiXinBaseEntity.getMchId());
            wxDeliverGoods.setOrder_key(orderKey);
            ArrayList<Shipping> shipping_list = new ArrayList<Shipping>();
            String itemNameDesc = "";
            for (WxOrderProductVO product : productVOList) {
                MallProductEntity mallProductVO = null;
                if (StringUtils.isNotEmpty((String)product.getProductId())) {
                    mallProductVO = this.mallProductInterface.getProduct(product.getProductId());
                    if (mallProductVO == null) {
                        mallProductVO = this.mallProductInterface.getProductByBarcode(product.getProductCbarcode());
                    }
                } else {
                    mallProductVO = this.mallProductInterface.getProductByBarcode(product.getProductCbarcode());
                }
                if (mallProductVO != null) {
                    itemNameDesc = (StringUtils.isNotEmpty((String)itemNameDesc) ? itemNameDesc + "," : "") + mallProductVO.getProName() + "*" + product.getProductNum().setScale(0, 4);
                    continue;
                }
                this.logger.error("\u8ba2\u5355:{},\u5546\u54c1:{},\u672a\u627e\u5230\u5546\u54c1\u4fe1\u606f", (Object)orderEntity.getOrderNo(), (Object)product.getProductCbarcode());
            }
            Shipping shipping = new Shipping();
            shipping.setItem_desc(itemNameDesc);
            if (shipping.getItem_desc().length() > 120) {
                shipping.setItem_desc(shipping.getItem_desc().substring(0, 119));
            }
            Contact contact = new Contact();
            if (StringUtils.isNotEmpty((String)orderEntity.getConsigneePhone())) {
                String phone = orderEntity.getConsigneePhone().substring(0, 3) + "****" + orderEntity.getConsigneePhone().substring(7);
                contact.setReceiver_contact(phone);
                shipping.setContact(contact);
            }
            if (StringUtils.isNotEmpty((String)waybillNo)) {
                shipping.setTracking_no(waybillNo);
            }
            if (StringUtils.isEmpty((String)logisticsOutCode)) {
                if (StringUtils.isNotEmpty((String)logisticsName)) {
                    if (logisticsName.contains("\u4e2d\u901a")) {
                        shipping.setExpress_company("ZTO");
                    } else if (logisticsName.contains("\u4eac\u4e1c")) {
                        shipping.setExpress_company("JD");
                    } else if (logisticsName.contains("\u5706\u901a")) {
                        shipping.setExpress_company("YTO");
                    } else if (logisticsName.contains("\u6781\u5154")) {
                        shipping.setExpress_company("JTSD");
                    } else if (logisticsName.contains("\u7533\u901a")) {
                        shipping.setExpress_company("STO");
                    } else if (logisticsName.contains("\u987a\u4e30")) {
                        shipping.setExpress_company("SF");
                    } else if (logisticsName.contains("EMS")) {
                        shipping.setExpress_company("EMS");
                    } else if (logisticsName.contains("\u90ae\u653f")) {
                        shipping.setExpress_company("YZPY");
                    } else {
                        this.logger.error("\u5feb\u9012\u516c\u53f8\u7f16\u7801\u672a\u80fd\u8bc6\u522b\uff0c\u5355\u53f7:{},\u7269\u6d41\u516c\u53f8:{}", (Object)waybillNo, (Object)logisticsName);
                    }
                }
            } else {
                shipping.setExpress_company(logisticsOutCode);
                this.logger.info("\u7269\u6d41\u516c\u53f8\u7f16\u7801:{}", (Object)logisticsOutCode);
            }
            shipping_list.add(shipping);
            wxDeliverGoods.setShipping_list(shipping_list);
            wxDeliverGoods.setLogistics_type(Integer.valueOf(orderMainEntity.getStatus() == 16 ? 3 : 1));
            wxDeliverGoods.setDelivery_mode(Integer.valueOf(1));
            wxDeliverGoods.setUpload_time(this.getTime());
            Payer payer = new Payer();
            CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(orderMainEntity.getCustomerId(), orderMainEntity.getPlatformId());
            payer.setOpenid(customerDetailVo.getOpenId());
            wxDeliverGoods.setPayer(payer);
            this.logger.info("\u8ba2\u5355\u53d1\u8d27\u4e0a\u4f20:{}\u53d1\u8d27\u4fe1\u606f:{}", (Object)orderEntity.getOrderNo(), (Object)JsonUtils.toJson((Object)wxDeliverGoods, (boolean)false));
            BaseResult baseResult = ShippingAPI.uploadShippingInfo((String)weiXinBaseEntity.getAccessToken(), (WxDeliverGoods)wxDeliverGoods);
            this.logger.info("\u8ba2\u5355\u53d1\u8d27\u4e0a\u4f20\u7ed3\u679c:{},{}", (Object)orderEntity.getOrderNo(), (Object)baseResult.toString());
            return baseResult.isSuccess() && Objects.equals(baseResult.getErrcode(), "0") ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)baseResult.getErrmsg());
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo uploadShipOrder(Date date) {
        this.logger.info("\u5f00\u59cb\u4e0a\u4f20\u5fae\u4fe1\u7269\u6d41\u8ba2\u5355....");
        if (date == null) {
            date = DateUtils.currentDate();
        }
        this.logger.info("\u5f00\u59cb\u4e0a\u4f20\u5fae\u4fe1\u7269\u6d41\u8ba2\u5355....{}", (Object)DateUtils.formatDate((Date)date, (String)"yyyy-MM-dd"));
        List<MallOrderShipmentEntity> list = this.mallOrderShipmentMapper.getOrderShipList(date, 0);
        if (CollectionUtils.isNotEmpty(list)) {
            for (MallOrderShipmentEntity orderShipmentEntity : list) {
                long start = System.currentTimeMillis();
                MallOrderMainEntity orderMainEntity = (MallOrderMainEntity)this.mallOrderMainMapper.selectByPrimaryKey((Serializable)((Object)orderShipmentEntity.getOrderMainNo()));
                MallOrderEntity orderEntity = (MallOrderEntity)this.mallOrderMapper.selectByPrimaryKey((Serializable)((Object)orderShipmentEntity.getOrderno()));
                MallOrderShipmentItemEntity query = new MallOrderShipmentItemEntity();
                query.setShipmentId(orderShipmentEntity.getShipmentId());
                List result = this.shipmentItemMapper.getList(query);
                List<WxOrderProductVO> productVOList = result.stream().map(item -> {
                    WxOrderProductVO wxOrderProductVO = new WxOrderProductVO();
                    wxOrderProductVO.setProductId(item.getProductId());
                    wxOrderProductVO.setProductCbarcode(item.getBarcode());
                    wxOrderProductVO.setProductNum(new BigDecimal(item.getQuantity()));
                    return wxOrderProductVO;
                }).collect(Collectors.toList());
                BaseJsonVo baseJsonVo = this.processShipment(orderMainEntity, orderEntity, productVOList, orderShipmentEntity.getLogisticsOutCode(), orderShipmentEntity.getLogisticsName());
                if (baseJsonVo.isSuccess()) {
                    orderShipmentEntity.setShipmentStatus((Integer)((Pair)baseJsonVo.getValue()).getSecond());
                    if (StringUtils.isNotEmpty((String)((String)((Pair)baseJsonVo.getValue()).getFirst()))) {
                        orderShipmentEntity.setWaybillToken((String)((Pair)baseJsonVo.getValue()).getFirst());
                    }
                    if ((Integer)((Pair)baseJsonVo.getValue()).getSecond() == 0) {
                        orderShipmentEntity.setShipmentStatus(this.getShipmentStatus(orderMainEntity));
                    }
                }
                this.mallOrderShipmentMapper.updateByPrimaryKeySelective(orderShipmentEntity);
                this.logger.info("\u8ba2\u5355:{},\u7269\u6d41\u7ec4\u4ef6:{},\u4e0a\u4f20\u7269\u6d41\u72b6\u6001:{} \u6210\u529f", new Object[]{orderEntity.getOrderNo(), ((Pair)baseJsonVo.getValue()).getFirst(), ((Pair)baseJsonVo.getValue()).getSecond()});
                long end = System.currentTimeMillis();
                this.logger.info("\u4e0a\u4f20\u5fae\u4fe1\u7269\u6d41\u4e00\u4e2a\u8ba2\u5355\u8017\u65f6:{}", (Object)(end - start));
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    private Integer getShipmentStatus(MallOrderMainEntity orderMainEntity) {
        try {
            List<MallOrderPayEntity> payEntityList = this.orderPayInterface.getList(orderMainEntity.getOrderMainNo());
            List wechatPayList = payEntityList.stream().filter(p -> p.getPaytypeId().intValue() == PayTypeEnum.WECHAT_PAY.getValue()).collect(Collectors.toList());
            WeiXinBaseEntity weiXinBaseEntity = this.weiXinBaseService.getAccessTokenByPlatformId(orderMainEntity.getPlatformId());
            ShipOrderResult shipOrderResult = ShippingAPI.get_order((String)weiXinBaseEntity.getAccessToken(), (String)weiXinBaseEntity.getMchId(), (String)((MallOrderPayEntity)wechatPayList.get(0)).getTradeNo());
            if (shipOrderResult.isSuccess() && shipOrderResult.getOrder().getOrderState() >= 2) {
                return 1;
            }
            this.logger.info("\u8ba2\u5355:{},\u67e5\u8be2\u53d1\u8d27\u72b6\u6001", (Object)orderMainEntity.getOrderMainNo(), (Object)JsonUtils.toJson((Object)shipOrderResult, (boolean)false));
        }
        catch (Exception e) {
            this.logger.error("\u8ba2\u5355:{},\u67e5\u8be2\u53d1\u8d27\u72b6\u6001\u5931\u8d25", (Object)orderMainEntity.getOrderMainNo());
        }
        return 0;
    }

    @Override
    public BaseJsonVo uploadShipOrder(String date) {
        if (StringUtils.isEmpty((String)date)) {
            date = DateUtils.date();
        }
        Date newDate = DateUtils.getDateFromString((String)date, (String)"yyyy-MM-dd");
        return this.uploadShipOrder(newDate);
    }

    private String getTime() {
        ZonedDateTime now = ZonedDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
        String formattedTime = now.format(formatter);
        return formattedTime;
    }

    @Override
    public List<MallOrderShipmentVo> getShipmentList(String orderno) {
        MallOrderShipmentEntity entity = new MallOrderShipmentEntity();
        entity.setOrderno(orderno);
        List shipmentList = this.mallOrderShipmentMapper.getList(entity);
        if (CollectionUtils.isNotEmpty((Collection)shipmentList)) {
            List<MallOrderShipmentVo> result = shipmentList.stream().map(shipment -> {
                MallOrderShipmentVo vo = new MallOrderShipmentVo();
                vo.setOrderno(shipment.getOrderno());
                vo.setShipmentDate(shipment.getShipmentDate());
                vo.setWaybillno(shipment.getWaybillno());
                if (StringUtils.isNotEmpty((String)shipment.getWaybillToken())) {
                    vo.setWaybillToken(shipment.getWaybillToken());
                }
                MallOrderShipmentItemEntity item = new MallOrderShipmentItemEntity();
                item.setShipmentId(shipment.getShipmentId());
                List itemList = this.shipmentItemMapper.getList(item);
                vo.setProductDesc(itemList.stream().map(itemEntity -> {
                    MallProductEntity product = this.mallProductInterface.getProductByBarcode(itemEntity.getBarcode());
                    return product != null ? product.getProName() + "*" + itemEntity.getQuantity() : "";
                }).collect(Collectors.joining(",")));
                return vo;
            }).collect(Collectors.toList());
            result.stream().sorted((o1, o2) -> o1.getShipmentDate().compareTo(o2.getShipmentDate()));
            return result;
        }
        return null;
    }

    @Override
    public void uploadShip(MallOrderMainEntity orderMainEntity, WeiXinBaseEntity weiXinBaseEntity, String logisticsName, String waybillNo) {
        if (orderMainEntity.getPayAmount().compareTo(BigDecimal.ZERO) > 0) {
            try {
                List<MallOrderPayEntity> payEntityList = this.orderPayInterface.getList(orderMainEntity.getOrderMainNo());
                List wechatPayList = payEntityList.stream().filter(p -> p.getPaytypeId().intValue() == PayTypeEnum.WECHAT_PAY.getValue()).collect(Collectors.toList());
                ShipOrder shipOrder = new ShipOrder();
                OrderKey orderKey = new OrderKey();
                orderKey.setOrder_number_type(Integer.valueOf(1));
                orderKey.setOut_trade_no(((MallOrderPayEntity)wechatPayList.get(0)).getTradeNo());
                orderKey.setMchid(weiXinBaseEntity.getMchId());
                shipOrder.setOrder_key(orderKey);
                shipOrder.setDelivery_mode(Integer.valueOf(1));
                Payer payer = new Payer();
                CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(orderMainEntity.getCustomerId(), orderMainEntity.getPlatformId());
                if (customerDetailVo == null) {
                    this.logger.info("\u4e0a\u4f20\u8ba2\u5355\u5931\u8d25,\u7528\u6237:{},openId \u4e3a\u7a7a", (Object)orderMainEntity.getCustomerId());
                    return;
                }
                payer.setOpenid(customerDetailVo.getOpenId());
                shipOrder.setPayer(payer);
                ArrayList<ShipOrderItem> shipping_list = new ArrayList<ShipOrderItem>();
                ShipOrderItem shipOrderItem = new ShipOrderItem();
                if (StringUtils.isNotEmpty((String)waybillNo)) {
                    shipOrderItem.setTracking_no(waybillNo);
                }
                if (StringUtils.isNotEmpty((String)logisticsName)) {
                    if (logisticsName.contains("\u4e2d\u901a")) {
                        shipOrderItem.setExpress_company("ZTO");
                    } else if (logisticsName.contains("\u4eac\u4e1c")) {
                        shipOrderItem.setExpress_company("JD");
                    } else if (logisticsName.contains("\u5706\u901a")) {
                        shipOrderItem.setExpress_company("YTO");
                    } else if (logisticsName.contains("\u6781\u5154")) {
                        shipOrderItem.setExpress_company("JTSD");
                    } else if (logisticsName.contains("\u7533\u901a")) {
                        shipOrderItem.setExpress_company("STO");
                    } else if (logisticsName.contains("\u987a\u4e30")) {
                        shipOrderItem.setExpress_company("SF");
                    } else {
                        this.logger.error("\u5feb\u9012\u516c\u53f8\u7f16\u7801\u672a\u80fd\u8bc6\u522b\uff0c\u5355\u53f7:{},\u7269\u6d41\u516c\u53f8:{}", (Object)waybillNo, (Object)logisticsName);
                    }
                }
                shipping_list.add(shipOrderItem);
                shipOrder.setShipping_list(shipping_list);
                shipOrder.setUpload_time(this.getTime());
                this.logger.info("[{}]\u7269\u6d41\u8ba2\u5355:{},{} \u6570\u636e\u4e0a\u4f20\u6210\u529f", (Object)orderMainEntity.getOrderMainNo(), (Object)shipOrder.toString());
                BaseResult baseResult = ShippingAPI.shippings((String)weiXinBaseEntity.getAccessToken(), (ShipOrder)shipOrder);
                this.logger.info("[{}]\u7269\u6d41\u8ba2\u5355\u4e0a\u62a5\u7ed3\u679c:{}", (Object)orderMainEntity.getOrderMainNo(), (Object)baseResult.toString());
            }
            catch (Exception e) {
                this.logger.error("\u8ba2\u5355:{},{}\u53d1\u8d27\u5355:\u53d1\u8d27\u4fe1\u606f\u4e0a\u4f20\u5931\u8d25", new Object[]{orderMainEntity.getOrderMainNo(), waybillNo, e});
            }
        }
    }

    @Override
    public void uploadOrder(String date) {
        List<MallOrderMainEntity> orderList;
        if (StringUtils.isEmpty((String)date)) {
            date = DateUtils.date();
        }
        if (CollectionUtils.isNotEmpty(orderList = this.mallOrderMainMapper.getMainOrderList(DateUtils.getDateFromString((String)date, (String)"yyyy-MM-dd")))) {
            for (MallOrderMainEntity orderMainEntity : orderList) {
                String key = "Upload:" + date + ":" + orderMainEntity.getOrderMainNo();
                if (this.redisCacheUtil.get(key) != null) continue;
                long start = System.currentTimeMillis();
                try {
                    BaseJsonVo baseJsonVo = this.uploadOrder(orderMainEntity);
                    if (baseJsonVo.isSuccess()) {
                        this.redisCacheUtil.set(key, (Object)1, Long.valueOf(86400L));
                    }
                }
                catch (Exception e) {
                    this.logger.error("\u8ba2\u5355:{}\u4e0a\u4f20\u7269\u6d41\u4fe1\u606f\u5931\u8d25:", (Object)orderMainEntity.getOrderMainNo(), (Object)e);
                }
                long end = System.currentTimeMillis();
                this.logger.info("\u4e00\u6b21\u4e0a\u4f20\u8ba2\u5355\u7269\u6d41\u8017\u65f6:{}", (Object)(end - start));
            }
        }
    }

    @Override
    public BaseJsonVo uploadOrder(MallOrderMainEntity orderMainEntity) {
        if (orderMainEntity.getPayAmount().compareTo(BigDecimal.ZERO) > 0 && orderMainEntity.getStatus() == 16) {
            this.logger.info("\u5f00\u59cb\u4e0a\u4f20\u865a\u62df\u8ba2\u5355:{}\u53d1\u8d27", (Object)orderMainEntity.getOrderMainNo());
            long start = System.currentTimeMillis();
            WeiXinBaseEntity weiXinBaseEntity = this.weiXinBaseService.getAccessTokenByPlatformId(orderMainEntity.getPlatformId());
            MallOrderEntity orderEntity = new MallOrderEntity();
            orderEntity.setOrderMainNo(orderMainEntity.getOrderMainNo());
            List orderList = this.mallOrderMapper.getList(orderEntity);
            ArrayList<WxOrderProductVO> list = new ArrayList<WxOrderProductVO>();
            List<MallOrderProductEntity> result = this.orderProductService.getOrderProductInfoByOrderMianNo(orderMainEntity.getOrderMainNo());
            for (MallOrderProductEntity orderProduct : result) {
                WxOrderProductVO wxOrderProductVO = new WxOrderProductVO();
                wxOrderProductVO.setProductId(orderProduct.getProductId());
                wxOrderProductVO.setProductName(orderProduct.getProductName());
                wxOrderProductVO.setProductNum(new BigDecimal(orderProduct.getQuantity()));
                wxOrderProductVO.setProductPrice(orderProduct.getUnitPrice());
                list.add(wxOrderProductVO);
            }
            BaseJsonVo baseJsonVo = ((MallOrderShipmentService)SpringContextUtil.getBean(this.getClass())).uploadShipOrder(orderMainEntity, weiXinBaseEntity, (MallOrderEntity)orderList.get(0), list, "", "", "");
            if (!baseJsonVo.isSuccess()) {
                this.logger.error("\u8ba2\u5355:{},\u4e0a\u4f20\u53d1\u8d27\u5931\u8d25:{}", (Object)orderEntity.getOrderMainNo(), (Object)baseJsonVo.getMessage());
            }
            long end = System.currentTimeMillis();
            this.logger.info("\u4e0a\u4f20\u865a\u62df\u8ba2\u5355:{}\u7269\u6d41\u4fe1\u606f\u8017\u65f6:{}", (Object)orderMainEntity.getOrderMainNo(), (Object)(end - start));
            return baseJsonVo;
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public List<String> verifyOrder(String date) {
        MallOrderMainEntity query = new MallOrderMainEntity();
        date = date.replace("-", "");
        query.setOrderMainNo(SqlUtils.sqlLike((String)date, (SqlLikeEnum)SqlLikeEnum.sqlLike_Suffix));
        List orderList = this.mallOrderMainMapper.getList(query);
        ArrayList<String> list = new ArrayList<String>();
        orderList.forEach(orderMainEntity -> {
            this.logger.info("\u5f00\u59cb\u6821\u9a8c[{}]\u8ba2\u5355:", (Object)orderMainEntity.getOrderMainNo());
            String result = this.verifyOrder((MallOrderMainEntity)orderMainEntity);
            this.logger.info("\u6821\u9a8c[{}]\u8ba2\u5355\u7ed3\u675f", (Object)orderMainEntity.getOrderMainNo());
            if (StringUtils.isNotEmpty((String)result)) {
                list.add(result);
                this.logger.info("[{}]\u8ba2\u5355:{},\u8ba2\u5355\u72b6\u6001:{},\u8ba2\u5355\u4e0a\u62a5\u5931\u8d25", new Object[]{orderMainEntity.getOrderMainNo(), orderMainEntity.getStatus(), result});
            }
        });
        return list;
    }

    private String verifyOrder(MallOrderMainEntity orderMainEntity) {
        if (orderMainEntity.getPayAmount().compareTo(BigDecimal.ZERO) > 0) {
            if (orderMainEntity.getStatus() <= 1) {
                this.logger.info("[{}]\u8ba2\u5355:{},\u8ba2\u5355\u72b6\u6001:{},\u672a\u652f\u4ed8\u8ba2\u5355\u4e0d\u8fdb\u884c\u8ba2\u5355\u4e0a\u62a5", (Object)orderMainEntity.getOrderMainNo(), (Object)orderMainEntity.getStatus());
                return "";
            }
            this.logger.info("[{}]\u9a8c\u8bc1\u652f\u4ed8\u8ba2\u5355\u5f00\u59cb", (Object)orderMainEntity.getOrderMainNo());
            try {
                WeiXinBaseEntity weiXinBaseEntity = this.weiXinBaseService.getAccessTokenByPlatformId(orderMainEntity.getPlatformId());
                VerifyOrder verifyOrder = new VerifyOrder();
                List<MallOrderPayEntity> payEntityList = this.orderPayInterface.getList(orderMainEntity.getOrderMainNo());
                List wechatPayList = payEntityList.stream().filter(p -> p.getPaytypeId().intValue() == PayTypeEnum.WECHAT_PAY.getValue()).collect(Collectors.toList());
                OrderKey orderKey = new OrderKey();
                orderKey.setOut_trade_no(((MallOrderPayEntity)wechatPayList.get(0)).getTradeNo());
                orderKey.setMchid(weiXinBaseEntity.getMchId());
                orderKey.setOrder_number_type(Integer.valueOf(1));
                verifyOrder.setOrder_key(orderKey);
                Payer payer = new Payer();
                CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(orderMainEntity.getCustomerId(), orderMainEntity.getPlatformId());
                if (customerDetailVo == null) {
                    this.logger.info("\u4e0a\u4f20\u8ba2\u5355\u5931\u8d25,\u7528\u6237:{},openId \u4e3a\u7a7a", (Object)orderMainEntity.getCustomerId());
                    return "";
                }
                payer.setOpenid(customerDetailVo.getOpenId());
                verifyOrder.setPayer(payer);
                this.logger.info("[{}]\u8ba2\u5355:{}, \u4e0a\u4f20\u9a8c\u8bc1", (Object)orderMainEntity.getOrderMainNo(), (Object)verifyOrder.toString());
                VerifyOrderResult baseResult = OrderAPI.verifyOrder((String)weiXinBaseEntity.getAccessToken(), (VerifyOrder)verifyOrder);
                this.logger.info("[{}]\u8ba2\u5355:{}, \u4e0a\u4f20\u9a8c\u8bc1\u7ed3\u679c:{}", new Object[]{orderMainEntity.getOrderMainNo(), verifyOrder.toString(), baseResult.toString()});
                if (!Objects.equals(baseResult.getVerify_result(), "\u8d2d\u7269\u8ba2\u5355\u4e0a\u4f20\u6210\u529f")) {
                    return "\u8ba2\u5355\u53f7:" + orderMainEntity.getOrderMainNo() + "," + baseResult.toString();
                }
                return "";
            }
            catch (Exception e) {
                this.logger.error("[{}]\u9a8c\u8bc1\u63a5\u5165\u8d2d\u7269\u8ba2\u5355\u51fa\u9519!", (Object)orderMainEntity.getOrderMainNo(), (Object)e);
            }
        }
        return "";
    }
}

