/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerOpenidEntity;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderEntitiesVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.entity.trade.MiniShopOrderAddressInfo;
import cc.lechun.mall.entity.trade.MiniShopOrderDeliveryDetail;
import cc.lechun.mall.entity.trade.MiniShopOrderDetail;
import cc.lechun.mall.entity.trade.MiniShopOrderPayInfo;
import cc.lechun.mall.entity.trade.MiniShopOrderPriceInfo;
import cc.lechun.mall.entity.trade.MiniShopOrderProductInfo;
import cc.lechun.mall.entity.trade.MiniShopOrderUpdateVO;
import cc.lechun.mall.entity.trade.MiniShopOrderVO;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.trade.MiniShopOrderInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.popular.api.shop.OrderAPI;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.shop.order.SceneCheckResult;

@Service
public class MiniShopOrderService
implements MiniShopOrderInterface {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    CustomerInterface customerInterface;
    @Autowired
    MallProductPicInterface productPicInterface;
    @Autowired
    MallOrderPayInterface mallOrderPayInterface;
    @Autowired
    WeiXinBaseInterface weiXinBaseInterface;

    @Override
    public MiniShopOrderVO buildMiniShopOrder(MallMainOrderVo mallMainOrderVo, MallOrderEntitiesVo orderEntitiesVo) {
        this.logger.info("===========buildMiniShopOrder==========mallMainOrderVo:{}", (Object)mallMainOrderVo);
        this.logger.info("===========buildMiniShopOrder==========orderEntitiesVo:{}", (Object)orderEntitiesVo);
        MallOrderEntity order = orderEntitiesVo.getOrderEntities().get(0);
        MiniShopOrderVO miniShopOrderVO = new MiniShopOrderVO();
        miniShopOrderVO.setOut_order_id(mallMainOrderVo.getMainOrderNo());
        miniShopOrderVO.setCreate_time(DateUtils.formatDate((Date)orderEntitiesVo.getOrderMainEntity().getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        miniShopOrderVO.setType(0);
        Optional<CustomerOpenidEntity> openidEntity = this.customerInterface.getCustomerOpenidList(orderEntitiesVo.getOrderMainEntity().getCustomerId()).stream().filter(customerOpenidEntity -> customerOpenidEntity.getPlatformId().intValue() == mallMainOrderVo.getPlatFormId()).findAny();
        if (openidEntity.isPresent()) {
            miniShopOrderVO.setOpenid(openidEntity.get().getOpenId());
        }
        miniShopOrderVO.setOut_user_id(orderEntitiesVo.getOrderMainEntity().getCustomerId());
        miniShopOrderVO.setPath("/account/pages/order_detail/index?orderMainNo=" + orderEntitiesVo.getOrderMainEntity().getOrderMainNo() + "&orderNo=" + order.getOrderNo());
        MiniShopOrderDetail miniShopOrderDetail = new MiniShopOrderDetail();
        ArrayList<MiniShopOrderProductInfo> miniShopOrderProductInfos = new ArrayList<MiniShopOrderProductInfo>();
        orderEntitiesVo.getOrderGroupProductEntities().forEach(product -> {
            MiniShopOrderProductInfo miniShopOrderProductInfo = new MiniShopOrderProductInfo();
            miniShopOrderProductInfo.setOut_product_id(product.getProductId());
            miniShopOrderProductInfo.setOut_sku_id(product.getProductId());
            miniShopOrderProductInfo.setProduct_cnt(product.getQuantity());
            miniShopOrderProductInfo.setTitle(product.getProductName());
            miniShopOrderProductInfo.setSale_price(product.getUnitPrice().multiply(new BigDecimal("100")).intValue());
            miniShopOrderProductInfo.setHead_img(this.productPicInterface.getProductPicUrl(product.getProductId(), ProductPicTypeEnum.PRO_SAMLL.getValue()).get(0));
            miniShopOrderProductInfo.setPath("pages/product_detail/index?productId=" + product.getProductId() + "&productType=4");
            miniShopOrderProductInfos.add(miniShopOrderProductInfo);
        });
        MiniShopOrderPayInfo miniShopOrderPayInfo = new MiniShopOrderPayInfo();
        List<MallOrderPayEntity> orderPayEntities = orderEntitiesVo.getOrderPayEntities();
        orderPayEntities.sort(new Comparator<MallOrderPayEntity>(){

            @Override
            public int compare(MallOrderPayEntity o1, MallOrderPayEntity o2) {
                return o2.getSort() - o1.getSort();
            }
        });
        this.logger.info("===========buildMiniShopOrder==========orderPayEntities:{}", orderPayEntities);
        miniShopOrderPayInfo.setPay_method(orderPayEntities.get(0).getPaytypeName());
        miniShopOrderPayInfo.setPrepay_id(orderPayEntities.get(0).getPrePayId());
        miniShopOrderPayInfo.setPrepay_time(DateUtils.now((String)"yyyy-MM-dd HH:mm:ss"));
        MiniShopOrderPriceInfo miniShopOrderPriceInfo = new MiniShopOrderPriceInfo();
        miniShopOrderPriceInfo.setOrder_price(orderEntitiesVo.getOrderMainEntity().getTotalAmount().multiply(new BigDecimal("100")).intValue());
        miniShopOrderPriceInfo.setFreight(orderEntitiesVo.getOrderMainEntity().getFreight().multiply(new BigDecimal("100")).intValue());
        miniShopOrderPriceInfo.setDiscounted_price(0);
        miniShopOrderDetail.setProduct_infos(miniShopOrderProductInfos);
        miniShopOrderDetail.setPay_info(miniShopOrderPayInfo);
        miniShopOrderDetail.setPrice_info(miniShopOrderPriceInfo);
        miniShopOrderVO.setOrder_detail(miniShopOrderDetail);
        MiniShopOrderDeliveryDetail miniShopOrderDeliveryDetail = new MiniShopOrderDeliveryDetail();
        miniShopOrderDeliveryDetail.setDelivery_type(StringUtils.isEmpty((String)order.getDeliverId()) ? 2 : 1);
        miniShopOrderVO.setDelivery_detail(miniShopOrderDeliveryDetail);
        MiniShopOrderAddressInfo miniShopOrderAddressInfo = new MiniShopOrderAddressInfo();
        if (StringUtils.isNotEmpty((String)order.getConsigneeName())) {
            miniShopOrderAddressInfo.setReceiver_name(order.getConsigneeName());
        }
        if (StringUtils.isNotEmpty((String)order.getConsigneePhone())) {
            miniShopOrderAddressInfo.setTel_number(order.getConsigneePhone());
        }
        if (StringUtils.isNotEmpty((String)order.getConsigneeProvincename())) {
            miniShopOrderAddressInfo.setProvince(order.getConsigneeProvincename());
        }
        if (StringUtils.isNotEmpty((String)order.getConsigneeCityname())) {
            miniShopOrderAddressInfo.setCity(order.getConsigneeCityname());
        }
        if (StringUtils.isNotEmpty((String)order.getConsigneeAreaname())) {
            miniShopOrderAddressInfo.setTown(order.getConsigneeAreaname());
        }
        if (StringUtils.isNotEmpty((String)order.getConsigneeAddr())) {
            miniShopOrderAddressInfo.setDetailed_address(order.getConsigneeAddr());
        }
        miniShopOrderVO.setAddress_info(miniShopOrderAddressInfo);
        return miniShopOrderVO;
    }

    @Override
    public Boolean checkMiniShopScene(int platFormId, Integer scene) {
        this.logger.info("******scene:{}", (Object)scene);
        if (scene == null || scene == 0) {
            return false;
        }
        try {
            String accessToken = this.weiXinBaseInterface.getAccessTokenByPlatformId(platFormId).getAccessToken();
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("scene", scene);
            SceneCheckResult sceneCheckResult = OrderAPI.sceneCheck((String)accessToken, (String)JsonUtils.toJson(map, (boolean)false));
            this.logger.info("******sceneCheckResult:scene={},result={}", (Object)scene, (Object)JsonUtils.toJson((Object)sceneCheckResult, (boolean)false));
            if (sceneCheckResult.getIs_matched() == 1) {
                this.logger.info("******sceneCheckResultSuccess:scene={},result={}", (Object)scene, (Object)JsonUtils.toJson((Object)sceneCheckResult, (boolean)false));
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public BaseJsonVo payOrderResult(MallOrderMainEntity mainEntity) {
        if (mainEntity.getMiniShop() != 1) {
            this.logger.info("{}\u975e\u5c0f\u5546\u5e97\u8ba2\u5355\uff0c\u4e0d\u7528\u540c\u6b65", (Object)mainEntity.getOrderMainNo());
            return BaseJsonVo.success((Object)(mainEntity.getOrderMainNo() + "\u975e\u5c0f\u5546\u5e97\u8ba2\u5355\uff0c\u4e0d\u7528\u540c\u6b65"));
        }
        this.logger.info("***********miniShopPaySyncStart*****{}\u5c0f\u5546\u5e97\u8ba2\u5355\uff0c\u5f00\u59cb\u540c\u6b65", (Object)mainEntity.getOrderMainNo());
        MiniShopOrderUpdateVO miniShopOrderUpdateVO = new MiniShopOrderUpdateVO();
        miniShopOrderUpdateVO.setOut_order_id(mainEntity.getOrderMainNo());
        miniShopOrderUpdateVO.setAction_type(mainEntity.getStatus() == 0 ? 4 : 1);
        miniShopOrderUpdateVO.setOpenid(this.customerInterface.getCustomer(mainEntity.getCustomerId()).getChannelCustomerId());
        if (mainEntity.getStatus() > 1) {
            List<MallOrderPayEntity> list = this.mallOrderPayInterface.getList(mainEntity.getOrderMainNo());
            list.sort(new Comparator<MallOrderPayEntity>(){

                @Override
                public int compare(MallOrderPayEntity o1, MallOrderPayEntity o2) {
                    return o2.getSort() - o1.getSort();
                }
            });
            miniShopOrderUpdateVO.setTransaction_id(list.get(0).getThirdTradeNo());
            miniShopOrderUpdateVO.setPay_time(DateUtils.formatDate((Date)mainEntity.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        String accessToken = this.weiXinBaseInterface.getAccessTokenByPlatformId(mainEntity.getPlatformId()).getAccessToken();
        BaseResult baseResult = OrderAPI.paySync((String)accessToken, (String)JsonUtils.toJson((Object)miniShopOrderUpdateVO, (boolean)false));
        this.logger.info("********miniShopPaySyncResult*******param:{},result:{}", (Object)JsonUtils.toJson((Object)miniShopOrderUpdateVO, (boolean)false), (Object)JsonUtils.toJson((Object)baseResult, (boolean)false));
        if (baseResult.isSuccess()) {
            return BaseJsonVo.success(null);
        }
        return BaseJsonVo.error((String)baseResult.getErrmsg());
    }
}

