/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.orderHandle;

import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerAddressVo;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.iservice.customer.CustomerAddressInterface;
import cc.lechun.mall.iservice.trade.MallTradeCommonInterface;
import cc.lechun.mall.service.trade.orderHandle.CardHandle;
import cc.lechun.mall.service.trade.orderHandle.OrderHandleInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="20_address")
public class AddressHandle
implements OrderHandleInterface {
    @Autowired
    private CustomerAddressInterface addressInterface;
    @Autowired
    private MallTradeCommonInterface tradeCommonInterface;
    @Autowired
    protected RedisCacheUtil redisCacheUtil;
    private static final Logger logger = LoggerFactory.getLogger(CardHandle.class);

    @Override
    public BaseJsonVo orderHandle(MallMainOrderVo mallMainOrderVo) {
        if (this.tradeCommonInterface.isNoDeliverOrder(mallMainOrderVo)) {
            return BaseJsonVo.success((Object)"");
        }
        int[] transportType = new int[]{-1, -1};
        mallMainOrderVo.getMallOrderVos().forEach(c -> {
            if (c.getTransportType() == 1) {
                transportType[0] = 1;
            }
            if (c.getTransportType() == 2) {
                transportType[1] = 2;
            }
        });
        CustomerAddressVo addressVo = null;
        try {
            if (mallMainOrderVo.getOrderCacheVo().getCacheType() != 2) {
                addressVo = this.addressInterface.getCustomerDefaultAddress(mallMainOrderVo.getCustomerId(), "", "", "", transportType);
                logger.info("\u7528\u6237:{},\u53d6\u9ed8\u8ba4\u5730\u5740:{}", (Object)mallMainOrderVo.getCustomerId(), (Object)addressVo.getAddress());
            } else {
                addressVo = this.addressInterface.getCustomerAddressVO(mallMainOrderVo.getOrderCacheVo().getAddressId(), transportType);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        if (mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.COMMUNITY_GROUP.getValue() || mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.CARD_PREPAY_DOUDIAN_CUSTOM.getValue()) {
            addressVo.setEnable(true);
        }
        if (addressVo != null && StringUtils.isNotEmpty((String)addressVo.getAddrId())) {
            mallMainOrderVo.setAddressVo(addressVo);
            mallMainOrderVo.getOrderCacheVo().setAddressId(addressVo.getAddrId());
        } else if (mallMainOrderVo.getOrderCacheVo().getCacheType() == 2) {
            BaseJsonVo.error((String)"\u6ca1\u6709\u586b\u5199\u6536\u8d27\u5730\u5740");
        }
        return BaseJsonVo.success((Object)"");
    }
}

