/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.orderHandle;

import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.prepay.PrepayCardTypeEnum;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardItemInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.shoppingcart.MallPriceCalcInterface;
import cc.lechun.mall.service.trade.orderHandle.OrderHandleInterface;
import java.math.BigDecimal;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="45_card")
public class CardHandle
implements OrderHandleInterface {
    private static final Logger logger = LoggerFactory.getLogger(CardHandle.class);
    @Lazy
    @Autowired
    private PrepayCardBatchInterface prepayCardBatchInterface;
    @Autowired
    private MallPromotionInterface promotionService;
    @Autowired
    private MallGroupInterface groupService;
    @Autowired
    private MallProductInterface productService;
    @Value(value="${lechun.environment}")
    private String environment;
    @Lazy
    @Autowired
    private PrepayCardItemInterface prepayCardItemInterface;
    @Autowired
    private MallPriceCalcInterface priceCalcInterface;

    @Override
    public BaseJsonVo orderHandle(MallMainOrderVo mallMainOrderVo) {
        if (StringUtils.isNotEmpty((String)mallMainOrderVo.getOrderCacheVo().getBindCode()) && Objects.equals(mallMainOrderVo.getOrderCacheVo().getOrderSource(), OrderSourceEnum.RECHANGE_CARD.getValue())) {
            mallMainOrderVo.setCardType(this.prepayCardBatchInterface.getPrepayCardType(mallMainOrderVo.getOrderCacheVo().getBindCode()));
            if (mallMainOrderVo.getCardType() == null) {
                if (mallMainOrderVo.getOrderCacheVo().getBindCode().length() > 2) {
                    mallMainOrderVo.setCardType(PrepayCardTypeEnum.yogurt_card.getValue());
                } else {
                    mallMainOrderVo.setCardType(Integer.valueOf(mallMainOrderVo.getOrderCacheVo().getBindCode()));
                }
            }
        }
        this.sumCardCut(mallMainOrderVo);
        return BaseJsonVo.success((Object)"");
    }

    private void sumCardCut(MallMainOrderVo mainOrderVo) {
        boolean isNewCard;
        boolean bl = isNewCard = Objects.equals(mainOrderVo.getOrderCacheVo().getBindCode(), String.valueOf(PrepayCardTypeEnum.new_card_Cold.getValue())) || Objects.equals(mainOrderVo.getOrderCacheVo().getBindCode(), String.valueOf(PrepayCardTypeEnum.new_card_Nomal.getValue()));
        if (isNewCard) {
            BigDecimal cardProductSum;
            BigDecimal cardCutSum;
            mainOrderVo.setCardProductCut(BigDecimal.ZERO);
            for (MallOrderVo mallOrderVo : mainOrderVo.getMallOrderVos()) {
                BigDecimal cardProductCut = BigDecimal.ZERO;
                for (MallProductVO productVO : mallOrderVo.getProducts()) {
                    if (productVO.getCardOriginPrice() == null || productVO.getCardOriginPrice().compareTo(productVO.getCardFactPrice()) <= 0) continue;
                    cardProductCut = PriceUtils.add((BigDecimal)cardProductCut, (BigDecimal)PriceUtils.multiply((BigDecimal)PriceUtils.subtract((BigDecimal)productVO.getCardOriginPrice(), (BigDecimal)productVO.getCardFactPrice()), (Integer)productVO.getQuantity()));
                }
                if (CollectionUtils.isNotEmpty(mallOrderVo.getPromotions())) {
                    for (MallPromotionVO promotionVO : mallOrderVo.getPromotions()) {
                        if (promotionVO.getCardOriginPrice() == null || promotionVO.getCardOriginPrice().compareTo(promotionVO.getCardFactPrice()) <= 0) continue;
                        cardProductCut = PriceUtils.add((BigDecimal)cardProductCut, (BigDecimal)PriceUtils.multiply((BigDecimal)PriceUtils.subtract((BigDecimal)promotionVO.getCardOriginPrice(), (BigDecimal)promotionVO.getCardFactPrice()), (Integer)promotionVO.getQuantity()));
                    }
                }
                if (cardProductCut.compareTo(BigDecimal.ZERO) > 0) {
                    logger.info("\u7528\u6237:{}\u5b50\u5355\u5361\u5546\u54c1\u4f18\u60e0:{}", (Object)mainOrderVo.getCustomerId(), (Object)cardProductCut);
                    mallOrderVo.setCardProductCut(cardProductCut);
                    mallOrderVo.setUseCardCutSum(PriceUtils.add((BigDecimal)mallOrderVo.getCardProductCut(), (BigDecimal)mallOrderVo.getFreeCut()));
                    logger.info("\u7528\u6237:{}\u5b50\u5355\u4f7f\u7528\u5976\u5361\u7701\u5408\u8ba1:{},\u8d60\u54c1\u7701:{},\u5361\u5546\u54c1\u7701:{}", new Object[]{mainOrderVo.getCustomerId(), mallOrderVo.getUseCardCutSum(), mallOrderVo.getFreeCut(), mallOrderVo.getCardProductCut(), mallOrderVo.getUseCardCutSum()});
                    continue;
                }
                mallOrderVo.setCardProductCut(BigDecimal.ZERO);
            }
            BigDecimal freeCutSum = BigDecimal.ZERO;
            if (mainOrderVo.getMallOrderVos().stream().anyMatch(item -> item.getFreeCut() != null)) {
                freeCutSum = mainOrderVo.getMallOrderVos().stream().filter(item -> item.getFreeCut() != null).map(MallOrderVo::getFreeCut).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            if ((cardCutSum = PriceUtils.add((BigDecimal)freeCutSum, (BigDecimal)(cardProductSum = mainOrderVo.getMallOrderVos().stream().map(MallOrderVo::getCardProductCut).reduce(BigDecimal.ZERO, BigDecimal::add)))).compareTo(BigDecimal.ZERO) > 0) {
                mainOrderVo.setUseCardCutSum(cardCutSum);
                mainOrderVo.setFreeCut(freeCutSum);
                mainOrderVo.setCardProductCut(cardProductSum);
                logger.info("\u7528\u6237:{}\u5361\u8ba2\u5355\u4f18\u60e0 ,\u8d60\u54c1\u4f18\u60e0:{},\u5546\u54c1\u4f18\u60e0:{},\u4f18\u60e0\u5408\u8ba1:{}", new Object[]{mainOrderVo.getCustomerId(), freeCutSum, cardProductSum, mainOrderVo.getUseCardCutSum()});
            }
        }
    }
}

