/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.orderHandle;

import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.platform.PlatFormEntity;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.service.trade.orderHandle.OrderHandleInterface;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="10_check")
public class CheckHandle
implements OrderHandleInterface {
    private static final Logger logger = LoggerFactory.getLogger(CheckHandle.class);
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    private PlatFormInterface platFormInterface;

    @Override
    public BaseJsonVo orderHandle(MallMainOrderVo mallMainOrderVo) {
        PlatFormEntity platFormEntity;
        for (MallOrderVo c : mallMainOrderVo.getMallOrderVos()) {
            if (CollectionUtils.isNotEmpty(c.getProducts())) {
                for (MallProductVO mallProductVO : c.getProducts()) {
                    if (mallProductVO.getValid().booleanValue()) continue;
                    return BaseJsonVo.error((String)mallProductVO.getInvalidReason());
                }
            }
            if (CollectionUtils.isNotEmpty(c.getGroups())) {
                for (MallGroupVO mallGroupVO : c.getGroups()) {
                    if (mallGroupVO.getValid().booleanValue()) continue;
                    return BaseJsonVo.error((String)mallGroupVO.getInvalidReason());
                }
            }
            if (!CollectionUtils.isNotEmpty(c.getPromotions())) continue;
            for (MallPromotionVO mallPromotionVO : c.getPromotions()) {
                if (mallPromotionVO.getValid().booleanValue()) continue;
                return BaseJsonVo.error((String)mallPromotionVO.getInvalidReason());
            }
        }
        if (mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.RECHANGE_CARD.getValue() && Objects.equals(mallMainOrderVo.getOrderCacheVo().getBindCode(), "undefined")) {
            logger.error("\u7528\u6237:{}\u63d0\u4ea4\u8ba2\u5355\u51fa\u9519,bindCode={}", (Object)mallMainOrderVo.getCustomerId(), (Object)mallMainOrderVo.getOrderCacheVo().getBindCode());
            return BaseJsonVo.error((String)"\u51fa\u9519\u4e86,\u8bf7\u91cd\u8bd5\u6216\u8054\u7cfb\u5ba2\u670d");
        }
        if (mallMainOrderVo.getOrderCacheVo().getCacheType() == 1 && (platFormEntity = this.platFormInterface.getPlatForm(mallMainOrderVo.getPlatFormId())) != null) {
            mallMainOrderVo.setTipMessage(this.dictionaryInterface.getValidDictionaryList(platFormEntity.getPlatformGroupId(), 20));
        }
        return BaseJsonVo.success((Object)"");
    }
}

