/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.orderHandle;

import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.deliver.DeliverDateVo;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.entity.trade.StockStatusEnum;
import cc.lechun.mall.iservice.deliver.DeliverNewErpInterface;
import cc.lechun.mall.iservice.trade.MallTradeCommonInterface;
import cc.lechun.mall.service.trade.orderHandle.OrderHandleInterface;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="38_deliver")
public class DeliverHandle
implements OrderHandleInterface {
    private static final Logger logger = LoggerFactory.getLogger(DeliverHandle.class);
    @Autowired
    private MallTradeCommonInterface tradeCommonInterface;
    @Autowired
    private DeliverNewErpInterface deliverNewErpInterface;
    @Autowired
    protected RedisCacheUtil redisCacheUtil;

    @Override
    public BaseJsonVo orderHandle(MallMainOrderVo mallMainOrderVo) {
        if (this.tradeCommonInterface.isNoDeliverOrder(mallMainOrderVo)) {
            return BaseJsonVo.success((Object)"");
        }
        MallOrderCacheVo orderCacheVo = mallMainOrderVo.getOrderCacheVo();
        if (orderCacheVo.getCacheType() == 2 && orderCacheVo.getDeliverDate() != null && DateUtils.dateTimeCompare((Date)orderCacheVo.getDeliverDate(), (Date)DateUtils.currentDate()) > 0L) {
            return BaseJsonVo.error((String)"\u914d\u9001\u65e5\u671f\u5c0f\u4e8e\u5f53\u524d\u65e5\u671f");
        }
        String[] err = new String[]{""};
        int loopCount = 0;
        Date deliverDate = mallMainOrderVo.getOrderCacheVo().getDeliverDate();
        Date deliverDate2 = mallMainOrderVo.getOrderCacheVo().getDeliverDate2();
        for (MallOrderVo c : mallMainOrderVo.getMallOrderVos()) {
            if (mallMainOrderVo.getOrderCacheVo().getCacheType() == 1 || mallMainOrderVo.getOrderCacheVo().getCacheType() == 3) {
                if (c.getOrderSource() != OrderSourceEnum.LONGPERIOD_BUY.getValue() || loopCount <= 0) {
                    c.setDeliverVo(this.deliverNewErpInterface.getDeliverByErp(c, mallMainOrderVo.getAddressVo(), DateUtils.formatDate((Date)deliverDate, (String)"yyyy-MM-dd"), mallMainOrderVo.getOrderCacheVo().getSpeedUp(), mallMainOrderVo.getOrderCacheVo().getCacheType()));
                    if (mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.COMMUNITY_GROUP.getValue()) {
                        c.getDeliverVo().setInventory(2);
                        if (mallMainOrderVo.getAddressVo() == null) {
                            c.getDeliverVo().setInventory(3);
                        }
                    }
                    if (c.getTransportType() == 2 && mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.RECHANGE_CARD.getValue()) {
                        this.buildCommandProductDeilverDate(c);
                    }
                }
            } else if (mallMainOrderVo.getOrderCacheVo().getCacheType() == 2) {
                if (Objects.equals(c.getOrderSource(), OrderSourceEnum.LONGPERIOD_BUY.getValue()) || Objects.equals(c.getOrderSource(), OrderSourceEnum.PERIODIC_PURCHASE.getValue())) {
                    if (loopCount > 0) {
                        deliverDate = DateUtils.getAddDateByDay((Date)deliverDate, (int)c.getDeliverPeriod());
                    }
                } else if (c.getSelfMadeType() == 2 && loopCount == 1) {
                    deliverDate = deliverDate2 != null ? deliverDate2 : deliverDate;
                }
                c.setDeliverVo(this.deliverNewErpInterface.getDeliverByErp(c, mallMainOrderVo.getAddressVo(), deliverDate != null ? DateUtils.formatDate((Date)deliverDate, (String)"yyyy-MM-dd") : "", mallMainOrderVo.getOrderCacheVo().getSpeedUp(), mallMainOrderVo.getOrderCacheVo().getCacheType()));
                String saleOutProduct = "";
                if (mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.COMMUNITY_GROUP.getValue() || mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.CARD_PREPAY_DOUDIAN_CUSTOM.getValue()) {
                    c.getDeliverVo().setInventory(2);
                } else {
                    if (c.getDeliverVo().getInventory() == 0) {
                        MallProductVO p;
                        List lst;
                        if (c.getProducts() != null) {
                            lst = c.getProducts().stream().filter(c1 -> c1.getSoldOut() == true).collect(Collectors.toList());
                            MallProductVO mallProductVO = p = lst.size() > 0 ? (MallProductVO)lst.get(0) : null;
                            if (p != null) {
                                saleOutProduct = p.getProNameSx();
                            }
                        }
                        if (c.getGroups() != null) {
                            MallGroupVO g;
                            lst = c.getGroups().stream().filter(c1 -> c1.getSoldOut() == true).collect(Collectors.toList());
                            MallGroupVO mallGroupVO = g = lst.size() > 0 ? (MallGroupVO)lst.get(0) : null;
                            if (g != null) {
                                saleOutProduct = g.getGroupName();
                            }
                        }
                        if (c.getPromotions() != null) {
                            lst = c.getPromotions().stream().filter(c1 -> c1.getSoldOut() == true).collect(Collectors.toList());
                            Serializable serializable = p = lst.size() > 0 ? (MallPromotionVO)lst.get(0) : null;
                            if (p != null) {
                                saleOutProduct = ((MallPromotionEntity)((Object)p)).getPromotionName();
                            }
                        }
                        c.getDeliverVo().setBaseError(saleOutProduct + "\u5e93\u5b58\u4e0d\u8db3~");
                        logger.info("?????????????\u5e93\u5b58\u4e0d\u8db3");
                    }
                    if (c.getDeliverVo().getInventory() == -1) {
                        c.getDeliverVo().setBaseError("\u6240\u5728\u57ce\u5e02\u57ce\u5e02\u5173\u95ed");
                        logger.info("?????????????\u5e93\u5b58\u4e0d\u8db3");
                    }
                    if (c.getDeliverVo().getInventory() == -2) {
                        c.getDeliverVo().setBaseError("\u6ca1\u6709\u9009\u62e9\u914d\u9001\u5730\u5740");
                        logger.info("?????????????\u5e93\u5b58\u4e0d\u8db3");
                    }
                    if (c.getDeliverVo().getInventory() != 2) {
                        if (c.getDeliverVo().isBaseSuccess()) {
                            if (c.getDeliverVo().getDeliverDate() == null) {
                                c.getDeliverVo().setBaseError("\u63d0\u8d27\u65e5\u671f\u4e0d\u53ef\u914d\u9001");
                            } else if (StringUtils.isNotEmpty((String)c.getDeliverVo().getDeliverDate()) && deliverDate != null && deliverDate.compareTo(DateUtils.getDateFromString((String)c.getDeliverVo().getDeliverDate(), (String)"yyyy-MM-dd")) != 0) {
                                c.getDeliverVo().setBaseError("\u914d\u9001\u65e5\u671f\u4e0d\u5728\u914d\u9001\u8303\u56f4\uff1a" + c.getDeliverVo().getDeliverDate() + "|" + DateUtils.formatDate((Date)deliverDate, (String)"yyyy-MM-dd"));
                            }
                        }
                        if (c.getDeliverVo().isBaseSuccess() && StringUtils.isNotEmpty((String)c.getDeliverVo().getPickDate()) && DateUtils.dateTimeCompare((Date)DateUtils.getDateFromString((String)c.getDeliverVo().getPickDate(), (String)"yyyy-MM-dd"), (Date)DateUtils.currentDate()) > 0L) {
                            c.getDeliverVo().setBaseError("\u63d0\u8d27\u65e5\u671f\uff08" + c.getDeliverVo().getPickDate() + "\uff09\u5c0f\u4e8e\u5f53\u524d\u65e5\u671f");
                        }
                    }
                }
            }
            if (c.getDeliverVo() != null && !c.getDeliverVo().isBaseSuccess()) {
                err[0] = c.getDeliverVo().getBaseErrMsg();
            }
            ++loopCount;
        }
        if (mallMainOrderVo.getMallOrderVos().size() > 1 && mallMainOrderVo.getMallOrderVos().get(1).getDeliverVo() != null) {
            int inventoryOne = mallMainOrderVo.getMallOrderVos().get(0).getDeliverVo().getInventory();
            int inventoryTwo = mallMainOrderVo.getMallOrderVos().get(1).getDeliverVo().getInventory();
            int inventoryInt = inventoryOne;
            if (inventoryOne == -1 || inventoryTwo == -1) {
                inventoryInt = -1;
            }
            if (inventoryOne == 0 || inventoryTwo == 0) {
                inventoryInt = 0;
            }
            mallMainOrderVo.getMallOrderVos().get(0).getDeliverVo().setInventory(inventoryInt);
            mallMainOrderVo.getMallOrderVos().get(1).getDeliverVo().setInventory(inventoryInt);
        }
        if (err[0].isEmpty()) {
            this.recordStock(mallMainOrderVo);
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)err[0]);
    }

    private void buildCommandProductDeilverDate(MallOrderVo c) {
        if (StringUtils.isEmpty((String)c.getDeliverVo().getDeliverDate())) {
            if (c.getDeliverVo().getInventory() == 2) {
                c.getDeliverVo().setDeliverDate(DateUtils.formatDate((Date)DateUtils.now(), (String)"yyyy-MM-dd"));
                c.getDeliverVo().setInventory(1);
            } else {
                c.getDeliverVo().setDeliverDate(DateUtils.formatDate((Date)DateUtils.now(), (String)"yyyy-MM-dd"));
            }
        }
        c.getDeliverVo().setDeliverDateDesc("\u53d1\u8d27\u65e5\u671f");
        int start = 0;
        if (CollectionUtils.isNotEmpty(c.getDeliverVo().getDeliverDateVos())) {
            start = c.getDeliverVo().getDeliverDateVos().size();
        } else {
            c.getDeliverVo().setDeliverDateVos(new ArrayList<DeliverDateVo>());
        }
        for (int i = start; i < 7; ++i) {
            DeliverDateVo deliverDateVo = new DeliverDateVo();
            deliverDateVo.setInventory(Objects.equals(2, c.getDeliverVo().getInventory()) ? 1 : c.getDeliverVo().getInventory());
            deliverDateVo.setDeliverDate(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.StrToDate((String)c.getDeliverVo().getDeliverDate()), (int)i), (String)"yyyy-MM-dd"));
            deliverDateVo.setSort(DateUtils.getWeekIndexOfDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.StrToDate((String)c.getDeliverVo().getDeliverDate()), (int)i)));
            deliverDateVo.setWeek(DateUtils.getShortWeekOfDate((int)(deliverDateVo.getSort() == 7 ? 0 : deliverDateVo.getSort())));
            deliverDateVo.setSpeedUp(0);
            deliverDateVo.setDeliverDateShow(DateUtils.formatDateChina((String)deliverDateVo.getDeliverDate(), (String)""));
            c.getDeliverVo().getDeliverDateVos().add(deliverDateVo);
        }
    }

    private void recordStock(MallMainOrderVo mallMainOrderVo) {
        try {
            String key = mallMainOrderVo.getCustomerId() + "StockRecord";
            if (mallMainOrderVo.getOrderCacheVo().getCacheType() == 1) {
                String remark = "";
                for (MallOrderVo orderVo : mallMainOrderVo.getMallOrderVos()) {
                    StringBuilder deliverStock = new StringBuilder();
                    if (orderVo.getDeliverVo() == null || orderVo.getDeliverVo().getDeliverDateVos() == null) continue;
                    for (int i = 0; i < orderVo.getDeliverVo().getDeliverDateVos().size(); ++i) {
                        int stockStatus;
                        if (i == 0) {
                            deliverStock.append(orderVo.getDeliverVo().getDeliverDateVos().get(i).getDeliverDate());
                        }
                        int n = stockStatus = Objects.equals(orderVo.getDeliverVo().getDeliverDateVos().get(i).getInventory(), 1) ? StockStatusEnum.available.getValue() : StockStatusEnum.sale_out.getValue();
                        if (Objects.equals(orderVo.getDeliverVo().getDeliverDate(), orderVo.getDeliverVo().getDeliverDateVos().get(i).getDeliverDate())) {
                            stockStatus = StockStatusEnum.select_deliver_day.getValue();
                        }
                        if (i == 0) {
                            deliverStock.append("|" + stockStatus);
                            continue;
                        }
                        deliverStock.append("," + stockStatus);
                    }
                    logger.info("\u8ba2\u5355\u53f7:{},remark:{},deliverStock:{},\u914d\u9001\u65e5\u671f:{}", new Object[]{mallMainOrderVo.getMainOrderNo(), mallMainOrderVo.getRemark(), deliverStock.toString(), JsonUtils.toJson(orderVo.getDeliverVo().getDeliverDateVos(), (boolean)false)});
                    if (!StringUtils.isNotEmpty((String)deliverStock.toString())) continue;
                    remark = (StringUtils.isNotEmpty((String)remark) ? remark + "|" : remark) + deliverStock.toString();
                }
                mallMainOrderVo.setRemark(remark);
                logger.info("\u8ba2\u5355\u53f7:{},remark:{}", (Object)mallMainOrderVo.getMainOrderNo(), (Object)mallMainOrderVo.getRemark());
                if (StringUtils.isNotEmpty((String)remark)) {
                    this.redisCacheUtil.set(key, (Object)remark, Long.valueOf(86400L));
                }
            } else if (mallMainOrderVo.getOrderCacheVo().getCacheType() == 2) {
                Object object = this.redisCacheUtil.get(key);
                if (object != null) {
                    String remark = object.toString();
                    logger.info("\u7528\u6237:{}remark={}", (Object)mallMainOrderVo.getCustomerId(), (Object)remark);
                    if (mallMainOrderVo.getOrderCacheVo().getDeliverDate() != null) {
                        String firstDay = remark.substring(0, remark.indexOf("|"));
                        String deliverDay = DateUtils.formatDate((Date)mallMainOrderVo.getOrderCacheVo().getDeliverDate(), (String)"yyyy-MM-dd");
                        int startIndex = Integer.valueOf(String.valueOf(DateUtils.getDateDiff((String)firstDay, (String)deliverDay)));
                        logger.info("\u7528\u6237:{},remark:{},\u5f00\u59cb\u65e5\u671f:{},\u914d\u9001\u65e5\u671f:{}\u9009\u62e9\u7b2c{}\u5929\u914d\u9001", new Object[]{mallMainOrderVo.getCustomerId(), remark, firstDay, deliverDay, startIndex + 1});
                        String[] arr = remark.substring(remark.indexOf("|") + 1).split(",");
                        StringBuilder deliverStock = new StringBuilder();
                        deliverStock.append(firstDay);
                        deliverStock.append("|");
                        for (int i = 0; i < arr.length; ++i) {
                            if (i > 0) {
                                deliverStock.append(",");
                            }
                            if (i == startIndex) {
                                deliverStock.append(StockStatusEnum.select_deliver_day.getValue());
                                continue;
                            }
                            deliverStock.append(arr[i]);
                        }
                        mallMainOrderVo.setRemark(deliverStock.toString());
                        logger.info("\u8ba2\u5355\u53f7:{},remark:{}", (Object)mallMainOrderVo.getMainOrderNo(), (Object)mallMainOrderVo.getRemark());
                    } else {
                        logger.info("\u7528\u6237:{},\u8ba2\u5355\u65e0\u5e93\u5b58,\u914d\u9001\u65e5\u671f\u4e3a\u7a7a", (Object)mallMainOrderVo.getCustomerId());
                        mallMainOrderVo.setRemark(remark);
                    }
                } else {
                    logger.info("\u672a\u67e5\u8be2\u5230\u7528\u6237:{},\u914d\u9001\u65e5\u671f\u5e93\u5b58\u7f13\u5b58", (Object)mallMainOrderVo.getCustomerId());
                }
            }
        }
        catch (NumberFormatException e) {
            logger.error("\u8bb0\u5f55\u914d\u9001\u65e5\u671f\u51fa\u9519", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("\u8bb0\u5f55\u914d\u9001\u65e5\u671f\u51fa\u9519", (Throwable)e);
        }
    }
}

