/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.orderHandle;

import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.prepay.PrepayCardTypeEnum;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.shoppingcart.MallPriceCalcInterface;
import cc.lechun.mall.service.trade.orderHandle.OrderHandleInterface;
import java.math.BigDecimal;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="49_balance")
public class balanceHandle
implements OrderHandleInterface {
    @Autowired
    private AccountBalanceInterface balanceInterface;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private MallPriceCalcInterface priceCalcInterface;
    private static final Logger logger = LoggerFactory.getLogger(balanceHandle.class);

    @Override
    public BaseJsonVo orderHandle(MallMainOrderVo mallMainOrderVo) {
        this.priceCalcInterface.totalOrderPrice(mallMainOrderVo.getMallOrderVos(), mallMainOrderVo);
        this.priceCalcInterface.totalMainOrderPrice(mallMainOrderVo);
        CustomerEntity customerEntity = this.customerInterface.getCustomer(mallMainOrderVo.getCustomerId());
        if (customerEntity == null) {
            if (mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.CARD_PREPAY_DOUDIAN_CUSTOM.getValue()) {
                customerEntity = new CustomerEntity();
                customerEntity.setCustomerId(mallMainOrderVo.getCustomerId());
            } else {
                return BaseJsonVo.error((String)("\u7528\u6237\u4e0d\u5b58\u5728customer:" + mallMainOrderVo.getCustomerId()));
            }
        }
        BigDecimal balance = BigDecimal.ZERO;
        BigDecimal useBalanceAmount = BigDecimal.ZERO;
        if (mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.RECHANGE_CARD.getValue()) {
            useBalanceAmount = Objects.equals(mallMainOrderVo.getCardType(), PrepayCardTypeEnum.yogurt_card.getValue()) ? PriceUtils.subtract((BigDecimal)mallMainOrderVo.getCardTotalAmount(), (BigDecimal)PriceUtils.multiply((BigDecimal)mallMainOrderVo.getCouponAmount(), (Integer)10)) : mallMainOrderVo.getCardTotalAmount();
            balance = this.balanceInterface.getSpecialTotal(customerEntity.getCustomerId(), mallMainOrderVo.getCardType());
            logger.info("\u7528\u6237{}\u9700\u8981\u652f\u4ed8\u7684\u70b9\u6570:{} \u7528\u6237\u5e10\u6237\u70b9\u6570:{}", new Object[]{mallMainOrderVo.getCustomerId(), useBalanceAmount, balance});
            mallMainOrderVo.setCardPayAmount(useBalanceAmount);
            mallMainOrderVo.setCardTotalBalanceAmount(balance);
            logger.info("\u7528\u6237{} \u5e10\u6237\u70b9\u6570:{},\u8ba2\u5355\u70b9\u6570:{}", new Object[]{mallMainOrderVo.getCustomerId(), balance, useBalanceAmount});
            if (balance.compareTo(BigDecimal.ZERO) < 0) {
                logger.error("\u7528\u6237{} \u5e10\u6237\u70b9\u6570:{}", (Object)mallMainOrderVo.getCustomerId(), (Object)balance);
                mallMainOrderVo.setCardTotalBalanceAmount(BigDecimal.ZERO);
            }
        } else {
            logger.info("\u8ba2\u5355\u603b\u989d:{},\u4f18\u60e0\u5238\u91d1\u989d:{},\u8ba2\u5355\u62b5\u6263:{}", new Object[]{mallMainOrderVo.getTotalAmount(), mallMainOrderVo.getCouponAmount(), mallMainOrderVo.getSourceOrderAmount()});
            useBalanceAmount = PriceUtils.subtract((BigDecimal)mallMainOrderVo.getTotalAmount(), (BigDecimal)mallMainOrderVo.getCouponAmount());
            useBalanceAmount = PriceUtils.subtract((BigDecimal)useBalanceAmount, (BigDecimal)mallMainOrderVo.getSourceOrderAmount());
            balance = Objects.equals(mallMainOrderVo.getOrderCacheVo().getMildCardPay(), 1) ? useBalanceAmount : this.balanceInterface.getGiftBalanceById(customerEntity.getCustomerId());
            logger.info("\u53ef\u7528\u4f59\u989d\u91d1\u989d:{},\u4f59\u989d\u603b\u989d:{}", (Object)useBalanceAmount, (Object)balance);
            mallMainOrderVo.setTotalBalanceAmount(balance);
        }
        if (useBalanceAmount.doubleValue() > balance.doubleValue()) {
            useBalanceAmount = balance;
        }
        if (mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.RECHANGE_CARD.getValue()) {
            BigDecimal useCardBalanceAmount = useBalanceAmount;
            BigDecimal userBalanceAmount = BigDecimal.ZERO;
            logger.info("\u7528\u6237:{} \u53ef\u7528\u5361\u4f59\u989d:{} ", (Object)customerEntity.getCustomerId(), (Object)useCardBalanceAmount);
            if (useCardBalanceAmount.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal payAmount = PriceUtils.subtract((BigDecimal)mallMainOrderVo.getCardTotalAmount(), (BigDecimal)useBalanceAmount);
                if (payAmount.compareTo(BigDecimal.ZERO) > 0) {
                    if (Objects.equals(mallMainOrderVo.getCardType(), PrepayCardTypeEnum.yogurt_card.getValue())) {
                        payAmount = PriceUtils.divide((BigDecimal)payAmount, (BigDecimal)new BigDecimal(10));
                    }
                    if (Objects.equals(mallMainOrderVo.getOrderCacheVo().getUseAccountBalance(), 1) || Objects.equals("1", mallMainOrderVo.getUseBalance())) {
                        userBalanceAmount = this.balanceInterface.getGiftBalanceById(customerEntity.getCustomerId());
                        logger.info("\u7528\u6237:{}\u4f59\u989d\u8bb0\u5f55:{},\u9700\u8981\u652f\u4ed8:{}", new Object[]{customerEntity.getCustomerId(), userBalanceAmount, payAmount});
                    }
                    mallMainOrderVo.setTotalBalanceAmount(userBalanceAmount);
                    mallMainOrderVo.setBalanceAmount(BigDecimal.ZERO);
                    if (mallMainOrderVo.getOrderCacheVo().getUseAccountBalance() == 1 || Objects.equals("1", mallMainOrderVo.getUseBalance())) {
                        if (userBalanceAmount.compareTo(payAmount) < 0) {
                            mallMainOrderVo.setPayAmount(payAmount.subtract(userBalanceAmount));
                            mallMainOrderVo.setBalanceAmount(userBalanceAmount);
                        } else {
                            mallMainOrderVo.setBalanceAmount(payAmount);
                        }
                    }
                    logger.info("\u7528\u6237:{} \u53ef\u7528\u5976\u5361\u91d1\u989d:{}, \u53ef\u4f7f\u7528\u4f59\u989d:{}", new Object[]{customerEntity.getCustomerId(), useBalanceAmount, mallMainOrderVo.getBalanceAmount()});
                }
                BigDecimal[] cardRemainder = new BigDecimal[]{BigDecimal.ZERO};
                BigDecimal[] cardFinalUseBalanceAmount = new BigDecimal[]{useBalanceAmount};
                BigDecimal[] remainder = new BigDecimal[]{BigDecimal.ZERO};
                BigDecimal[] finalUseBalanceAmount = new BigDecimal[]{mallMainOrderVo.getBalanceAmount().compareTo(BigDecimal.ZERO) > 0 ? mallMainOrderVo.getBalanceAmount() : BigDecimal.ZERO};
                BigDecimal mainOrderMoneyAmount = PriceUtils.subtractToSix((BigDecimal)mallMainOrderVo.getCardTotalAmount(), (BigDecimal)PriceUtils.multiply((BigDecimal)mallMainOrderVo.getCouponAmount(), (Integer)10));
                mallMainOrderVo.getMallOrderVos().forEach(c -> {
                    BigDecimal orderMoneyAmount = BigDecimal.ZERO;
                    orderMoneyAmount = Objects.equals(mallMainOrderVo.getCardType(), PrepayCardTypeEnum.yogurt_card.getValue()) ? PriceUtils.subtractToSix((BigDecimal)c.getCardTotalAmount(), (BigDecimal)PriceUtils.multiply((BigDecimal)c.getCouponAmount(), (Integer)10)) : PriceUtils.subtractToSix((BigDecimal)c.getCardTotalAmount(), (BigDecimal)c.getCouponAmount());
                    logger.info("\u4e3b\u8ba2\u5355\u70b9\u6570:{},\u5b50\u5355\u70b9\u6570:{}", (Object)mainOrderMoneyAmount, (Object)orderMoneyAmount);
                    BigDecimal orderDivideMainMoneyAmount = orderMoneyAmount.divide(mainOrderMoneyAmount, 6, 4);
                    BigDecimal subCardBalanceAmount = PriceUtils.multiply((BigDecimal)orderDivideMainMoneyAmount, (BigDecimal)cardFinalUseBalanceAmount[0]);
                    BigDecimal subBalanceAmount = BigDecimal.ZERO;
                    if (mallMainOrderVo.getBalanceAmount().compareTo(BigDecimal.ZERO) > 0) {
                        subBalanceAmount = PriceUtils.multiply((BigDecimal)orderDivideMainMoneyAmount, (BigDecimal)finalUseBalanceAmount[0]);
                    }
                    logger.info("\u5b50\u5355\u70b9\u6570\u5360\u6bd4:{},\u5b50\u5355\u70b9\u6570:{},\u5b50\u8ba2\u5355\u4f59\u989d:{}", new Object[]{orderDivideMainMoneyAmount, subCardBalanceAmount, subBalanceAmount});
                    c.setCardBalanceAmount(subCardBalanceAmount);
                    c.setBalanceAmount(subBalanceAmount);
                    cardRemainder[0] = PriceUtils.addNoUp((BigDecimal)cardRemainder[0], (BigDecimal)subCardBalanceAmount);
                    remainder[0] = PriceUtils.addNoUp((BigDecimal)remainder[0], (BigDecimal)subBalanceAmount);
                    logger.info("\u5b50\u5355\u70b9\u6570\u5360\u6bd4:{},\u5b50\u8ba2\u5355\u4f59\u989d:{}", (Object)cardRemainder[0], (Object)remainder[0]);
                });
                cardRemainder[0] = PriceUtils.subtractToSix((BigDecimal)useCardBalanceAmount, (BigDecimal)cardRemainder[0]);
                if (cardRemainder[0].doubleValue() != 0.0) {
                    mallMainOrderVo.getMallOrderVos().get(0).setCardBalanceAmount(PriceUtils.add((BigDecimal)mallMainOrderVo.getMallOrderVos().get(0).getCardBalanceAmount(), (BigDecimal)cardRemainder[0]));
                }
                remainder[0] = PriceUtils.subtractToSix((BigDecimal)mallMainOrderVo.getBalanceAmount(), (BigDecimal)remainder[0]);
                if (remainder[0].doubleValue() != 0.0) {
                    mallMainOrderVo.getMallOrderVos().get(0).setBalanceAmount(PriceUtils.add((BigDecimal)mallMainOrderVo.getMallOrderVos().get(0).getBalanceAmount(), (BigDecimal)remainder[0]));
                }
            }
            mallMainOrderVo.setCardBalanceAmount(useCardBalanceAmount);
        } else {
            if (mallMainOrderVo.getOrderCacheVo().getUseAccountBalance() == 0 || Objects.equals("0", mallMainOrderVo.getUseBalance())) {
                mallMainOrderVo.setBalanceAmount(BigDecimal.ZERO);
                return BaseJsonVo.success((Object)"");
            }
            if (useBalanceAmount.doubleValue() > 0.0) {
                BigDecimal[] remainder = new BigDecimal[]{BigDecimal.ZERO};
                BigDecimal[] finalUseBalanceAmount = new BigDecimal[]{useBalanceAmount};
                BigDecimal mianOrderMoneyAmount = PriceUtils.subtractToSix((BigDecimal)mallMainOrderVo.getTotalAmount(), (BigDecimal)mallMainOrderVo.getCouponAmount());
                mallMainOrderVo.getMallOrderVos().forEach(c -> {
                    BigDecimal orderMoneyAmount = PriceUtils.subtractToSix((BigDecimal)c.getTotalAmount(), (BigDecimal)c.getCouponAmount());
                    BigDecimal orderDivideMainMoneyAmount = orderMoneyAmount.divide(mianOrderMoneyAmount, 6, 4);
                    BigDecimal subBalanceAmount = PriceUtils.multiply((BigDecimal)orderDivideMainMoneyAmount, (BigDecimal)finalUseBalanceAmount[0]);
                    c.setBalanceAmount(subBalanceAmount);
                    remainder[0] = PriceUtils.addNoUp((BigDecimal)remainder[0], (BigDecimal)subBalanceAmount);
                });
                remainder[0] = PriceUtils.subtractToSix((BigDecimal)useBalanceAmount, (BigDecimal)remainder[0]);
                if (remainder[0].doubleValue() != 0.0) {
                    mallMainOrderVo.getMallOrderVos().get(0).setBalanceAmount(PriceUtils.add((BigDecimal)mallMainOrderVo.getMallOrderVos().get(0).getBalanceAmount(), (BigDecimal)remainder[0]));
                }
            }
            mallMainOrderVo.setBalanceAmount(useBalanceAmount);
        }
        return BaseJsonVo.success((Object)"");
    }
}

