/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.orderPlan;

import cc.lechun.apiinvoke.refund.PrepayCardInvoke;
import cc.lechun.balance.dto.BalanceChangeSpecialDTO;
import cc.lechun.common.enums.common.StatusEnum;
import cc.lechun.common.enums.trade.DeliveryTypeEnum;
import cc.lechun.common.enums.trade.OrderClassEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.common.vo.jms.MessageResult;
import cc.lechun.framework.core.database.util.SpringContextUtil;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.entity.pay.PayOutputEntity;
import cc.lechun.mall.entity.prepay.PrepayCardDetailEntity;
import cc.lechun.mall.entity.prepay.PrepayCardDetailOrderVo;
import cc.lechun.mall.entity.prepay.PrepayCardEntity;
import cc.lechun.mall.entity.prepay.PrepayCardPlanStatusEnum;
import cc.lechun.mall.entity.prepay.PrepayCardStatusEnum;
import cc.lechun.mall.entity.prepay.PrepayCardTypeEnum;
import cc.lechun.mall.entity.prepay.ShopChannelEnum;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderCacheInItemVo;
import cc.lechun.mall.entity.trade.MallOrderCacheInVo;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.orderPlan.MallOrderPlanEntity;
import cc.lechun.mall.entity.trade.orderPlan.MallOrderPlanProductEntity;
import cc.lechun.mall.iservice.pay.PayOrderInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardPlanDetailInterface;
import cc.lechun.mall.iservice.sales.ChannelInterface;
import cc.lechun.mall.iservice.shoppingcart.MallShoppingcartInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import cc.lechun.mall.iservice.trade.MallTradeInterface;
import cc.lechun.mall.iservice.trade.orderPlan.MallOrderPlanDomainInterface;
import cc.lechun.mall.iservice.trade.orderPlan.MallOrderPlanInterface;
import cc.lechun.mall.iservice.trade.orderPlan.MallOrderPlanLogInterface;
import cc.lechun.mall.iservice.trade.orderPlan.MallOrderPlanMessageInterface;
import cc.lechun.mall.iservice.trade.orderPlan.MallOrderPlanProductInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import java.io.Serializable;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class MallOrderPlanDomainService
implements MallOrderPlanDomainInterface {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MallOrderPlanInterface orderPlanInterface;
    @Autowired
    private MallOrderPlanProductInterface orderPlanProductInterface;
    @Autowired
    @Lazy
    private MallTradeInterface tradeInterface;
    @Autowired
    MallOrderPlanLogInterface orderPlanLogInterface;
    @Autowired
    @Lazy
    private PrepayCardInterface prepayCardService;
    @Autowired
    @Lazy
    private PrepayCardPlanDetailInterface prepayCardPlanDetailService;
    @Autowired
    @Lazy
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    @Lazy
    private MallOrderProductInterface orderProductInterface;
    @Autowired
    @Lazy
    private MallOrderInterface orderInterface;
    @Autowired
    @Lazy
    private PayOrderInterface payOrderInterface;
    @Autowired
    private MessageInterface messageInterface;
    @Autowired
    private MallOrderPlanMessageInterface orderPlanMessageInterface;
    @Lazy
    @Autowired
    private PrepayCardBatchInterface prepayCardBatchInterface;
    @Lazy
    @Autowired
    private MallOrderPlanDomainInterface orderPlanDomainInterface;
    @Autowired
    protected RedisCacheUtil redisCacheUtil;
    @Autowired
    private MallShoppingcartInterface shoppingcartInterface;
    @Autowired
    PrepayCardInvoke prepayCardInvoke;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private ChannelInterface channelInterface;

    @Override
    @Transactional
    public BaseJsonVo saveOrderPlan(int detailedId) {
        PrepayCardDetailEntity prepayCardDetailEntity = (PrepayCardDetailEntity)this.prepayCardPlanDetailService.selectByPrimaryKey(Integer.valueOf(detailedId));
        if (prepayCardDetailEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u8ba1\u5212");
        }
        if (prepayCardDetailEntity.getStatus() >= PrepayCardPlanStatusEnum.DELIVERY.getValue()) {
            return BaseJsonVo.error((String)("\u8ba1\u5212" + PrepayCardPlanStatusEnum.getName(prepayCardDetailEntity.getStatus()) + "\u4e0d\u80fd\u4fee\u6539"));
        }
        if (StringUtils.isNotEmpty((String)prepayCardDetailEntity.getOrderMainNo())) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u5df2\u751f\u6210,\u8bf7\u8054\u7cfb\u5ba2\u670d\u4fee\u6539\u8ba2\u5355");
        }
        int i = this.orderPlanProductInterface.deleteOrderPlanProduct(String.valueOf(detailedId));
        if (i > 0) {
            MallOrderPlanEntity orderPlanEntity = this.orderPlanInterface.getOrderPlan(prepayCardDetailEntity.getCustomerId());
            if (orderPlanEntity == null || StringUtils.isEmpty((String)orderPlanEntity.getOrderPlanId())) {
                this.logger.error("\u7528\u6237:{}\u8ba1\u5212\u4e0d\u5b58\u5728", (Object)orderPlanEntity.getCustomerId());
                return BaseJsonVo.error((String)"\u8ba1\u5212\u4e0d\u5b58\u5728");
            }
            BaseJsonVo<List<MallProductVO>> productSR = this.shoppingcartInterface.buildShoppingcartProducts(prepayCardDetailEntity.getCustomerId(), true, orderPlanEntity.getBindCode());
            if (!productSR.isSuccess()) {
                this.logger.error("\u7528\u6237:{}\u8d2d\u7269\u8f66\u6ca1\u6709\u5546\u54c1", (Object)orderPlanEntity.getCustomerId());
                return productSR;
            }
            this.logger.info("\u67e5\u8be2\u7528\u6237:{},\u8d2d\u7269\u8f66\u5546\u54c1:{}", (Object)prepayCardDetailEntity.getCustomerId(), (Object)JsonUtils.toJson((Object)productSR.getValue(), (boolean)false));
            BigDecimal usedPoint = BigDecimal.ZERO;
            ArrayList<MallOrderPlanProductEntity> planProductEntityList = new ArrayList<MallOrderPlanProductEntity>();
            for (MallProductVO productVO : (List)productSR.getValue()) {
                this.logger.info("\u5546\u54c1:{}", (Object)JsonUtils.toJson((Object)productVO, (boolean)false));
                MallOrderPlanProductEntity orderPlanProductEntity = new MallOrderPlanProductEntity();
                orderPlanProductEntity.setProductId(productVO.getProId());
                orderPlanProductEntity.setQuantity(productVO.getCount());
                orderPlanProductEntity.setProductName(productVO.getProName());
                orderPlanProductEntity.setProductType(SalesTypeEnum.SALES_PRODUCT.getValue());
                orderPlanProductEntity.setOrderPlanId(String.valueOf(detailedId));
                planProductEntityList.add(orderPlanProductEntity);
                usedPoint = PriceUtils.add((BigDecimal)usedPoint, (BigDecimal)PriceUtils.multiply((BigDecimal)productVO.getCardFactPrice(), (Integer)productVO.getCount()));
            }
            i = this.orderPlanProductInterface.batchInsert(planProductEntityList);
            if (i == 0) {
                this.logger.info("\u7528\u6237:{}\u6279\u91cf\u5199\u5165\u5546\u54c1\u5931\u8d25", (Object)orderPlanEntity.getCustomerId());
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            prepayCardDetailEntity.setPricePoint(usedPoint);
            prepayCardDetailEntity.setQuantity(((List)productSR.getValue()).stream().map(MallProductVO::getCount).reduce(0, (a, b) -> a + b));
            this.prepayCardPlanDetailService.updateByPrimaryKeySelective(prepayCardDetailEntity);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo saveOrderPlan(MallMainOrderVo mallMainOrderVo) {
        this.logger.info("\u5f00\u59cb\u4fdd\u5b58\u8ba2\u5355\u8ba1\u5212:{}", (Object)mallMainOrderVo.getCustomerId());
        MallOrderPlanEntity query = new MallOrderPlanEntity();
        query.setCustomerId(mallMainOrderVo.getCustomerId());
        MallOrderPlanEntity orderPlanEntity = (MallOrderPlanEntity)this.orderPlanInterface.getSingle(query, 0L);
        if (orderPlanEntity == null || StringUtils.isEmpty((String)orderPlanEntity.getOrderPlanId())) {
            int result;
            this.logger.info("\u67e5\u8be2\u7528\u6237:{}\u8ba1\u5212\u4e3a\u7a7a,\u65b0\u5efa\u8ba1\u5212", (Object)mallMainOrderVo.getCustomerId());
            orderPlanEntity = new MallOrderPlanEntity();
            orderPlanEntity.setCustomerId(mallMainOrderVo.getCustomerId());
            orderPlanEntity.setCreateTime(DateUtils.now());
            orderPlanEntity.setFirstOrderMainNo("");
            orderPlanEntity.setOrderPlanId(RandomUtils.generateId());
            orderPlanEntity.setSystemStatus(StatusEnum.STATUS_OK.getValue());
            orderPlanEntity.setUserStatus(StatusEnum.STATUS_OK.getValue());
            orderPlanEntity.setProductSelType(1);
            orderPlanEntity.setPlatformId(mallMainOrderVo.getPlatFormId());
            orderPlanEntity.setPeriod(DeliveryTypeEnum.getDay(mallMainOrderVo.getOrderCacheVo().getDeliveryType()));
            orderPlanEntity.setDeliveryType(mallMainOrderVo.getOrderCacheVo().getDeliveryType());
            orderPlanEntity.setNoticeType(mallMainOrderVo.getOrderCacheVo().getNoticeType());
            orderPlanEntity.setBindCode(mallMainOrderVo.getOrderCacheVo().getBindCode());
            if (mallMainOrderVo.getOrderCacheVo().getDeliveryType() > DeliveryTypeEnum.ONLY_ONE_DELIVERY.getValue()) {
                orderPlanEntity.setIntervalDay(DeliveryTypeEnum.getDay(mallMainOrderVo.getOrderCacheVo().getDeliveryType()));
                orderPlanEntity.setFirstTime(mallMainOrderVo.getOrderCacheVo().getDeliverDate());
                orderPlanEntity.setUserStatus(StatusEnum.STATUS_OK.getValue());
            }
            if (mallMainOrderVo.getOrderCacheVo().getDeliverDate() != null) {
                orderPlanEntity.setFirstTime(mallMainOrderVo.getOrderCacheVo().getDeliverDate());
                this.logger.info("\u5f00\u59cb\u66f4\u65b0\u7528\u6237{}\u8ba1\u5212 ", (Object)orderPlanEntity.getCustomerId());
            }
            if ((result = this.orderPlanInterface.insertSelective(orderPlanEntity)) == 0) {
                this.logger.error("\u7528\u6237:{}\u8ba2\u5355\u8ba1\u5212\u4fdd\u5b58\u5931\u8d25", (Object)mallMainOrderVo.getCustomerId());
                return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
            }
        } else {
            this.logger.info("\u7528\u6237\u9009\u62e9\u7684\u914d\u9001\u5468\u671f\u7c7b\u578b:{},\u63d0\u9192\u5468\u671f\u7c7b\u578b:{}", (Object)mallMainOrderVo.getOrderCacheVo().getDeliveryType(), (Object)mallMainOrderVo.getOrderCacheVo().getNoticeType());
            if (mallMainOrderVo.getOrderCacheVo().getDeliveryType() != null) {
                int result;
                orderPlanEntity.setPeriod(DeliveryTypeEnum.getDay(mallMainOrderVo.getOrderCacheVo().getDeliveryType()));
                orderPlanEntity.setDeliveryType(mallMainOrderVo.getOrderCacheVo().getDeliveryType());
                orderPlanEntity.setIntervalDay(DeliveryTypeEnum.getDay(mallMainOrderVo.getOrderCacheVo().getDeliveryType()));
                orderPlanEntity.setFirstTime(mallMainOrderVo.getOrderCacheVo().getDeliverDate());
                orderPlanEntity.setUserStatus(StatusEnum.STATUS_OK.getValue());
                orderPlanEntity.setUpdateTime(DateUtils.now());
                orderPlanEntity.setAddrId(mallMainOrderVo.getOrderCacheVo().getAddressId());
                orderPlanEntity.setBindCode(mallMainOrderVo.getOrderCacheVo().getBindCode());
                if (mallMainOrderVo.getOrderCacheVo().getNoticeType() != null) {
                    orderPlanEntity.setNoticeType(mallMainOrderVo.getOrderCacheVo().getNoticeType());
                }
                if ((result = this.orderPlanInterface.updateByPrimaryKeySelective(orderPlanEntity)) == 0) {
                    this.logger.error("\u7528\u6237:{}\u8ba2\u5355\u8ba1\u5212\u4fdd\u5b58\u5931\u8d25", (Object)mallMainOrderVo.getCustomerId());
                }
                this.logger.info("\u7528\u6237:{},\u8ba1\u5212:{}\u5df2\u8bbe\u7f6e\u7f13\u5b58", (Object)orderPlanEntity.getCustomerId(), (Object)orderPlanEntity.toString());
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo saveOrderPlan(MallOrderMainEntity orderMainEntity) {
        try {
            ((MallOrderPlanDomainService)SpringContextUtil.getBean(this.getClass())).updateOrderChannel(orderMainEntity);
        }
        catch (Exception e) {
            this.logger.info("\u66f4\u65b0\u5976\u5361\u8ba2\u5355\u6e20\u9053\u51fa\u9519", (Throwable)e);
        }
        try {
            this.logger.info("\u7528\u6237:{}\u4e0b\u5355\u6210\u529f\uff0c\u5f00\u59cb\u66f4\u65b0\u8ba1\u5212", (Object)orderMainEntity.getCustomerId());
            MallOrderPlanEntity query = new MallOrderPlanEntity();
            query.setCustomerId(orderMainEntity.getCustomerId());
            query.setUserStatus(StatusEnum.STATUS_OK.getValue());
            MallOrderPlanEntity orderPlanEntity = (MallOrderPlanEntity)this.orderPlanInterface.getSingle(query, 0L);
            if (orderPlanEntity != null && StringUtils.isNotEmpty((String)orderPlanEntity.getOrderPlanId())) {
                this.logger.info("\u7528\u6237\u8ba1\u5212:{}\u4e0b\u5355\u6210\u529f\uff0c\u5f00\u59cb\u66f4\u65b0\u8ba1\u5212", (Object)JsonUtils.toJson((Object)orderPlanEntity, (boolean)false));
                orderPlanEntity.setFirstOrderMainNo(orderMainEntity.getOrderMainNo());
                orderPlanEntity.setUpdateTime(DateUtils.now());
                orderPlanEntity.setUserStatus(StatusEnum.STATUS_FAIL.getValue());
                this.orderPlanInterface.updateByPrimaryKeySelective(orderPlanEntity);
                if (orderPlanEntity.getDeliveryType() > DeliveryTypeEnum.ONLY_ONE_DELIVERY.getValue()) {
                    if (orderMainEntity.getPayAmount().compareTo(BigDecimal.ZERO) == 0) {
                        Integer cardType = StringUtils.isNotEmpty((String)orderMainEntity.getBindCode()) ? (orderMainEntity.getBindCode().length() > 2 ? PrepayCardTypeEnum.yogurt_card.getValue() : Integer.valueOf(orderMainEntity.getBindCode()).intValue()) : PrepayCardTypeEnum.yogurt_card.getValue();
                        if (Objects.equals(cardType, PrepayCardTypeEnum.yogurt_card.getValue()) || Objects.equals(cardType, PrepayCardTypeEnum.new_card_Cold.getValue()) || Objects.equals(cardType, PrepayCardTypeEnum.new_card_Nomal.getValue())) {
                            int num;
                            BaseJsonVo<BigDecimal> baseJsonVo = this.prepayCardService.getSpecialTotal(orderMainEntity.getCustomerId(), cardType);
                            if (!baseJsonVo.isSuccess()) {
                                return baseJsonVo;
                            }
                            BigDecimal remainPoint = (BigDecimal)baseJsonVo.getValue();
                            if (remainPoint.compareTo(orderMainEntity.getPoints()) > 0 && (num = PriceUtils.divide((BigDecimal)remainPoint, (BigDecimal)orderMainEntity.getPoints()).intValue()) > 0) {
                                for (int i = 0; i < num; ++i) {
                                    BaseJsonVo<MallOrderCacheVo> jsonVo = this.tradeInterface.setOrderCacheByShoppingcat(orderMainEntity.getCustomerId(), orderMainEntity.getPlatformId(), orderMainEntity.getOrderSource(), orderMainEntity.getBindCode(), 1, 1, 1, "");
                                    if (jsonVo.isSuccess()) {
                                        MallOrderCacheVo mallOrderCacheVo = (MallOrderCacheVo)jsonVo.getValue();
                                        mallOrderCacheVo.setCacheType(2);
                                        mallOrderCacheVo.setAddressId(orderPlanEntity.getAddrId());
                                        mallOrderCacheVo.setDeliverDate(DateUtils.getAddDateByDay((Date)orderPlanEntity.getFirstTime(), (int)(orderPlanEntity.getIntervalDay() * (i + 1))));
                                        mallOrderCacheVo.setDeliverDate2(DateUtils.getAddDateByDay((Date)orderPlanEntity.getFirstTime(), (int)(orderPlanEntity.getIntervalDay() * (i + 1))));
                                        mallOrderCacheVo.setMildCardPay(1);
                                        BaseJsonVo createOrder = this.prepayCardPlanDetailService.createPlanOrder(mallOrderCacheVo, orderMainEntity.getCustomerId(), (int)orderMainEntity.getPlatformId());
                                        this.logger.info("\u7528\u6237:{}\u5976\u5361\u8ba2\u5355\u521b\u5efa:{},\u6d88\u606f:{}", new Object[]{orderMainEntity.getCustomerId(), createOrder.isSuccess(), createOrder.getMessage()});
                                        if (createOrder.isSuccess()) continue;
                                        this.logger.error("\u7528\u6237:{}\u5976\u5361\u8ba2\u5355\u521b\u5efa:{},\u9519\u8bef\u6d88\u606f:{}", new Object[]{orderMainEntity.getCustomerId(), createOrder.isSuccess(), createOrder.getMessage()});
                                        break;
                                    }
                                    this.logger.error("\u7528\u6237:{}\u521b\u5efa\u5468\u671f\u8ba2\u5355\u5931\u8d25:{}", (Object)orderMainEntity.getCustomerId(), (Object)baseJsonVo.getMessage());
                                    return jsonVo;
                                }
                            }
                            this.tradeInterface.removeCartChecked(orderMainEntity.getPlatformId(), orderMainEntity.getCustomerId(), true, 0, orderMainEntity.getBindCode());
                        }
                    } else {
                        this.logger.info("\u7528\u6237\u6709\u8865\u5fae\u4fe1\u652f\u4ed8:{}", (Object)orderMainEntity.getCustomerId());
                    }
                }
                this.logger.info("\u7528\u6237:{}\u4e0b\u5355\u6210\u529f\uff0c\u66f4\u65b0\u8ba1\u5212{}", (Object)orderMainEntity.getCustomerId(), (Object)orderPlanEntity.toString());
            }
        }
        catch (InvalidKeySpecException e) {
            this.logger.error("\u5468\u671f\u8d2d\u4e70\u8ba2\u5355\u51fa\u9519", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error("\u5468\u671f\u8d2d\u4e70\u8ba2\u5355\u51fa\u9519", (Throwable)e);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Retryable(value={Exception.class}, maxAttempts=3, backoff=@Backoff(delay=10000L, multiplier=2.0))
    public void updateOrderChannel(MallOrderMainEntity orderMainEntity) {
        PrepayCardEntity prepayCardEntity;
        List<PrepayCardDetailEntity> planDetailList = this.prepayCardPlanDetailService.getPlanDetailListByOrderMainNo(orderMainEntity.getOrderMainNo());
        if ((planDetailList = planDetailList.stream().sorted((p1, p2) -> p1.getSalePrice().compareTo(p2.getSalePrice())).collect(Collectors.toList())).get(0).getSalePrice().compareTo(orderMainEntity.getPayAmount()) > 0 && (prepayCardEntity = (PrepayCardEntity)this.prepayCardService.selectByPrimaryKey((Serializable)((Object)planDetailList.get(0).getCardId()))) != null && StringUtils.isNotEmpty((String)prepayCardEntity.getShopId())) {
            orderMainEntity.setChannelId(ShopChannelEnum.getChannelId(prepayCardEntity.getShopId()));
            MallOrderMainEntity update = new MallOrderMainEntity();
            update.setOrderMainNo(orderMainEntity.getOrderMainNo());
            update.setChannelId(ShopChannelEnum.getChannelId(prepayCardEntity.getShopId()));
            this.orderMainInterface.updateOrderMain(update);
            this.logger.info("\u8ba2\u5355:{}\u6e20\u9053:{}\u66f4\u65b0\u6210\u529f", (Object)orderMainEntity.getOrderMainNo(), (Object)update.getChannelId());
        }
    }

    @Override
    public BaseJsonVo saveOrderPlan(String orderMainNo) {
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        return this.saveOrderPlan(orderMainEntity);
    }

    @Override
    public BaseJsonVo getOrderPlan(MallMainOrderVo mallMainOrderVo) {
        MallOrderPlanEntity query = new MallOrderPlanEntity();
        query.setCustomerId(mallMainOrderVo.getCustomerId());
        MallOrderPlanEntity orderPlanEntity = (MallOrderPlanEntity)this.orderPlanInterface.getSingle(query, 0L);
        if (orderPlanEntity == null || StringUtils.isEmpty((String)orderPlanEntity.getOrderPlanId())) {
            this.logger.info("\u7528\u6237\uff1a{},\u8ba1\u5212\u914d\u9001\u5468\u671f\uff0c\u63d0\u9192\u5468\u671f\u90fd\u6ca1\u6709\u914d\u7f6e", (Object)mallMainOrderVo.getCustomerId());
            return BaseJsonVo.success((Object)"");
        }
        this.logger.info("\u7528\u6237{}\u8bbe\u7f6e\u7684\u914d\u9001\u8ba1\u5212:{},\u63d0\u9192\u8ba1\u5212:{}", new Object[]{orderPlanEntity.getCustomerId(), orderPlanEntity.getDeliveryType(), orderPlanEntity.getNoticeType()});
        mallMainOrderVo.setDeliveryType(orderPlanEntity.getDeliveryType());
        mallMainOrderVo.setNoticeType(orderPlanEntity.getNoticeType());
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo execPlan(Date date) {
        this.logger.info("date:{}", (Object)date);
        List<PrepayCardDetailEntity> detailList = this.prepayCardPlanDetailService.getTodayValidPointPlan(date);
        if (CollectionUtils.isEmpty(detailList)) {
            this.logger.info("\u7b26\u5408\u6761\u4ef6\u7684\u8ba1\u5212\u4e3a\u7a7a");
            return BaseJsonVo.success((Object)"");
        }
        for (PrepayCardDetailEntity detailEntity : detailList) {
            this.orderPlanDomainInterface.execPlan(detailEntity);
        }
        return BaseJsonVo.success((Object)"\u6267\u884c\u5b8c\u6bd5");
    }

    @Override
    public BaseJsonVo cancelPlan(String customerId) {
        MallOrderPlanEntity query = new MallOrderPlanEntity();
        query.setCustomerId(customerId);
        MallOrderPlanEntity orderPlanEntity = (MallOrderPlanEntity)this.orderPlanInterface.getSingle(query, 0L);
        if (orderPlanEntity == null || StringUtils.isEmpty((String)orderPlanEntity.getOrderPlanId())) {
            this.logger.info("\u7528\u6237:{},\u4e0d\u5b58\u5728\u5468\u671f\u914d\u9001\u8ba1\u5212", (Object)customerId);
            this.orderCancelFailNotice(orderPlanEntity.getCustomerId(), "\u53bb\u5546\u57ce\u6211\u7684\u8ba2\u5355\u770b\u770b t.lechun.cc/1xD5g00", "\u4e0d\u5b58\u572812\u5c0f\u65f6\u5185\u70b9\u5361\u8ba2\u5355");
            return BaseJsonVo.error((String)"\u53d6\u6d88\u5931\u8d25");
        }
        int hour = 12;
        this.logger.info("\u5f00\u59cb\u67e5\u8be2\u7528\u6237:{},{}\u5c0f\u65f6\u5185\u7684\u8ba2\u5355", (Object)customerId, (Object)hour);
        PrepayCardDetailEntity detailQuery = new PrepayCardDetailEntity();
        List<PrepayCardDetailEntity> detailList = this.prepayCardPlanDetailService.getPrepayCardDetailEntityList(customerId, PrepayCardPlanStatusEnum.DELIVERY.getValue(), 12);
        if (CollectionUtils.isEmpty(detailList)) {
            this.logger.info("\u7528\u6237:{},{}\u5c0f\u65f6\u5185\u7684\u8ba2\u5355\u4e0d\u5b58\u5728", (Object)customerId, (Object)hour);
            this.orderCancelFailNotice(orderPlanEntity.getCustomerId(), "\u53bb\u5546\u57ce\u6211\u7684\u8ba2\u5355\u770b\u770b t.lechun.cc/1xD5g00", "\u4e0d\u5b58\u572812\u5c0f\u65f6\u5185\u70b9\u5361\u8ba2\u5355");
            return BaseJsonVo.error((String)("\u7528\u6237\u4e0d\u5b58\u5728" + hour + "\u5c0f\u65f6\u5185\u7684\u8ba1\u5212\u8ba2\u5355"));
        }
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(detailList.get(0).getOrderMainNo());
        BaseJsonVo baseJsonVo = this.prepayCardInvoke.refundPrepayCardForMall(orderMainEntity.getOrderMainNo(), null, customerId);
        this.logger.info("\u7528\u6237:{},\u8ba2\u5355:{}\u53d6\u6d88:{},\u539f\u56e0:{}", new Object[]{customerId, detailList.get(0).getOrderMainNo(), baseJsonVo.isSuccess(), baseJsonVo.getMessage()});
        if (baseJsonVo.isSuccess()) {
            this.cancelOrderNotice(orderPlanEntity.getCustomerId(), orderMainEntity.getOrderMainNo(), "\u53d6\u6d88\u6210\u529f", "\u5df2\u53d6\u6d88", orderMainEntity.getCreateTime());
        } else {
            this.cancelOrderNotice(orderPlanEntity.getCustomerId(), orderMainEntity.getOrderMainNo(), baseJsonVo.getMessage(), OrderStatusEnum.getName(orderMainEntity.getStatus()), orderMainEntity.getCreateTime());
        }
        return BaseJsonVo.success((Object)"");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BaseJsonVo execPlan(PrepayCardDetailEntity prepayCardDetailEntity) {
        if (!Objects.equals(prepayCardDetailEntity.getOrderSource(), OrderSourceEnum.RECHANGE_CARD.getValue())) {
            this.logger.info("\u8ba1\u5212:{},\u975e\u70b9\u5361\u8ba1\u5212", (Object)prepayCardDetailEntity.getDetailedId());
            return BaseJsonVo.success((Object)"");
        }
        if (!Objects.equals(prepayCardDetailEntity.getStatus(), PrepayCardPlanStatusEnum.ACTIVE.getValue())) {
            this.logger.info("\u8ba1\u5212:{},\u72b6\u6001:{},\u4e0d\u80fd\u521b\u5efa\u8ba1\u5212");
            return BaseJsonVo.success((Object)"");
        }
        if (StringUtils.isNotEmpty((String)prepayCardDetailEntity.getCardId())) {
            this.logger.info("\u8ba1\u5212:{},\u5361id:{},\u4e0d\u80fd\u521b\u5efa\u8ba1\u5212", (Object)prepayCardDetailEntity.getDetailedId(), (Object)prepayCardDetailEntity.getCardId());
            return BaseJsonVo.success((Object)"");
        }
        if (StringUtils.isNotEmpty((String)prepayCardDetailEntity.getOrderMainNo())) {
            this.logger.info("\u8ba1\u5212:{},\u5df2\u751f\u6210\u8ba2\u5355:{},\u4e0d\u80fd\u521b\u5efa\u8ba1\u5212", (Object)prepayCardDetailEntity.getDetailedId(), (Object)prepayCardDetailEntity.getOrderMainNo());
            return BaseJsonVo.success((Object)"");
        }
        PrepayCardDetailOrderVo prepayCardDetailOrderVo = new PrepayCardDetailOrderVo();
        BeanUtils.copyProperties((Object)prepayCardDetailEntity, (Object)prepayCardDetailOrderVo);
        prepayCardDetailOrderVo.setDeliverDate(prepayCardDetailEntity.getPickTime());
        if (StringUtils.isNotEmpty((String)prepayCardDetailEntity.getOrderPlanId())) {
            MallOrderPlanEntity mallOrderPlanEntity = (MallOrderPlanEntity)this.orderPlanInterface.selectByPrimaryKey((Serializable)((Object)prepayCardDetailEntity.getOrderPlanId()));
            prepayCardDetailOrderVo.setDeliverDate(DateUtils.getAddDateByDay((Date)prepayCardDetailEntity.getPickTime(), (int)mallOrderPlanEntity.getIntervalDay()));
        }
        MallOrderPlanEntity orderPlanEntity = (MallOrderPlanEntity)this.orderPlanInterface.selectByPrimaryKey((Serializable)((Object)prepayCardDetailEntity.getOrderPlanId()));
        prepayCardDetailOrderVo.setPlatformId(orderPlanEntity.getPlatformId());
        prepayCardDetailOrderVo.setBindCode(orderPlanEntity.getBindCode());
        MallOrderPlanProductEntity orderPlanProductEntity = new MallOrderPlanProductEntity();
        orderPlanProductEntity.setOrderPlanId(prepayCardDetailEntity.getDetailedId().toString());
        List mallOrderPlanProductEntityList = this.orderPlanProductInterface.getList(orderPlanProductEntity, 0L);
        if (CollectionUtils.isEmpty((Collection)mallOrderPlanProductEntityList)) {
            this.logger.error("\u8ba1\u5212:{},\u6ca1\u6709\u5546\u54c1", (Object)prepayCardDetailEntity.getDetailedId());
            return BaseJsonVo.error((String)"\u8ba1\u5212\u5546\u54c1\u4e3a\u7a7a");
        }
        MallOrderCacheInVo inVo = new MallOrderCacheInVo();
        inVo.setOrderSource(OrderSourceEnum.RECHANGE_CARD.getValue());
        inVo.setBindCode(prepayCardDetailOrderVo.getBindCode());
        inVo.setDefineField("");
        inVo.setMallOrderCacheInItemVoList(new ArrayList<MallOrderCacheInItemVo>());
        for (MallOrderPlanProductEntity planProductEntity : mallOrderPlanProductEntityList) {
            MallOrderCacheInItemVo orderCacheInItemVo = new MallOrderCacheInItemVo();
            orderCacheInItemVo.setItemId(planProductEntity.getProductId());
            orderCacheInItemVo.setItemType(planProductEntity.getProductType());
            orderCacheInItemVo.setQuantity(planProductEntity.getQuantity());
            inVo.getMallOrderCacheInItemVoList().add(orderCacheInItemVo);
        }
        BaseJsonVo baseJsonVo = this.tradeInterface.setOrderCache(prepayCardDetailOrderVo.getPlatformId(), prepayCardDetailOrderVo.getCustomerId(), inVo);
        this.logger.info("\u8ba1\u5212:{},\u7528\u6237:{},\u8bbe\u7f6e\u7f13\u5b58:{} message={}", new Object[]{prepayCardDetailOrderVo.getDetailedId(), prepayCardDetailOrderVo.getCustomerId(), baseJsonVo.isSuccess(), baseJsonVo.getMessage()});
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        try {
            ((MallOrderCacheVo)baseJsonVo.getValue()).setDeliverDate(prepayCardDetailOrderVo.getDeliverDate());
            BaseJsonVo<Map<String, Object>> tempBaseJson = this.createPlanOrder(prepayCardDetailOrderVo, (MallOrderCacheVo)baseJsonVo.getValue());
            this.logger.info("\u8ba1\u5212:{},\u521b\u5efa\u8ba2\u5355:{}", (Object)prepayCardDetailEntity.getDetailedId(), (Object)tempBaseJson.isSuccess());
            if (!tempBaseJson.isSuccess()) {
                this.logger.info("\u7528\u6237:{},\u5f00\u59cb\u63a8\u9001\u521b\u5355\u5931\u8d25\u901a\u77e5", (Object)prepayCardDetailOrderVo.getCustomerId());
                this.pushCreatedOrderFailNotice(prepayCardDetailOrderVo.getCustomerId(), baseJsonVo.getMessage(), "\u4e0b\u5355\u5931\u8d25", "\u53bb\u5546\u57ce\u9009\u62e9\u53d1\u8d27\u65e5\u671f\u8bd5\u8bd5");
                prepayCardDetailEntity.setStatus(PrepayCardPlanStatusEnum.NOEFFECT.getValue());
                this.prepayCardPlanDetailService.updateByPrimaryKeySelective(prepayCardDetailEntity);
                return BaseJsonVo.error((String)"\u4e0b\u5355\u5931\u8d25");
            }
            Map result = (Map)tempBaseJson.getValue();
            String mainOrderNo = result.get("mainOrderNo").toString();
            String ip = "127.0.0.1";
            PayOutputEntity payOutputEntity = this.payOrderInterface.topay(prepayCardDetailOrderVo.getCustomerId(), mainOrderNo, ip);
            this.logger.info("\u8ba2\u5355:{}payResult {} ", (Object)mainOrderNo, (Object)JsonUtils.toJson((Object)payOutputEntity, (boolean)false));
            if (payOutputEntity.getStatus() != 6) {
                this.logger.info("\u8ba2\u5355:{}\u652f\u4ed8\u5931\u8d25,\u652f\u4ed8\u7ed3\u679c:{}", (Object)mainOrderNo, (Object)payOutputEntity.toString());
                return BaseJsonVo.error((String)"\u4e0b\u5355\u5931\u8d25");
            }
            MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(mainOrderNo);
            this.prepayCardPlanDetailService.deleteByPrimaryKey(prepayCardDetailEntity.getDetailedId());
            HashMap<String, String> cot = new HashMap<String, String>();
            cot.put("userId", orderMainEntity.getCustomerId());
            cot.put("orderMainNo", orderMainEntity.getOrderMainNo());
            String ticketNo = "";
            cot.put("ticketNo", ticketNo);
            Date sendTime = DateUtils.getAddDateBySecond((Date)DateUtils.now(), (int)1200);
            MessageResult mr = this.messageQueueService.sendTaskMessage(MessageQueueTagEnum.orderPayMessage, MessageParam.messageParam((String)orderMainEntity.getOrderMainNo(), cot), sendTime);
            this.logger.info("\u63a8\u9001\u6d88\u606f\u961f\u5217\u7ed3\u679c\uff1a{},{}", (Object)mr.isStatus(), (Object)mr.getMsg().toString());
            return BaseJsonVo.success((Object)"");
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
            return BaseJsonVo.error((String)"\u4e0b\u5355\u5931\u8d25");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return BaseJsonVo.error((String)"\u4e0b\u5355\u5931\u8d25");
    }

    @Override
    public BaseJsonVo pushCreatedOrderNotice(MallOrderMainEntity orderMainEntity) {
        String actionId = "createdOrderNotice";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("date", DateUtils.formatDate((Date)DateUtils.getAddDateBySecond((Date)DateUtils.now(), (int)43200), (String)""));
        map.put("orderStatus", OrderStatusEnum.getName(orderMainEntity.getStatus()));
        List<MallOrderEntity> orderList = this.orderInterface.getOrderList(orderMainEntity.getOrderMainNo());
        map.put("orderMainNo", orderMainEntity.getOrderMainNo());
        map.put("orderNo", orderList.get(0).getOrderNo());
        map.put("deliverDate", orderList.get(0).getDeliverTime());
        return this.messageInterface.sendWechatMessage(actionId, orderMainEntity.getCustomerId(), map);
    }

    @Override
    public BaseJsonVo pushCreatedOrderNotice(String orderMainNo) {
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        return this.pushCreatedOrderNotice(orderMainEntity);
    }

    private BaseJsonVo pushCreatedOrderFailNotice(String customerId, String reson, String order, String notice) {
        String actionId = "createOrderFail";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("orderNo", order);
        map.put("reson", reson);
        map.put("notice", notice);
        return this.messageInterface.sendWechatMessage(actionId, customerId, map);
    }

    private BaseJsonVo cancelOrderNotice(String customerId, String order, String notice, String statusName, Date orderCreateDate) {
        String actionId = "orderCancel";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("orderNo", order);
        map.put("date", DateUtils.formatDate((Date)orderCreateDate, (String)""));
        map.put("orderStatus", statusName);
        map.put("notice", notice);
        return this.messageInterface.sendWechatMessage(actionId, customerId, map);
    }

    public BaseJsonVo orderCancelFailNotice(String customerId, String notice, String reson) {
        String actionId = "orderCancelFail";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("reson", reson);
        map.put("notice", notice);
        return this.messageInterface.sendWechatMessage(actionId, customerId, map);
    }

    private BaseJsonVo<Map<String, Object>> createPlanOrder(PrepayCardDetailOrderVo prepayCardDetailOrderVo, MallOrderCacheVo orderCacheVo) throws InvalidKeySpecException, NoSuchAlgorithmException {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        orderCacheVo.setCacheType(2);
        orderCacheVo.setAddressId(prepayCardDetailOrderVo.getAddrId());
        orderCacheVo.setDeliverDate(prepayCardDetailOrderVo.getDeliverDate());
        orderCacheVo.setDeliverDate2(prepayCardDetailOrderVo.getDeliverDate());
        String date = orderCacheVo.getDeliverDate() == null ? DateUtils.date() : DateUtils.formatDate((Date)orderCacheVo.getDeliverDate(), (String)"yyyy-MM-dd");
        orderCacheVo.setDeliverDate(DateUtils.getDateFromString((String)date, (String)"yyyy-MM-dd"));
        date = orderCacheVo.getDeliverDate2() == null ? DateUtils.date() : DateUtils.formatDate((Date)orderCacheVo.getDeliverDate2(), (String)"yyyy-MM-dd");
        orderCacheVo.setDeliverDate2(DateUtils.getDateFromString((String)date, (String)"yyyy-MM-dd"));
        orderCacheVo.setSourceOrderNo("");
        orderCacheVo.setMildCardPay(1);
        baseJsonVo = this.tradeInterface.createOrder(prepayCardDetailOrderVo.getPlatformId(), prepayCardDetailOrderVo.getCustomerId(), orderCacheVo);
        this.logger.info("createPlanOrder createResult : {}", (Object)JsonUtils.toJson((Object)baseJsonVo, (boolean)false));
        return baseJsonVo;
    }

    @Override
    @Transactional
    public BaseJsonVo createPlanDetail(String orderMainNo, List<BalanceChangeSpecialDTO> cardCostList) {
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        if (Objects.equals(orderMainEntity.getOrderClass(), OrderClassEnum.SPLITE_DELIVERY_ORDER.getValue()) || Objects.equals(orderMainEntity.getOrderSource(), OrderSourceEnum.RECHANGE_CARD.getValue())) {
            return this.createPlanDetail(orderMainEntity, cardCostList);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo createPlanDetail(MallOrderMainEntity orderMainEntity, List<BalanceChangeSpecialDTO> cardCostList) {
        for (BalanceChangeSpecialDTO entry : cardCostList) {
            if (entry.getParChangeMoney().compareTo(BigDecimal.ZERO) == 0) continue;
            List<MallOrderEntity> orderList = this.orderInterface.getOrderList(orderMainEntity.getOrderMainNo());
            PrepayCardEntity query = new PrepayCardEntity();
            query.setRelateCardNo(entry.getCardNo());
            PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardService.getSingle(query, 0L);
            if (prepayCardEntity.getStatus().intValue() == PrepayCardStatusEnum.TAKED.getValue()) {
                prepayCardEntity.setStatus(PrepayCardStatusEnum.ACTIVE.getValue());
                this.prepayCardService.updateByPrimaryKeySelective(prepayCardEntity);
            }
            PrepayCardDetailEntity prepayCardDetailEntity = new PrepayCardDetailEntity();
            prepayCardDetailEntity.setOrderMainNo(orderMainEntity.getOrderMainNo());
            prepayCardDetailEntity.setCardId(prepayCardEntity.getCardId());
            prepayCardDetailEntity.setCardOrderMainNo(StringUtils.isNotEmpty((String)prepayCardEntity.getOrderMainNo()) ? prepayCardEntity.getOrderMainNo() : "");
            prepayCardDetailEntity.setCreateTime(DateUtils.now());
            prepayCardDetailEntity.setStatus(PrepayCardPlanStatusEnum.DELIVERY.getValue());
            prepayCardDetailEntity.setCustomerId(orderMainEntity.getCustomerId());
            prepayCardDetailEntity.setOrderSource(orderMainEntity.getOrderSource());
            prepayCardDetailEntity.setAddrId(orderList.get(0).getAddrId());
            prepayCardDetailEntity.setPromotionId("");
            prepayCardDetailEntity.setQuantity(orderMainEntity.getQuantity());
            prepayCardDetailEntity.setPickTime(orderList.get(0).getPickupTime() == null ? DateUtils.now() : orderList.get(0).getPickupTime());
            prepayCardDetailEntity.setPerPrice(entry.getParChangeMoney());
            prepayCardDetailEntity.setSalePrice(entry.getRealChangeMoney());
            if (Objects.equals(prepayCardEntity.getCardType(), PrepayCardTypeEnum.yogurt_card.getValue())) {
                prepayCardDetailEntity.setSalePrice(PriceUtils.divide((BigDecimal)prepayCardDetailEntity.getSalePrice(), (BigDecimal)new BigDecimal(100)));
            }
            prepayCardDetailEntity.setPricePoint(orderMainEntity.getTotalAmount());
            this.prepayCardPlanDetailService.insertSelective(prepayCardDetailEntity);
            this.logger.info("\u7528\u6237:{},\u8ba1\u5212:{},\u8ba2\u5355:{} \u5df2\u4fdd\u5b58\u6267\u884c\u4fdd\u5b58\u8ba1\u5212\u660e\u7ec6", new Object[]{orderMainEntity.getCustomerId(), prepayCardDetailEntity.getOrderPlanId(), orderMainEntity.getOrderMainNo()});
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo pushPlanNotice(Date date) {
        return BaseJsonVo.success((Object)"");
    }
}

