/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.orderSourcePrice;

import cc.lechun.active.entity.active.ActiveItemEntity;
import cc.lechun.active.entity.active.LevelPriceVo;
import cc.lechun.active.iservice.active.ActiveItemInterface;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

public class BasePrice {
    @Autowired
    private ActiveItemInterface activeItemService;

    public void priceCalculation(MallOrderCacheVo orderCacheVo, MallPromotionVO promotionVO, Integer deliverCount) {
        ActiveItemEntity activeItemEntity = this.getPrice(orderCacheVo.getBindCode(), promotionVO.getPromotionId(), SalesTypeEnum.SALES_PROMOTION.getValue(), promotionVO.getQuantity());
        if (activeItemEntity != null) {
            promotionVO.setFactPrice(activeItemEntity.getSalePrice());
            promotionVO.setPromotionPrice(activeItemEntity.getSalePrice());
            promotionVO.setOriginPrice(activeItemEntity.getOriginPrice());
            promotionVO.setPromotionDiff(PriceUtils.subtract((BigDecimal)activeItemEntity.getOriginPrice(), (BigDecimal)promotionVO.getPromotionPrice()));
            if (promotionVO.getPromotionDiff().compareTo(BigDecimal.ZERO) < 0) {
                promotionVO.setPromotionDiff(BigDecimal.ZERO);
            }
        }
    }

    public void priceCalculation(MallOrderCacheVo orderCacheVo, MallProductVO productVO, Integer deliverCount) {
        ActiveItemEntity activeItemEntity = this.getPrice(orderCacheVo.getBindCode(), productVO.getItemId(), SalesTypeEnum.SALES_PRODUCT.getValue(), productVO.getQuantity());
        if (activeItemEntity != null) {
            productVO.setFactPrice(activeItemEntity.getSalePrice());
            productVO.setOriginPrice(activeItemEntity.getOriginPrice());
        }
    }

    public ActiveItemEntity getPrice(String bindCode, String itemId, Integer itemType, Integer count) {
        ActiveItemEntity itemQuery = new ActiveItemEntity();
        itemQuery.setBindCode(bindCode);
        itemQuery.setStatus(1);
        itemQuery.setItemId(itemId);
        itemQuery.setItemType(itemType);
        ActiveItemEntity itemEntity = (ActiveItemEntity)this.activeItemService.getSingle(itemQuery, 0L);
        if (itemEntity == null) {
            throw new RuntimeException("\u65e0\u6548\u7684\u5546\u54c1");
        }
        if (StringUtils.isNotEmpty((String)itemEntity.getPriceList())) {
            List levelPriceVoList = JsonUtils.getListByArray(LevelPriceVo.class, (String)itemEntity.getPriceList());
            Optional<LevelPriceVo> LevelPriceVoOption = levelPriceVoList.stream().filter(d -> d.getStart() <= count && count <= d.getEnd()).findFirst();
            itemEntity.setSalePrice(LevelPriceVoOption.isPresent() ? LevelPriceVoOption.get().getPrice() : itemEntity.getSalePrice());
        }
        return itemEntity;
    }
}

