/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.orderSourcePrice;

import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.mall.entity.prepay.PrepayCardBatchEntity;
import cc.lechun.mall.entity.prepay.PrepayCardTypeEnum;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.service.trade.orderSourcePrice.PriceHandle;
import java.math.BigDecimal;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="26_source")
public class CardPlanHandle
implements PriceHandle {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Lazy
    @Autowired
    private PrepayCardBatchInterface prepayCardBatchInterface;

    @Override
    public void priceCalculation(MallOrderCacheVo orderCacheVo, MallPromotionVO promotionVO, Integer deliverCount) {
        PrepayCardBatchEntity prepayCardBatchEntity = (PrepayCardBatchEntity)this.prepayCardBatchInterface.selectByPrimaryKey(orderCacheVo.getBatchId());
        if (Objects.equals(prepayCardBatchEntity.getCardType(), PrepayCardTypeEnum.milk_card.getValue()) || Objects.equals(prepayCardBatchEntity.getCardType(), PrepayCardTypeEnum.coffee_card.getValue())) {
            promotionVO.setFactPrice(prepayCardBatchEntity.getPerPrice());
            promotionVO.setPromotionPrice(prepayCardBatchEntity.getPerPrice());
            promotionVO.setPromotionDiff(PriceUtils.subtract((BigDecimal)promotionVO.getOriginPrice(), (BigDecimal)promotionVO.getPromotionPrice()));
            if (promotionVO.getPromotionDiff().compareTo(BigDecimal.ZERO) < 0) {
                promotionVO.setPromotionDiff(BigDecimal.ZERO);
            }
        }
    }

    @Override
    public void priceCalculation(MallOrderCacheVo orderCacheVo, MallProductVO productVO, Integer deliverCount) {
    }
}

