/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.orderSourcePrice;

import cc.lechun.active.entity.active.ActiveItemEntity;
import cc.lechun.active.iservice.groupon.GrouponInterface;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.sales.CutRuleEntity;
import cc.lechun.mall.entity.sales.CutRuleTypeEnum;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.iservice.sales.CutRuleInterface;
import cc.lechun.mall.iservice.sales.MallProductCategoryInterface;
import cc.lechun.mall.service.dictionary.DictionaryService;
import cc.lechun.mall.service.trade.orderSourcePrice.PriceHandle;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="46_source")
public class PeriodicPurchaseHandle
implements PriceHandle {
    @Autowired
    private GrouponInterface grouponService;
    @Autowired
    private DictionaryService dictionaryService;
    @Autowired
    private CutRuleInterface cutRuleService;
    @Autowired
    private MallProductCategoryInterface mallProductCategoryService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void priceCalculation(MallOrderCacheVo orderCacheVo, MallPromotionVO promotionVO, Integer deliverCount) {
        ActiveItemEntity activeItemEntity = this.grouponService.getPrice(orderCacheVo.getBindCode(), promotionVO.getPromotionId(), SalesTypeEnum.SALES_PROMOTION.getValue(), promotionVO.getQuantity() * deliverCount);
        if (activeItemEntity != null) {
            this.logger.info("\u4fc3\u9500:{}\u5468\u671f\u539f\u4ef7:{},\u8d2d\u4e70\u4ef7\u683c:{},\u6570\u91cf:{}", new Object[]{promotionVO.getPromotionName(), activeItemEntity.getOriginPrice(), activeItemEntity.getSalePrice(), promotionVO.getQuantity() * deliverCount});
            promotionVO.setFactPrice(activeItemEntity.getSalePrice());
            promotionVO.setPromotionPrice(activeItemEntity.getSalePrice());
            promotionVO.setOriginPrice(activeItemEntity.getOriginPrice());
            CutRuleEntity cutRuleEntity = new CutRuleEntity();
            cutRuleEntity.setBindCode(orderCacheVo.getBindCode());
            cutRuleEntity.setRuleType(CutRuleTypeEnum.DELIVERTY_NUM.getValue());
            List cutRuleEntityList = this.cutRuleService.getList(cutRuleEntity);
            if (CollectionUtils.isNotEmpty((Collection)cutRuleEntityList)) {
                cutRuleEntityList.sort((o1, o2) -> o2.getStart().compareTo(o1.getStart()));
                Optional<CutRuleEntity> optional = cutRuleEntityList.stream().filter(c -> deliverCount >= c.getStart().intValue() && deliverCount < c.getEnd().intValue()).findFirst();
                if (optional.isPresent()) {
                    promotionVO.setPromotionPrice(PriceUtils.multiply((BigDecimal)promotionVO.getPromotionPrice(), (BigDecimal)optional.get().getDiscount()));
                    promotionVO.setFactPrice(activeItemEntity.getSalePrice());
                    this.logger.info("\u6d3b\u52a8:{},\u914d\u9001\u6b21\u6570\uff1a{}, \u6298\u6263:{}", new Object[]{orderCacheVo.getBindCode(), deliverCount, optional.get().getDiscount()});
                }
            }
            promotionVO.setPromotionDiff(PriceUtils.subtract((BigDecimal)activeItemEntity.getOriginPrice(), (BigDecimal)promotionVO.getPromotionPrice()));
            if (promotionVO.getPromotionDiff().compareTo(BigDecimal.ZERO) < 0) {
                promotionVO.setPromotionDiff(BigDecimal.ZERO);
            }
            this.logger.info("\u5468\u671f\u8d2d\u4fc3\u9500\u4ef7\u683c:{}", (Object)promotionVO.toString());
        }
    }

    @Override
    public void priceCalculation(MallOrderCacheVo orderCacheVo, MallProductVO productVO, Integer deliverCount) {
        ActiveItemEntity activeItemEntity = this.grouponService.getPrice(orderCacheVo.getBindCode(), productVO.getItemId(), SalesTypeEnum.SALES_PRODUCT.getValue(), productVO.getQuantity() * deliverCount);
        if (activeItemEntity != null) {
            List<String> productLineList;
            List<DictionaryEntity> dictionaryEntityList;
            this.logger.info("\u5546\u54c1:{}\u5468\u671f\u8d2d\u539f\u4ef7:{},\u5b9e\u9645\u4ef7\u683c:{},\u5355\u6b21\u6570\u91cf:{}", new Object[]{productVO.getProName(), activeItemEntity.getOriginPrice(), activeItemEntity.getSalePrice(), productVO.getQuantity() * deliverCount});
            productVO.setFactPrice(activeItemEntity.getSalePrice());
            productVO.setOriginPrice(activeItemEntity.getOriginPrice());
            CutRuleEntity cutRuleEntity = new CutRuleEntity();
            cutRuleEntity.setBindCode(orderCacheVo.getBindCode());
            cutRuleEntity.setRuleType(CutRuleTypeEnum.DELIVERTY_NUM.getValue());
            List cutRuleEntityList = this.cutRuleService.getList(cutRuleEntity);
            if (CollectionUtils.isNotEmpty((Collection)cutRuleEntityList)) {
                cutRuleEntityList.sort((o1, o2) -> o2.getStart().compareTo(o1.getStart()));
                Optional<CutRuleEntity> optional = cutRuleEntityList.stream().filter(c -> deliverCount >= c.getStart().intValue() && deliverCount < c.getEnd().intValue()).findFirst();
                if (optional.isPresent()) {
                    productVO.setFactPrice(PriceUtils.multiply((BigDecimal)productVO.getFactPrice(), (BigDecimal)optional.get().getDiscount()));
                    this.logger.info("\u6d3b\u52a8:{},\u914d\u9001\u6b21\u6570\uff1a{}\uff0c\u914d\u9001\u6b21\u6570\u6298\u6263:{}", new Object[]{orderCacheVo.getBindCode(), deliverCount, optional.get().getDiscount()});
                }
            }
            if (CollectionUtils.isNotEmpty(dictionaryEntityList = this.dictionaryService.getValidDictionaryList(227)) && CollectionUtils.isNotEmpty(productLineList = this.mallProductCategoryService.getProductCategoryList(productVO.getProductCategoryId(), new ArrayList<String>(), null))) {
                boolean flag = false;
                for (String item : productLineList) {
                    for (DictionaryEntity dictionaryEntity : dictionaryEntityList) {
                        if (Objects.equals(item, dictionaryEntity.getDictionaryKey())) {
                            this.logger.info("\u6d3b\u52a8:{},\u5546\u54c1:{}\uff0c\u6298\u6263\u524d\u552e\u4ef7:{}", new Object[]{orderCacheVo.getBindCode(), productVO.getProName(), productVO.getFactPrice()});
                            productVO.setFactPrice(PriceUtils.multiply((BigDecimal)productVO.getFactPrice(), (BigDecimal)new BigDecimal(dictionaryEntity.getDictionaryName())));
                            flag = true;
                            this.logger.info("\u6d3b\u52a8:{},\u5546\u54c1:{}\uff0c\u4ea7\u54c1\u7ebf\u6298\u6263:{},\u6298\u6263\u540e:{}", new Object[]{orderCacheVo.getBindCode(), productVO.getProName(), new BigDecimal(dictionaryEntity.getDictionaryName()), productVO.getFactPrice()});
                        }
                        if (!flag) continue;
                        break;
                    }
                    if (!flag) continue;
                    break;
                }
            }
            this.logger.info("\u5546\u54c1\u5468\u671f\u8d2d\u4ef7\u683c:{}", (Object)productVO.toString());
        }
    }
}

