/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.user;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.sign.MD5;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.dao.user.MallRoleResourceMapper;
import cc.lechun.mall.dao.user.MallUserMapper;
import cc.lechun.mall.dao.user.MallUserRoleMapper;
import cc.lechun.mall.entity.user.MallRoleResourceEntity;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.entity.user.MallUserMenuRsVo;
import cc.lechun.mall.entity.user.MallUserMenuVo;
import cc.lechun.mall.entity.user.MallUserRoleEntity;
import cc.lechun.mall.iservice.user.SysUserInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysUserService
implements SysUserInterface {
    @Autowired
    MallUserMapper mallUserMapper;
    @Autowired
    MallUserRoleMapper mallUserRoleMapper;
    @Autowired
    MallRoleResourceMapper mallRoleResourceMapper;

    @Override
    public BaseJsonVo saveMallUser(MallUserEntity mallUserEntity) {
        BaseJsonVo rs = this.validUser(mallUserEntity);
        if (!rs.isSuccess()) {
            return rs;
        }
        mallUserEntity.setUserId(IDGenerate.getUniqueID() + "");
        mallUserEntity.setCreateTime(DateUtils.now());
        mallUserEntity.setUserType(1);
        mallUserEntity.setPassword(MD5.sign((String)"lechun", (String)mallUserEntity.getPassword()));
        this.mallUserMapper.insertSelective(mallUserEntity);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo updateMallUser(MallUserEntity mallUserEntity) {
        BaseJsonVo rs = this.validUser(mallUserEntity);
        if (!rs.isSuccess()) {
            return rs;
        }
        if (!StringUtils.isEmpty((String)mallUserEntity.getPassword())) {
            mallUserEntity.setPassword(MD5.sign((String)"lechun", (String)mallUserEntity.getPassword()));
        }
        this.mallUserMapper.updateByPrimaryKeySelective(mallUserEntity);
        return BaseJsonVo.success((Object)"");
    }

    private BaseJsonVo validUser(MallUserEntity mallUserEntity) {
        if (StringUtils.isEmpty((String)mallUserEntity.getUserName())) {
            return BaseJsonVo.paramError((String)"\u767b\u5f55\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)mallUserEntity.getUserNick())) {
            return BaseJsonVo.paramError((String)"\u6635\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)mallUserEntity.getUserId()) && StringUtils.isEmpty((String)mallUserEntity.getPassword())) {
            return BaseJsonVo.paramError((String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (mallUserEntity.getPlatformGroupId() == null) {
            return BaseJsonVo.paramError((String)"\u6240\u5c5e\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public PageInfo getMallUserList(int pageNum, int pageSize, String userName, String userNick, int platformGroupId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.mallUserMapper.getMallUserList(userName, userNick, platformGroupId);
        PageInfo rs = page.toPageInfo();
        return rs;
    }

    @Override
    @ReadThroughSingleCache(namespace="getMallUserNickName", expiration=7200)
    public String getMallUserNickName(@ParameterValueKeyProvider String user_id) {
        MallUserEntity mallUserEntity = this.getMallUser(user_id);
        return mallUserEntity == null ? "" : mallUserEntity.getUserNick();
    }

    @Override
    public MallUserEntity getMallUser(String user_id) {
        return (MallUserEntity)this.mallUserMapper.selectByPrimaryKey((Serializable)((Object)user_id));
    }

    @Override
    public MallUserEntity getSysUser4name(String user_name) {
        return this.mallUserMapper.getSysUser4name(user_name);
    }

    @Override
    public List<MallUserMenuRsVo> getSysUserMenu(String user_id) {
        List<MallUserMenuVo> ls = this.mallUserMapper.getUserMenuList(user_id);
        ArrayList<MallUserMenuRsVo> rs = new ArrayList<MallUserMenuRsVo>();
        ls.stream().collect(Collectors.groupingBy(o -> o.getParentResourceId())).entrySet().forEach(longListEntry -> {
            MallUserMenuRsVo rsvo = new MallUserMenuRsVo();
            rsvo.setMenu_list((List)longListEntry.getValue());
            rsvo.setParentResourceId((Long)longListEntry.getKey());
            rsvo.setParentResourceName(((MallUserMenuVo)((List)longListEntry.getValue()).get(0)).getParentResourceName());
            rsvo.setParentResourceIcon(((MallUserMenuVo)((List)longListEntry.getValue()).get(0)).getParentResourceIcon());
            rsvo.setParentResourceOrder(((MallUserMenuVo)((List)longListEntry.getValue()).get(0)).getParentResourceOrder());
            rsvo.getMenu_list().sort((o1, o2) -> o1.getParentResourceOrder() - o2.getParentResourceOrder());
            rs.add(rsvo);
        });
        rs.sort((o1, o2) -> o1.getParentResourceOrder() - o2.getParentResourceOrder());
        return rs;
    }

    @Override
    public List<Integer> getSysUserRoleList(String user_id) {
        return this.mallUserMapper.getSysUserRoleList(user_id);
    }

    @Override
    public List<String> getSysUserResourceList(String user_id) {
        return this.mallUserMapper.getSysUserResourceList(user_id);
    }

    @Override
    public PageInfo getMallUserRoleList(int pageNum, int pageSize, String userId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.mallUserMapper.getMallUserRoleList(userId);
        PageInfo rs = page.toPageInfo();
        return rs;
    }

    @Override
    public void saveUserRole(MallUserRoleEntity mallUserRoleEntity) {
        this.mallUserRoleMapper.insertSelective(mallUserRoleEntity);
    }

    @Override
    public void deleteUserRole(int id) {
        this.mallUserRoleMapper.deleteByPrimaryKey(Integer.valueOf(id));
    }

    @Override
    public PageInfo getMallRoleResourceList(int pageNum, int pageSize, String roleId, int resourceType) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.mallUserMapper.getMallRoleResourceList(roleId, resourceType);
        PageInfo rs = page.toPageInfo();
        return rs;
    }

    @Override
    public void saveRoleResource(MallRoleResourceEntity mallRoleResourceEntity) {
        this.mallRoleResourceMapper.insertSelective(mallRoleResourceEntity);
    }

    @Override
    public void deleteRoleResource(long id) {
        this.mallRoleResourceMapper.deleteByPrimaryKey(Long.valueOf(id));
    }
}

