/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.vip;

import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveQrcodeInterface;
import cc.lechun.apiinvoke.bi.BIOrderDetailInvoke;
import cc.lechun.common.enums.common.StatusEnum;
import cc.lechun.common.enums.customer.VipRightTypeEnum;
import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.database.util.SpringContextUtil;
import cc.lechun.mall.dao.vip.MallVipConditionMapper;
import cc.lechun.mall.dao.vip.MallVipDiscountRangeMapper;
import cc.lechun.mall.dao.vip.MallVipLogMapper;
import cc.lechun.mall.dao.vip.MallVipMapper;
import cc.lechun.mall.dao.vip.MallVipNoticeTemplateMapper;
import cc.lechun.mall.dao.vip.MallVipQuestionnairePaperMapper;
import cc.lechun.mall.dao.vip.MallVipRewardsMapper;
import cc.lechun.mall.dao.vip.MallVipRewardsRelationMapper;
import cc.lechun.mall.dao.vip.MallVipRightsMapper;
import cc.lechun.mall.dao.vip.MallVipTasksMapper;
import cc.lechun.mall.dao.vip.MallVipTasksRelationMapper;
import cc.lechun.mall.dao.vip.MallVipTasksRewardsMapper;
import cc.lechun.mall.dao.vip.MallVipdaylogMapper;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.point.CustomerPointVo;
import cc.lechun.mall.entity.prepay.PrepayCardTypeEnum;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.vip.CustomerBuyTypeEnum;
import cc.lechun.mall.entity.vip.MallVipConditionEntity;
import cc.lechun.mall.entity.vip.MallVipDiscountRangeEntity;
import cc.lechun.mall.entity.vip.MallVipEntity;
import cc.lechun.mall.entity.vip.MallVipLogEntity;
import cc.lechun.mall.entity.vip.MallVipQuestionnairePaperEntity;
import cc.lechun.mall.entity.vip.MallVipRewardsEntity;
import cc.lechun.mall.entity.vip.MallVipRewardsRelationEntity;
import cc.lechun.mall.entity.vip.MallVipRightsEntity;
import cc.lechun.mall.entity.vip.MallVipSetVo;
import cc.lechun.mall.entity.vip.MallVipTasksEntity;
import cc.lechun.mall.entity.vip.MallVipTasksRelationEntity;
import cc.lechun.mall.entity.vip.MallVipTasksRewardsEntity;
import cc.lechun.mall.entity.vip.MallVipTimeEntity;
import cc.lechun.mall.entity.vip.MallVipVo;
import cc.lechun.mall.entity.vip.SimpleVipVo;
import cc.lechun.mall.entity.vip.SupperVipTypeEnum;
import cc.lechun.mall.entity.vip.SupperVipVo;
import cc.lechun.mall.entity.vip.VipLevelTypeEnum;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.point.CustomerPointInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.vip.MallVipConditionInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import cc.lechun.mall.iservice.vip.MallVipTimeInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import com.google.code.ssm.api.InvalidateSingleCache;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MallVipService
extends BaseService
implements MallVipInterface {
    @Autowired
    private MallVipMapper vipMapper;
    @Autowired
    private MallVipConditionMapper vipConditionMapper;
    @Resource
    MallVipDiscountRangeMapper vipDiscountRangeMapper;
    @Autowired
    MallVipTasksMapper tasksMapper;
    @Autowired
    MallVipTasksRelationMapper vipTaskRelationMapper;
    @Autowired
    MallVipTasksRewardsMapper vipTasksRewardsMapper;
    @Autowired
    MallVipRewardsMapper vipRewardsMapper;
    @Autowired
    MallVipRewardsRelationMapper vipRewardsRelationMapper;
    @Autowired
    MallVipRightsMapper vipRightsMapper;
    @Autowired
    MallVipLogMapper vipLogMapper;
    @Autowired
    MallVipQuestionnairePaperMapper vipQuestionnairePaperMapper;
    @Autowired
    MallVipNoticeTemplateMapper vipNoticeTemplateMapper;
    @Autowired
    MallVipdaylogMapper vipdaylogMapper;
    @Autowired
    private CustomerInterface customerService;
    @Lazy
    @Autowired
    private MallOrderMainInterface orderMainService;
    @Lazy
    @Autowired
    private MallOrderInterface orderService;
    @Autowired
    private MallProductPicInterface picService;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    @Lazy
    private ActiveCashticketInterface activeCashticketService;
    @Autowired
    private DictionaryInterface dicService;
    @Autowired
    private ActiveQrcodeInterface qrcodeService;
    @Autowired
    @Lazy
    private MessageInterface messageService;
    @Autowired
    private PlatFormInterface platFormService;
    @Autowired
    private MallVipInterface vipInterface;
    @Lazy
    @Autowired
    private AccountBalanceInterface accountBalanceInterface;
    @Autowired
    private BIOrderDetailInvoke biOrderDetailInvoke;
    @Autowired
    private MallVipConditionInterface vipConditionInterface;
    @Autowired
    private MallVipTimeInterface vipTimeInterface;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private CustomerPointInterface customerPointInterface;

    @Override
    public MallVipEntity selectByPrimaryKey(String id) {
        return (MallVipEntity)this.vipMapper.selectByPrimaryKey((Serializable)((Object)id));
    }

    @Override
    public MallVipEntity getSingle(MallVipEntity vip) {
        return (MallVipEntity)this.vipMapper.getSingle(vip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseJsonVo saveFreeVip(String vipNo, String customerId) throws InterruptedException {
        this.logger.info("\u4e3b\u5361\u8d60\u9001:{},\u63a5\u53d7\u7528\u6237:{}", (Object)vipNo, (Object)customerId);
        RLock lock = this.redissonClient.getLock("FreeVip:" + vipNo);
        boolean isLocked = lock.tryLock(15L, TimeUnit.SECONDS);
        if (isLocked) {
            try {
                MallVipTimeEntity vipQuery = new MallVipTimeEntity();
                vipQuery.setVipNo(vipNo);
                MallVipTimeEntity vipTimeEntity = (MallVipTimeEntity)this.vipTimeInterface.getSingle(vipQuery, 0L);
                if (vipTimeEntity == null) {
                    BaseJsonVo baseJsonVo = BaseJsonVo.error((String)"\u8d60\u9001\u526f\u5361\u5931\u8d25,\u4e3b\u5361\u4e0d\u5b58\u5728");
                    return baseJsonVo;
                }
                if (!Objects.equals(vipTimeEntity.getStatus(), StatusEnum.STATUS_OK.getValue())) {
                    BaseJsonVo baseJsonVo = BaseJsonVo.error((String)"\u8d60\u9001\u526f\u5361\u5931\u8d25,\u4e3b\u5361\u5df2\u5931\u6548");
                    return baseJsonVo;
                }
                if (vipTimeEntity.getEndTime().before(new Date())) {
                    BaseJsonVo baseJsonVo = BaseJsonVo.error((String)"\u8d60\u9001\u526f\u5361\u5931\u8d25,\u4e3b\u5361\u5df2\u8fc7\u671f");
                    return baseJsonVo;
                }
                if (Objects.equals(vipTimeEntity.getCustomerId(), customerId)) {
                    BaseJsonVo baseJsonVo = BaseJsonVo.error((String)"\u8d60\u9001\u526f\u5361\u5931\u8d25,\u4e0d\u80fd\u8d60\u9001\u7ed9\u81ea\u5df1");
                    return baseJsonVo;
                }
                SimpleVipVo simpleVipVo = this.vipInterface.getSimpleVipVo(customerId, VipLevelTypeEnum.superVip.getValue());
                if (Objects.equals(simpleVipVo.getVipLevel(), VipLevelTypeEnum.superVip.getValue()) && simpleVipVo.getStatus().intValue() == StatusEnum.STATUS_OK.getValue() && simpleVipVo.getVipLevel() == vipTimeEntity.getVipType()) {
                    if (!Objects.equals(simpleVipVo.getVipNo(), vipNo)) {
                        BaseJsonVo baseJsonVo = BaseJsonVo.error((String)"\u8d60\u9001\u526f\u5361\u5931\u8d25,\u5df2\u6709\u8d85\u7ea7\u4f1a\u5458");
                        return baseJsonVo;
                    }
                    BaseJsonVo baseJsonVo = BaseJsonVo.success((Object)"\u8d60\u9001\u526f\u5361\u6210\u529f");
                    return baseJsonVo;
                }
                vipQuery = new MallVipTimeEntity();
                vipQuery.setParentId(vipTimeEntity.getId());
                vipQuery.setStatus(1);
                MallVipTimeEntity result = (MallVipTimeEntity)this.vipTimeInterface.getSingle(vipQuery, 0L);
                if (result != null && !Objects.equals(result.getCustomerId(), customerId)) {
                    BaseJsonVo baseJsonVo = BaseJsonVo.error((String)"\u8d60\u9001\u526f\u5361\u5931\u8d25,\u4e3b\u5361\u5df2\u8d60\u9001\u7ed9\u5176\u4ed6\u4eba");
                    return baseJsonVo;
                }
                MallVipTimeEntity newVip = new MallVipTimeEntity();
                BeanUtils.copyProperties((Object)vipTimeEntity, (Object)newVip);
                newVip.setParentId(vipTimeEntity.getId());
                newVip.setBeginTime(new Date());
                newVip.setSourceOrderMainNo(null);
                newVip.setCustomerId(customerId);
                newVip.setRemark("\u526f\u5361\u8d60\u9001");
                newVip.setFreeStatus(1);
                newVip.setCreateTime(new Date());
                newVip.setId(null);
                this.vipTimeInterface.insertSelective(newVip);
                this.logger.info("\u4f1a\u5458:{} \u8d60\u9001\u7ed9\u7528\u6237:{}\u6210\u529f", (Object)vipNo, (Object)customerId);
                BaseJsonVo baseJsonVo = BaseJsonVo.success((Object)"\u9886\u53d6\u6210\u529f");
                return baseJsonVo;
            }
            finally {
                lock.unlock();
            }
        }
        return BaseJsonVo.error((String)"\u8d60\u9001\u5931\u8d25,\u8bf7\u7a0d\u5019\u91cd\u8bd5");
    }

    @Override
    @ReadThroughSingleCache(namespace="VIP")
    public List<MallVipConditionEntity> conditionList(@ParameterValueKeyProvider(order=0) Integer platformGroupId, @ParameterValueKeyProvider(order=1) Integer levelType) {
        MallVipConditionEntity searchParam = new MallVipConditionEntity();
        searchParam.setPlatformGroupId(platformGroupId);
        searchParam.setLevelType(levelType);
        List lst = this.vipConditionMapper.getList(searchParam);
        lst.sort(Comparator.comparing(MallVipConditionEntity::getLevelType).thenComparing(MallVipConditionEntity::getLevel));
        return lst;
    }

    @Override
    @ReadThroughSingleCache(namespace="MallVipService.getVipCondition")
    public MallVipConditionEntity getVipCondition(@ParameterValueKeyProvider Integer level) {
        MallVipConditionEntity searchParam = new MallVipConditionEntity();
        searchParam.setLevel(level);
        return (MallVipConditionEntity)this.vipConditionMapper.getSingle(searchParam);
    }

    @Override
    @ReadThroughSingleCache(namespace="MallVipService.checkDiscountRange", expiration=600)
    public boolean checkDiscountRange(@ParameterValueKeyProvider(order=0) int orderSource, @ParameterValueKeyProvider(order=1) int level) {
        MallVipDiscountRangeEntity query = new MallVipDiscountRangeEntity();
        query.setLevel(level);
        MallVipDiscountRangeEntity vipDiscountRangeEntity = (MallVipDiscountRangeEntity)this.vipDiscountRangeMapper.getSingle(query);
        if (vipDiscountRangeEntity != null) {
            List<String> orderSourceList = Arrays.asList(vipDiscountRangeEntity.getOrderSource().split(","));
            String orderSourceStr = String.valueOf(orderSource);
            if (orderSourceList.stream().anyMatch(o -> Objects.equals(o, orderSourceStr))) {
                this.logger.info("\u4f1a\u5458\u7b49\u7ea7:{},\u8ba2\u5355\u6765\u6e90:{}\u5b58\u5728\u6298\u6263", (Object)level, (Object)orderSource);
                return true;
            }
        }
        this.logger.info("\u4f1a\u5458\u7b49\u7ea7:{},\u8ba2\u5355\u6765\u6e90:{}\u4e0d\u5b58\u5728\u6298\u6263", (Object)level, (Object)orderSource);
        return false;
    }

    @Override
    public List<MallVipRewardsEntity> rewardsList(Integer platformGroupId) {
        MallVipRewardsEntity param = new MallVipRewardsEntity();
        param.setPlatformGroupId(platformGroupId);
        List list = this.vipRewardsMapper.getList(param);
        return list;
    }

    @Override
    public PageInfo rewardsList(Integer platformGroupId, int currentPage, int pageSize) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        PageInfo pg = page.toPageInfo();
        List<MallVipRewardsEntity> list = this.rewardsList(platformGroupId);
        ArrayList listData = new ArrayList();
        list.forEach(reward -> {
            ActiveQrcodeEntity qrcode;
            Map map = ObjectConvert.beanToMap((Object)reward);
            map.put("rewardDataName", reward.getRewardData());
            if ("1".equals(reward.getRewardType()) && (qrcode = this.qrcodeService.getQrcode(reward.getRewardData())) != null) {
                map.put("rewardDataName", qrcode.getQrcodeName());
            }
            listData.add(map);
        });
        pg.setList(listData);
        return pg;
    }

    @Override
    public List<MallVipRightsEntity> rightsList(Integer platformGroupId) {
        List<MallVipRightsEntity> rights = this.vipRightsMapper.getVipRights(platformGroupId);
        return rights;
    }

    @Override
    public MallVipRightsEntity getRight(String rightId) {
        return this.vipRightsMapper.getRight(rightId);
    }

    @Override
    public List<MallVipTasksEntity> tasksList(Integer platformGroupId) {
        MallVipTasksEntity param = new MallVipTasksEntity();
        param.setPlatformGroupId(platformGroupId);
        List list = this.tasksMapper.getList(param);
        return list;
    }

    @Override
    public List<MallVipTasksRewardsEntity> tasksRewardsList(Integer platformGroupId) {
        MallVipTasksRewardsEntity param = new MallVipTasksRewardsEntity();
        param.setPlatformGroupId(platformGroupId);
        List list = this.vipTasksRewardsMapper.getList(param);
        return list;
    }

    @Override
    public BaseJsonVo customerLevelUp(String customerId, String orderMainNo) {
        Integer targetLevel;
        Integer sourceLevel;
        Integer platformGroupId;
        MallVipSetVo checkResult;
        BaseJsonVo<MallVipSetVo> sr = this.checkCustomerCanLevelUp(customerId, orderMainNo);
        this.logger.info("\u89e6\u53d1\u7528\u6237\u5347\u7ea72\uff0c\u7528\u6237ID\uff1a{},\u4e3b\u8ba2\u5355\u53f7\uff1a{}\uff0c\u662f\u5426\u53ef\u5347\u7ea7\uff1a{}", new Object[]{customerId, orderMainNo, JsonUtils.toJson(sr, (boolean)false)});
        if (sr.isSuccess()) {
            checkResult = (MallVipSetVo)sr.getValue();
            orderMainNo = checkResult.getOrderMainNo();
            platformGroupId = 1000;
            MallVipEntity vipInfo = this.vipInterface.getUserVipInfo(customerId);
            sourceLevel = vipInfo.getLevel();
            MallVipConditionEntity condition = this.vipConditionMapper.getTargetLevel(checkResult.getOrderCount());
            if (condition == null) {
                this.logger.error("\u7528\u6237:{},\u8ba2\u5355:{} \u67e5\u8be2\u76ee\u6807\u7b49\u7ea7\u51fa\u9519", (Object)customerId, (Object)checkResult.getOrderCount());
                return BaseJsonVo.error((String)"");
            }
            targetLevel = condition.getLevel();
            MallVipEntity vipquery = new MallVipEntity();
            vipquery.setCustomerId(customerId);
            MallVipEntity vipEntity = (MallVipEntity)this.vipMapper.getSingle(vipquery);
            boolean invalid = vipEntity != null && vipEntity.getEndTime() != null && vipEntity.getEndTime().before(new Date());
            this.logger.info("\u89e6\u53d1\u7528\u6237\u5347\u7ea74\uff0c\u7528\u6237ID\uff1a{},\u4e3b\u8ba2\u5355\u53f7\uff1a{}\uff0c\u5f53\u524d\u7b49\u7ea7\uff1a{}\uff0c\u5347\u7ea7\u7b49\u7ea7\uff1a{}", new Object[]{customerId, orderMainNo, sourceLevel, targetLevel});
            if (targetLevel > sourceLevel || invalid) {
                int i = 0;
                if (vipEntity == null) {
                    vipInfo.setId(String.valueOf(IDGenerate.getUniqueID()));
                    vipInfo.setLevel(targetLevel);
                    vipInfo.setIsReward(0);
                    vipInfo.setCreateTime(DateUtils.now());
                    vipInfo.setBeginTime(null);
                    vipInfo.setEndTime(null);
                    i = this.vipMapper.insert(vipInfo);
                } else {
                    vipInfo.setLevel(targetLevel);
                    vipInfo.setBeginTime(null);
                    vipInfo.setEndTime(null);
                    i = this.vipMapper.updateByPrimaryKey(vipInfo);
                }
                this.logger.info("\u89e6\u53d1\u7528\u6237\u5347\u7ea75\uff0c\u7528\u6237ID\uff1a{},\u4e3b\u8ba2\u5355\u53f7\uff1a{}\uff0c\u66f4\u65b0\u6570\u636e\u5e93\u7ed3\u679c\uff1a{}", new Object[]{customerId, orderMainNo, i});
                this.customerVipTaskRelation(customerId);
                this.customerVipRewardRelation(customerId);
                this.vipInterface.deleteUserVipInfoCache(customerId);
                Calendar rightNow = Calendar.getInstance();
                int hour = rightNow.get(11);
                if (hour < 22 && hour > 7) {
                    this.logger.info("\u89e6\u53d1\u7528\u6237\u5347\u7ea76\uff0c\u7528\u6237ID\uff1a{},\u4e3b\u8ba2\u5355\u53f7\uff1a{}\uff0c\u53d1\u9001\u901a\u77e5", (Object)customerId, (Object)orderMainNo);
                    this.sendTemplateVipLevelUpNoticeMessage(customerId);
                }
            }
        } else {
            return sr;
        }
        MallVipLogEntity log = new MallVipLogEntity();
        log.setId(String.valueOf(IDGenerate.getUniqueID()));
        log.setCustomerId(customerId);
        log.setPlatformGroupId(platformGroupId);
        log.setFromLevel(sourceLevel);
        log.setToLevel(targetLevel);
        log.setOrderMainNo(orderMainNo);
        log.setOrderNo(checkResult.getOrderNo());
        log.setOrderNum(checkResult.getOrderCount());
        log.setRemark("\u8ba2\u5355\u5347\u7ea7");
        log.setType("1");
        log.setLevelup(sourceLevel >= targetLevel ? (short)0 : 1);
        log.setCreateTime(DateUtils.now());
        int i = this.vipLogMapper.insert(log);
        this.logger.info("\u89e6\u53d1\u7528\u6237\u5347\u7ea77\uff0c\u7528\u6237ID\uff1a{},\u4e3b\u8ba2\u5355\u53f7\uff1a{}\uff0c\u4fdd\u5b58\u5347\u7ea7\u8bb0\u5f55\uff1a{},\u4fdd\u5b58\u7ed3\u679c\uff1a{}", new Object[]{customerId, orderMainNo, JsonUtils.toJson((Object)log, (boolean)false), i});
        return BaseJsonVo.success(null);
    }

    public BaseJsonVo<MallVipSetVo> checkCustomerCanLevelUp(String customerId, String orderMainNo) {
        List<MallOrderEntity> orderList;
        MallOrderMainEntity mainOrder;
        if (StringUtils.isEmpty((String)customerId)) {
            return BaseJsonVo.error((String)"\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CustomerEntity customerEntity = this.customerService.getCustomer(customerId);
        if (customerEntity == null) {
            return BaseJsonVo.error((String)"\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5347\u7ea7\u4f1a\u5458");
        }
        MallVipEntity entity = this.getUserVipInfo(customerId);
        MallVipConditionEntity vipConditionEntity = this.getVipCondition(entity.getLevel());
        if (vipConditionEntity != null && Objects.equals(vipConditionEntity.getLevelType(), VipLevelTypeEnum.pay.getValue()) && entity.getBeginTime() != null && entity.getEndTime() != null) {
            boolean canUpgrade;
            boolean bl = canUpgrade = entity.getBeginTime().after(new Date()) || entity.getEndTime().before(new Date());
            if (!canUpgrade) {
                this.logger.info("\u7528\u6237\uff1a{}\u4ed8\u8d39\u4f1a\u5458\u5728\u6548\u671f\u5185\u4e0d\u80fd\u5347\u7ea7", (Object)customerId);
            }
        }
        if (StringUtils.isEmpty((String)orderMainNo)) {
            mainOrder = this.orderMainService.getLastOrder(customerId);
            if (mainOrder != null) {
                orderMainNo = mainOrder.getOrderMainNo();
            } else {
                this.logger.error("\u7ed1\u5b9a\u4f1a\u5458\u7b49\u7ea7\u5931\u8d25,\u67e5\u4e0d\u5230\u7528\u6237:{}\u8ba2\u5355", (Object)customerId);
            }
        } else {
            mainOrder = this.orderMainService.selectByPrimaryKey(orderMainNo);
            if (mainOrder == null && (mainOrder = this.orderMainService.getLastOrder(customerId)) != null) {
                orderMainNo = mainOrder.getOrderMainNo();
            }
        }
        Integer orderCount = this.orderService.getUserOrderCount(customerId);
        MallVipSetVo setVo = new MallVipSetVo();
        setVo.setCanLevelUp(0);
        setVo.setCustomerId(customerId);
        setVo.setOrderMainNo(orderMainNo);
        setVo.setOrderNo("");
        setVo.setOrderCount(orderCount == null ? 0 : orderCount);
        this.logger.info("setVo\uff08\u67e5\u5b50\u5355\u524d\uff09" + JsonUtils.toJson((Object)setVo, (boolean)false));
        if (StringUtils.isNotEmpty((String)orderMainNo) && CollectionUtils.isNotEmpty(orderList = this.orderService.findOrders(orderMainNo)) && (orderList = orderList.stream().filter(c -> c.getStatus() >= 16 && c.getStatus() < 20).collect(Collectors.toList())) != null && orderList.size() > 0) {
            orderList = orderList.stream().sorted(Comparator.comparing(MallOrderEntity::getCompleteTime, Comparator.nullsFirst(Date::compareTo)).reversed()).collect(Collectors.toList());
            setVo.setCanLevelUp(1);
            setVo.setOrderNo(orderList.get(0).getOrderNo());
            setVo.setCreateTime(mainOrder.getCreateTime());
            setVo.setCompleteTime(orderList.get(0).getCompleteTime());
        }
        this.logger.info("setVo\uff08\u67e5\u5b50\u5355\u540e\uff09" + JsonUtils.toJson((Object)setVo, (boolean)false));
        BaseJsonVo jsonVo = this.biOrderDetailInvoke.getCustomerOrderCountForVipLevel(customerId);
        this.logger.info("jsonVo\uff08\u67e5BI\u540e\uff09" + JsonUtils.toJson((Object)jsonVo, (boolean)false));
        if (jsonVo.isSuccess()) {
            MallVipSetVo vipSetVo = (MallVipSetVo)ObjectConvert.mapConvertToBean((Map)((Map)jsonVo.getValue()), MallVipSetVo.class);
            this.logger.info("vipSetVo\uff08\u67e5BI\u540e\uff09" + JsonUtils.toJson((Object)vipSetVo, (boolean)false));
            if (Integer.valueOf(1).equals(vipSetVo.getCanLevelUp())) {
                setVo.setOrderCount(setVo.getOrderCount() + vipSetVo.getOrderCount());
                setVo.setCanLevelUp(vipSetVo.getCanLevelUp());
                if (vipSetVo.getCompleteTime() != null && vipSetVo.getCompleteTime().after(setVo.getCompleteTime() == null ? DateUtils.StrToDate((String)"1900-01-01") : setVo.getCompleteTime())) {
                    setVo.setOrderMainNo(vipSetVo.getOrderMainNo());
                    setVo.setOrderNo(vipSetVo.getOrderNo());
                    setVo.setCreateTime(vipSetVo.getCreateTime());
                    setVo.setCompleteTime(vipSetVo.getCompleteTime());
                }
            }
        }
        this.logger.info("setVo\uff08\u67e5BI\u540e\uff09" + JsonUtils.toJson((Object)setVo, (boolean)false));
        if (!Integer.valueOf(1).equals(setVo.getCanLevelUp())) {
            this.logger.error("\u7ed1\u5b9a\u4f1a\u5458\u7b49\u7ea7\u5931\u8d25,\u7528\u6237:{}\u67e5\u8be2\u4e0d\u5230\u5b50\u8ba2\u5355", (Object)customerId);
            return BaseJsonVo.error((String)"\u67e5\u8be2\u4e0d\u5230\u5b50\u8ba2\u5355");
        }
        return BaseJsonVo.success((Object)setVo);
    }

    @Override
    @ReadThroughSingleCache(namespace="MallVipService.getUserVipInfo", expiration=300)
    public MallVipEntity getUserVipInfo(@ParameterValueKeyProvider String customerId) {
        MallVipEntity searchParam = new MallVipEntity();
        if (customerId.isEmpty()) {
            searchParam.setPlatformGroupId(0);
            searchParam.setLevel(0);
            return searchParam;
        }
        return this.vipInterface.getUserVipInfoByCustomerId(customerId);
    }

    @Override
    @ReadThroughSingleCache(namespace="MallVipService.getUserVipInfoByCustomerId", expiration=300)
    public MallVipEntity getUserVipInfoByCustomerId(@ParameterValueKeyProvider String customerId) {
        MallVipEntity searchParam = new MallVipEntity();
        searchParam.setCustomerId(customerId);
        MallVipEntity entity = (MallVipEntity)this.vipMapper.getSingle(searchParam);
        if (entity == null || entity.getLevel() == null) {
            CustomerEntity customerEntity = this.customerService.getCustomer(customerId);
            searchParam.setPlatformGroupId(customerEntity == null ? 1000 : customerEntity.getPlatformGroupId());
            searchParam.setLevel(0);
            return searchParam;
        }
        return entity;
    }

    @Override
    public MallVipVo getUserVipVO(String customerId) {
        MallVipEntity vipEntity = this.vipInterface.getUserVipInfo(customerId);
        MallVipVo vipVo = new MallVipVo();
        try {
            ObjectConvert.fatherConvertToChild((Object)vipEntity, (Object)vipVo);
        }
        catch (Exception e) {
            this.logger.error("\u6784\u5efa\u7528\u6237\uff1a{}\u4f1a\u5458\u4fe1\u606f\u51fa\u9519", (Object)customerId, (Object)e);
        }
        vipVo.setVip(vipVo.getLevel() != 0);
        MallVipConditionEntity vipConditionEntity = this.getVipCondition(vipEntity.getLevel());
        if (vipConditionEntity != null) {
            MallVipEntity vipQuery;
            List list;
            vipVo.setVipName(vipConditionEntity.getLevelName());
            vipVo.setCanFree(false);
            if (Objects.equals(vipConditionEntity.getFree(), 1) && (list = this.vipMapper.getList(vipQuery = new MallVipEntity())).size() < vipConditionEntity.getFreeQuantity()) {
                vipVo.setCanFree(true);
            }
        }
        return vipVo;
    }

    @Override
    @ReadThroughSingleCache(namespace="MallVipService.getSimpleVipVo", expiration=300)
    public SimpleVipVo getSimpleVipVo(@ParameterValueKeyProvider(order=0) String customerId, @ParameterValueKeyProvider(order=1) Integer vipLevelType) {
        SimpleVipVo simpleVo = new SimpleVipVo();
        MallVipEntity mallVipVo = this.vipInterface.getUserVipInfo(customerId);
        simpleVo.setVipLevel(mallVipVo.getLevel());
        simpleVo.setVip(mallVipVo.getLevel() != 0);
        simpleVo.setVipType(VipLevelTypeEnum.order.getValue());
        simpleVo.setVipTypeName(VipLevelTypeEnum.order.getName());
        simpleVo.setStatus(1);
        simpleVo.setCustomerId(customerId);
        simpleVo.setStatusName(StatusEnum.STATUS_OK.getName());
        simpleVo.setCanShare(false);
        simpleVo.setReson("\u666e\u901a\u4f1a\u5458\u514d\u8d39\u83b7\u5f97");
        if (vipLevelType != null) {
            MallVipTimeEntity query = new MallVipTimeEntity();
            query.setCustomerId(customerId);
            query.setStatus(1);
            query.setVipType(vipLevelType);
            List vipTimeList = this.vipTimeInterface.getList(query, 0L);
            if (CollectionUtils.isEmpty((Collection)vipTimeList)) {
                return simpleVo;
            }
            vipTimeList = vipTimeList.stream().sorted((o1, o2) -> o1.getCreateTime().compareTo(o2.getCreateTime())).collect(Collectors.toList());
            simpleVo.setStartTime(((MallVipTimeEntity)vipTimeList.get(0)).getBeginTime());
            simpleVo.setEndTime(((MallVipTimeEntity)vipTimeList.get(vipTimeList.size() - 1)).getEndTime());
            simpleVo.setVipType(vipLevelType);
            simpleVo.setVipLevel(((MallVipTimeEntity)vipTimeList.get(0)).getLevel());
            simpleVo.setVipNo(((MallVipTimeEntity)vipTimeList.get(0)).getVipNo());
            simpleVo.setVipTypeName(VipLevelTypeEnum.getName(vipLevelType));
            if (simpleVo.getEndTime().before(new Date())) {
                simpleVo.setStatus(StatusEnum.STATUS_FAIL.getValue());
                simpleVo.setStatusName(StatusEnum.STATUS_FAIL.getName());
            }
            simpleVo.setSuperVipType(vipTimeList.stream().allMatch(vipTime -> StringUtils.isNotEmpty((String)vipTime.getSourceOrderMainNo()) && vipTime.getEndTime().compareTo(new Date()) >= 0) ? SupperVipTypeEnum.main.getValue() : SupperVipTypeEnum.auxiliary.getValue());
            simpleVo.setSuperVipTypeName(SupperVipTypeEnum.getName(simpleVo.getSuperVipType()));
            simpleVo.setParentId(((MallVipTimeEntity)vipTimeList.get(0)).getParentId());
            MallVipConditionEntity vipConditionEntity = this.getVipCondition(simpleVo.getVipLevel());
            simpleVo.setVipName(vipConditionEntity.getLevelName());
            if (!simpleVo.getVip()) {
                simpleVo.setVip(simpleVo.getStatus().intValue() == StatusEnum.STATUS_OK.getValue());
            }
            if (simpleVo.getParentId() != null) {
                MallVipTimeEntity parentVipTimeQuery = new MallVipTimeEntity();
                parentVipTimeQuery.setId(simpleVo.getParentId());
                MallVipTimeEntity parentVipTime = (MallVipTimeEntity)this.vipTimeInterface.getSingle(parentVipTimeQuery, 0L);
                if (parentVipTime != null && parentVipTime.getStatus().intValue() == StatusEnum.STATUS_FAIL.getValue()) {
                    simpleVo.setStatus(StatusEnum.STATUS_FAIL.getValue());
                    simpleVo.setStatusName(StatusEnum.STATUS_FAIL.getName());
                }
            }
            simpleVo.setCanShare(simpleVo.getStatus().intValue() == StatusEnum.STATUS_OK.getValue() && simpleVo.getSuperVipType().intValue() == SupperVipTypeEnum.main.getValue());
            if (!simpleVo.isCanShare()) {
                if (simpleVo.getSuperVipType().intValue() == SupperVipTypeEnum.auxiliary.getValue()) {
                    simpleVo.setReson("\u526f\u5361\u4e0d\u80fd\u5206\u4eab");
                } else if (simpleVo.getStatus().intValue() == StatusEnum.STATUS_FAIL.getValue()) {
                    simpleVo.setReson("\u4f1a\u5458\u5df2\u5931\u6548");
                }
            }
            if (simpleVo.isCanShare()) {
                MallVipTimeEntity tempQuery = new MallVipTimeEntity();
                tempQuery.setParentId(((MallVipTimeEntity)vipTimeList.get(vipTimeList.size() - 1)).getId());
                tempQuery.setStatus(StatusEnum.STATUS_OK.getValue());
                List vipTimeList2 = this.vipTimeInterface.getList(tempQuery, 0L);
                if (CollectionUtils.isNotEmpty((Collection)vipTimeList2)) {
                    simpleVo.setCanShare(false);
                    simpleVo.setReson("\u526f\u5361\u5df2\u5206\u4eab");
                }
            }
        }
        this.logger.info("\u7528\u6237:{},\u4f1a\u5458\u4fe1\u606f:{}", (Object)customerId, (Object)JSON.toJSONString((Object)simpleVo));
        return simpleVo;
    }

    @Override
    public Integer getBuyType(String customerId, Integer vipLevelType) {
        SimpleVipVo mallVipVo = this.vipInterface.getSimpleVipVo(customerId, vipLevelType);
        int vipBuyType = CustomerBuyTypeEnum.common_user.getValue();
        if (Objects.equals(mallVipVo.getVipType(), VipLevelTypeEnum.superVip.getValue())) {
            vipBuyType = CustomerBuyTypeEnum.renewal_user.getValue();
        } else {
            String cardType = PrepayCardTypeEnum.milk_card.getValue() + "," + PrepayCardTypeEnum.new_card_Cold.getValue() + "," + PrepayCardTypeEnum.new_card_Nomal.getValue();
            List<Map<String, Object>> list = this.accountBalanceInterface.getSpecialTotal(customerId, cardType);
            BigDecimal cardBalance = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty(list)) {
                for (Map<String, Object> map : list) {
                    cardBalance = PriceUtils.add((BigDecimal)new BigDecimal(map.get("usableAccount").toString()), (BigDecimal)cardBalance);
                }
            }
            if (cardBalance.compareTo(BigDecimal.ZERO) > 0) {
                vipBuyType = CustomerBuyTypeEnum.card_user.getValue();
            }
        }
        return vipBuyType;
    }

    @Override
    @InvalidateSingleCache(namespace="VIP")
    public void deleteUserVipInfoCache(@ParameterValueKeyProvider String customerId) {
    }

    @Override
    @Transactional
    public void customerVipTaskRelation(String customerId) {
        MallVipEntity vip = this.vipInterface.getUserVipInfo(customerId);
        List<MallVipTasksEntity> tasks = this.tasksMapper.findUngetTasksByCustomerId(customerId, vip.getLevel());
        ArrayList list = new ArrayList();
        tasks.forEach(task -> {
            MallVipTasksRelationEntity entity = new MallVipTasksRelationEntity();
            entity.setId(IDGenerate.getUniqueIdStr());
            entity.setCustomerId(customerId);
            entity.setTaskId(task.getId());
            entity.setTaskType(task.getTaskType());
            entity.setTaskName(task.getTaskName());
            entity.setPlatformGroupId(this.customerService.getCustomer(customerId).getPlatformGroupId());
            entity.setIsFinished("0");
            entity.setRecommendTimes(0);
            entity.setCreateTime(DateUtils.now());
            list.add(entity);
        });
        if (list.size() > 0) {
            this.vipTaskRelationMapper.batchInsert(list);
        }
    }

    @Override
    @Transactional
    public void customerVipRewardRelation(String customerId) {
        CustomerEntity customer = this.customerService.getCustomer(customerId);
        MallVipEntity vip = this.vipInterface.getUserVipInfo(customerId);
        Integer curLevel = vip.getLevel();
        List<MallVipConditionEntity> conditions = this.conditionList(customer.getPlatformGroupId(), VipLevelTypeEnum.order.getValue());
        conditions.forEach(condition -> {
            List<MallVipRewardsRelationEntity> checkRewardsRelations;
            if (curLevel >= condition.getLevel() && ((checkRewardsRelations = this.vipRewardsRelationMapper.findThisLevelRewardsRelation(customerId, condition.getLevel())) == null || checkRewardsRelations.size() == 0)) {
                List<MallVipRewardsEntity> rewards = this.vipRewardsMapper.findRewardsByLevel(condition.getLevel());
                List<MallVipRewardsRelationEntity> rewardsRelations = this.vipRewardsRelationMapper.findCustomerRewardsRelation(customerId);
                ArrayList sqls = new ArrayList();
                rewards.forEach(reward -> {
                    if (!rewardsRelations.stream().anyMatch(rewardRelation -> rewardRelation.getRewardId().equals(reward.getId()))) {
                        MallVipRewardsRelationEntity entity = new MallVipRewardsRelationEntity();
                        entity.setId(IDGenerate.getUniqueIdStr());
                        entity.setCustomerId(customerId);
                        entity.setRewardId(reward.getId());
                        entity.setRewardName(reward.getRewardName());
                        entity.setRewardType(reward.getRewardType());
                        entity.setPlatformGroupId(this.customerService.getCustomer(customerId).getPlatformGroupId());
                        entity.setHasReceived("0");
                        entity.setCreateTime(DateUtils.now());
                        this.vipRewardsRelationMapper.insert(entity);
                    }
                });
            }
        });
    }

    @Override
    public BaseJsonVo customerVipReward(String customerId, String relationId, Integer platformId) {
        BaseJsonVo vo;
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        if (StringUtils.isEmpty((String)customerId) || StringUtils.isEmpty((String)relationId)) {
            result.setError("\u7f3a\u5c11\u53c2\u6570");
            return result;
        }
        MallVipRewardsRelationEntity rewardsRelation = (MallVipRewardsRelationEntity)this.vipRewardsRelationMapper.selectByPrimaryKey((Serializable)((Object)relationId));
        if (rewardsRelation == null) {
            result.setError("\u7528\u6237\u6ca1\u6709\u8be5\u5956\u52b1");
            return result;
        }
        if ("1".equals(rewardsRelation.getHasReceived())) {
            result.setError("\u5df2\u9886\u53d6\u8be5\u5956\u52b1");
            return result;
        }
        MallVipRewardsEntity rewards = (MallVipRewardsEntity)this.vipRewardsMapper.selectByPrimaryKey((Serializable)((Object)rewardsRelation.getRewardId()));
        if (rewards == null) {
            result.setError("\u7cfb\u7edf\u65e0\u8be5\u5956\u52b1");
            return result;
        }
        Boolean hasReceived = false;
        if ("1".equals(rewards.getRewardType())) {
            this.activeCashticketService.sendTicket4BaseAsynchronous(customerId, rewards.getRewardData(), "", platformId, true);
            hasReceived = true;
        } else if ("2".equals(rewards.getRewardType()) && (vo = this.accountBalanceInterface.activeCharge(customerId, new BigDecimal(rewards.getRewardData()).divide(new BigDecimal(100)), "\u4f1a\u5458\u5347\u7ea7\u5956\u52b1", true, "\u4f1a\u5458\u5347\u7ea7\u5956\u52b1\u8d60\u9001", rewards.getId())).isSuccess()) {
            hasReceived = true;
        }
        if (!hasReceived.booleanValue()) {
            result.setError("\u53d1\u9001\u5956\u52b1\u5931\u8d25");
            return result;
        }
        rewardsRelation.setHasReceived("1");
        this.vipRewardsRelationMapper.updateByPrimaryKeySelective(rewardsRelation);
        this.vipInterface.deleteUserVipInfoCache(customerId);
        return result;
    }

    @Override
    @ReadThroughSingleCache(namespace="VIP_CENTER_INFO", expiration=300)
    public Map<String, Object> centerInfo(@ParameterValueKeyProvider String customerId) {
        CustomerEntity customer = this.customerService.getCustomer(customerId);
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        List<MallVipConditionEntity> conditionList = this.conditionList(customer.getPlatformGroupId(), VipLevelTypeEnum.order.getValue());
        ArrayList conditions = new ArrayList();
        for (MallVipConditionEntity condition : conditionList) {
            HashMap<String, Object> _condition = new HashMap<String, Object>();
            _condition.put("ID", condition.getId());
            _condition.put("LEVEL", condition.getLevel());
            _condition.put("ORDER_NUM", condition.getOrderNum());
            _condition.put("LEVEL_TYPE", condition.getLevelType());
            _condition.put("LEVEL_NAME", condition.getLevelName());
            _condition.put("LEVEL_IMG_URL", this.picService.getProductPicUrl(condition.getId() == null ? "" : condition.getId(), ProductPicTypeEnum.VIP_CONDITION_POP.getValue()).get(0));
            conditions.add(_condition);
        }
        rtnMap.put("CONDITIONS", conditions);
        Integer orderCount = this.orderService.getUserOrderCount(customerId);
        MallVipEntity vipEntity = this.vipInterface.getUserVipInfo(customerId);
        MallVipConditionEntity vipConditionEntity = this.vipConditionInterface.getVipConditionByLevel(vipEntity.getLevel());
        Integer curLevel = vipEntity != null ? vipEntity.getLevel() : 0;
        rtnMap.put("ORDER_COUNT", orderCount);
        rtnMap.put("CURRENT_LEVEL", curLevel);
        rtnMap.put("CURRENT_LEVEL_NAME", curLevel == 0 ? "" : vipConditionEntity.getLevelName());
        rtnMap.put("CURRENT_LEVEL_TYPE", curLevel == 0 ? "" : vipConditionEntity.getLevelType());
        rtnMap.put("CURRENT_LEVEL_BEGIN_TIME", curLevel == 0 ? null : vipEntity.getBeginTime());
        rtnMap.put("CURRENT_LEVEL_END_TIME", curLevel == 0 ? null : vipEntity.getEndTime());
        List<Object> levelSet = this.getVipRight(customerId, conditionList, orderCount, curLevel, VipLevelTypeEnum.order.getValue());
        rtnMap.put("LEVELS_DATA", levelSet);
        return rtnMap;
    }

    @NotNull
    private List<Object> getVipRight(String customerId, List<MallVipConditionEntity> conditionList, Integer orderCount, Integer curLevel, Integer vipType) {
        List<Map<String, Object>> userRewards = this.vipRewardsRelationMapper.findUserRewards(customerId);
        List<Map<String, Object>> vipRewards = this.vipRewardsMapper.findVipHasnotRewards(curLevel);
        userRewards.addAll(vipRewards);
        List<Map<String, Object>> vipRightsHas = this.vipRightsMapper.findVipHasRights(curLevel);
        List<Map<String, Object>> vipRightsHasNot = this.vipRightsMapper.findVipHasNotRights(curLevel);
        vipRightsHasNot.addAll(vipRightsHas);
        ArrayList<Object> levelSet = new ArrayList<Object>();
        for (MallVipConditionEntity condition : conditionList) {
            if (Objects.equals(vipType, VipLevelTypeEnum.superVip.getValue()) && condition.getLevel() < curLevel) continue;
            HashMap<String, Object> levelRtnRecord = new HashMap<String, Object>();
            levelRtnRecord.put("ORDER_COUNT_DIFF", condition.getOrderNum() - orderCount < 0 ? 0 : condition.getOrderNum() - orderCount);
            levelRtnRecord.put("LEVEL", condition.getLevel());
            if (condition.getLevel() <= curLevel) {
                Map<String, Object> thisLevelTime = this.vipLogMapper.findCustomerLevelUpTime(customerId, condition.getLevel());
                if (thisLevelTime != null && thisLevelTime.size() > 0) {
                    levelRtnRecord.put("THIS_LEVEL_TIME", thisLevelTime.get("CREATE_TIME"));
                } else {
                    levelRtnRecord.put("THIS_LEVEL_TIME", "");
                }
                levelRtnRecord.put("LIGHT", "ON");
            } else {
                levelRtnRecord.put("THIS_LEVEL_TIME", "");
                levelRtnRecord.put("LIGHT", "OFF");
            }
            ArrayList<Map<String, Object>> rewardsRecordSet = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> reward : userRewards) {
                if (((Integer)reward.get("LEVEL")).intValue() != condition.getLevel().intValue()) continue;
                if ("ON".equals(reward.get("LIGHT"))) {
                    reward.put("REWARD_ICON_URL", this.picService.getProductPicUrl(reward.get("REWARD_ID").toString(), ProductPicTypeEnum.VIP_REWARD_ICON.getValue()).get(0));
                } else {
                    reward.put("REWARD_ICON_URL", this.picService.getProductPicUrl(reward.get("REWARD_ID").toString(), ProductPicTypeEnum.VIP_REWARD_ICON_DARK.getValue()).get(0));
                }
                reward.put("REWARD_IMG_URL", this.picService.getProductPicUrl(reward.get("REWARD_ID").toString(), ProductPicTypeEnum.VIP_REWARD_POP.getValue()).get(0));
                rewardsRecordSet.add(reward);
            }
            levelRtnRecord.put("REWARDS", rewardsRecordSet);
            ArrayList<Map<String, Object>> rightsRecordSet = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> right : vipRightsHasNot) {
                if (((Integer)right.get("LEVEL")).intValue() != condition.getLevel().intValue()) continue;
                if ("ON".equals(right.get("LIGHT"))) {
                    right.put("RIGHT_ICON_URL", this.picService.getProductPicUrl(right.get("ID").toString(), ProductPicTypeEnum.VIP_RIGHT_ICON.getValue()).get(0));
                } else {
                    right.put("RIGHT_ICON_URL", this.picService.getProductPicUrl(right.get("ID").toString(), ProductPicTypeEnum.VIP_RIGHT_ICON_DARK.getValue()).get(0));
                }
                right.put("RIGHT_IMG_URL", this.picService.getProductPicUrl(right.get("ID").toString(), ProductPicTypeEnum.VIP_RIGHT_POP.getValue()).get(0));
                if (right.get("RIGHT_IMG_URL") != null && StringUtils.isNotEmpty((String)String.valueOf(right.get("RIGHT_IMG_URL")))) {
                    right.put("SHOW_POP", 1);
                } else {
                    right.put("SHOW_POP", 0);
                }
                if (Integer.valueOf(String.valueOf(right.get("STATUS"))) == 0) {
                    right.put("HAS_RECEIVED", 3);
                }
                rightsRecordSet.add(right);
            }
            levelRtnRecord.put("RIGHTS", rightsRecordSet);
            levelSet.add(levelRtnRecord);
        }
        return levelSet;
    }

    @Override
    public Map<String, Object> pushCustomerTask(String customerId) {
        Map<String, Object> record = this.vipTaskRelationMapper.findCustomerPushTask(customerId);
        if (record != null && StringUtils.isNotEmpty((String)String.valueOf(record.get("ID")))) {
            record.put("TASK_IMG_URL", this.picService.getProductPicUrl(String.valueOf(record.get("ID")), ProductPicTypeEnum.VIP_TASK_FONTPAGE.getValue()).get(0));
            this.vipTaskRelationMapper.updatePushTimes(String.valueOf(record.get("RID")));
        }
        return record;
    }

    @Override
    public Map<String, Object> customerTasks(String customerId) {
        this.customerVipTaskRelation(customerId);
        if (this.checkFinishTaskBindMobile(customerId).booleanValue()) {
            this.finishTaskBindMobile(customerId);
        }
        CustomerEntity customer = this.customerService.getCustomer(customerId);
        HashMap<String, Object> rtnRecord = new HashMap<String, Object>();
        List<MallVipConditionEntity> conditionList = this.conditionList(customer.getPlatformGroupId(), VipLevelTypeEnum.order.getValue());
        rtnRecord.put("CONDITIONS", conditionList);
        Integer orderCount = this.orderService.getUserOrderCount(customerId);
        Integer curLevel = this.vipInterface.getUserVipInfo(customerId).getLevel();
        rtnRecord.put("ORDER_COUNT", orderCount);
        rtnRecord.put("CURRENT_LEVEL", curLevel);
        List<Map<String, Object>> userTasks = this.vipTaskRelationMapper.findCustomerTasks(customerId);
        List<Map<String, Object>> vipTasks = this.tasksMapper.findHasnotTasksByLevel(curLevel);
        ArrayList levelSet = new ArrayList();
        for (MallVipConditionEntity condition : conditionList) {
            HashMap<String, Object> levelRtnRecord = new HashMap<String, Object>();
            levelRtnRecord.put("ORDER_COUNT_DIFF", condition.getOrderNum() - orderCount < 0 ? 0 : condition.getOrderNum() - orderCount);
            levelRtnRecord.put("LEVEL", condition.getLevel());
            if (condition.getLevel() <= curLevel) {
                levelRtnRecord.put("LIGHT", "ON");
            } else {
                levelRtnRecord.put("LIGHT", "OFF");
            }
            ArrayList<Map<String, Object>> tasksRecordSet = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> task : userTasks) {
                if (((Integer)task.get("LEVEL")).intValue() != condition.getLevel().intValue()) continue;
                if (condition.getLevel() > curLevel) {
                    task.put("LIGHT", "OFF");
                    task.put("IS_FINISHED", "2");
                }
                tasksRecordSet.add(task);
            }
            levelRtnRecord.put("TASKS", tasksRecordSet);
            levelSet.add(levelRtnRecord);
        }
        rtnRecord.put("LEVELS_DATA", levelSet);
        return rtnRecord;
    }

    @Override
    @ReadThroughSingleCache(namespace="MallVipService.checkCustomerRight", expiration=120)
    public MallVipRightsEntity checkCustomerRight(@ParameterValueKeyProvider(order=0) String customerId, @ParameterValueKeyProvider(order=1) String rightId) {
        CustomerEntity customer = this.customerService.getCustomer(customerId);
        MallVipEntity vip = this.vipInterface.getUserVipInfo(customerId);
        MallVipRightsEntity searchParam = new MallVipRightsEntity();
        searchParam.setPlatformGroupId(customer.getPlatformGroupId());
        searchParam.setStatus("1");
        searchParam.setRightId(rightId);
        searchParam.setHasRight("1");
        searchParam.setLevel(vip.getLevel());
        return (MallVipRightsEntity)this.vipRightsMapper.getSingle(searchParam);
    }

    @Override
    public BaseJsonVo getCustomerRight(String customerId, String rightId) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        MallVipRightsEntity entity = this.checkCustomerRight(customerId, rightId);
        if (entity != null) {
            result.setValue((Object)entity);
        } else {
            result.setError("\u65e0\u6743\u9650");
        }
        return result;
    }

    @Override
    @ReadThroughSingleCache(namespace="MallVipService.checkCustomerRightByType", expiration=120)
    public MallVipRightsEntity checkCustomerRightByType(@ParameterValueKeyProvider(order=0) String customerId, @ParameterValueKeyProvider(order=1) String typeId, @ParameterValueKeyProvider(order=2) Boolean isVipDay) {
        CustomerEntity customer = this.customerService.getCustomer(customerId);
        MallVipEntity vip = this.vipInterface.getUserVipInfo(customerId);
        if ("3".equals(typeId) && !isVipDay.booleanValue() && vip.getLevel() < 6) {
            return null;
        }
        MallVipRightsEntity searchParam = new MallVipRightsEntity();
        searchParam.setPlatformGroupId(customer.getPlatformGroupId());
        searchParam.setStatus("1");
        searchParam.setRightType(typeId);
        searchParam.setHasRight("1");
        searchParam.setLevel(vip.getLevel());
        return (MallVipRightsEntity)this.vipRightsMapper.getSingle(searchParam);
    }

    @Override
    public BaseJsonVo finishTask(String customerId, String taskId) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        MallVipTasksEntity task = (MallVipTasksEntity)this.tasksMapper.selectByPrimaryKey((Serializable)((Object)taskId));
        if (task == null) {
            result.setError("\u4efb\u52a1\u4e0d\u5b58\u5728");
            return result;
        }
        MallVipTasksRelationEntity searchParam = new MallVipTasksRelationEntity();
        searchParam.setCustomerId(customerId);
        searchParam.setTaskId(taskId);
        searchParam.setIsFinished("0");
        MallVipTasksRelationEntity taskRelation = (MallVipTasksRelationEntity)this.vipTaskRelationMapper.getSingle(searchParam);
        if (taskRelation == null) {
            result.setError("\u7528\u6237\u6ca1\u6709\u8be5\u4efb\u52a1\u6216\u8005\u5df2\u5b8c\u6210\u4e86\u8be5\u4efb\u52a1");
            return result;
        }
        Boolean hasReceived = true;
        String rewardSql = "SELECT ID,TASK_ID,TASK_TYPE,TASK_NAME,REWARD_TYPE,REWARD_NAME,REWARD_DATA,STATUS FROM t_mall_customer_vip_tasks_rewards WHERE TASK_ID = '" + taskId + "'";
        MallVipTasksRewardsEntity searchParam2 = new MallVipTasksRewardsEntity();
        searchParam2.setTaskId(taskId);
        List rewards = this.vipTasksRewardsMapper.getList(searchParam2);
        if (rewards != null && rewards.size() > 0) {
            for (MallVipTasksRewardsEntity reward : rewards) {
                BaseJsonVo vo;
                if ("1".equals(reward.getRewardType())) {
                    this.activeCashticketService.sendTicket4BaseAsynchronous(customerId, reward.getRewardData(), "", 1000, false);
                    continue;
                }
                if (!"2".equals(reward.getRewardType()) || (vo = this.accountBalanceInterface.activeCharge(customerId, new BigDecimal(reward.getRewardData()).divide(new BigDecimal(100)), taskRelation.getTaskName(), true, "\u5b8c\u6210" + taskRelation.getTaskName() + "\u8d60\u9001", taskRelation.getTaskId())).isSuccess()) continue;
                hasReceived = false;
            }
        }
        if (hasReceived.booleanValue()) {
            taskRelation.setIsFinished("1");
            taskRelation.setCreateTime(DateUtils.now());
            this.vipTaskRelationMapper.updateByPrimaryKeySelective(taskRelation);
        } else {
            result.setError(customerId + "|" + taskId + "|\u53d1\u9001\u4efb\u52a1\u5956\u54c1\u5931\u8d25");
        }
        this.vipInterface.deleteUserVipInfoCache(customerId);
        return result;
    }

    @Override
    public BaseJsonVo finishTaskAllTaste(String customerId) {
        List<Map<String, Object>> list = this.vipTaskRelationMapper.finishTaskAllTaste(customerId);
        if (list == null || list.size() == 0) {
            this.finishTask(customerId, "3164433361515307029");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo finishTaskVipOnly(String customerId, String orderMainNo) {
        List<Map<String, Object>> list = this.vipTaskRelationMapper.finishTaskVipOnly(customerId, orderMainNo);
        if (list != null && list.size() > 0) {
            this.finishTask(customerId, "3164445216329869515");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo finishTaskNewTaste(String customerId, String orderMainNo) {
        List<Map<String, Object>> list = this.vipTaskRelationMapper.finishTaskNewTaste(customerId, orderMainNo);
        if (list != null && list.size() > 0) {
            this.finishTask(customerId, "3164445280522429618");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo finishTaskMiaosha(String customerId, String orderMainNo) {
        List<Map<String, Object>> list = this.vipTaskRelationMapper.finishTaskMiaosha(customerId, orderMainNo);
        if (list != null && list.size() > 0) {
            this.finishTask(customerId, "3172187990057360659");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public Boolean isFinishedTask5yuan(String customerId) {
        Map<String, Object> list = this.vipTaskRelationMapper.isFinishedTask5yuan(customerId);
        Map<String, Object> existWhite = this.vipTaskRelationMapper.existsWhiteList(customerId, 1);
        if (list != null && list.size() != 0 && ("2".equals(list.get("status")) || "3".equals(list.get("status"))) && (existWhite == null || existWhite.size() == 0 || existWhite.get("_exist") == null)) {
            return true;
        }
        return false;
    }

    @Override
    public BaseJsonVo finishTask5yuan(String customerId) {
        if (this.isFinishedTask5yuan(customerId).booleanValue()) {
            this.finishTask(customerId, "3164445118971216140");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo finishTaskTuangou(String customerId, String orderMainNo) {
        List<Map<String, Object>> list = this.vipTaskRelationMapper.finishTaskTuangou(orderMainNo);
        if (list != null && list.size() > 0) {
            this.finishTask(customerId, "3164445184631168131");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo finishTaskPleaseYoghourt(String customerId, String orderMainNo) {
        List<Map<String, Object>> list = this.vipTaskRelationMapper.finishTaskPleaseYoghourt(orderMainNo);
        if (list != null && list.size() > 0) {
            this.finishTask(customerId, "3164445404530475556");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo finishTaskTupianchuanbo(String customerId, String orderMainNo) {
        List<Map<String, Object>> list = this.vipTaskRelationMapper.finishTaskTupianchuanbo(orderMainNo);
        if (list != null && list.size() > 0) {
            this.finishTask(customerId, "3170555507788115764");
            this.finishTask(customerId, "3170555406046817438");
            this.finishTask(customerId, "3164654221540859007");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo finishTaskOrderedTwice(String customerId) {
        Map<String, Object> list = this.vipTaskRelationMapper.finishTaskOrderedTwice(customerId, DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)-30), (String)"yyyy-MM-dd HH:mm:ss"));
        this.logger.info("\u6708\u6536\u4e24\u5355\u4efb\u52a1[" + customerId + "]" + (list == null ? 0 : list.size()));
        if (list != null && list.size() > 0 && list.get("_cou") != null && Integer.valueOf(list.get("_cou").toString()) > 0) {
            this.finishTask(customerId, "1245978092654039040");
        }
        if (list != null && list.size() > 0 && list.get("_cou") != null && Integer.valueOf(list.get("_cou").toString()) > 1) {
            this.finishTask(customerId, "3164445355091200679");
        }
        if (list != null && list.size() > 0 && list.get("_cou") != null && Integer.valueOf(list.get("_cou").toString()) > 2) {
            this.finishTask(customerId, "1245978630363811840");
        }
        if (list != null && list.size() > 0 && list.get("_cou") != null && Integer.valueOf(list.get("_cou").toString()) > 3) {
            this.finishTask(customerId, "1022869781126189056");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo finishTaskRegularOrder(String customerId, String orderMainNo) {
        List<Map<String, Object>> list = this.vipTaskRelationMapper.finishTaskRegularOrder(orderMainNo);
        if (list != null && list.size() > 0) {
            this.finishTask(customerId, "3172187498156596686");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo finishTaskCanteen(String customerId, String orderMainNo) {
        List<Map<String, Object>> list = this.vipTaskRelationMapper.finishTaskCanteen(orderMainNo);
        if (list != null && list.size() > 0) {
            this.finishTask(customerId, "3172187593008494233");
        }
        return BaseJsonVo.success((Object)"");
    }

    private Boolean checkFinishTaskBindMobile(String customerId) {
        CustomerEntity customer = this.customerService.getCustomer(customerId);
        if (StringUtils.isNotEmpty((String)customer.getMobile())) {
            return true;
        }
        return false;
    }

    @Override
    public BaseJsonVo finishTaskBindMobile(String customerId) {
        this.finishTask(customerId, "1022869204455526400");
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo finishTaskImproveInfo(String customerId) {
        this.finishTask(customerId, "1022869402032410624");
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo finishEvaluate(String customerId) {
        this.finishTask(customerId, "3164445155423067970");
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public Integer getMaxLevelOrderShort(String customerId) {
        Integer vipOrderCount = this.orderService.getUserOrderCount(customerId);
        CustomerEntity customer = this.customerService.getCustomer(customerId);
        List<MallVipConditionEntity> conditions = this.conditionList(customer.getPlatformGroupId(), VipLevelTypeEnum.order.getValue());
        if (conditions == null || conditions.size() == 0) {
            return 0;
        }
        Integer maxLevelOrderShort = conditions.get(conditions.size() - 1).getOrderNum();
        if (vipOrderCount >= maxLevelOrderShort) {
            return 0;
        }
        return maxLevelOrderShort - vipOrderCount;
    }

    @Override
    public BaseJsonVo sendTemplateVipLevelUpNoticeMessage(String customerId) {
        return null;
    }

    @Override
    @Transactional
    public BaseJsonVo saveVipQuestionnaire(List<MallVipQuestionnairePaperEntity> papers) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        for (MallVipQuestionnairePaperEntity r : papers) {
            r.setId(IDGenerate.getUniqueIdStr());
            this.vipQuestionnairePaperMapper.insert(r);
        }
        if (papers.size() > 0) {
            this.finishTask(papers.get(0).getCustomerId(), "3172412336858010334");
        }
        return result;
    }

    @Override
    public void rebuildVipLevel(String customerId) {
        BaseJsonVo baseJsonVo = this.customerLevelUp(customerId, "");
        if (!baseJsonVo.isSuccess()) {
            throw new RuntimeException("\u7528\u6237\u4f1a\u5458\u7b49\u7ea7\u6709\u8bef");
        }
    }

    @Override
    public void rebuildVipLevelBatch() {
        List<Map<String, String>> orderMainList = this.orderMainService.getRebuildVipLevelBatch();
        orderMainList.forEach(map -> this.customerLevelUp((String)map.get("CUSTOMER_ID"), (String)map.get("ORDER_MAIN_NO")));
    }

    @Override
    public BaseJsonVo rebuildVipLevelEveryday() {
        List<Map<String, String>> orderMainList = this.orderMainService.getRebuildVipLevelEverydayBatch(DateUtils.date());
        BaseJsonVo jsonVo = this.biOrderDetailInvoke.getNeedLevelUpCustomers();
        List cus = jsonVo.isSuccess() ? (List)jsonVo.getValue() : new ArrayList();
        orderMainList.forEach(map -> {
            this.customerLevelUp((String)map.get("CUSTOMER_ID"), (String)map.get("ORDER_MAIN_NO"));
            cus.remove(map.get("CUSTOMER_ID"));
        });
        cus.forEach(c -> this.customerLevelUp((String)c, null));
        return BaseJsonVo.success(null);
    }

    @Override
    public boolean checkVipRightByType(String customerId, String rightType) {
        if (String.valueOf(VipRightTypeEnum.RIGHT_XINPINCHANGXIAN.getValue()).equals(rightType)) {
            return true;
        }
        MallVipEntity vipEntity = this.vipInterface.getUserVipInfo(customerId);
        int level = 0;
        if (vipEntity != null) {
            level = vipEntity.getLevel();
        }
        MallVipRightsEntity rightsEntity = new MallVipRightsEntity();
        rightsEntity.setLevel(level);
        rightsEntity.setStatus("1");
        rightsEntity.setRightType(rightType);
        rightsEntity.setHasRight("1");
        List vipRightsEntities = this.vipRightsMapper.getList(rightsEntity);
        return vipRightsEntities != null && vipRightsEntities.size() != 0;
    }

    @Override
    public Boolean isVipDayNow() {
        int weekIndex;
        Object isVipDayStr = this.memcachedService.get("VIP", "VIP_DAY");
        if (isVipDayStr == null || StringUtils.isEmpty((String)isVipDayStr.toString())) {
            return false;
        }
        Map r = (Map)JSON.parseObject((String)isVipDayStr.toString(), HashMap.class);
        if (r == null || r.get("weekIndex") == null || "0".equals(r.get("isEffective").toString())) {
            return false;
        }
        int weekIndexOfDate = DateUtils.getWeekIndexOfDate((Date)DateUtils.now());
        if (weekIndexOfDate == (weekIndex = Integer.valueOf(r.get("weekIndex").toString()).intValue())) {
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Object> getMallVipDay() {
        Object isVipDayStr = this.memcachedService.get("VIP", "VIP_DAY");
        if (isVipDayStr == null || StringUtils.isEmpty((String)isVipDayStr.toString())) {
            return null;
        }
        Map r = (Map)JSON.parseObject((String)isVipDayStr.toString(), HashMap.class);
        if (r == null || r.get("weekIndex") == null || "0".equals(r.get("isEffective").toString())) {
            return null;
        }
        return r;
    }

    @Override
    public Boolean isVip(String customerId) {
        if (customerId == null || customerId.isEmpty()) {
            return false;
        }
        MallVipEntity vip = this.vipInterface.getUserVipInfo(customerId);
        if (vip.getLevel() > 0) {
            return true;
        }
        return false;
    }

    @Override
    public void finishAllTasksByFinishOrder(String orderMainNo, String customerId) {
        this.finishTaskAllTaste(customerId);
        this.finishTask5yuan(customerId);
        this.finishTaskCanteen(customerId, orderMainNo);
        this.finishTaskMiaosha(customerId, orderMainNo);
        this.finishTaskNewTaste(customerId, orderMainNo);
        this.finishTaskOrderedTwice(customerId);
        this.finishTaskRegularOrder(customerId, orderMainNo);
        this.finishTaskTuangou(customerId, orderMainNo);
        this.finishTaskVipOnly(customerId, orderMainNo);
        this.finishTaskTupianchuanbo(customerId, orderMainNo);
        this.finishTaskPleaseYoghourt(customerId, orderMainNo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo paySuccessCreateVip(MallOrderMainEntity mainEntity) {
        MallVipTimeEntity vipTimeEntity;
        BaseJsonVo jsonVo = BaseJsonVo.error((String)"\u521b\u5efa\u5931\u8d25");
        if (mainEntity == null) {
            return BaseJsonVo.error((String)"\u521b\u5efa\u5931\u8d25\uff0c\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (mainEntity.getCustomerId() == null || mainEntity.getCustomerId().isEmpty()) {
            return BaseJsonVo.error((String)"\u521b\u5efa\u5931\u8d25\uff0c\u7528\u6237\u4e0d\u5b58\u5728");
        }
        MallVipConditionEntity vipConditionEntity = this.vipConditionInterface.getVipConditionByBindCode(mainEntity.getBindCode());
        if (vipConditionEntity == null) {
            return BaseJsonVo.error((String)"\u521b\u5efa\u5931\u8d25\uff0c\u4f1a\u5458\u6761\u4ef6\u4e0d\u5b58\u5728");
        }
        MallVipTimeEntity query = new MallVipTimeEntity();
        query.setCustomerId(mainEntity.getCustomerId());
        query.setSourceOrderMainNo(mainEntity.getOrderMainNo());
        MallVipTimeEntity result = (MallVipTimeEntity)this.vipTimeInterface.getSingle(query, 0L);
        if (result != null) {
            return BaseJsonVo.success((Object)"");
        }
        Date endDate = null;
        try {
            endDate = this.getVipConditionEndDate(vipConditionEntity, mainEntity.getCreateTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Date beginDate = mainEntity.getCreateTime();
        int vipType = mainEntity.getOrderSource().intValue() == OrderSourceEnum.Buy_Supper_Member.getValue() ? VipLevelTypeEnum.superVip.getValue() : VipLevelTypeEnum.pay.getValue();
        SimpleVipVo simpleVipVo = this.getSimpleVipVo(mainEntity.getCustomerId(), VipLevelTypeEnum.superVip.getValue());
        if (simpleVipVo != null && Objects.equals(simpleVipVo.getVipType(), VipLevelTypeEnum.superVip.getValue()) && simpleVipVo.getStatus().intValue() == StatusEnum.STATUS_OK.getValue()) {
            beginDate = simpleVipVo.getEndTime();
        }
        if ((vipTimeEntity = this.vipTimeInterface.insert(mainEntity.getCustomerId(), mainEntity.getOrderMainNo(), vipConditionEntity.getLevel(), vipType, beginDate, endDate, "\u8d2d\u4e70\u4f1a\u5458", vipConditionEntity.getPeriod(), vipConditionEntity.getPeriodUnit())) == null) {
            return BaseJsonVo.error((String)"\u521b\u5efa\u5931\u8d25\uff0c\u4f1a\u5458\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        if (Objects.equals(vipType, VipLevelTypeEnum.pay.getValue())) {
            return ((MallVipService)SpringContextUtil.getBean(this.getClass())).createVip(vipTimeEntity.getCustomerId());
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @Transactional
    public BaseJsonVo createVip(String customerId) {
        MallVipEntity vipEntity = this.vipInterface.getUserVipInfo(customerId);
        int sourceLevel = vipEntity.getLevel();
        List<MallVipTimeEntity> lst = this.vipTimeInterface.getCustomerCurrentLevel(customerId);
        List lst1 = lst.stream().filter(x -> x.getBeginTime().getTime() < new Date().getTime() && x.getEndTime().getTime() > new Date().getTime()).collect(Collectors.toList());
        if (lst1.size() > 0) {
            BaseJsonVo<MallVipSetVo> sr;
            if (vipEntity == null) {
                vipEntity = new MallVipEntity();
                vipEntity.setCustomerId(customerId);
                vipEntity.setCreateTime(new Date());
                vipEntity.setPlatformGroupId(1000);
                vipEntity.setIsReward(0);
                vipEntity.setLevel(((MallVipTimeEntity)lst1.get(0)).getLevel());
                vipEntity.setBeginTime(((MallVipTimeEntity)lst1.get(0)).getBeginTime());
                vipEntity.setEndTime(((MallVipTimeEntity)lst1.get(0)).getEndTime());
            } else {
                if (vipEntity.getLevel().equals(((MallVipTimeEntity)lst1.get(0)).getLevel())) {
                    vipEntity.setIsReward(0);
                }
                vipEntity.setLevel(((MallVipTimeEntity)lst1.get(0)).getLevel());
                vipEntity.setBeginTime(((MallVipTimeEntity)lst1.get(0)).getBeginTime());
                vipEntity.setEndTime(((MallVipTimeEntity)lst1.get(0)).getEndTime());
                vipEntity.setUpdateTime(new Date());
            }
            this.vipMapper.insertOrUpdate(vipEntity);
            Integer orderCount = 0;
            MallOrderMainEntity orderMain = this.orderMainService.getLastOrder(customerId);
            if (orderMain != null && StringUtils.isNotEmpty((String)orderMain.getOrderMainNo()) && (sr = this.checkCustomerCanLevelUp(customerId, orderMain.getOrderMainNo())).isSuccess()) {
                orderCount = ((MallVipSetVo)sr.getValue()).getOrderCount();
            }
            MallVipLogEntity log = new MallVipLogEntity();
            log.setId(String.valueOf(IDGenerate.getUniqueID()));
            log.setCustomerId(customerId);
            log.setPlatformGroupId(1000);
            log.setFromLevel(sourceLevel);
            log.setToLevel(vipEntity.getLevel());
            log.setOrderMainNo(((MallVipTimeEntity)lst1.get(0)).getSourceOrderMainNo());
            log.setOrderNo("");
            log.setOrderNum(orderCount);
            log.setRemark("\u4ed8\u8d39\u4f1a\u5458");
            log.setType("2");
            log.setLevelup(sourceLevel >= vipEntity.getLevel() ? (short)0 : 1);
            log.setCreateTime(DateUtils.now());
            this.vipLogMapper.insert(log);
        } else {
            this.rebuildVipLevel(customerId);
        }
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo createVip(MallVipEntity vipEntity) {
        int sourceLevel = vipEntity.getLevel();
        List<MallVipTimeEntity> lst = this.vipTimeInterface.getCustomerCurrentLevel(vipEntity.getCustomerId());
        List lst1 = lst.stream().filter(x -> x.getBeginTime().getTime() < new Date().getTime() && x.getEndTime().getTime() > new Date().getTime()).collect(Collectors.toList());
        if (lst1.size() > 0) {
            BaseJsonVo<MallVipSetVo> sr;
            if (vipEntity == null) {
                vipEntity = new MallVipEntity();
                vipEntity.setCustomerId(vipEntity.getCustomerId());
                vipEntity.setCreateTime(new Date());
                vipEntity.setPlatformGroupId(1000);
                vipEntity.setIsReward(0);
                vipEntity.setLevel(((MallVipTimeEntity)lst1.get(0)).getLevel());
                vipEntity.setBeginTime(((MallVipTimeEntity)lst1.get(0)).getBeginTime());
                vipEntity.setEndTime(((MallVipTimeEntity)lst1.get(0)).getEndTime());
            } else {
                if (vipEntity.getLevel().equals(((MallVipTimeEntity)lst1.get(0)).getLevel())) {
                    vipEntity.setIsReward(0);
                }
                vipEntity.setLevel(((MallVipTimeEntity)lst1.get(0)).getLevel());
                vipEntity.setBeginTime(((MallVipTimeEntity)lst1.get(0)).getBeginTime());
                vipEntity.setEndTime(((MallVipTimeEntity)lst1.get(0)).getEndTime());
                vipEntity.setUpdateTime(new Date());
            }
            this.vipMapper.insertOrUpdate(vipEntity);
            Integer orderCount = 0;
            MallOrderMainEntity orderMain = this.orderMainService.getLastOrder(vipEntity.getCustomerId());
            if (orderMain != null && StringUtils.isNotEmpty((String)orderMain.getOrderMainNo()) && (sr = this.checkCustomerCanLevelUp(vipEntity.getCustomerId(), orderMain.getOrderMainNo())).isSuccess()) {
                orderCount = ((MallVipSetVo)sr.getValue()).getOrderCount();
            }
            MallVipLogEntity log = new MallVipLogEntity();
            log.setId(String.valueOf(IDGenerate.getUniqueID()));
            log.setCustomerId(vipEntity.getCustomerId());
            log.setPlatformGroupId(1000);
            log.setFromLevel(sourceLevel);
            log.setToLevel(vipEntity.getLevel());
            log.setOrderMainNo(((MallVipTimeEntity)lst1.get(0)).getSourceOrderMainNo());
            log.setOrderNo("");
            log.setOrderNum(orderCount);
            log.setRemark("\u4ed8\u8d39\u4f1a\u5458");
            log.setType("2");
            log.setLevelup(sourceLevel >= vipEntity.getLevel() ? (short)0 : 1);
            log.setCreateTime(DateUtils.now());
            this.vipLogMapper.insert(log);
        } else {
            this.rebuildVipLevel(vipEntity.getCustomerId());
        }
        return BaseJsonVo.success((Object)"");
    }

    private Date getVipConditionEndDate(MallVipConditionEntity vipConditionEntity, Date beginTime) throws Exception {
        beginTime = DateUtils.getAddDateBySecond((Date)DateUtils.getDateFromString((String)DateUtils.formatDate((Date)beginTime, (String)"yyyy-MM-dd")), (int)86399);
        if (vipConditionEntity.getPeriod() == null || vipConditionEntity.getPeriodUnit() == null) {
            throw new Exception("\u6709\u6548\u671f\u65f6\u957f\u672a\u8bbe\u7f6e");
        }
        Calendar cal = Calendar.getInstance();
        switch (vipConditionEntity.getPeriodUnit()) {
            case 1: {
                cal.setTime(beginTime);
                cal.add(1, vipConditionEntity.getPeriod());
                return cal.getTime();
            }
            case 2: {
                cal.setTime(beginTime);
                cal.add(2, vipConditionEntity.getPeriod());
                return cal.getTime();
            }
            case 3: {
                cal.setTime(beginTime);
                cal.add(2, vipConditionEntity.getPeriod());
                return cal.getTime();
            }
        }
        throw new Exception("\u6709\u6548\u671f\u65f6\u957f\u672a\u8bbe\u7f6e\uff0c\u65e0\u6cd5\u5339\u914d\u7ed3\u675f\u65e5\u671f");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo refundVip(String orderMainNo) {
        if (StringUtil.isEmpty((String)orderMainNo)) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MallVipTimeEntity vipTimeEntity = this.vipTimeInterface.getVipTimeByOrderMainNo(orderMainNo);
        if (vipTimeEntity == null) {
            this.logger.info("\u8ba2\u5355:{}\uff0c\u4e0d\u662f\u4ed8\u8d39\u4f1a\u5458\u8ba2\u5355", (Object)orderMainNo);
            return BaseJsonVo.success((Object)"vip\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        if (!Integer.valueOf(1).equals(vipTimeEntity.getStatus())) {
            this.logger.info("\u8ba2\u5355:{},vip\u8bb0\u5f55\u5df2\u9000\u6b3e", (Object)orderMainNo);
            return BaseJsonVo.error((String)"vip\u8bb0\u5f55\u5df2\u9000\u6b3e");
        }
        vipTimeEntity.setStatus(0);
        this.vipTimeInterface.updateRefundStatus(vipTimeEntity);
        if (Objects.equals(vipTimeEntity.getVipType(), VipLevelTypeEnum.pay.getValue())) {
            MallVipEntity vipEntity = this.vipInterface.getUserVipInfo(vipTimeEntity.getCustomerId());
            vipEntity.setEndTime(DateUtils.getAddDateBySecond((Date)new Date(), (int)-1));
            this.vipMapper.updateByPrimaryKeySelective(vipEntity);
            this.logger.info("\u7528\u6237:{} \u4f1a\u5458\u5df2\u9000\u6b3e\u5b8c\u6210", (Object)vipEntity.getCustomerId());
            ((MallVipService)SpringContextUtil.getBean(this.getClass())).createVip(vipEntity.getCustomerId());
        }
        MallVipTimeEntity queryVip = new MallVipTimeEntity();
        queryVip.setParentId(vipTimeEntity.getId());
        MallVipTimeEntity vipEntity = (MallVipTimeEntity)this.vipTimeInterface.getSingle(queryVip, 0L);
        if (vipEntity != null) {
            vipEntity.setStatus(0);
            vipEntity.setRemark("\u4e3b\u5361\u4f1a\u5458\u9000\u6b3e");
            this.vipTimeInterface.updateByPrimaryKeySelective(vipEntity);
            this.logger.info("\u7528\u6237:{} \u526f\u5361\u4f1a\u5458\u5df2\u9000\u6b3e\u5b8c\u6210", (Object)vipEntity.getCustomerId());
        }
        return BaseJsonVo.success((String)"\u4f1a\u5458:{}\u5df2\u7ecf\u9000\u6389\u4e86", (Object)vipEntity.getCustomerId());
    }

    @Override
    public BaseJsonVo refundVip(MallVipEntity vipEntity) {
        vipEntity.setEndTime(DateUtils.getAddDateBySecond((Date)new Date(), (int)-1));
        this.vipMapper.updateByPrimaryKeySelective(vipEntity);
        return this.createVip(vipEntity.getCustomerId());
    }

    @Override
    public MallVipTimeEntity getPayedVipRecord(String orderMainNo) {
        return this.vipTimeInterface.getVipTimeByOrderMainNo(orderMainNo);
    }

    @Override
    public BaseJsonVo getSupperVipCenter(String customerId) {
        SimpleVipVo vipVo = this.vipInterface.getSimpleVipVo(customerId, VipLevelTypeEnum.superVip.getValue());
        if (vipVo.getVipType().intValue() != VipLevelTypeEnum.superVip.getValue()) {
            return BaseJsonVo.error((String)"\u4e0d\u662f\u8d85\u7ea7\u4f1a\u5458");
        }
        SupperVipVo supperVipVo = new SupperVipVo();
        supperVipVo.setVip(vipVo);
        CustomerPointVo customerPointVo = this.customerPointInterface.getCustomerPoint(customerId);
        supperVipVo.setTotalPoint(customerPointVo.getTotalPoint());
        CustomerEntity customer = this.customerService.getCustomer(customerId);
        List<MallVipConditionEntity> conditionList = this.conditionList(customer.getPlatformGroupId(), VipLevelTypeEnum.superVip.getValue());
        supperVipVo.setVipRightList(this.getVipRight(customerId, conditionList, 0, vipVo.getVipLevel(), vipVo.getVipType()));
        return BaseJsonVo.success((Object)supperVipVo);
    }
}

