/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.vip;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.vip.MallVipTimeMapper;
import cc.lechun.mall.entity.vip.MallVipTimeEntity;
import cc.lechun.mall.iservice.vip.MallVipTimeInterface;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MallVipTimeService
extends BaseService<MallVipTimeEntity, Integer>
implements MallVipTimeInterface {
    @Resource
    private MallVipTimeMapper mallVipTimeMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MallVipTimeEntity insert(String customerId, String orderMainNo, int level, int vipType, Date beginTime, Date endTime, String remark, Integer period, Integer periodUnit) {
        MallVipTimeEntity vipTimeEntity = new MallVipTimeEntity();
        vipTimeEntity.setSourceOrderMainNo(orderMainNo);
        vipTimeEntity = (MallVipTimeEntity)this.mallVipTimeMapper.getSingle(vipTimeEntity);
        if (vipTimeEntity == null) {
            vipTimeEntity = new MallVipTimeEntity();
            vipTimeEntity.setCreateTime(new Date());
            vipTimeEntity.setEndTime(endTime);
            vipTimeEntity.setBeginTime(beginTime);
            vipTimeEntity.setStatus(1);
            vipTimeEntity.setSourceOrderMainNo(orderMainNo);
            vipTimeEntity.setCustomerId(customerId);
            vipTimeEntity.setLevel(level);
            vipTimeEntity.setRemark(remark);
            vipTimeEntity.setFreeStatus(0);
            vipTimeEntity.setPeriod(period);
            vipTimeEntity.setPeriodUnit(periodUnit);
            vipTimeEntity.setVipType(vipType);
            vipTimeEntity.setVipNo(RandomUtils.generateId());
            this.reBuildVipTime(vipTimeEntity);
        }
        return vipTimeEntity;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo reBuildVipTime(MallVipTimeEntity vipTimeEntity) {
        MallVipTimeEntity search = new MallVipTimeEntity();
        search.setCustomerId(vipTimeEntity.getCustomerId());
        search.setStatus(1);
        List lst = this.mallVipTimeMapper.getList(search);
        if (Integer.valueOf(1).equals(vipTimeEntity.getStatus())) {
            if (lst.size() > 0) {
                lst = lst.stream().sorted((e, f) -> f.getEndTime().compareTo(e.getEndTime())).collect(Collectors.toList());
                MallVipTimeEntity v = (MallVipTimeEntity)lst.get(0);
                vipTimeEntity.setBeginTime(DateUtils.getAddDateBySecond((Date)v.getEndTime(), (int)1));
                Date endTime = this.getVipConditionEndDate(vipTimeEntity.getPeriod(), vipTimeEntity.getPeriodUnit(), vipTimeEntity.getBeginTime());
                if (endTime == null) {
                    throw new RuntimeException("\u4f1a\u5458\u6709\u6548\u671f\u8ba1\u7b97\u9519\u8bef");
                }
                vipTimeEntity.setEndTime(endTime);
                this.mallVipTimeMapper.insert(vipTimeEntity);
            } else {
                this.mallVipTimeMapper.insert(vipTimeEntity);
            }
        } else if (lst.size() > 0) {
            lst = lst.stream().sorted((e, f) -> e.getEndTime().compareTo(f.getEndTime())).collect(Collectors.toList());
            MallVipTimeEntity lastVip = null;
            for (MallVipTimeEntity v : lst) {
                if (lastVip == null) {
                    v.setBeginTime(new Date());
                } else {
                    v.setBeginTime(DateUtils.getAddDateBySecond((Date)lastVip.getEndTime(), (int)1));
                }
                Date endTime = this.getVipConditionEndDate(v.getPeriod(), v.getPeriodUnit(), v.getBeginTime());
                if (endTime == null) {
                    throw new RuntimeException("\u4f1a\u5458\u6709\u6548\u671f\u8ba1\u7b97\u9519\u8bef");
                }
                v.setEndTime(endTime);
                this.mallVipTimeMapper.updateByPrimaryKeySelective(v);
                lastVip = v;
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public List<MallVipTimeEntity> getCustomerCurrentLevel(String customerId) {
        return this.mallVipTimeMapper.getCustomerCurrentLevel(customerId);
    }

    @Override
    public void updateFreeStatus(Integer id, Integer status) {
        MallVipTimeEntity update = new MallVipTimeEntity();
        update.setId(id);
        update.setFreeStatus(status);
        this.mallVipTimeMapper.updateByPrimaryKeySelective(update);
    }

    @Override
    public void updateRefundStatus(MallVipTimeEntity vipTimeEntity) {
        MallVipTimeEntity update = new MallVipTimeEntity();
        update.setId(vipTimeEntity.getId());
        update.setStatus(vipTimeEntity.getStatus());
        this.mallVipTimeMapper.updateByPrimaryKeySelective(update);
        this.reBuildVipTime(vipTimeEntity);
    }

    @Override
    public MallVipTimeEntity getVipTimeByOrderMainNo(String orderMainNo) {
        MallVipTimeEntity search = new MallVipTimeEntity();
        search.setSourceOrderMainNo(orderMainNo);
        return (MallVipTimeEntity)this.mallVipTimeMapper.getSingle(search);
    }

    private Date getVipConditionEndDate(Integer period, Integer periodUnit, Date beginTime) {
        beginTime = DateUtils.getAddDateBySecond((Date)DateUtils.getDateFromString((String)DateUtils.formatDate((Date)beginTime, (String)"yyyy-MM-dd")), (int)86399);
        if (period == null || periodUnit == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        switch (periodUnit) {
            case 1: {
                cal.setTime(beginTime);
                cal.add(1, period);
                return cal.getTime();
            }
            case 2: {
                cal.setTime(beginTime);
                cal.add(2, period);
                return cal.getTime();
            }
            case 3: {
                cal.setTime(beginTime);
                cal.add(5, period);
                return cal.getTime();
            }
        }
        return null;
    }
}

