/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.vip;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.IndexActiveVo;
import cc.lechun.active.entity.active.VipIndexActiveVo;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.prepay.PrepayCardTypeEnum;
import cc.lechun.mall.entity.sales.MallActivePromotionVO;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.vip.CustomerBuyTypeEnum;
import cc.lechun.mall.entity.vip.SimpleVipVo;
import cc.lechun.mall.entity.vip.VipLevelTypeEnum;
import cc.lechun.mall.entity.vip.VipPrice;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import cc.lechun.mall.service.vip.discount.DiscountStrategy;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserPayVipService {
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private MallVipInterface vipInterface;
    @Autowired
    private MallPromotionInterface promotionInterface;
    @Autowired
    private AccountBalanceInterface accountBalanceInterface;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, DiscountStrategy> discountStrategyMap = new ConcurrentHashMap<String, DiscountStrategy>();

    public UserPayVipService(Map<String, DiscountStrategy> discountStrategyMap) {
        this.discountStrategyMap.clear();
        discountStrategyMap.forEach((k, v) -> this.discountStrategyMap.put((String)k, (DiscountStrategy)v));
    }

    public BaseJsonVo getPayVip(String bindCode, String customerId, Integer platformGroupId) {
        VipIndexActiveVo vipIndexActiveVo = new VipIndexActiveVo();
        ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode);
        BaseJsonVo<IndexActiveVo> indexActiveVoBaseJsonVo = this.activeInterface.buildIndexActiveVo(activeEntity.getActiveNo());
        if (!indexActiveVoBaseJsonVo.isSuccess()) {
            return indexActiveVoBaseJsonVo;
        }
        BeanUtils.copyProperties((Object)indexActiveVoBaseJsonVo.getValue(), (Object)vipIndexActiveVo);
        List<ActiveEntity> activeEntityList = this.activeInterface.getActiveList4ActiveType(platformGroupId, 53);
        String cardType = PrepayCardTypeEnum.new_card_Cold.getValue() + "," + PrepayCardTypeEnum.new_card_Nomal.getValue();
        List<Map<String, Object>> list = this.accountBalanceInterface.getSpecialTotal(customerId, cardType);
        Integer vipBuyType = this.vipInterface.getBuyType(customerId, VipLevelTypeEnum.superVip.getValue());
        for (ActiveEntity active : activeEntityList) {
            MallActivePromotionVO mallActivePromotionVO = this.getMallActivePromotionVO(customerId, vipBuyType, active);
            vipIndexActiveVo.setPromotionList(new ArrayList<MallActivePromotionVO>());
            vipIndexActiveVo.getPromotionList().add(mallActivePromotionVO);
        }
        return BaseJsonVo.success((Object)vipIndexActiveVo);
    }

    private Integer getBuyType(String customerId, SimpleVipVo mallVipVo) {
        int vipBuyType = CustomerBuyTypeEnum.common_user.getValue();
        if (Objects.equals(mallVipVo.getVipType(), VipLevelTypeEnum.superVip.getValue())) {
            vipBuyType = CustomerBuyTypeEnum.renewal_user.getValue();
        } else {
            String cardType = PrepayCardTypeEnum.milk_card.getValue() + "," + PrepayCardTypeEnum.new_card_Cold.getValue() + "," + PrepayCardTypeEnum.new_card_Nomal.getValue();
            List<Map<String, Object>> list = this.accountBalanceInterface.getSpecialTotal(customerId, cardType);
            BigDecimal cardBalance = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty(list)) {
                for (Map<String, Object> map : list) {
                    cardBalance = PriceUtils.add((BigDecimal)new BigDecimal(map.get("usableAccount").toString()), (BigDecimal)cardBalance);
                }
            }
            if (cardBalance.compareTo(BigDecimal.ZERO) > 0) {
                vipBuyType = CustomerBuyTypeEnum.card_user.getValue();
            }
        }
        return vipBuyType;
    }

    public MallActivePromotionVO getMallActivePromotionVO(String customerId, String bindCode) {
        return this.getMallActivePromotionVO(customerId, this.vipInterface.getBuyType(customerId, VipLevelTypeEnum.superVip.getValue()), bindCode);
    }

    public MallActivePromotionVO getMallActivePromotionVO(String customerId, Integer vipBuyType, String bindCode) {
        return this.getMallActivePromotionVO(customerId, vipBuyType, this.activeInterface.getActiveEntityByQrcode(bindCode));
    }

    @NotNull
    public MallActivePromotionVO getMallActivePromotionVO(String customerId, Integer vipBuyType, ActiveEntity active) {
        MallPromotionVO mallPromotionVO = this.promotionInterface.getPromotionVo(active.getActiveNo());
        MallActivePromotionVO mallActivePromotionVO = new MallActivePromotionVO();
        BeanUtils.copyProperties((Object)mallPromotionVO, (Object)mallActivePromotionVO);
        mallActivePromotionVO.setOrderSource(this.activeInterface.getOrderSourceByActiveType(active.getActiveType()));
        DiscountStrategy discountStrategy = this.discountStrategyMap.get(vipBuyType + "_vipUser");
        VipPrice vipPrice = discountStrategy.calculateDiscount(mallPromotionVO.getPromotionPrice());
        this.logger.info("getSuperVipPrice \u7528\u6237:{} \u8d2d\u4e70\u7c7b\u578b:{},\u8d2d\u4e70\u4ef7:{},{}", new Object[]{customerId, vipBuyType, vipPrice.getPrice(), vipPrice.getPriceDesc()});
        mallPromotionVO.setFactPrice(vipPrice.getPrice());
        mallPromotionVO.setPromotionPrice(vipPrice.getPrice());
        mallActivePromotionVO.setPromotionPrice(vipPrice.getPrice());
        mallActivePromotionVO.setFactPrice(vipPrice.getPrice());
        mallActivePromotionVO.setDiscountDesc(vipPrice.getPriceDesc());
        mallActivePromotionVO.setPromotionDiff(PriceUtils.subtract((BigDecimal)mallPromotionVO.getOriginPrice(), (BigDecimal)mallPromotionVO.getPromotionPrice()));
        return mallActivePromotionVO;
    }
}

