/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.vip.refund;

import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.vip.MallVipVo;
import cc.lechun.mall.entity.vip.MembershipOrder;
import cc.lechun.mall.entity.vip.RefundConditionEnum;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import cc.lechun.mall.service.vip.refund.FullRefundPolicy;
import cc.lechun.mall.service.vip.refund.PartialRefundPolicy;
import cc.lechun.mall.service.vip.refund.RefundPolicy;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class VipRefundService {
    private Map<Integer, RefundPolicy> refundPolicyMap = new HashMap<Integer, RefundPolicy>();
    @Autowired
    private MallVipInterface mallVipInterface;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public VipRefundService() {
        this.refundPolicyMap.put(RefundConditionEnum.WITHIN_REFUND_PERIOD.getValue(), new FullRefundPolicy());
        this.refundPolicyMap.put(RefundConditionEnum.BEYOND_REFUND_PERIOD.getValue(), new PartialRefundPolicy());
    }

    public BigDecimal getRefund(MembershipOrder order) {
        RefundPolicy refundPolicy = this.refundPolicyMap.get(order.isWithinRefundPeriod() ? RefundConditionEnum.WITHIN_REFUND_PERIOD.getValue() : RefundConditionEnum.BEYOND_REFUND_PERIOD.getValue());
        return refundPolicy.calculate(order);
    }

    @Transactional
    public BaseJsonVo processRefund(MembershipOrder order, String customerId) {
        MallVipVo vipVo = this.mallVipInterface.getUserVipVO(customerId);
        this.mallVipInterface.refundVip(order.getOrderNo());
        this.logger.info("\u7528\u6237:{} \u4f1a\u5458\u5df2\u9000\u6b3e\u5b8c\u6210", (Object)customerId);
        return BaseJsonVo.success((Object)"");
    }
}

