/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.common.enums.weixin.MessageTypeEnum;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.weixin.MallMessageConfigMapper;
import cc.lechun.mall.entity.weixin.MallMessageConfigEntity;
import cc.lechun.mall.iservice.weixin.MallMessageConfigInterface;
import cc.lechun.mall.iservice.weixin.TemplateMessageInterface;
import cc.lechun.mall.iservice.weixin.WeiXinKeywordInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallMessageConfigService
extends BaseService
implements MallMessageConfigInterface {
    @Autowired
    private MallMessageConfigMapper messageConfigMapper;
    @Autowired
    private WeiXinKeywordInterface keywordInterface;
    @Autowired
    private TemplateMessageInterface templateMessageInterface;

    @Override
    @ReadThroughSingleCache(namespace="MallMessageConfigService.getMessageConfigEntityList", expiration=600)
    public List<MallMessageConfigEntity> getMessageConfigEntityList(@ParameterValueKeyProvider(order=0) Integer platformGroupId, @ParameterValueKeyProvider(order=1) String action) {
        MallMessageConfigEntity messageConfigEntity = new MallMessageConfigEntity();
        messageConfigEntity.setActionId(action);
        messageConfigEntity.setPlatformGroupId(platformGroupId);
        return this.messageConfigMapper.getList(messageConfigEntity);
    }

    @Override
    @ReadThroughSingleCache(namespace="MallMessageConfigService.select", expiration=600)
    public MallMessageConfigEntity select(@ParameterValueKeyProvider int messageConfigId) {
        return (MallMessageConfigEntity)this.messageConfigMapper.selectByPrimaryKey(Integer.valueOf(messageConfigId));
    }

    @Override
    public BaseJsonVo getMessageConfig(Integer messageConfigId, Map<String, String> variable) {
        MallMessageConfigEntity configEntity = this.select(messageConfigId);
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        if (MessageTypeEnum.CUSTOMZICE_MESSAGE.getValue() == configEntity.getMessageType().intValue() || MessageTypeEnum.SMS_MESSAGE.getValue() == configEntity.getMessageType().intValue()) {
            BaseJsonVo baseJsonVo = this.keywordInterface.getKeywordContent(configEntity.getMessageId(), variable);
            if (!baseJsonVo.isSuccess()) {
                return baseJsonVo;
            }
            map.put(configEntity.getMessageType(), baseJsonVo.getValue());
        } else if (MessageTypeEnum.TEMPLATE_MESSAGE.getValue() == configEntity.getMessageType().intValue() || MessageTypeEnum.MP_SUBSCRIBE_MESSAGE.getValue() == configEntity.getMessageType().intValue()) {
            BaseJsonVo baseJsonVo = this.templateMessageInterface.getTemplateMessageContent(configEntity.getMessageId(), variable);
            if (!baseJsonVo.isSuccess()) {
                return baseJsonVo;
            }
            map.put(configEntity.getMessageType(), baseJsonVo.getValue());
        }
        return BaseJsonVo.success(map);
    }

    @Override
    public BaseJsonVo getMessageConfigByMessageType(int messageType, Integer messageId, Map<String, String> variable) {
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        if (messageType == 1 || messageType == 3) {
            BaseJsonVo baseJsonVo = this.keywordInterface.getKeywordContent(messageId, variable);
            if (!baseJsonVo.isSuccess()) {
                return baseJsonVo;
            }
            map.put(messageType, baseJsonVo.getValue());
        } else if (messageType == 2) {
            BaseJsonVo baseJsonVo = this.templateMessageInterface.getTemplateMessageContent(messageId, variable);
            if (!baseJsonVo.isSuccess()) {
                return baseJsonVo;
            }
            map.put(messageType, baseJsonVo.getValue());
        } else if (messageType == 4) {
            BaseJsonVo baseJsonVo = this.templateMessageInterface.getTemplateMessageContent(messageId, variable);
            if (!baseJsonVo.isSuccess()) {
                return baseJsonVo;
            }
            map.put(messageType, baseJsonVo.getValue());
        }
        return BaseJsonVo.success(map);
    }
}

