/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.active.entity.active.ActivePropertyEntity;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.sign.MD5;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.weixin.TemplateMessageMapper;
import cc.lechun.mall.entity.weixin.MallTemplateMessageSubcriptConfigEntity;
import cc.lechun.mall.entity.weixin.TemplateExecOrderEnum;
import cc.lechun.mall.entity.weixin.TemplateExecTimeTypeEnum;
import cc.lechun.mall.entity.weixin.TemplateMessageBodyVo;
import cc.lechun.mall.entity.weixin.TemplateMessageContentEntity;
import cc.lechun.mall.entity.weixin.TemplateMessageEntity;
import cc.lechun.mall.entity.weixin.WeekEnum;
import cc.lechun.mall.iservice.weixin.MallTemplateMessageSubcriptConfigInterface;
import cc.lechun.mall.iservice.weixin.TemplateMessageContentInterface;
import cc.lechun.mall.iservice.weixin.TemplateMessageInterface;
import cc.lechun.mall.iservice.weixin.WeiXinKeywordInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.RandomUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.popular.bean.message.templatemessage.MiniSubscribeMessage;
import weixin.popular.bean.message.templatemessage.MiniprogramMessageRedirectItem;
import weixin.popular.bean.message.templatemessage.MpSubscribeMessage;
import weixin.popular.bean.message.templatemessage.TemplateMessage;
import weixin.popular.bean.message.templatemessage.TemplateMessageItem;

@Service
public class TemplateMessageService
extends BaseService
implements TemplateMessageInterface {
    @Autowired
    private TemplateMessageMapper templateMessageMapper;
    @Autowired
    private WeiXinKeywordInterface keywordInterface;
    @Autowired
    private MallTemplateMessageSubcriptConfigInterface mallTemplateMessageSubcriptConfigInterface;
    @Autowired
    TemplateMessageContentInterface templateMessageContentInterface;

    @Override
    @ReadThroughSingleCache(namespace="TemplateMessageService.getTempMessageListBySence", expiration=120)
    public List<TemplateMessageEntity> getTempMessageListBySence(@ParameterValueKeyProvider(order=0) Integer sence, @ParameterValueKeyProvider(order=1) Integer platformId) {
        ArrayList<TemplateMessageEntity> resultList = new ArrayList<TemplateMessageEntity>();
        List<MallTemplateMessageSubcriptConfigEntity> list = this.mallTemplateMessageSubcriptConfigInterface.getTempMessageListBySence(sence, platformId);
        if (list.size() == 0) {
            this.logger.info("sence={},platformId={} \u573a\u666f\u6d88\u606f\u8ba2\u9605\u672a\u914d\u7f6e", (Object)sence, (Object)platformId);
            return new ArrayList<TemplateMessageEntity>();
        }
        for (MallTemplateMessageSubcriptConfigEntity messageSubcriptConfigEntity : list) {
            TemplateMessageEntity templateMessageEntity = this.getTemplateMessageById(messageSubcriptConfigEntity.getTemplateId());
            resultList.add(templateMessageEntity);
        }
        return resultList;
    }

    @Override
    @ReadThroughSingleCache(namespace="TemplateMessageService.getTemplateMessageById")
    public TemplateMessageEntity getTemplateMessageById(@ParameterValueKeyProvider Integer id) {
        return (TemplateMessageEntity)this.templateMessageMapper.selectByPrimaryKey(id);
    }

    public List<TemplateMessageEntity> getTemplateMessageList(Integer platformId) {
        TemplateMessageEntity messageEntity = new TemplateMessageEntity();
        messageEntity.setPlatformId(platformId);
        return this.templateMessageMapper.getList(messageEntity);
    }

    @Override
    public BaseJsonVo getTemplateMessageContent(Integer messageId, Map<String, String> variable) {
        try {
            TemplateMessageEntity templateMessageEntity = this.getTemplateMessageById(messageId);
            if (templateMessageEntity == null) {
                this.logger.error("\u6a21\u677f\u6d88\u606fid:{}\u6a21\u677f\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5", (Object)messageId);
                return BaseJsonVo.error((String)"\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            }
            this.setTemplateMessageEntity(templateMessageEntity);
            if (templateMessageEntity.getPlatformId() != null && templateMessageEntity.getPlatformId() == 1) {
                if (templateMessageEntity.getMessageType() == 2) {
                    BaseJsonVo<TemplateMessage> result = this.getTemplateMessageContent(templateMessageEntity, messageId, variable);
                    if (result.isSuccess()) {
                        return BaseJsonVo.success((Object)result.getValue());
                    }
                    return BaseJsonVo.error((String)result.getMessage());
                }
                if (templateMessageEntity.getMessageType() == 4) {
                    BaseJsonVo<MpSubscribeMessage> result = this.getMpSubscribeMessageContent(templateMessageEntity, messageId, variable);
                    if (result.isSuccess()) {
                        return BaseJsonVo.success((Object)result.getValue());
                    }
                    return BaseJsonVo.error((String)result.getMessage());
                }
            } else if (templateMessageEntity.getPlatformId() != null && templateMessageEntity.getPlatformId() == 4) {
                BaseJsonVo<MiniSubscribeMessage> result = this.getMiniTemplateMessageContent(templateMessageEntity, messageId, variable);
                if (result.isSuccess()) {
                    return BaseJsonVo.success((Object)result.getValue());
                }
                return BaseJsonVo.error((String)result.getMessage());
            }
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u9519\u8bef", (Throwable)e);
        }
        return BaseJsonVo.error((String)"\u7ec4\u7ec7\u6d88\u606f\u5360\u4f4d\u7b26Map\u5f02\u5e38");
    }

    private BaseJsonVo<TemplateMessage> getTemplateMessageContent(TemplateMessageEntity templateMessageEntity, Integer messageId, Map<String, String> variable) {
        TemplateMessage templateMessage = new TemplateMessage();
        templateMessage.setTemplate_id(templateMessageEntity.getTemplateId());
        templateMessage.setTouser("");
        if (StringUtils.isNotEmpty((String)templateMessageEntity.getUrl())) {
            templateMessage.setUrl(this.keywordInterface.replaceVariable(templateMessageEntity.getUrl(), variable));
            if (!templateMessageEntity.getUrl().startsWith("http")) {
                MiniprogramMessageRedirectItem miniprogramMessageRedirectItem = new MiniprogramMessageRedirectItem();
                miniprogramMessageRedirectItem.setAppid("wxccfc57d73bc81766");
                miniprogramMessageRedirectItem.setPagepath(templateMessage.getUrl());
                templateMessage.setMiniprogram(miniprogramMessageRedirectItem);
                templateMessage.setUrl("http://mp.weixin.qq.com");
            }
        }
        LinkedHashMap<String, TemplateMessageItem> data = new LinkedHashMap<String, TemplateMessageItem>();
        TemplateMessageItem first = new TemplateMessageItem();
        String firstContent = this.keywordInterface.replaceVariable(templateMessageEntity.getFirst(), variable);
        if (StringUtils.isNotEmpty((String)firstContent) && firstContent.contains("$")) {
            this.logger.error("\u6a21\u677f\u6d88{}\u606f\u5934\u6587\u672c\u5360\u4f4d\u5f02\u5e38", (Object)templateMessageEntity.getMessageName());
            return BaseJsonVo.error((String)"\u6a21\u677f\u6d88\u606f\u70b9\u4f4d\u5f02\u5e38");
        }
        first.setValue(firstContent);
        first.setColor(templateMessageEntity.getTopColor());
        data.put("first", first);
        if (templateMessageEntity.getVariable().isEmpty()) {
            return BaseJsonVo.error((String)"\u6a21\u677f\u6d88\u606f\u6ca1\u6709\u8bbe\u7f6ebody");
        }
        String bodyStr = this.keywordInterface.replaceVariable(templateMessageEntity.getVariable(), variable);
        if (StringUtils.isNotEmpty((String)bodyStr) && bodyStr.contains("$")) {
            this.logger.error("\u6a21\u677f\u6d88{}\u606f\u6587\u672c\u5360\u4f4d\u5f02\u5e38", (Object)templateMessageEntity.getMessageName());
            return BaseJsonVo.error((String)"\u6a21\u677f\u6d88\u606f\u70b9\u4f4d\u5f02\u5e38");
        }
        List bodyVos = JsonUtils.getListByArray(TemplateMessageBodyVo.class, (String)bodyStr);
        if (bodyVos == null || bodyVos.size() == 0) {
            return BaseJsonVo.error((String)"\u6a21\u677f\u6d88\u606f\u6ca1\u6709\u8bbe\u7f6ebody");
        }
        for (TemplateMessageBodyVo bodyVo : bodyVos) {
            TemplateMessageItem body = new TemplateMessageItem();
            body.setValue(bodyVo.getValue());
            body.setColor(bodyVo.getColor());
            data.put(bodyVo.getTitle(), body);
        }
        TemplateMessageItem remark = new TemplateMessageItem();
        String remarkContent = this.keywordInterface.replaceVariable(templateMessageEntity.getRemark(), variable);
        if (StringUtils.isNotEmpty((String)remarkContent) && remarkContent.contains("$")) {
            this.logger.error("\u6a21\u677f\u6d88{}\u606f\u5934remarkContent\u5c3e\u6587\u672c\u5360\u4f4d\u5f02\u5e38", (Object)templateMessageEntity.getMessageName());
            return BaseJsonVo.error((String)"\u6a21\u677f\u6d88\u606f\u70b9\u4f4d\u5f02\u5e38");
        }
        remark.setValue(remarkContent);
        remark.setColor(templateMessageEntity.getBottomColor());
        data.put("remark", remark);
        templateMessage.setData(data);
        return BaseJsonVo.success((Object)templateMessage);
    }

    private void setTemplateMessageEntity(TemplateMessageEntity templateMessageEntity) {
        List<TemplateMessageContentEntity> contentList = this.templateMessageContentInterface.getList(templateMessageEntity.getMessageId());
        if (CollectionUtils.isNotEmpty(contentList)) {
            String propertyMessageKey = templateMessageEntity.getMessageId() + ":" + templateMessageEntity.getMessageType() + ":MessageProperty";
            Object property = this.redisCacheUtil.get(propertyMessageKey);
            if (property != null) {
                ActivePropertyEntity activePropertyEntity = (ActivePropertyEntity)this.redisCacheUtil.get(propertyMessageKey);
                String key = activePropertyEntity.getBindCode() + ":" + templateMessageEntity.getMessageId() + ":" + DateUtils.date() + ":ExecRule";
                if (this.redisCacheUtil.get(key) != null) {
                    TemplateMessageContentEntity temp = (TemplateMessageContentEntity)this.redisCacheUtil.get(key);
                    BeanUtils.copyProperties((Object)temp, (Object)templateMessageEntity);
                    this.logger.info("\u63a8\u9001\u6a21\u677f\u5df2\u7f13\u5b58,\u6a21\u677f\u5185\u5bb9:{}", (Object)temp);
                } else {
                    List<WeekEnum> weekEnumList = WeekEnum.getList();
                    String week = weekEnumList.get(this.getLocalDate(DateUtils.now()).getDayOfWeek().getValue() - 1).getName();
                    this.logger.info("\u4eca\u5929\u662f\uff1a{}", (Object)week);
                    List tempList = contentList.stream().filter(content -> Objects.equals(content.getExecTypeValue(), week) && Objects.equals(TemplateExecTimeTypeEnum.ByWeek.getValue(), content.getExecType())).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(tempList)) {
                        int k = 0;
                        if (Integer.valueOf(activePropertyEntity.getPropertyRemark()).intValue() == TemplateExecOrderEnum.Sort.getValue()) {
                            int order = 0;
                            String orderKey = activePropertyEntity.getBindCode() + ":MarketMessage:order";
                            order = (Integer)this.redisCacheUtil.get(orderKey);
                            k = order % tempList.size();
                            BeanUtils.copyProperties(tempList.get(k), (Object)templateMessageEntity);
                            this.logger.info("\u63a8\u9001\u6a21\u677f\u987a\u5e8f{},\u6a21\u677f\u5185\u5bb9:{}", (Object)k, tempList.get(k));
                            this.redisCacheUtil.set(key, tempList.get(k), Long.valueOf(43200L));
                        } else if (Integer.valueOf(activePropertyEntity.getPropertyRemark()).intValue() == TemplateExecOrderEnum.Random.getValue()) {
                            if (this.redisCacheUtil.get(key) == null) {
                                k = RandomUtils.nextInt((int)1, (int)999);
                                k %= tempList.size();
                            }
                            BeanUtils.copyProperties(tempList.get(k), (Object)templateMessageEntity);
                            this.redisCacheUtil.set(key, tempList.get(k), Long.valueOf(43200L));
                        }
                    } else {
                        this.logger.info("\u6ca1\u6709\u914d\u7f6e:{}\u63a8\u9001\u7684\u6587\u6848", (Object)week);
                    }
                }
            } else {
                List<WeekEnum> weekEnumList = WeekEnum.getList();
                String week = weekEnumList.get(this.getLocalDate(DateUtils.now()).getDayOfWeek().getValue() - 1).getName();
                this.logger.info("\u4eca\u5929\u662f\uff1a{}", (Object)week);
                List tempList = contentList.stream().filter(content -> Objects.equals(content.getExecTypeValue(), week) && Objects.equals(TemplateExecTimeTypeEnum.ByWeek.getValue(), content.getExecType())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(tempList)) {
                    int k = RandomUtils.nextInt((int)1, (int)999);
                    BeanUtils.copyProperties(tempList.get(k %= tempList.size()), (Object)templateMessageEntity);
                }
            }
        } else {
            this.logger.info("\u6a21\u677f\u6d88\u606f:{}\u4e0d\u5b58\u5728\u591a\u5957\u6a21\u677f\u914d\u7f6e", (Object)templateMessageEntity.getMessageName());
        }
    }

    private LocalDate getLocalDate(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        LocalDate localDate = localDateTime.toLocalDate();
        return localDate;
    }

    private BaseJsonVo<MiniSubscribeMessage> getMiniTemplateMessageContent(TemplateMessageEntity templateMessageEntity, Integer messageId, Map<String, String> variable) {
        try {
            MiniSubscribeMessage templateMessage = new MiniSubscribeMessage();
            LinkedHashMap data = new LinkedHashMap();
            if (templateMessageEntity != null) {
                templateMessage.setTemplate_id(templateMessageEntity.getTemplateId());
                templateMessage.setTouser("");
                if (StringUtils.isNotEmpty((String)templateMessageEntity.getUrl())) {
                    templateMessage.setPage(this.keywordInterface.replaceVariable(templateMessageEntity.getUrl(), variable));
                }
                if (templateMessageEntity.getVariable().isEmpty()) {
                    return BaseJsonVo.error((String)"\u6a21\u677f\u6d88\u606f\u6ca1\u6709\u8bbe\u7f6ebody");
                }
                String bodyStr = this.keywordInterface.replaceVariable(templateMessageEntity.getVariable(), variable);
                List bodyVos = JsonUtils.getListByArray(TemplateMessageBodyVo.class, (String)bodyStr);
                if (bodyVos == null || bodyVos.size() == 0) {
                    return BaseJsonVo.error((String)"\u6a21\u677f\u6d88\u606f\u6ca1\u6709\u8bbe\u7f6ebody");
                }
                boolean errFlag = false;
                for (TemplateMessageBodyVo bodyVo : bodyVos) {
                    LinkedHashMap<String, String> item = new LinkedHashMap<String, String>();
                    String content = this.keywordInterface.replaceVariable(bodyVo.getValue(), variable);
                    if (content.contains("$")) {
                        errFlag = true;
                        break;
                    }
                    item.put("value", content);
                    data.put(bodyVo.getTitle(), item);
                }
                if (errFlag) {
                    return BaseJsonVo.error((String)"\u7ec4\u7ec7\u6d88\u606f\u5360\u4f4d\u7b26Map\u5f02\u5e38");
                }
                templateMessage.setData(data);
            }
            return BaseJsonVo.success((Object)templateMessage);
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u6a21\u677f\u6d88\u606f:{}\u51fa\u9519,", (Object)templateMessageEntity.toString());
            this.logger.error("\u67e5\u8be2\u9519\u8bef", (Throwable)e);
            return BaseJsonVo.error((String)"\u7ec4\u7ec7\u6d88\u606f\u5360\u4f4d\u7b26Map\u5f02\u5e38");
        }
    }

    private BaseJsonVo<MpSubscribeMessage> getMpSubscribeMessageContent(TemplateMessageEntity templateMessageEntity, Integer messageId, Map<String, String> variable) {
        try {
            MpSubscribeMessage templateMessage = new MpSubscribeMessage();
            LinkedHashMap data = new LinkedHashMap();
            if (templateMessageEntity != null) {
                templateMessage.setTemplate_id(templateMessageEntity.getTemplateId());
                templateMessage.setTouser("");
                if (StringUtils.isNotEmpty((String)templateMessageEntity.getUrl())) {
                    if (templateMessageEntity.getUrl().startsWith("http")) {
                        templateMessage.setPage(this.keywordInterface.replaceVariable(templateMessageEntity.getUrl(), variable));
                    } else {
                        LinkedHashMap<String, String> objectLinkedHashMap = new LinkedHashMap<String, String>();
                        objectLinkedHashMap.put("appid", templateMessageEntity.getAppid());
                        objectLinkedHashMap.put("pagepath", this.keywordInterface.replaceVariable(templateMessageEntity.getUrl(), variable));
                        templateMessage.setMiniprogram(objectLinkedHashMap);
                    }
                }
                if (templateMessageEntity.getVariable().isEmpty()) {
                    return BaseJsonVo.error((String)"\u6a21\u677f\u6d88\u606f\u6ca1\u6709\u8bbe\u7f6ebody");
                }
                String bodyStr = this.keywordInterface.replaceVariable(templateMessageEntity.getVariable(), variable);
                List bodyVos = JsonUtils.getListByArray(TemplateMessageBodyVo.class, (String)bodyStr);
                if (bodyVos == null || bodyVos.size() == 0) {
                    return BaseJsonVo.error((String)"\u6a21\u677f\u6d88\u606f\u6ca1\u6709\u8bbe\u7f6ebody");
                }
                boolean errFlag = false;
                for (TemplateMessageBodyVo bodyVo : bodyVos) {
                    LinkedHashMap<String, String> item = new LinkedHashMap<String, String>();
                    String content = this.keywordInterface.replaceVariable(bodyVo.getValue(), variable);
                    if (content.contains("$")) {
                        errFlag = true;
                        break;
                    }
                    item.put("value", content);
                    data.put(bodyVo.getTitle(), item);
                }
                if (errFlag) {
                    return BaseJsonVo.error((String)"\u7ec4\u7ec7\u6d88\u606f\u5360\u4f4d\u7b26Map\u5f02\u5e38");
                }
                templateMessage.setData(data);
            }
            return BaseJsonVo.success((Object)templateMessage);
        }
        catch (Exception e) {
            this.logger.info("\u67e5\u8be2\u9519\u8bef", (Throwable)e);
            return BaseJsonVo.error((String)"\u7ec4\u7ec7\u6d88\u606f\u5360\u4f4d\u7b26Map\u5f02\u5e38");
        }
    }

    @Override
    public Map<String, String> getTempMessageListByPage(String page, Integer platformId, String bindCode, Integer orderSource) {
        StringBuilder keyBuilder = new StringBuilder(page).append(platformId).append(bindCode == null ? "" : bindCode).append(orderSource == null ? "" : orderSource).append("TempMessage");
        String key = MD5.sign((String)keyBuilder.toString());
        Object cachedData = this.redisCacheUtil.get(key);
        if (cachedData instanceof Map) {
            return (Map)cachedData;
        }
        List<MallTemplateMessageSubcriptConfigEntity> list = this.mallTemplateMessageSubcriptConfigInterface.getTempMessageListByPage(page, platformId, bindCode, orderSource);
        if (CollectionUtils.isEmpty(list)) {
            this.logger.info("page={}, platformId={} \u9875\u9762\u6d88\u606f\u8ba2\u9605\u672a\u914d\u7f6e", (Object)page, (Object)platformId);
            return new HashMap<String, String>();
        }
        if (list.size() > 3) {
            list = list.stream().sorted(Comparator.comparing(MallTemplateMessageSubcriptConfigEntity::getCreatTime).reversed()).collect(Collectors.toList());
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (MallTemplateMessageSubcriptConfigEntity configEntity : list) {
            String event = Optional.ofNullable(configEntity.getEvent()).filter(e -> !e.isEmpty()).orElse("default");
            TemplateMessageEntity templateMessageEntity = this.getTemplateMessageById(configEntity.getTemplateId());
            if (templateMessageEntity == null) continue;
            map.compute(event, (key1, existingValue) -> {
                if (existingValue == null) {
                    return templateMessageEntity.getTemplateId();
                }
                String[] arr = existingValue.split(",");
                return arr.length < 3 ? existingValue + "," + templateMessageEntity.getTemplateId() : existingValue;
            });
        }
        this.redisCacheUtil.set(key, map, Long.valueOf(3600L));
        return map;
    }
}

