/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.dao.weixin.WeiXinGroupUserRefMapper;
import cc.lechun.mall.entity.weixin.WeiXinGroupUserRefEntity;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import cc.lechun.mall.iservice.weixin.WeiXinGroupUserInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.popular.api.UserAPI;
import weixin.popular.bean.BaseResult;

@Service
public class WeiXinGroupUserService
extends BaseService
implements WeiXinGroupUserInterface {
    @Autowired
    private WeiXinGroupUserRefMapper groupUserRefMapper;
    @Autowired
    private WeiXinBaseInterface baseInterface;
    @Autowired
    private MessageQueueService messageQueueService;

    @Override
    public Integer getGroupUserCount(String groupId) {
        return this.groupUserRefMapper.getGroupUserCount(groupId);
    }

    @Override
    public List<String> getGroupUserOpenIds(String groupId, int size, int[] status) {
        return this.groupUserRefMapper.getGroupUserOpenIds(groupId, size, status);
    }

    @Override
    public boolean updateGroupUserStatusBatch(String groupId, List<String> openIds) {
        return this.groupUserRefMapper.updateGroupUserStatusBatch(groupId, openIds, 1, "", "");
    }

    @Override
    public boolean updateGroupUserStatus(String groupId, String openId, int status) {
        ArrayList<String> openIds = new ArrayList<String>();
        openIds.add(openId);
        return this.groupUserRefMapper.updateGroupUserStatusBatch(groupId, openIds, status, "", "");
    }

    private WeiXinGroupUserRefEntity getSingle(String groupId, String openId) {
        WeiXinGroupUserRefEntity search = new WeiXinGroupUserRefEntity();
        search.setGroupId(groupId);
        search.setOpenId(openId);
        return (WeiXinGroupUserRefEntity)this.groupUserRefMapper.getSingle(search);
    }

    private List<WeiXinGroupUserRefEntity> getList(String groupId, String openId) {
        WeiXinGroupUserRefEntity search = new WeiXinGroupUserRefEntity();
        search.setGroupId(groupId);
        search.setOpenId(openId);
        return this.groupUserRefMapper.getList(search);
    }

    @Override
    public boolean deleteByGroupId(String groupId) {
        return this.groupUserRefMapper.deleteByGroupId(groupId);
    }

    @Override
    public Boolean uploadGroupUsers(int platformId, String groupId, Map<Integer, String> maps) {
        String accessToken = this.baseInterface.getAccessTokenValueByPlatformId(platformId);
        boolean tryBoolean = true;
        this.logger.info("uploadGroupUsers\u83b7\u53d6\u5206\u7ec4\u7528\u6237accessToken:" + accessToken);
        BaseResult s = UserAPI.groupsMembersBatchUpdate((String)accessToken, Arrays.stream(maps.values().toArray(new String[maps.size()])).collect(Collectors.toList()), (String)groupId);
        this.logger.info("uploadGroupUsers\u83b7\u53d6\u5206\u7ec4\u7528\u6237BaseResult:" + s.isSuccess() + "|" + s.getErrcode() + "|" + s.getErrmsg());
        if (s.isSuccess()) {
            this.groupUserRefMapper.updateGroupUserStatusBatchById(platformId + "_" + groupId, Arrays.stream(maps.keySet().toArray(new Integer[maps.size()])).collect(Collectors.toList()), 1);
        } else if ("49003".equals(s.getErrcode()) || "40003".equals(s.getErrcode()) || "45059".equals(s.getErrcode())) {
            ArrayList<String> user1 = new ArrayList<String>();
            Iterator<Map.Entry<Integer, String>> it = maps.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, String> entry = it.next();
                user1.add(entry.getValue());
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                s = UserAPI.groupsMembersBatchUpdate((String)accessToken, user1, (String)groupId);
                if (s.isSuccess()) {
                    this.groupUserRefMapper.updateGroupUserStatusBatch(platformId + "_" + groupId, user1, 1, "", "");
                    it.remove();
                } else if ("49003".equals(s.getErrcode()) || "40003".equals(s.getErrcode()) || "45059".equals(s.getErrcode())) {
                    this.groupUserRefMapper.updateGroupUserStatusBatch(platformId + "_" + groupId, user1, -1, s.getErrcode(), s.getErrmsg());
                    it.remove();
                }
                user1.remove(entry.getValue());
            }
            if (tryBoolean && maps.size() > 0) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("maps", maps);
                map.put("platformId", platformId);
                map.put("groupId", groupId);
                this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.uploadUsers, MessageParam.messageParam((String)"", map));
                this.groupUserRefMapper.updateGroupUserStatusBatch(platformId + "_" + groupId, Arrays.stream(maps.values().toArray(new String[maps.size()])).collect(Collectors.toList()), 0, "10000", "cms\u7cfb\u7edf\u91cd\u8bd5");
            }
        } else {
            if ("45011".equals(s.getErrcode())) {
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                this.groupUserRefMapper.updateGroupUserStatusBatch(platformId + "_" + groupId, Arrays.stream(maps.values().toArray(new String[maps.size()])).collect(Collectors.toList()), 0, s.getErrcode(), s.getErrmsg());
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("maps", maps);
                map.put("platformId", platformId);
                map.put("groupId", groupId);
                this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.uploadUsers, MessageParam.messageParam((String)"", map));
            }
            this.logger.error("uploadGroupUsers\u83b7\u53d6\u5206\u7ec4\u7528\u6237:" + s.isSuccess() + "|" + s.getErrcode() + "|" + s.getErrmsg());
        }
        return s.isSuccess();
    }
}

