/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.active.entity.active.ActivePropertyEntity;
import cc.lechun.common.constants.message.WechatMsgType;
import cc.lechun.common.enums.platform.PlatFormEnum;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.weixin.WeiXinKeywordMapper;
import cc.lechun.mall.entity.weixin.TemplateExecOrderEnum;
import cc.lechun.mall.entity.weixin.TemplateExecTimeTypeEnum;
import cc.lechun.mall.entity.weixin.WeekEnum;
import cc.lechun.mall.entity.weixin.WeiXinKeywordContentEntity;
import cc.lechun.mall.entity.weixin.WeiXinKeywordEntity;
import cc.lechun.mall.entity.weixin.WeiXinMediaEntity;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import cc.lechun.mall.iservice.weixin.WeiXinKeywordContentInterface;
import cc.lechun.mall.iservice.weixin.WeiXinKeywordInterface;
import cc.lechun.mall.iservice.weixin.WeiXinMediaInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.RandomUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.popular.api.MediaAPI;
import weixin.popular.bean.media.Media;
import weixin.popular.bean.media.MediaType;
import weixin.popular.bean.message.message.ImageMessage;
import weixin.popular.bean.message.message.MiniCardMessage;
import weixin.popular.bean.message.message.NewsMessage;
import weixin.popular.bean.message.message.TextMessage;

@Service
public class WeiXinKeywordService
extends BaseService
implements WeiXinKeywordInterface {
    @Autowired
    private WeiXinKeywordMapper weiXinKeywordMapper;
    @Autowired
    private WeiXinBaseInterface weiXinBaseService;
    @Autowired
    private OssService ossService;
    @Autowired
    private WeiXinMediaInterface mediaInterface;
    @Autowired
    WeiXinKeywordContentInterface weiXinKeywordContentInterface;

    @Override
    @ReadThroughSingleCache(namespace="WeiXinKeywordService.getWeiXinKeywordById")
    public WeiXinKeywordEntity getWeiXinKeywordById(@ParameterValueKeyProvider int id) {
        return (WeiXinKeywordEntity)this.weiXinKeywordMapper.selectByPrimaryKey(Integer.valueOf(id));
    }

    @Override
    public WeiXinKeywordEntity getKeywordByKeyword(String keyword, Integer platformId) {
        if (StringUtils.isEmpty((String)keyword)) {
            return null;
        }
        try {
            return this.weiXinKeywordMapper.getKeywordByKeyword(keyword, null);
        }
        catch (Exception e) {
            this.logger.error("keyword={},platformId={}", new Object[]{keyword, platformId, e});
            return null;
        }
    }

    @Override
    public List<WeiXinKeywordEntity> getKeywordByParentID(Integer id) {
        WeiXinKeywordEntity param = new WeiXinKeywordEntity();
        param.setParentId(id);
        return this.weiXinKeywordMapper.getList(param);
    }

    @Override
    public String getContent(WeiXinKeywordEntity keywordEntity, String para1, String para2, String para3) {
        String content = "";
        String string = content = StringUtils.isNotEmpty((String)keywordEntity.getTitle()) ? MessageFormat.format(keywordEntity.getTitle(), para1, para2, para3) : "";
        content = StringUtils.isNotEmpty((String)keywordEntity.getUrl()) ? content + "<a href='" + keywordEntity.getUrl() + "'>" + (StringUtils.isNotEmpty((String)keywordEntity.getContent()) ? keywordEntity.getContent() : "") + "</a>" : content + (StringUtils.isNotEmpty((String)keywordEntity.getContent()) ? keywordEntity.getContent() : "");
        return content;
    }

    @Override
    @ReadThroughSingleCache(namespace="WeiXinKeywordService.getKeywordMapContent")
    public Map<String, String> getKeywordMapContent(@ParameterValueKeyProvider Integer keywordId) {
        WeiXinKeywordEntity keywordEntity = this.getWeiXinKeywordById(keywordId);
        if (keywordEntity == null) {
            this.logger.info("\u914d\u7f6e\u7684\u5173\u952e\u5b57id{} \u5173\u952e\u5b57\u4e0d\u5b58\u5728", (Object)keywordId);
            return null;
        }
        return this.getKeywordMapContent(keywordEntity);
    }

    @Override
    public String replaceVariable(String src, Map<String, String> variable) {
        if (variable == null || variable.size() == 0) {
            return src;
        }
        for (String k : variable.keySet()) {
            src = src.replace("${" + k + "}", variable.get(k));
            src = src.replace("$" + k, variable.get(k));
            src = src.replace("{" + k + "}", variable.get(k));
        }
        return src;
    }

    @Override
    public BaseJsonVo getKeywordContent(Integer keywordId, Map<String, String> variable) {
        WeiXinKeywordEntity keywordEntity = this.getWeiXinKeywordById(keywordId);
        if (keywordEntity == null || keywordEntity.getId() < 0) {
            return BaseJsonVo.error((String)("\u67e5\u627e\u7684\u5173\u952e\u5b57{" + keywordId + "}\u4e0d\u5b58\u5728"));
        }
        return this.getKeywordContent(keywordEntity, variable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BaseJsonVo getKeywordContent(WeiXinKeywordEntity keywordEntity, Map<String, String> variable) {
        Map<String, String> map1 = this.getKeywordMapContent(keywordEntity);
        if (map1.size() == 0) {
            return BaseJsonVo.error((String)"\u5173\u952e\u5b57\u6ca1\u6709\u8bbe\u7f6e\u5185\u5bb9");
        }
        ImageMessage message = null;
        if (map1.containsKey(WechatMsgType.text)) {
            String content = this.replaceVariable(map1.get(WechatMsgType.text), variable);
            if (content.contains("${") || content.contains("{")) {
                this.logger.error("\u5173\u952e\u5b57\u70b9\u4f4d\u5f02\u5e38:{}", (Object)keywordEntity.toString());
                return BaseJsonVo.error((String)"\u7ec4\u7ec7\u6d88\u606f\u5360\u4f4d\u7b26Map\u5f02\u5e38");
            }
            message = new TextMessage("", content);
        } else if (map1.containsKey(WechatMsgType.news)) {
            List<WeiXinMediaEntity> mediaEntities = this.mediaInterface.getMediaListByMediaId(map1.get(WechatMsgType.news));
            ArrayList<NewsMessage.Article> articles = new ArrayList<NewsMessage.Article>();
            if (mediaEntities == null || mediaEntities.size() <= 0) return BaseJsonVo.error((String)"\u7d20\u6750\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u5173\u952e\u5b57\u6ca1\u6709\u5173\u8054\u7d20\u6750");
            for (WeiXinMediaEntity mediaEntity : mediaEntities) {
                NewsMessage.Article article = new NewsMessage.Article(mediaEntity.getTitle(), mediaEntity.getDigest(), mediaEntity.getUrl(), mediaEntity.getImageUrl());
                articles.add(article);
            }
            message = new NewsMessage("", articles);
        } else if (map1.containsKey(WechatMsgType.image)) {
            message = new ImageMessage("", map1.get(WechatMsgType.image));
        } else {
            if (!map1.containsKey(WechatMsgType.miniCard)) return BaseJsonVo.error((String)"\u6682\u4e0d\u652f\u6301\u8be5\u6d88\u606f\u7c7b\u578b\u7684\u53d1\u9001");
            if (StringUtils.isNotEmpty((String)keywordEntity.getImageUrl())) {
                String accessToken = this.weiXinBaseService.getAccessTokenValueByPlatformId(PlatFormEnum.LECHUN_WECHAT_MAIN.getValue());
                this.logger.info(" \u63a8\u9001\u5361\u7247\u6d88\u606f....{}", (Object)keywordEntity.getImageUrl());
                String mediaKey = keywordEntity.getId() + ":subcript:media";
                if (this.redisCacheUtil.get(mediaKey) != null) {
                    keywordEntity.setMediaId(this.redisCacheUtil.get(mediaKey).toString());
                    this.logger.info("\u5b58\u5728\u56fe\u7247\u7d20\u6750\u7f13\u5b58:{}", (Object)keywordEntity.getMediaId());
                } else {
                    try {
                        URI uri = new URI(keywordEntity.getImageUrl());
                        Media media = MediaAPI.mediaUpload((String)accessToken, (MediaType)MediaType.image, (URI)uri);
                        if (media == null) {
                            this.logger.error("\u4e0a\u4f20\u4e34\u65f6\u7d20\u6750\u51fa\u9519,{}", (Object)keywordEntity.toString());
                            return null;
                        }
                        keywordEntity.setMediaId(media.getMedia_id());
                        this.logger.info("\u4e0d\u5b58\u5728\u56fe\u7247\u7d20\u6750\u7f13\u5b58,\u65b0\u4e0a\u4f20\u56fe\u7247\u7d20\u6750:{}", (Object)keywordEntity.getMediaId());
                        this.redisCacheUtil.set(mediaKey, (Object)media.getMedia_id(), Long.valueOf(172800L));
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                }
                message = new MiniCardMessage("", keywordEntity.getTitle(), keywordEntity.getUrl(), keywordEntity.getMediaId());
                this.logger.info("\u5c0f\u7a0b\u5e8f\u5361\u7247:{}", (Object)JsonUtils.toJson((Object)message, (boolean)false));
            } else {
                this.logger.info("\u5c0f\u7a0b\u5e8f\u5361\u7247\u672a\u914d\u7f6e\u56fe\u7247\uff0c\u56fe\u7247\u4e3a\u7a7a{}", (Object)keywordEntity.toString());
                return BaseJsonVo.error((String)("\u5173\u952e\u5b57:" + keywordEntity.getKeyword() + "\u5c0f\u7a0b\u5e8f\u5361\u7247\u672a\u914d\u7f6e\u56fe\u7247"));
            }
        }
        if (message != null) return BaseJsonVo.success((Object)message);
        return BaseJsonVo.error((String)"\u6682\u4e0d\u652f\u6301\u8be5\u6d88\u606f\u7c7b\u578b\u7684\u53d1\u9001");
    }

    @Override
    public Map<String, String> getKeywordMapContent(WeiXinKeywordEntity keywordEntity) {
        HashMap<String, String> map = new HashMap<String, String>();
        this.setKeywordMessageEntity(keywordEntity);
        if (Objects.equals(keywordEntity.getType(), WechatMsgType.text)) {
            String outContent = keywordEntity.getTitle();
            if (StringUtils.isNotEmpty((String)keywordEntity.getUrl())) {
                outContent = keywordEntity.getUrl().startsWith("http") ? (StringUtils.isNotEmpty((String)keywordEntity.getContent()) ? outContent + "<a href='" + keywordEntity.getUrl() + "'>" + keywordEntity.getContent() + "</a>" : "<a href='" + keywordEntity.getUrl() + "'>" + outContent + "</a>") : (StringUtils.isNotEmpty((String)keywordEntity.getContent()) ? outContent + "<a data-miniprogram-appid=\"wxccfc57d73bc81766\" data-miniprogram-path=\"" + keywordEntity.getUrl() + "\" href='http://mp.weixin.qq.com'>" + keywordEntity.getContent() + "</a>" : "<a data-miniprogram-appid=\"wxccfc57d73bc81766\" data-miniprogram-path=\"" + keywordEntity.getUrl() + "\" href='http://mp.weixin.qq.com'>" + outContent + "</a>");
            } else if (StringUtils.isNotEmpty((String)keywordEntity.getContent())) {
                outContent = outContent + keywordEntity.getContent();
            }
            this.logger.info("\u63a8\u9001\u5185\u5bb9\u7ec4\u88c5:{}", (Object)outContent);
            map.put(keywordEntity.getType(), outContent);
        } else if (Objects.equals(keywordEntity.getType(), WechatMsgType.news)) {
            map.put(keywordEntity.getType(), keywordEntity.getMediaId());
        } else if (Objects.equals(keywordEntity.getType(), WechatMsgType.image)) {
            map.put(keywordEntity.getType(), keywordEntity.getMediaId());
        } else if (Objects.equals(keywordEntity.getType(), WechatMsgType.miniCard)) {
            map.put(keywordEntity.getType(), keywordEntity.getMediaId());
        }
        return map;
    }

    private void setKeywordMessageEntity(WeiXinKeywordEntity weiXinKeywordEntity) {
        List<WeiXinKeywordContentEntity> contentList = this.weiXinKeywordContentInterface.getKeyWordCotnetList(weiXinKeywordEntity.getId());
        if (CollectionUtils.isNotEmpty(contentList)) {
            String propertyMessageKey = weiXinKeywordEntity.getId() + ":1:MessageProperty";
            Object property = this.redisCacheUtil.get(propertyMessageKey);
            if (property != null) {
                ActivePropertyEntity activePropertyEntity = (ActivePropertyEntity)property;
                String key = activePropertyEntity.getBindCode() + ":" + weiXinKeywordEntity.getId() + ":" + DateUtils.date() + ":ExecRule";
                if (this.redisCacheUtil.get(key) != null) {
                    WeiXinKeywordContentEntity temp = (WeiXinKeywordContentEntity)this.redisCacheUtil.get(key);
                    BeanUtils.copyProperties((Object)temp, (Object)weiXinKeywordEntity);
                    this.logger.info("\u4ece\u7f13\u5b58\u4e2d\u53d6\u8981\u63a8\u9001\u7684\u6587\u6848:{}", (Object)weiXinKeywordEntity);
                } else {
                    List<WeekEnum> weekEnumList = WeekEnum.getList();
                    String week = weekEnumList.get(this.getLocalDate(DateUtils.now()).getDayOfWeek().getValue() - 1).getName();
                    this.logger.info("\u4eca\u5929\u662f\uff1a{}", (Object)week);
                    List tempList = contentList.stream().filter(content -> Objects.equals(content.getExecTypeValue(), week) && Objects.equals(TemplateExecTimeTypeEnum.ByWeek.getValue(), content.getExecType())).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(tempList)) {
                        int k = 0;
                        if (Integer.valueOf(activePropertyEntity.getPropertyRemark()).intValue() == TemplateExecOrderEnum.Sort.getValue()) {
                            Integer orderNo = Integer.valueOf(activePropertyEntity.getPropertyRemark());
                            boolean order = false;
                            String orderKey = activePropertyEntity.getBindCode() + ":MarketMessage:order";
                            Object object = this.redisCacheUtil.get(orderKey);
                            if (object != null) {
                                k = (Integer)object % tempList.size();
                                this.redisCacheUtil.set(key, tempList.get(k), Long.valueOf(86400L));
                                BeanUtils.copyProperties(tempList.get(k), (Object)weiXinKeywordEntity);
                                this.logger.info("\u63a8\u9001\u6587\u6848\u987a\u5e8f:{},\u63a8\u9001\u6587\u6848:{}", (Object)k, tempList.get(k));
                            }
                        } else if (Integer.valueOf(activePropertyEntity.getPropertyRemark()).intValue() == TemplateExecOrderEnum.Random.getValue()) {
                            if (this.redisCacheUtil.get(key) == null) {
                                k = RandomUtils.nextInt((int)1, (int)999);
                                k %= tempList.size();
                            }
                            this.redisCacheUtil.set(key, tempList.get(k), Long.valueOf(86400L));
                            BeanUtils.copyProperties(tempList.get(k), (Object)weiXinKeywordEntity);
                        }
                    } else {
                        this.logger.info("\u6ca1\u6709\u914d\u7f6e:{}\u63a8\u9001\u7684\u6587\u6848", (Object)week);
                    }
                }
            } else {
                this.logger.info("\u7f13\u5b58\u6ca1\u6709");
                this.setKeywordMessageEntity(contentList, weiXinKeywordEntity);
            }
        }
    }

    private void setKeywordMessageEntity(List<WeiXinKeywordContentEntity> contentList, WeiXinKeywordEntity weiXinKeywordEntity) {
        List<WeekEnum> weekEnumList = WeekEnum.getList();
        String week = weekEnumList.get(this.getLocalDate(DateUtils.now()).getDayOfWeek().getValue() - 1).getName();
        this.logger.info("\u4eca\u5929\u662f\uff1a{}", (Object)week);
        List tempList = contentList.stream().filter(content -> Objects.equals(content.getExecTypeValue(), week) && Objects.equals(TemplateExecTimeTypeEnum.ByWeek.getValue(), content.getExecType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(tempList)) {
            int k = Math.abs(DateUtils.now().hashCode());
            BeanUtils.copyProperties(tempList.get(k %= tempList.size()), (Object)weiXinKeywordEntity);
        } else {
            this.logger.info("\u6ca1\u6709\u914d\u7f6e:{}\u63a8\u9001\u7684\u6587\u6848", (Object)week);
        }
    }

    private LocalDate getLocalDate(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        LocalDate localDate = localDateTime.toLocalDate();
        return localDate;
    }
}

