/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.database.annotation.WriteDataSource;
import cc.lechun.mall.dao.weixin.WeiXinMediaMapper;
import cc.lechun.mall.entity.weixin.WeiXinMediaEntity;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import cc.lechun.mall.iservice.weixin.WeiXinMediaInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WeiXinMediaService
extends BaseService
implements WeiXinMediaInterface {
    @Autowired
    private WeiXinMediaMapper weiXinMediaMapper;
    @Autowired
    private WeiXinBaseInterface weiXinBaseService;
    @Autowired
    private OssService ossSerivce;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private PlatFormInterface platFormInterface;

    @Override
    @WriteDataSource
    public boolean saveMedia(WeiXinMediaEntity weiXinMedia) {
        weiXinMedia.setImageUrl(this.ossSerivce.removeUrlDomain(weiXinMedia.getImageUrl()));
        this.removeCache(weiXinMedia.getMediaId(), weiXinMedia.getId(), weiXinMedia.getPlatformId());
        if (weiXinMedia.getId() == null || weiXinMedia.getId() == 0) {
            return this.weiXinMediaMapper.insert(weiXinMedia) >= 1;
        }
        return this.weiXinMediaMapper.updateByPrimaryKeySelective(weiXinMedia) >= 1;
    }

    @Override
    @ReadThroughSingleCache(namespace="WeiXinMediaService.getWeiXinMediaById", expiration=300)
    public WeiXinMediaEntity getWeiXinMediaById(@ParameterValueKeyProvider Integer id) {
        WeiXinMediaEntity weiXinMedia = (WeiXinMediaEntity)this.weiXinMediaMapper.selectByPrimaryKey(id);
        weiXinMedia.setImageUrl(this.ossSerivce.getImageResoure(weiXinMedia.getImageUrl()));
        return weiXinMedia;
    }

    @Override
    public List<WeiXinMediaEntity> getMediaListByMediaId(String mediaId) {
        return this.weiXinMediaMapper.getMediaListByMediaId(mediaId);
    }

    @Override
    @ReadThroughSingleCache(namespace="WeiXinMediaService.getMediaByMediaId", expiration=300)
    public WeiXinMediaEntity getMediaByMediaId(@ParameterValueKeyProvider String mediaId) {
        WeiXinMediaEntity queryWeiXinMediaEntity = new WeiXinMediaEntity();
        queryWeiXinMediaEntity.setMediaId(mediaId);
        return this.getWeiXinMedia(queryWeiXinMediaEntity);
    }

    @Override
    public WeiXinMediaEntity getWeiXinMedia(WeiXinMediaEntity weiXinMediaEntity) {
        return (WeiXinMediaEntity)this.weiXinMediaMapper.getSingle(weiXinMediaEntity);
    }

    private void removeCache(String mediaId, Integer Id, Integer platformId) {
        this.memcachedService.delete("WeiXinMediaService.getMediaListByStatus", "1");
        this.memcachedService.delete("WeiXinMediaService.getMediaListByStatus", "0");
        this.memcachedService.delete("WeiXinMediaService.getMediaListByStatus", String.valueOf(Integer.MAX_VALUE));
        this.memcachedService.delete("WeiXinMediaService.getMediaListByMediaId", mediaId == null ? "" : mediaId);
        this.memcachedService.delete("WeiXinMediaService.getMediaByMediaId", mediaId == null ? "" : mediaId);
        this.memcachedService.delete("WeiXinMediaService.getMediaListByMediaId", mediaId == null ? "" : mediaId);
        this.memcachedService.delete("WeiXinMediaService.getWeiXinMediaById", String.valueOf(Id == null ? 0 : Id));
        this.memcachedService.delete("WeiXinMediaService.getMediaListForOption", String.valueOf(platformId));
    }
}

