/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.invite.ActiveInviteEntity;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.invite.ActiveInviteInterface;
import cc.lechun.active.vo.ActiveCashticketMessageVo;
import cc.lechun.common.cache.MallRedisLock;
import cc.lechun.common.constants.message.WechatMsgType;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.entity.weixin.WeiXinKeywordEntity;
import cc.lechun.mall.entity.weixin.WeiXinMediaEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import cc.lechun.mall.iservice.weixin.WeiXinKeywordInterface;
import cc.lechun.mall.iservice.weixin.WeiXinMediaInterface;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.popular.api.MediaAPI;
import weixin.popular.api.MessageAPI;
import weixin.popular.bean.media.Media;
import weixin.popular.bean.media.MediaType;
import weixin.popular.bean.message.EventMessage;
import weixin.popular.bean.message.message.Message;
import weixin.popular.bean.message.message.MiniCardMessage;
import weixin.popular.bean.message.message.TextMessage;
import weixin.popular.bean.xmlmessage.XMLImageMessage;
import weixin.popular.bean.xmlmessage.XMLMessage;
import weixin.popular.bean.xmlmessage.XMLNewsMessage;
import weixin.popular.bean.xmlmessage.XMLTextMessage;

@Service
public class WeiXinMessage
extends BaseService {
    @Autowired
    private ActiveInterface activeService;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private WeiXinMediaInterface weiXinMediaService;
    @Autowired
    private OssService ossInterface;
    @Autowired
    private WeiXinKeywordInterface weiXinKeywordService;
    @Autowired
    private ActiveCashticketInterface activeCashticketService;
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private ActiveInviteInterface activeInviteInterface;
    @Autowired
    private WeiXinBaseInterface weiXinBaseService;
    @Autowired
    private MessageInterface messageService;
    @Autowired
    private MallRedisLock mallRedisLock;

    public XMLMessage pushTextMessage(EventMessage eventMessage, String outContent) {
        XMLTextMessage xmlTextMessage = new XMLTextMessage(eventMessage.getFromUserName(), eventMessage.getToUserName(), outContent);
        return xmlTextMessage;
    }

    public XMLMessage pushCardMessage(EventMessage eventMessage, String outContent) {
        XMLTextMessage xmlTextMessage = new XMLTextMessage(eventMessage.getFromUserName(), eventMessage.getToUserName(), outContent);
        return xmlTextMessage;
    }

    public XMLMessage pushImageMessage(EventMessage eventMessage, String mediaId) {
        XMLImageMessage xmlImageMessage = new XMLImageMessage(eventMessage.getFromUserName(), eventMessage.getToUserName(), mediaId);
        return xmlImageMessage;
    }

    public XMLMessage pushMessage(EventMessage eventMessage, WeiXinKeywordEntity weiXinKeywordEntity, int platformId) {
        return this.pushMessage(eventMessage, weiXinKeywordEntity, platformId, new HashMap<String, String>());
    }

    public XMLMessage pushMessage(EventMessage eventMessage, WeiXinKeywordEntity weiXinKeywordEntity, int platformId, HashMap<String, String> paraMap) {
        if (weiXinKeywordEntity != null) {
            if ("coupon".equals(weiXinKeywordEntity.getType())) {
                String bindCodeCash = this.activeService.getActiveCouponByKeyWordId(weiXinKeywordEntity.getId());
                if (StringUtils.isNotEmpty((String)bindCodeCash)) {
                    ActiveCashticketMessageVo activeCashticketMessageVo = new ActiveCashticketMessageVo();
                    activeCashticketMessageVo.setBindCode(bindCodeCash);
                    activeCashticketMessageVo.setOpenId(eventMessage.getFromUserName());
                    activeCashticketMessageVo.setVersionDetailId("");
                    activeCashticketMessageVo.setSendMessage(true);
                    activeCashticketMessageVo.setPlatFormId(platformId);
                    this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.sendActiveCashTicket, MessageParam.messageParam((String)eventMessage.getFromUserName(), (Object)activeCashticketMessageVo));
                } else {
                    this.logger.info("\u5173\u952e\u5b57\u6ca1\u6709\u7ed1\u5b9a\u6d3b\u52a8\u6216\u6d3b\u52a8\u6ca1\u6709\u5173\u8054\u4f18\u60e0\u5238\u6216\u6d3b\u52a8\u5df2\u8fc7\u671f,\u5173\u952e\u5b57:{}", (Object)weiXinKeywordEntity.getKeyword());
                }
            } else if ("text".equals(weiXinKeywordEntity.getType())) {
                BaseJsonVo vo;
                BaseJsonVo baseJsonVo;
                if (weiXinKeywordEntity.getKeyword().endsWith("\u5206\u9500") && (baseJsonVo = this.activeService.getActiveByKeyWordId(weiXinKeywordEntity.getId())).isSuccess()) {
                    String bindCode;
                    Map map = (Map)baseJsonVo.getValue();
                    ActiveEntity activeEntity = (ActiveEntity)map.get("active");
                    if ((baseJsonVo = this.activeInviteInterface.saveActiveInviteByOpenId(activeEntity, bindCode = map.get("bindCode").toString(), eventMessage.getFromUserName(), platformId)).isSuccess()) {
                        ActiveInviteEntity activeInviteEntity = (ActiveInviteEntity)baseJsonVo.getValue();
                        paraMap.put("inviteId", activeInviteEntity.getInviteId());
                    } else {
                        this.logger.error("\u751f\u6210\u9080\u8bf7\u8bb0\u5f55\u6709\u8bef,{}", (Object)weiXinKeywordEntity.toString());
                    }
                }
                if ((vo = this.weiXinKeywordService.getKeywordContent(weiXinKeywordEntity, paraMap)).isSuccess()) {
                    TextMessage message = (TextMessage)vo.getValue();
                    return this.pushTextMessage(eventMessage, message.getText().getContent());
                }
            } else if (Objects.equals(WechatMsgType.miniCard, weiXinKeywordEntity.getType())) {
                BaseJsonVo baseJsonVo = this.weiXinKeywordService.getKeywordContent(weiXinKeywordEntity, paraMap);
                if (baseJsonVo.isSuccess()) {
                    String accessToken = this.weiXinBaseService.getAccessTokenValueByPlatformId(platformId);
                    MiniCardMessage message = (MiniCardMessage)baseJsonVo.getValue();
                    message.setTouser(eventMessage.getFromUserName());
                    MessageAPI.messageCustomSend((String)accessToken, (Message)message);
                }
            } else if ("image".equals(weiXinKeywordEntity.getType())) {
                if (StringUtils.isNotEmpty((String)weiXinKeywordEntity.getImageUrl())) {
                    this.logger.info(" \u63a8\u9001\u56fe\u7247\u6d88\u606f....{}", (Object)weiXinKeywordEntity.getImageUrl());
                    String mediaKey = weiXinKeywordEntity.getId() + ":subcript:media";
                    Object mediaId = this.redisCacheUtil.get(mediaKey);
                    if (mediaId == null && this.mallRedisLock.tryLock(mediaKey, 5000L)) {
                        try {
                            URI uri = new URI(weiXinKeywordEntity.getImageUrl());
                            String accessToken = this.weiXinBaseService.getAccessTokenValueByPlatformId(platformId);
                            Media media = MediaAPI.mediaUpload((String)accessToken, (MediaType)MediaType.image, (URI)uri);
                            if (media == null) {
                                this.logger.error("\u4e0a\u4f20\u4e34\u65f6\u7d20\u6750\u51fa\u9519,{}", (Object)weiXinKeywordEntity.toString());
                                return null;
                            }
                            mediaId = media.getMedia_id();
                            this.logger.info("\u4e0d\u5b58\u5728\u56fe\u7247\u7d20\u6750\u7f13\u5b58,\u65b0\u4e0a\u4f20\u56fe\u7247\u7d20\u6750:{}", (Object)weiXinKeywordEntity.getMediaId());
                            this.redisCacheUtil.set(mediaKey, mediaId, Long.valueOf(172800L));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.logger.error("\u67e5\u8be2\u5173\u952e\u5b57{}\u56fe\u7247\u7d20\u6750\u7f13\u5b58\u65f6\u51fa\u9519", (Object)weiXinKeywordEntity.getKeyword());
                        }
                    }
                    if (mediaId != null && StringUtils.isNotEmpty((String)mediaId.toString())) {
                        return this.pushImageMessage(eventMessage, mediaId.toString());
                    }
                } else {
                    this.logger.info("\u56fe\u7247\u4e3a\u7a7a{}", (Object)weiXinKeywordEntity.toString());
                }
            } else if ("news".equals(weiXinKeywordEntity.getType())) {
                if (StringUtils.isNotEmpty((String)weiXinKeywordEntity.getMediaId())) {
                    List<WeiXinMediaEntity> mediaList = this.weiXinMediaService.getMediaListByMediaId(weiXinKeywordEntity.getMediaId());
                    ArrayList<XMLNewsMessage.Article> list = new ArrayList<XMLNewsMessage.Article>();
                    if (mediaList.size() >= 1) {
                        for (WeiXinMediaEntity weiXinMedia : mediaList) {
                            XMLNewsMessage.Article item = new XMLNewsMessage.Article();
                            String url = weiXinMedia.getUrl();
                            item.setUrl(url);
                            item.setDescription(weiXinMedia.getDigest());
                            item.setPicurl(this.ossInterface.getImageResoure(weiXinMedia.getImageUrl()));
                            item.setTitle(weiXinMedia.getTitle());
                            list.add(item);
                        }
                        XMLNewsMessage xmlNewsMessage = new XMLNewsMessage(eventMessage.getFromUserName(), eventMessage.getToUserName(), list);
                        return xmlNewsMessage;
                    }
                }
            } else {
                this.logger.info("\u672a\u77e5\u7684\u5173\u952e\u5b57\u6d88\u606f\u7c7b\u578b:[{}]", (Object)weiXinKeywordEntity.getType());
            }
        }
        return null;
    }

    public XMLMessage pushMessage(EventMessage eventMessage, Integer keywordId, int platformId) {
        WeiXinKeywordEntity weiXinKeywordEntity;
        if (keywordId != null && keywordId > 0 && (weiXinKeywordEntity = this.weiXinKeywordService.getWeiXinKeywordById(keywordId)) != null) {
            HashSet<Integer> sended = new HashSet<Integer>();
            block0: for (int i = 0; i < 3 && sended.size() <= 3; ++i) {
                List<WeiXinKeywordEntity> subKeywords = this.weiXinKeywordService.getKeywordByParentID(weiXinKeywordEntity.getId());
                for (WeiXinKeywordEntity subKeyword : subKeywords) {
                    if (sended.size() > 3) continue block0;
                    if (sended.contains(subKeyword.getId())) continue;
                    BaseJsonVo keywordContent = this.weiXinKeywordService.getKeywordContent(subKeyword.getId(), null);
                    if (keywordContent.isSuccess()) {
                        Message value = (Message)keywordContent.getValue();
                        HashMap<Integer, Message> map = new HashMap<Integer, Message>();
                        map.put(1, value);
                        WeiXinKeywordEntity finalWeiXinKeywordEntity = weiXinKeywordEntity;
                        new Thread(() -> {
                            try {
                                Thread.currentThread();
                                Thread.sleep(200 * sended.size());
                            }
                            catch (InterruptedException e) {
                                this.logger.error("\u5173\u952e\u5b57\u53d1\u9001\u5173\u8054\u5173\u952e\u5b57[{}]\u5f02\u5e38\uff1a{}", (Object)subKeyword.getKeyword(), (Object)e);
                            }
                            BaseJsonVo baseJsonVo = this.messageService.sendWechatMessageBase(subKeyword.getPlatformId(), finalWeiXinKeywordEntity.getId(), eventMessage.getFromUserName(), map, true);
                            if (baseJsonVo.isSuccess()) {
                                this.logger.info("\u5173\u952e\u5b57\u53d1\u9001\u5173\u8054\u5173\u952e\u5b57[{}]\u6210\u529f\uff1a{}", (Object)subKeyword.getKeyword(), (Object)baseJsonVo.getMessage());
                            } else {
                                this.logger.error("\u5173\u952e\u5b57\u53d1\u9001\u5173\u8054\u5173\u952e\u5b57[{}]\u5931\u8d25\uff1a{}", (Object)subKeyword.getKeyword(), (Object)baseJsonVo.getMessage());
                            }
                        }).start();
                        sended.add(subKeyword.getId());
                        continue;
                    }
                    this.logger.error("\u5173\u952e\u5b57\u53d1\u9001\u5173\u8054\u5173\u952e\u5b57[{}]\u5931\u8d25\uff1a{}", (Object)subKeyword.getKeyword(), (Object)"\u65e0\u6cd5\u67e5\u8be2\u5230\u5173\u952e\u5b57Content");
                }
            }
            return this.pushMessage(eventMessage, weiXinKeywordEntity, platformId);
        }
        return null;
    }

    public XMLMessage pushMessage(EventMessage eventMessage, Integer keywordId, int platformId, HashMap<String, String> paraMap) {
        WeiXinKeywordEntity weiXinKeywordEntity;
        if (keywordId != null && keywordId > 0 && (weiXinKeywordEntity = this.weiXinKeywordService.getWeiXinKeywordById(keywordId)) != null) {
            return this.pushMessage(eventMessage, weiXinKeywordEntity, platformId, paraMap);
        }
        return null;
    }
}

