/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin.reply;

import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.InteractionTypeEnum;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.customer.InteractionInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import cc.lechun.mall.service.weixin.reply.MenuMessageHandle;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import weixin.popular.bean.message.EventMessage;
import weixin.popular.bean.xmlmessage.XMLMessage;

@Component
public class MenuMessageContext {
    private Map<String, MenuMessageHandle> messageHandle = new ConcurrentHashMap<String, MenuMessageHandle>();
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private InteractionInterface interactionInterface;
    @Autowired
    private MessageInterface messageService;

    @Autowired
    public MenuMessageContext(Map<String, MenuMessageHandle> messageHandle) {
        this.messageHandle.clear();
        messageHandle.forEach((k, v) -> this.messageHandle.put((String)k, (MenuMessageHandle)v));
    }

    public XMLMessage receiveMessage(EventMessage eventMessage, int platformId) {
        MenuMessageHandle menuMessageHandle;
        CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetailByOpenid(eventMessage.getFromUserName(), platformId);
        if (customerDetailVo != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("nickName", StringUtils.isNotEmpty((String)customerDetailVo.getNickName()) ? customerDetailVo.getNickName() : "");
            BaseJsonVo baseJsonVo = this.messageService.sendWechatMessage("clickMenu", customerDetailVo.getCustomerId(), map);
            this.interactionInterface.saveCustomerInteractionAsync(customerDetailVo.getCustomerId(), 1, InteractionTypeEnum.CLICK_MENU.getValue(), eventMessage.getEventKey() == null ? "" : eventMessage.getEventKey().toLowerCase(), platformId);
        }
        if ((menuMessageHandle = this.messageHandle.get(eventMessage.getEventKey().toLowerCase())) != null) {
            return menuMessageHandle.receiveMessage(eventMessage, platformId, customerDetailVo);
        }
        return null;
    }
}

