/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.youshu;

import cc.lechun.common.enums.cashticket.CashDiscountModeEnum;
import cc.lechun.mall.entity.cashticket.CashticketBatchEntity;
import cc.lechun.mall.entity.cashticket.CashticketBatchVo;
import cc.lechun.mall.entity.cashticket.CashticketCustomerEntity;
import cc.lechun.mall.service.youshu.DataSource;
import cc.lechun.mall.service.youshu.YouShuBase;
import cc.lechun.mall.service.youshu.ZhlsApiSignature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Objects;
import org.springframework.stereotype.Component;
import weixin.popular.api.YouShuCouponAPI;
import weixin.popular.bean.advertisement.YouShuBaseResult;
import weixin.popular.bean.youshu.coupon.ConsumeCustomerCoupon;
import weixin.popular.bean.youshu.coupon.CouponData;
import weixin.popular.bean.youshu.coupon.CustomerCoupon;
import weixin.popular.util.JsonUtil;

@Component
public class CouponService
extends YouShuBase {
    public void addCoupon(CashticketBatchEntity cashticketBatchEntity) {
        CouponData couponData = new CouponData();
        String orderSource = this.getOrderSource(DataSource.active_info.getName());
        couponData.setDataSourceId(orderSource);
        CouponData.CouponInfo couponInfo = new CouponData.CouponInfo();
        couponInfo.setCoupon_name(cashticketBatchEntity.getTicketBatchName());
        couponInfo.setCoupon_sub_type(Integer.valueOf(Objects.equals(CashDiscountModeEnum.manjian.getValue(), cashticketBatchEntity.getDiscountMode().intValue()) ? 1 : 2));
        couponInfo.setExternal_coupon_id(cashticketBatchEntity.getTicketBatchId());
        couponInfo.setAmount_minimum(cashticketBatchEntity.getAmountMin());
        if (couponInfo.getCoupon_sub_type() == 1) {
            couponInfo.setAmount_coupon(cashticketBatchEntity.getAmount());
        } else if (couponInfo.getCoupon_sub_type() == 2) {
            couponInfo.setDiscount_coupon(new BigDecimal(cashticketBatchEntity.getDiscountAmount()));
            couponInfo.setMax_discount_amount(new BigDecimal(10000));
        }
        ArrayList<CouponData.CouponInfo> list = new ArrayList<CouponData.CouponInfo>();
        list.add(couponInfo);
        couponData.setCoupons(list);
        couponData.setDataSourceId(orderSource);
        try {
            String data = JsonUtil.toJSONString((Object)couponData);
            String url = ZhlsApiSignature.sign(this.app_id, this.app_secret);
            YouShuBaseResult youShuBaseResult = YouShuCouponAPI.addCoupon((String)this.baseUrl, (String)url, (String)data);
            this.logger.info("\u5361\u5238:{},\u4e0a\u62a5\u5361\u5238\u4fe1\u606f:{},msg={}", new Object[]{cashticketBatchEntity.getTicketBatchName(), data, youShuBaseResult.toString()});
        }
        catch (Exception e) {
            this.logger.error("\u6709\u6570\u5361\u5238\u4e0a\u62a5\u51fa\u9519:", (Throwable)e);
        }
    }

    public void addCoupon(CashticketBatchVo cashticketBatchVo) {
        CouponData couponData = new CouponData();
        String orderSource = this.getOrderSource(DataSource.active_info.getName());
        couponData.setDataSourceId(orderSource);
        CouponData.CouponInfo couponInfo = new CouponData.CouponInfo();
        couponInfo.setCoupon_name(cashticketBatchVo.getTicketBatchName());
        couponInfo.setCoupon_sub_type(Integer.valueOf(Objects.equals(CashDiscountModeEnum.manjian.getValue(), cashticketBatchVo.getDiscountMode().intValue()) ? 1 : 2));
        couponInfo.setExternal_coupon_id(cashticketBatchVo.getTicketBatchId());
        couponInfo.setAmount_minimum(cashticketBatchVo.getAmountMin());
        if (couponInfo.getCoupon_sub_type() == 1) {
            couponInfo.setAmount_coupon(cashticketBatchVo.getAmount());
        } else if (couponInfo.getCoupon_sub_type() == 2) {
            couponInfo.setDiscount_coupon(new BigDecimal(cashticketBatchVo.getDiscountAmount()));
            couponInfo.setMax_discount_amount(new BigDecimal(10000));
        }
        ArrayList<CouponData.CouponInfo> list = new ArrayList<CouponData.CouponInfo>();
        list.add(couponInfo);
        couponData.setCoupons(list);
        String data = JsonUtil.toJSONString((Object)couponData);
        try {
            String url = ZhlsApiSignature.sign(this.app_id, this.app_secret);
            YouShuBaseResult youShuBaseResult = YouShuCouponAPI.addCoupon((String)this.baseUrl, (String)url, (String)data);
            this.logger.info("\u5361\u5238:{},\u4e0a\u62a5\u5361\u5238\u4fe1\u606f:{},msg={}", new Object[]{cashticketBatchVo.getTicketBatchName(), data, youShuBaseResult.toString()});
        }
        catch (Exception e) {
            this.logger.error("\u6709\u6570\u5361\u5238\u4e0a\u62a5\u51fa\u9519:", (Throwable)e);
        }
    }

    public void getCoupon(CashticketCustomerEntity cashticketCustomerEntity, String appId, String openId) {
        CustomerCoupon customerCoupon = new CustomerCoupon();
        String orderSource = this.getOrderSource(DataSource.active_info.getName());
        customerCoupon.setDataSourceId(orderSource);
        ArrayList<CustomerCoupon.CustomerCouponInfo> coupons = new ArrayList<CustomerCoupon.CustomerCouponInfo>();
        CustomerCoupon.CustomerCouponInfo customerCouponInfo = new CustomerCoupon.CustomerCouponInfo();
        customerCouponInfo.setExternal_coupon_id(cashticketCustomerEntity.getTicketBatchId());
        customerCouponInfo.setCoupon_code(cashticketCustomerEntity.getTicketCustomerId().toString());
        customerCouponInfo.setGet_time(String.valueOf(cashticketCustomerEntity.getCreateTime().getTime()));
        CustomerCoupon.UserInfo user = new CustomerCoupon.UserInfo();
        user.setMiniprogram_appid(appId);
        user.setOpen_id(openId);
        customerCouponInfo.setUser(user);
        coupons.add(customerCouponInfo);
        customerCoupon.setCoupons(coupons);
        try {
            String url = ZhlsApiSignature.sign(this.app_id, this.app_secret);
            String data = JsonUtil.toJSONString((Object)customerCoupon);
            YouShuBaseResult youShuBaseResult = YouShuCouponAPI.getCoupon((String)this.baseUrl, (String)url, (String)data);
            this.logger.info("\u5361\u5238id:{},\u4e0a\u62a5\u9886\u53d6\u5361\u5238\u4fe1\u606f:{},msg={}", new Object[]{cashticketCustomerEntity.getTicketCustomerId(), data, youShuBaseResult.toString()});
        }
        catch (Exception e) {
            this.logger.error("\u6709\u6570\u9886\u53d6\u5361\u5238\u4e0a\u62a5\u51fa\u9519:", (Throwable)e);
        }
    }

    public void consume(CashticketCustomerEntity cashticketCustomerEntity, String appId, String openId) {
        try {
            this.logger.info("\u5f00\u59cb\u4e0a\u62a5\u7528\u6237:{}\u4f18\u60e0\u5238:{} appId:{},\u6838\u9500", new Object[]{openId, cashticketCustomerEntity.getOrderMainNo(), appId});
            ConsumeCustomerCoupon consumeCustomerCoupon = new ConsumeCustomerCoupon();
            String orderSource = this.getOrderSource(DataSource.active_info.getName());
            consumeCustomerCoupon.setDataSourceId(orderSource);
            ConsumeCustomerCoupon.CustomerCouponInfo customerCouponInfo = new ConsumeCustomerCoupon.CustomerCouponInfo();
            customerCouponInfo.setConsume_time(String.valueOf(cashticketCustomerEntity.getUsedTime().getTime()));
            customerCouponInfo.setCoupon_code(cashticketCustomerEntity.getTicketCustomerId().toString());
            customerCouponInfo.setExternal_coupon_id(cashticketCustomerEntity.getTicketBatchId());
            ArrayList<ConsumeCustomerCoupon.CustomerCouponInfo> couponList = new ArrayList<ConsumeCustomerCoupon.CustomerCouponInfo>();
            ConsumeCustomerCoupon.UserInfo userInfo = new ConsumeCustomerCoupon.UserInfo();
            userInfo.setMiniprogram_appid(appId);
            userInfo.setOpen_id(openId);
            customerCouponInfo.setUser(userInfo);
            couponList.add(customerCouponInfo);
            consumeCustomerCoupon.setCoupons(couponList);
            String url = ZhlsApiSignature.sign(this.app_id, this.app_secret);
            String data = JsonUtil.toJSONString((Object)consumeCustomerCoupon);
            YouShuBaseResult youShuBaseResult = YouShuCouponAPI.consume((String)this.baseUrl, (String)url, (String)data);
            this.logger.info("\u5361\u5238id:{},\u4e0a\u62a5\u6838\u9500\u5361\u5238\u4fe1\u606f:{},msg={}", (Object)cashticketCustomerEntity.getTicketCustomerId(), (Object)youShuBaseResult.getRetcode());
        }
        catch (Exception e) {
            this.logger.error("\u6709\u6570\u9886\u53d6\u5361\u5238\u4e0a\u62a5\u51fa\u9519:", (Throwable)e);
        }
    }
}

