/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.youshu;

import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import cc.lechun.mall.service.youshu.DataSource;
import cc.lechun.mall.service.youshu.YouShuBase;
import cc.lechun.mall.service.youshu.ZhlsApiSignature;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import weixin.popular.api.AdWechatAPI;
import weixin.popular.bean.advertisement.DataSourceResult;

@Component
public class DataSourceService
extends YouShuBase {
    @Autowired
    private WeiXinBaseInterface weiXinBaseInterface;
    @Autowired
    private DictionaryInterface dictionaryInterface;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public void createDataSource(Integer platformGroupId) {
        List<DataSource> list = DataSource.getList();
        if (list.size() > 0) {
            try {
                this.logger.info("\u521b\u5efa\u817e\u8baf\u6709\u6570\u6570\u636e\u6e90 appId:{},secret:{},baseUrl:{}", new Object[]{this.app_id, this.app_secret, this.baseUrl});
                String url = ZhlsApiSignature.sign(this.app_id, this.app_secret);
                for (DataSource dataSource : list) {
                    DataSourceResult dataSourceResult = AdWechatAPI.createDatasource((String)this.baseUrl, (String)url, (String)this.merchantId, (int)dataSource.getValue());
                    if (dataSourceResult == null) continue;
                    this.logger.info("\u521b\u5efa\u817e\u8baf\u6709\u6570\u6570\u636e\u6e90:{}", (Object)dataSourceResult.toString());
                    if (dataSourceResult.getRetcode() != 0) continue;
                    this.creatDataSource(platformGroupId, dataSource, dataSourceResult);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void createDataSource(Integer dataSourceType, String itemName, Integer platformGroupId) {
        try {
            this.logger.info("\u521b\u5efa\u817e\u8baf\u6709\u6570\u6570\u636e\u6e90 appId:{},secret:{},baseUrl:{}", new Object[]{this.app_id, this.app_secret, this.baseUrl});
            String url = ZhlsApiSignature.sign(this.app_id, this.app_secret);
            DataSourceResult dataSourceResult = AdWechatAPI.createDatasource((String)this.baseUrl, (String)url, (String)this.merchantId, (int)dataSourceType);
            if (dataSourceResult != null) {
                this.logger.info("\u521b\u5efa\u817e\u8baf\u6709\u6570\u6570\u636e\u6e90:{}", (Object)dataSourceResult.toString());
                if (dataSourceResult.getRetcode() == 0) {
                    this.creatDataSource(platformGroupId, dataSourceType, itemName, dataSourceResult);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void creatDataSource(Integer platformGroupId, DataSource dataSource, DataSourceResult dataSourceResult) {
        this.creatDataSource(platformGroupId, dataSource.getValue(), dataSource.getName(), dataSourceResult);
    }

    private void creatDataSource(Integer platformGroupId, Integer dataSourceType, String itemName, DataSourceResult dataSourceResult) {
        DictionaryEntity query = new DictionaryEntity();
        query.setDictionaryTypeId(213);
        query.setDictionaryKey(String.valueOf(dataSourceType));
        DictionaryEntity one = this.dictionaryInterface.getSingle(query);
        if (one == null) {
            DictionaryEntity dictionaryEntity = new DictionaryEntity();
            dictionaryEntity.setDictionaryKey(String.valueOf(dataSourceType));
            String name = "";
            if (dataSourceResult.getData().getJSONObject("dataSource") != null) {
                name = dataSourceResult.getData().getJSONObject("dataSource").getInteger("id").toString();
            } else {
                JSONObject jsonObject = dataSourceResult.getData().getJSONArray("dataSources").getJSONObject(0);
                name = jsonObject.getInteger("id").toString();
            }
            dictionaryEntity.setDictionaryName(name);
            dictionaryEntity.setRemark("\u817e\u8baf\u6709\u6570" + itemName + "\u6570\u636e\u6e90");
            dictionaryEntity.setSort((short)dataSourceResult.getRetcode().intValue());
            dictionaryEntity.setDictionaryTypeId(213);
            dictionaryEntity.setPlatformGroupId(platformGroupId == null ? 1000 : platformGroupId);
            this.dictionaryInterface.saveDictionary(dictionaryEntity.getPlatformGroupId(), dictionaryEntity.getDictionaryTypeId(), dictionaryEntity.getDictionaryKey(), dictionaryEntity.getDictionaryName(), dictionaryEntity.getSort().shortValue(), dictionaryEntity.getRemark());
        } else if (dataSourceResult.getData().getJSONArray("dataSources") != null) {
            String name = dataSourceResult.getData().getJSONArray("dataSources").getJSONObject(0).getString("id");
            one.setDictionaryName(name);
            this.dictionaryInterface.updateDictionary(one.getDictionaryId(), one.getDictionaryKey(), name, one.getSort().shortValue(), one.getRemark());
        }
    }

    public void getDataSource(Integer platformGroupId) {
        List<DataSource> list = DataSource.getList();
        if (list.size() > 0) {
            try {
                String url = ZhlsApiSignature.sign(this.app_id, this.app_secret);
                for (DataSource dataSource : list) {
                    DataSourceResult dataSourceResult = AdWechatAPI.getDatasource((String)this.baseUrl, (String)url, (String)this.merchantId, (int)dataSource.getValue());
                    if (dataSourceResult == null) continue;
                    this.logger.info("\u67e5\u8be2\u817e\u8baf\u6709\u6570\u6570\u636e\u6e90:source={},{}", (Object)dataSource, (Object)dataSourceResult.toString());
                    if (dataSourceResult.getRetcode() != 0) continue;
                    this.creatDataSource(platformGroupId, dataSource, dataSourceResult);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

