/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.youshu;

import cc.lechun.common.enums.pay.PayTypeEnum;
import cc.lechun.common.enums.trade.OrderClassEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.core.database.util.SpringContextUtil;
import cc.lechun.mall.entity.cashticket.CashticketCustomerEntity;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderGroupProductEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.entity.weixin.WeiXinBaseEntity;
import cc.lechun.mall.iservice.cashticket.CashticketCustomerInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.trade.MallOrderGroupProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import cc.lechun.mall.service.youshu.DataSource;
import cc.lechun.mall.service.youshu.OrderSource;
import cc.lechun.mall.service.youshu.OrderStatus;
import cc.lechun.mall.service.youshu.OrderType;
import cc.lechun.mall.service.youshu.PaymentType;
import cc.lechun.mall.service.youshu.YouShuBase;
import cc.lechun.mall.service.youshu.ZhlsApiSignature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;
import weixin.popular.api.YouShuOrderAPI;
import weixin.popular.bean.advertisement.YouShuBaseResult;
import weixin.popular.bean.youshu.order.MainOrderData;
import weixin.popular.bean.youshu.order.ModifyOrder;
import weixin.popular.bean.youshu.order.OrderSum;
import weixin.popular.bean.youshu.order.OrderSumItem;
import weixin.popular.bean.youshu.order.RefundOrder;
import weixin.popular.util.JsonUtil;

@Component
public class OrderDataService
extends YouShuBase {
    @Autowired
    private WeiXinBaseInterface weiXinBaseInterface;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private MallOrderGroupProductInterface orderGroupProductInterface;
    @Autowired
    private MallOrderPayInterface orderPayInterface;
    @Autowired
    private CashticketCustomerInterface cashticketCustomerInterface;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Lazy
    @Autowired
    private MallOrderInterface orderInterface;
    @Autowired
    private MallGroupInterface mallGroupInterface;

    @Retryable(value={Exception.class}, maxAttempts=3, backoff=@Backoff(delay=10000L, multiplier=2.0))
    public void addOrder(MallOrderMainEntity orderMainEntity) {
        if (orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARDPLAN.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_TMALL.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_JD_POP.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_CHANNEL.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_JD_SELF_RUN.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_THIRD_PARTY_CHANNEL.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_THIRD_PARTY_STRATEGY.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_SHOP.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.RECHANGE_CARD.getValue()) {
            return;
        }
        CustomerDetailVo customerDetailVo = this.customerInterface.getCustomerDetail(orderMainEntity.getCustomerId(), orderMainEntity.getPlatformId());
        if (customerDetailVo == null) {
            this.logger.error("\u975e\u5fae\u4fe1\u6e20\u9053\u8ba2\u5355:{},customerId:{}", (Object)orderMainEntity.getOrderMainNo(), (Object)orderMainEntity.getCustomerId());
            return;
        }
        try {
            String url = ZhlsApiSignature.sign(this.app_id, this.app_secret);
            String data = "";
            List<MallOrderGroupProductEntity> productList = this.orderGroupProductInterface.getOrderGroupProductListByMianOrderNo(orderMainEntity.getOrderMainNo());
            if (CollectionUtils.isEmpty(productList)) {
                throw new RuntimeException("\u8ba2\u5355\u5546\u54c1\u4e3a\u7a7a");
            }
            String orderSource = this.getOrderSource(DataSource.main_order.getName());
            MainOrderData mainOrderData = new MainOrderData();
            mainOrderData.setDataSourceId(orderSource);
            MainOrderData.Order order = new MainOrderData.Order();
            ArrayList<MainOrderData.Order> orders = new ArrayList<MainOrderData.Order>();
            mainOrderData.setOrders(orders);
            order.setCreate_time(String.valueOf(orderMainEntity.getCreateTime().getTime()));
            order.setExternal_order_id(orderMainEntity.getOrderMainNo());
            order.setFreight_amount(orderMainEntity.getFreight());
            order.setGoods_amount_total(PriceUtils.subtract((BigDecimal)orderMainEntity.getTotalAmount(), (BigDecimal)orderMainEntity.getFreight()));
            order.setPayment_amount(PriceUtils.add((BigDecimal)orderMainEntity.getOrderAmount(), (BigDecimal)orderMainEntity.getFreight()));
            order.setPayable_amount(orderMainEntity.getTotalAmount());
            if (orderMainEntity.getStatus() >= 4 && orderMainEntity.getStatus() < 16) {
                order.setOrder_status(OrderStatus.getName(10));
            } else {
                order.setOrder_status(OrderStatus.getName(orderMainEntity.getStatus()));
            }
            order.setStatus_change_time(String.valueOf(DateUtils.now().getTime()));
            int orderType = OrderType.common_order.getValue();
            if (orderMainEntity.getOrderClass().intValue() == OrderClassEnum.CHARGE_ORDER.getValue() || orderMainEntity.getOrderSource() == 18 || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY.getValue()) {
                orderType = OrderType.add_recharge_order.getValue();
            }
            order.setOrder_type(Integer.valueOf(orderType));
            order.setOrder_source(orderMainEntity.getPlatformId() == 1 ? OrderSource.mobileweb.getName() : (orderMainEntity.getPlatformId() == 4 ? OrderSource.wxapp.getName() : OrderSource.other.getName()));
            order.setOrder_amount(orderMainEntity.getTotalAmount());
            order.setGoods_num_total(Integer.valueOf(productList.stream().mapToInt(MallOrderGroupProductEntity::getQuantity).sum()));
            MainOrderData.UserInfo userInfo = new MainOrderData.UserInfo();
            userInfo.setOpen_id(customerDetailVo.getOpenId());
            userInfo.setUnion_id(customerDetailVo.getUnionid());
            userInfo.setUser_id(orderMainEntity.getCustomerId());
            WeiXinBaseEntity weiXinBaseEntity = this.weiXinBaseInterface.getWeixinBaseByFlatformId(orderMainEntity.getPlatformId());
            userInfo.setApp_id(weiXinBaseEntity.getAppid());
            order.setUser_info(userInfo);
            ArrayList goodsInfoList = new ArrayList();
            if (productList.size() > 0) {
                productList.stream().collect(Collectors.toMap(MallOrderGroupProductEntity::getProductId, Function.identity(), (p1, p2) -> {
                    p1.setQuantity(p1.getQuantity() + p2.getQuantity());
                    p1.setOriginPriceSum(PriceUtils.add((BigDecimal)p1.getOriginPriceSum(), (BigDecimal)p2.getOriginPriceSum()));
                    return p1;
                })).forEach((k, v) -> {
                    MainOrderData.GoodsInfo goodsInfo = new MainOrderData.GoodsInfo();
                    MallOrderGroupProductEntity orderGroupProductEntity = v;
                    goodsInfo.setExternal_sku_id(v.getProductId());
                    goodsInfo.setGoods_amount(orderGroupProductEntity.getUnitPrice());
                    goodsInfo.setGoods_num(orderGroupProductEntity.getQuantity());
                    goodsInfo.setPayment_amount(orderGroupProductEntity.getOriginPriceSum());
                    goodsInfo.setSku_name_chinese(orderGroupProductEntity.getProductName());
                    goodsInfo.setSpu_name_chinese(orderGroupProductEntity.getProductName());
                    goodsInfo.setExternal_spu_id(orderGroupProductEntity.getProductId());
                    goodsInfoList.add(goodsInfo);
                });
                order.setGoods_info(goodsInfoList);
            }
            ArrayList<MainOrderData.CouponInfo> couponInfoList = new ArrayList<MainOrderData.CouponInfo>();
            ArrayList<MainOrderData.PaymentInfo> paymentInfoList = new ArrayList<MainOrderData.PaymentInfo>();
            List<MallOrderPayEntity> orderPayList = this.orderPayInterface.getList(orderMainEntity.getOrderMainNo());
            if (orderPayList.size() > 0) {
                List<MallOrderPayEntity> cashPayList = orderPayList.stream().filter(pay -> pay.getPaytypeId().intValue() == PaymentType.coupon.getValue()).collect(Collectors.toList());
                MainOrderData.CouponInfo couponInfo = new MainOrderData.CouponInfo();
                if (cashPayList != null && cashPayList.size() > 0) {
                    couponInfo.setCoupon_amount_total(cashPayList.stream().map(MallOrderPayEntity::getPayamount).reduce(BigDecimal.ZERO, BigDecimal::add));
                    couponInfo.setCoupon_type(Integer.valueOf(1));
                    couponInfo.setCoupon_sub_type(Integer.valueOf(1));
                    couponInfoList.add(couponInfo);
                    order.setCoupon_info(couponInfoList);
                    ArrayList couponDetailList = new ArrayList();
                    cashPayList.forEach(orderPay -> {
                        MainOrderData.CouponDetail couponDetail = new MainOrderData.CouponDetail();
                        couponDetail.setExternal_coupon_id(String.valueOf(orderPay.getCashticketId()));
                        CashticketCustomerEntity cashticketCustomerEntity = this.cashticketCustomerInterface.getCashticketCustomer(orderPay.getCashticketId());
                        couponDetail.setExternal_coupon_id(cashticketCustomerEntity == null ? "" : cashticketCustomerEntity.getTicketBatchId());
                        couponDetail.setCoupon_name(orderPay.getCashticketNo());
                        couponDetail.setCoupon_amount(orderPay.getPayamount());
                        couponDetailList.add(couponDetail);
                    });
                    couponInfo.setCoupon_detail(couponDetailList);
                    order.setCoupon_info(couponInfoList);
                }
                MainOrderData.PaymentInfo paymentInfo = new MainOrderData.PaymentInfo();
                BigDecimal payAmount = orderPayList.stream().filter(pay -> pay.getPaytypeId().intValue() == PayTypeEnum.BANK_PAY.getValue() || pay.getPaytypeId().intValue() == PayTypeEnum.WECHAT_PAY.getValue() || pay.getPaytypeId().intValue() == PayTypeEnum.ALIPAY_PAY.getValue() || pay.getPaytypeId().intValue() == PayTypeEnum.BALANCE_PAY.getValue()).map(MallOrderPayEntity::getPayamount).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (payAmount.compareTo(BigDecimal.ZERO) > 0) {
                    paymentInfo.setPayment_type(PaymentType.getName(orderPayList.stream().filter(pay -> pay.getPaytypeId().intValue() == PayTypeEnum.BANK_PAY.getValue() || pay.getPaytypeId().intValue() == PayTypeEnum.WECHAT_PAY.getValue() || pay.getPaytypeId().intValue() == PayTypeEnum.ALIPAY_PAY.getValue() || pay.getPaytypeId().intValue() == PayTypeEnum.BALANCE_PAY.getValue() || pay.getPaytypeId().intValue() == PayTypeEnum.BALANCE_PAY.getValue()).findFirst().get().getPaytypeId()));
                    paymentInfo.setTrans_id(orderPayList.stream().filter(pay -> pay.getPaytypeId().intValue() == PayTypeEnum.BANK_PAY.getValue() || pay.getPaytypeId().intValue() == PayTypeEnum.WECHAT_PAY.getValue() || pay.getPaytypeId().intValue() == PayTypeEnum.ALIPAY_PAY.getValue() || pay.getPaytypeId().intValue() == PayTypeEnum.BALANCE_PAY.getValue() || pay.getPaytypeId().intValue() == PayTypeEnum.BALANCE_PAY.getValue()).findFirst().get().getTradeNo());
                } else {
                    payAmount = cashPayList.stream().map(MallOrderPayEntity::getPayamount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    paymentInfo.setTrans_amount(cashPayList.stream().map(MallOrderPayEntity::getPayamount).reduce(BigDecimal.ZERO, BigDecimal::add));
                    paymentInfo.setPayment_type(PaymentType.getName(PaymentType.coupon.getValue()));
                    paymentInfo.setTrans_id(orderPayList.get(0).getTradeNo());
                }
                paymentInfo.setTrans_amount(payAmount);
                order.setPayment_amount(payAmount);
                paymentInfoList.add(paymentInfo);
                order.setPayment_info(paymentInfoList);
            }
            order.setIs_deleted(Integer.valueOf(0));
            orders.add(order);
            data = JsonUtil.toJSONString((Object)mainOrderData);
            YouShuBaseResult youShuBaseResult = YouShuOrderAPI.addOrder((String)this.baseUrl, (String)url, (String)data);
            this.logger.info("\u4e0a\u62a5\u7ed3\u679c:{}", (Object)youShuBaseResult.toString());
        }
        catch (Exception e) {
            this.logger.error("\u6709\u6570\u8ba2\u5355{}\u4e0a\u62a5\u51fa\u9519", (Object)orderMainEntity.getOrderMainNo(), (Object)e);
        }
    }

    public void updateOrder(MallOrderMainEntity orderMainEntity) {
        try {
            if (orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARDPLAN.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_TMALL.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_JD_POP.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_CHANNEL.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_JD_SELF_RUN.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_THIRD_PARTY_CHANNEL.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_THIRD_PARTY_STRATEGY.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_SHOP.getValue() || orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.RECHANGE_CARD.getValue()) {
                return;
            }
            String url = ZhlsApiSignature.sign(this.app_id, this.app_secret);
            String data = "";
            ModifyOrder modifyOrder = new ModifyOrder();
            String orderSource = this.getOrderSource(DataSource.main_order.getName());
            modifyOrder.setDataSourceId(orderSource);
            ModifyOrder.ModifyOrderItem modifyOrderItem = new ModifyOrder.ModifyOrderItem();
            modifyOrderItem.setExternal_order_id(orderMainEntity.getOrderMainNo());
            modifyOrderItem.setStatus_change_time(String.valueOf(DateUtils.now().getTime()));
            if (orderMainEntity.getStatus() >= 4 && orderMainEntity.getStatus() < 16) {
                modifyOrderItem.setOrder_status(OrderStatus.getName(10));
            } else {
                modifyOrderItem.setOrder_status(OrderStatus.getName(orderMainEntity.getStatus()));
            }
            ArrayList<ModifyOrder.ModifyOrderItem> list = new ArrayList<ModifyOrder.ModifyOrderItem>();
            list.add(modifyOrderItem);
            modifyOrder.setOrders(list);
            data = JsonUtil.toJSONString((Object)modifyOrder);
            this.logger.info("\u4e0a\u62a5\u6570\u636e:{},BaseUrl={},url={}", new Object[]{data, this.baseUrl, url});
            YouShuBaseResult youShuBaseResult = YouShuOrderAPI.updateOrder((String)this.baseUrl, (String)url, (String)data);
            this.logger.info("\u4e0a\u62a5\u7ed3\u679c:{}", (Object)youShuBaseResult.toString());
        }
        catch (Exception e) {
            this.logger.error("\u6709\u6570\u8ba2\u5355{}\u4e0a\u62a5\u51fa\u9519:{}", (Object)orderMainEntity.getOrderMainNo(), (Object)e.getMessage());
        }
    }

    public void addOrderSum(Date date) {
        try {
            String url = ZhlsApiSignature.sign(this.app_id, this.app_secret);
            String data = "";
            String orderSource = this.getOrderSource(DataSource.add_order_sum.getName());
            OrderSum orderSum = new OrderSum();
            orderSum.setDataSourceId(orderSource);
            ArrayList<OrderSumItem> orders = new ArrayList<OrderSumItem>();
            OrderSumItem orderSumItem = new OrderSumItem();
            orderSumItem.setRef_date(String.valueOf(DateUtils.getAddDateByDay((Date)date, (int)-1).getTime()));
            List<Map<String, Object>> orderAmountSumList = this.orderMainInterface.getPayOrderSum(DateUtils.getAddDateByDay((Date)date, (int)-1), date, 0);
            orderAmountSumList.forEach(item -> {
                BigDecimal amount_sum = new BigDecimal(0);
                if (item.get("amount_sum") != null) {
                    amount_sum = new BigDecimal(item.get("amount_sum").toString());
                }
                orderSumItem.setGive_order_amount_sum(amount_sum);
            });
            orderAmountSumList = this.orderMainInterface.getPayOrderSum(DateUtils.getAddDateByDay((Date)date, (int)-1), date, 1);
            orderAmountSumList.forEach(item -> {
                BigDecimal amount_sum = new BigDecimal(0);
                if (item.get("amount_sum") != null) {
                    amount_sum = new BigDecimal(item.get("amount_sum").toString());
                }
                orderSumItem.setPayment_amount_sum(amount_sum);
            });
            List<Map<String, Object>> orderSumList = this.orderMainInterface.getOrderNumSum(DateUtils.getAddDateByDay((Date)date, (int)-1), date, 0);
            orderSumList.forEach(item -> {
                int orderNumSum = 0;
                if (item.get("num_sum") != null) {
                    orderNumSum = Integer.valueOf(item.get("num_sum").toString());
                }
                orderSumItem.setGive_order_num_sum(Integer.valueOf(orderNumSum));
            });
            orderSumList = this.orderMainInterface.getOrderNumSum(DateUtils.getAddDateByDay((Date)date, (int)-1), date, 1);
            orderSumList.forEach(item -> {
                int orderNumSum = 0;
                if (item.get("num_sum") != null) {
                    orderNumSum = Integer.valueOf(item.get("num_sum").toString());
                }
                orderSumItem.setPayed_num_sum(Integer.valueOf(orderNumSum));
            });
            orders.add(orderSumItem);
            orderSum.setOrders(orders);
            data = JsonUtil.toJSONString((Object)orderSum);
            this.logger.info("\u8ba2\u5355\u6c47\u603b\u4e0a\u62a5\u6570\u636e:{},BaseUrl={},url={}", new Object[]{data, this.baseUrl, url});
            YouShuBaseResult youShuBaseResult = YouShuOrderAPI.addOrderSum((String)this.baseUrl, (String)url, (String)data);
            this.logger.info("\u8ba2\u5355\u6c47\u603b\u4e0a\u62a5\u6570\u636e:{}", (Object)youShuBaseResult.toString());
        }
        catch (Exception e) {
            this.logger.error("\u6709\u6570\u8ba2\u5355\u6821\u5bf9\u5bf9\u51fa\u9519", (Throwable)e);
        }
    }

    public void addOrder(String orderMainNo) {
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        ((OrderDataService)SpringContextUtil.getBean(this.getClass())).addOrder(orderMainEntity);
    }

    public void updateOrder(String orderMainNo) {
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        this.updateOrder(orderMainEntity);
    }

    public void refundOrder(MallOrderEntity orderEntity, String refundNo, String refundType) {
        RefundOrder refundOrder = new RefundOrder();
        this.logger.info("\u5f00\u59cb\u4e0a\u62a5\u9000\u6b3e,\u8ba2\u5355\u53f7:{},\u9000\u6b3e\u5355\u53f7:{}", (Object)orderEntity.getOrderNo(), (Object)refundNo);
        try {
            ArrayList<RefundOrder.Order> orderList = new ArrayList<RefundOrder.Order>();
            RefundOrder.Order order = new RefundOrder.Order();
            order.setExternal_order_id(orderEntity.getOrderNo());
            order.setExternal_return_order_id(refundNo);
            List<MallOrderGroupProductEntity> productEntityList = this.orderGroupProductInterface.getOrderGroupProductListByOrderNo(orderEntity.getOrderNo());
            if (CollectionUtils.isNotEmpty(productEntityList)) {
                Integer refundNum = 0;
                BigDecimal return_freight_amount = BigDecimal.ZERO;
                BigDecimal return_order_amount = BigDecimal.ZERO;
                ArrayList<RefundOrder.Order.ReturnGoodsInfo> returnGoodsInfoList = new ArrayList<RefundOrder.Order.ReturnGoodsInfo>();
                for (MallOrderGroupProductEntity productEntity : productEntityList) {
                    if (productEntity.getRefundCount() == null || productEntity.getRefundCount() <= 0) continue;
                    RefundOrder.Order.ReturnGoodsInfo returnGoodsInfo = new RefundOrder.Order.ReturnGoodsInfo();
                    returnGoodsInfo.setExternal_sku_id(productEntity.getProductId());
                    returnGoodsInfo.setExternal_spu_id(productEntity.getProductId());
                    returnGoodsInfo.setSku_name_chinese(productEntity.getProductName());
                    returnGoodsInfo.setSpu_name_chinese(productEntity.getProductName());
                    returnGoodsInfo.setReturn_goods_num(productEntity.getRefundCount().toString());
                    returnGoodsInfo.setReturn_goods_amount(PriceUtils.multiply((BigDecimal)productEntity.getRefundAmount(), (Integer)productEntity.getRefundCount()).toString());
                    refundNum = refundNum + productEntity.getRefundCount();
                    if (productEntity.getRefundAmount().compareTo(BigDecimal.ZERO) > 0) {
                        return_order_amount = PriceUtils.add((BigDecimal)return_order_amount, (BigDecimal)PriceUtils.multiply((BigDecimal)productEntity.getRefundAmount(), (Integer)productEntity.getRefundCount()));
                        if (productEntity.getRefundAmount().compareTo(productEntity.getUnitPrice()) > 0) {
                            BigDecimal freight = PriceUtils.subtract((BigDecimal)productEntity.getRefundAmount(), (BigDecimal)productEntity.getUnitPrice());
                            return_freight_amount = PriceUtils.add((BigDecimal)return_freight_amount, (BigDecimal)PriceUtils.multiply((BigDecimal)freight, (Integer)productEntity.getRefundCount()));
                        }
                    }
                    returnGoodsInfoList.add(returnGoodsInfo);
                }
                order.setReturn_goods_info(returnGoodsInfoList);
                BigDecimal return_amount = PriceUtils.subtract((BigDecimal)return_order_amount, (BigDecimal)return_freight_amount);
                order.setExternal_return_order_id(refundNo);
                order.setReturn_num(refundNum);
                order.setReturn_freight_amount(return_freight_amount);
                order.setReturn_amount(return_amount);
                order.setReturn_order_amount(return_order_amount);
                order.setReturn_order_status("1292");
                order.setReturn_num(refundNum);
                order.setReturn_create_time(String.valueOf(DateUtils.now().getTime()));
                order.setStatus_change_time(String.valueOf(DateUtils.now().getTime()));
                orderList.add(order);
                refundOrder.setOrders(orderList);
            }
            String url = ZhlsApiSignature.sign(this.app_id, this.app_secret);
            String orderSource = this.getOrderSource(DataSource.main_order.getName());
            refundOrder.setDataSourceId(orderSource);
            String data = JsonUtil.toJSONString((Object)refundOrder);
            this.logger.info("\u9000\u6b3e\u4e0a\u62a5\u6570\u636e:{},BaseUrl={},url={}", new Object[]{data, this.baseUrl, url});
            YouShuBaseResult youShuBaseResult = YouShuOrderAPI.refundOrder((String)this.baseUrl, (String)url, (String)data);
            this.logger.info("\u9000\u6b3e\u4e0a\u62a5\u7ed3\u679c:{}", (Object)youShuBaseResult.toString());
        }
        catch (Exception e) {
            this.logger.error("\u6709\u6570\u8ba2\u5355:{},\u9000\u6b3e{}\u4e0a\u62a5\u51fa\u9519:{}", new Object[]{orderEntity.getOrderNo(), refundOrder.toString(), e.getMessage()});
        }
    }

    public void refundOrder(String orderNo, String refundNo, String refundType) {
        MallOrderEntity orderEntity = this.orderInterface.getmallOrder(orderNo);
        ((OrderDataService)SpringContextUtil.getBean(this.getClass())).refundOrder(orderEntity, refundNo, refundType);
    }
}

