/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.youshu;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.mall.entity.weixin.WeiXinBaseEntity;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import cc.lechun.mall.service.youshu.DataSource;
import cc.lechun.mall.service.youshu.YouShuBase;
import cc.lechun.mall.service.youshu.ZhlsApiSignature;
import com.tencent.ApiException;
import com.tencent.lingshou.AnalysisApi;
import com.tencent.lingshou.model.AddWxappVisitPageList;
import com.tencent.lingshou.model.AddWxappVisitPageRawMsg;
import com.tencent.lingshou.model.AddWxappVisitPageRequest;
import com.tencent.lingshou.model.BaseResponse;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import weixin.popular.api.DataCubeAPI;
import weixin.popular.api.YouShuVisitePageAPI;
import weixin.popular.bean.advertisement.YouShuBaseResult;
import weixin.popular.bean.datacube.wxapp.ReportVisitpageResult;
import weixin.popular.bean.datacube.wxapp.VisitpageResult;
import weixin.popular.util.JsonUtil;

@Component
public class VisitPageService
extends YouShuBase {
    @Autowired
    private WeiXinBaseInterface weiXinBaseInterface;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AnalysisApi api = new AnalysisApi.AnalysisBuilder("bi30f2c02da82347a7", "5f7679925afa4654bdb50c677c0f32e7", "https://test.zhls.qq.com/data-api/v1").build();

    public void visitPage(int platformId, String begin_date, String end_date) {
        try {
            this.logger.info("\u4e0a\u62a5\u6709\u6570\u9875\u9762\u8bbf\u95ee appId:{},secret:{},baseUrl:{}", new Object[]{this.app_id, this.app_secret, this.baseUrl});
            String data = "";
            ReportVisitpageResult reportVisitpageResult = new ReportVisitpageResult();
            String orderSource = this.getOrderSource(DataSource.visit_page.getName());
            reportVisitpageResult.setDataSourceId(orderSource);
            reportVisitpageResult.getRawMsg().add(this.getVisitePageData(platformId, begin_date, end_date));
            if (((VisitpageResult)reportVisitpageResult.getRawMsg().get(0)).getList() != null && ((VisitpageResult)reportVisitpageResult.getRawMsg().get(0)).getList().size() > 0) {
                this.logger.info("\u9875\u9762\u8bbf\u95ee\u4e0a\u62a5\u6570\u636e:{}", (Object)JsonUtil.toJSONString((Object)reportVisitpageResult));
                String url = ZhlsApiSignature.sign(this.app_id, this.app_secret);
                YouShuBaseResult youShuBaseResult = YouShuVisitePageAPI.addVisitePage((String)this.baseUrl, (String)url, (ReportVisitpageResult)reportVisitpageResult);
                this.logger.info("\u4e0a\u62a5\u7ed3\u679c:{}", (Object)youShuBaseResult.toString());
            } else {
                this.logger.info("\u65e5\u671f:{},\u65e0\u8bbf\u95ee\u6570\u636e", (Object)((VisitpageResult)reportVisitpageResult.getRawMsg().get(0)).getRef_date());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void visitPage(String dataSourceId, int platformId, String begin_date, String end_date) {
        AddWxappVisitPageRequest body = new AddWxappVisitPageRequest();
        body.setDataSourceId(dataSourceId);
        VisitpageResult visitpageResult = this.getVisitePageData(platformId, begin_date, end_date);
        if (visitpageResult.getList() != null && visitpageResult.getList().size() > 0) {
            AddWxappVisitPageRawMsg addWxappVisitPageRawMsg = new AddWxappVisitPageRawMsg();
            addWxappVisitPageRawMsg.setRefDate(visitpageResult.getRef_date());
            AddWxappVisitPageList addWxappVisitPageList = new AddWxappVisitPageList();
            LinkedList<AddWxappVisitPageList> addWxappVisitPageLists = new LinkedList<AddWxappVisitPageList>();
            for (VisitpageResult.Item item : visitpageResult.getList()) {
                addWxappVisitPageList.setPagePath(item.getPage_path());
                addWxappVisitPageList.setPageVisitPv(item.getPage_visit_pv());
                addWxappVisitPageList.setPageVisitUv(item.getPage_visit_uv());
                addWxappVisitPageList.setPageStaytimePv(item.getPage_staytime_pv());
                addWxappVisitPageList.setEntrypagePv(item.getEntrypage_pv());
                addWxappVisitPageList.setExitpagePv(item.getExitpage_pv());
                addWxappVisitPageList.setPageSharePv(item.getPage_share_pv());
                addWxappVisitPageList.setPageShareUv(item.getPage_share_uv());
                addWxappVisitPageLists.add(addWxappVisitPageList);
            }
            addWxappVisitPageRawMsg.setList(addWxappVisitPageLists);
            LinkedList<AddWxappVisitPageRawMsg> addWxappVisitPageRawMsgs = new LinkedList<AddWxappVisitPageRawMsg>();
            addWxappVisitPageRawMsgs.add(addWxappVisitPageRawMsg);
            body.setRawMsg(addWxappVisitPageRawMsgs);
            try {
                BaseResponse response = this.api.addWxappVisitPage(body);
                System.out.println(response);
            }
            catch (ApiException apiException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public VisitpageResult getVisitePageData(int platformId, String begin_date, String end_date) {
        WeiXinBaseEntity weiXinBaseEntity = this.weiXinBaseInterface.getWeixinBaseByFlatformId(platformId);
        if (weiXinBaseEntity == null) {
            this.logger.info("\u65e0\u6548\u7684\u5e73\u53f0");
            throw new RuntimeException("\u65e0\u6548\u7684\u5e73\u53f0");
        }
        return DataCubeAPI.getweanalysisappidvisitpage((String)weiXinBaseEntity.getAccessToken(), (String)(StringUtils.isNotEmpty((String)begin_date) ? begin_date.replace("-", "") : DateUtils.date().replace("-", "")), (String)(StringUtils.isNotEmpty((String)end_date) ? end_date.replace("-", "") : DateUtils.date().replace("-", "")));
    }
}

