/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.utils.ems;

import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.utils.ems.EmsConfig;
import cc.lechun.utils.ems.entity.WaybillRoute;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.org.apache.commons.codec.binary.Base64;
import com.aliyun.openservices.shade.org.apache.commons.codec.digest.DigestUtils;
import com.sf.csim.express.service.HttpClientUtil;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmsUtils {
    @Autowired
    private EmsConfig emsConfig;
    private static final Logger logger = LoggerFactory.getLogger(EmsUtils.class);

    public BaseJsonVo callBack(String logistics_interface, String data_digest, String type, String clientId) {
        logger.info("logistics_interface:" + logistics_interface);
        logger.info("data_digest:" + data_digest);
        logger.info("type:" + type);
        logger.info("clientId:" + clientId);
        String sign = this.encryptSignForOpen(logistics_interface);
        if (!sign.equals(data_digest)) {
            // empty if block
        }
        return BaseJsonVo.success((Object)"");
    }

    public List<WaybillRoute> trace(String logisticsNumber) {
        Map<String, String> params = this.buildParams(logisticsNumber);
        try {
            String res = HttpClientUtil.post((String)this.emsConfig.url, params);
            JSONObject jsonObject = JSON.parseObject((String)res);
            if (!Objects.equals(jsonObject.get((Object)"success"), true)) {
                return new ArrayList<WaybillRoute>();
            }
            JSONObject result = (JSONObject)jsonObject.get((Object)"value");
            if (!Objects.equals(result.get((Object)"resCode"), "true")) {
                return new ArrayList<WaybillRoute>();
            }
            List lst = JsonUtils.getListByArray(WaybillRoute.class, (String)result.get((Object)"resObj").toString());
            return lst.stream().sorted(Comparator.comparing(WaybillRoute::getOpTime).reversed()).collect(Collectors.toList());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            return new ArrayList<WaybillRoute>();
        }
    }

    public Map<String, String> buildParams(String logisticsNumber) {
        HashMap<String, String> map = new HashMap<String, String>();
        long timestamp = new Date().getTime();
        map.put("timestamp", String.valueOf(timestamp));
        map.put("authenticate", this.emsConfig.authenticate);
        map.put("version", this.emsConfig.version);
        map.put("format", "JSON");
        HashedMap param = new HashedMap();
        param.put("NUMBER", logisticsNumber);
        map.put("param", JsonUtils.toJson((Object)param, (boolean)false));
        map.put("Tracking-Api-Key", this.encryptSignForOpen(JsonUtils.toJson((Object)param, (boolean)false)));
        return map;
    }

    public String encryptSignForOpen(String param) {
        String sign;
        String data = "";
        String secret = this.emsConfig.app_secret;
        try {
            byte[] signByte = DigestUtils.md5((String)(data + secret));
            sign = Base64.encodeBase64String((byte[])signByte);
        }
        catch (Throwable e) {
            logger.error("\u52a0\u5bc6\u5931\u8d25.e:{}.", (Object)e.toString());
            sign = "ERROR";
        }
        return sign;
    }

    public Object xml2Object(String inputXml, Class<?> type, String alias) {
        if (null == inputXml || "".equals(inputXml)) {
            return null;
        }
        try {
            XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8", (NameCoder)new XmlFriendlyNameCoder("-_", "_")));
            xstream.alias(alias, type);
            return xstream.fromXML(inputXml);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("xml\u8f6c\u6362\u9519\u8bef" + e.getMessage());
            return null;
        }
    }
}

