/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.utils.tracking;

import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.utils.tracking.TrackingConfig;
import cc.lechun.utils.tracking.entity.ImportOrder;
import cc.lechun.utils.tracking.entity.TrackingInfo;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.org.apache.commons.codec.binary.Base64;
import com.aliyun.openservices.shade.org.apache.commons.codec.digest.DigestUtils;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.collections.map.HashedMap;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TrackingUtils {
    @Autowired
    private TrackingConfig trackingConfig;
    private static final Logger logger = LoggerFactory.getLogger(TrackingUtils.class);

    public BaseJsonVo callBack(String result) {
        logger.info("\u56de\u8c03\u8fd4\u56de:{}", (Object)result);
        JSONObject jsonObject = JSON.parseObject((String)result);
        if (!Objects.equals(jsonObject.getIntValue("code"), 200)) {
            return BaseJsonVo.error((String)jsonObject.getString("message"));
        }
        JSONObject data = (JSONObject)jsonObject.get((Object)"data");
        return BaseJsonVo.success((Object)"");
    }

    public List<TrackingInfo> trace(String logisticsNumber) {
        try {
            URIBuilder uriBuilder = new URIBuilder(this.trackingConfig.getOrderRount + "?tracking_number=" + logisticsNumber);
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            httpGet.addHeader("Accept", "application/json");
            httpGet.addHeader("Tracking-Api-Key", this.trackingConfig.app_secret);
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject jsonObject = JSON.parseObject((String)result);
            if (!Objects.equals(jsonObject.getInteger("code"), 200)) {
                return new ArrayList<TrackingInfo>();
            }
            JSONArray data = jsonObject.getJSONArray("data");
            JSONObject origin_info = ((JSONObject)data.get(0)).getJSONObject("origin_info");
            List lst = JsonUtils.getListByArray(TrackingInfo.class, (String)origin_info.get((Object)"trackinfo").toString());
            return lst.stream().sorted(Comparator.comparing(TrackingInfo::getCheckpoint_date).reversed()).collect(Collectors.toList());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            return new ArrayList<TrackingInfo>();
        }
    }

    public Map<String, String> buildParams(String logisticsNumber) {
        HashMap<String, String> map = new HashMap<String, String>();
        long timestamp = new Date().getTime();
        map.put("timestamp", String.valueOf(timestamp));
        map.put("format", "JSON");
        HashedMap param = new HashedMap();
        param.put("Tracking-Api-Key", this.trackingConfig.app_secret);
        map.put("param", JsonUtils.toJson((Object)param, (boolean)false));
        map.put("sign", this.encryptSignForOpen(JsonUtils.toJson((Object)param, (boolean)false)));
        return map;
    }

    public BaseJsonVo importTrackingNumber(String logisticsNumber) {
        try {
            HttpPost httpPost = new HttpPost(this.trackingConfig.importOrder);
            httpPost.addHeader("Accept", "application/json");
            httpPost.addHeader("Tracking-Api-Key", this.trackingConfig.app_secret);
            ImportOrder importOrder = new ImportOrder();
            importOrder.setTracking_number(logisticsNumber);
            importOrder.setCourier_code(this.getName(logisticsNumber));
            logger.info("\u53c2\u6570:{}", (Object)JsonUtils.toJson((Object)importOrder, (boolean)false));
            StringEntity reqEntity = new StringEntity(JsonUtils.toJson((Object)importOrder, (boolean)false), ContentType.create((String)"application/json", (String)"utf-8"));
            httpPost.setEntity((HttpEntity)reqEntity);
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject jsonObject = JSON.parseObject((String)result);
            if (jsonObject.getIntValue("code") == 200) {
                return BaseJsonVo.success((Object)"");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BaseJsonVo.error((String)"");
    }

    public String getName(String logisticsNumber) {
        if (logisticsNumber.toLowerCase().startsWith("yt")) {
            return "yt";
        }
        if (logisticsNumber.startsWith("12")) {
            return "china-ems";
        }
        if (logisticsNumber.startsWith("12")) {
            return "china-ems";
        }
        if (logisticsNumber.toLowerCase().startsWith("jd")) {
            return "jd";
        }
        if (logisticsNumber.toLowerCase().startsWith("ttkd")) {
            return "ttkd";
        }
        if (logisticsNumber.toLowerCase().startsWith("deppon")) {
            return "deppon";
        }
        if (logisticsNumber.toLowerCase().startsWith("zjs-express")) {
            return "zjs-express";
        }
        return "";
    }

    public String encryptSignForOpen(String param) {
        String sign;
        String data = "";
        String secret = this.trackingConfig.app_secret;
        try {
            byte[] signByte = DigestUtils.md5((String)(data + secret));
            sign = Base64.encodeBase64String((byte[])signByte);
        }
        catch (Throwable e) {
            logger.error("\u52a0\u5bc6\u5931\u8d25.e:{}.", (Object)e.toString());
            sign = "ERROR";
        }
        return sign;
    }

    public Object xml2Object(String inputXml, Class<?> type, String alias) {
        if (null == inputXml || "".equals(inputXml)) {
            return null;
        }
        try {
            XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8", (NameCoder)new XmlFriendlyNameCoder("-_", "_")));
            xstream.alias(alias, type);
            return xstream.fromXML(inputXml);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("xml\u8f6c\u6362\u9519\u8bef" + e.getMessage());
            return null;
        }
    }

    public String getSign() throws NoSuchAlgorithmException, InvalidKeyException {
        String signature = "0d90bb874fed0b056d8b3aa794529ebacd49932a0cea691629b63eaf2ca9d400";
        String timestamp = "1653632765";
        String account = "info@trackingmore.org";
        Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret_key = new SecretKeySpec(account.getBytes(), "HmacSHA256");
        sha256_HMAC.init(secret_key);
        byte[] bytes = sha256_HMAC.doFinal(timestamp.getBytes());
        StringBuilder new_signature = new StringBuilder();
        for (byte item : bytes) {
            new_signature.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
        }
        System.out.println(new_signature.toString());
        System.out.println(new_signature.toString().equals(signature));
        return new_signature.toString();
    }
}

