/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.utils.yto;

import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.utils.yto.YtoConfig;
import cc.lechun.utils.yto.entity.CallBackWaybillRoute;
import cc.lechun.utils.yto.entity.WaybillRoute;
import com.aliyun.openservices.shade.org.apache.commons.codec.binary.Base64;
import com.aliyun.openservices.shade.org.apache.commons.codec.digest.DigestUtils;
import com.sf.csim.express.service.HttpClientUtil;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class YtoUtils {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private YtoConfig ytoConfig;

    public BaseJsonVo callBack(String logistics_interface, String data_digest, String type, String clientId) {
        CallBackWaybillRoute callBackWaybillRoute;
        this.logger.info("logistics_interface:" + logistics_interface);
        this.logger.info("data_digest:" + data_digest);
        this.logger.info("type:" + type);
        this.logger.info("clientId:" + clientId);
        String sign = this.encryptSignForOpen(logistics_interface);
        if (!sign.equals(data_digest)) {
            // empty if block
        }
        if ((callBackWaybillRoute = (CallBackWaybillRoute)this.xml2Object(logistics_interface, CallBackWaybillRoute.class, "UpdateInfo")) != null) {
            return BaseJsonVo.success((Object)callBackWaybillRoute);
        }
        this.logger.error("YTO callBack \u9519\u8bef\uff1a" + logistics_interface);
        BaseJsonVo jsonVo = new BaseJsonVo();
        jsonVo.setError("YTO callBack \u9519\u8bef");
        jsonVo.setValue((Object)callBackWaybillRoute);
        return jsonVo;
    }

    public List<WaybillRoute> trace(String logisticsNumber) {
        Map<String, String> params = this.buildParams(logisticsNumber);
        try {
            String res = HttpClientUtil.post((String)this.ytoConfig.getPostUrl(), params);
            if (res.indexOf("code") >= 0) {
                return new ArrayList<WaybillRoute>();
            }
            List lst = JsonUtils.getListByArray(WaybillRoute.class, (String)res);
            return lst.stream().sorted(Comparator.comparing(WaybillRoute::getUpload_Time).reversed()).collect(Collectors.toList());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.getMessage(), (Throwable)e);
            return new ArrayList<WaybillRoute>();
        }
    }

    public Map<String, String> buildParams(String logisticsNumber) {
        HashMap<String, String> map = new HashMap<String, String>();
        long timestamp = new Date().getTime();
        map.put("timestamp", String.valueOf(timestamp));
        map.put("format", "JSON");
        HashedMap param = new HashedMap();
        param.put("NUMBER", logisticsNumber);
        map.put("param", JsonUtils.toJson((Object)param, (boolean)false));
        map.put("sign", this.encryptSignForOpen(JsonUtils.toJson((Object)param, (boolean)false)));
        return map;
    }

    public String encryptSignForOpen(String param) {
        String sign;
        String data = param + this.ytoConfig.method + this.ytoConfig.version;
        String secret = this.ytoConfig.secret;
        try {
            byte[] signByte = DigestUtils.md5((String)(data + secret));
            sign = Base64.encodeBase64String((byte[])signByte);
        }
        catch (Throwable e) {
            this.logger.error("\u52a0\u5bc6\u5931\u8d25.e:{}.", (Object)e.toString());
            sign = "ERROR";
        }
        return sign;
    }

    public Object xml2Object(String inputXml, Class<?> type, String alias) {
        if (null == inputXml || "".equals(inputXml)) {
            return null;
        }
        try {
            XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8", (NameCoder)new XmlFriendlyNameCoder("-_", "_")));
            xstream.alias(alias, type);
            return xstream.fromXML(inputXml);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("xml\u8f6c\u6362\u9519\u8bef" + e.getMessage());
            return null;
        }
    }
}

