/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.entity.normal.vo.html;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.pro.entity.common.KeyValue;
import cc.lechun.pro.entity.normal.NormalPlanEntity;
import cc.lechun.pro.entity.normal.vo.NormalSPredictVO;
import cc.lechun.pro.entity.normal.vo.NormalStoreVO;
import cc.lechun.pro.util.Decimal;
import cc.lechun.pro.util.MyCopy;
import cc.lechun.pro.util.date.MyDateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SumSwichHtml
implements Serializable {
    private static Logger log = LoggerFactory.getLogger(SumSwichHtml.class);
    private Map<String, KeyValue> storeNameMap;
    private Map<String, KeyValue> matNameMap;
    private Map<String, KeyValue> factoryNameMap;
    private List<String> pickupDays;
    private List<Map<String, Object>> predictNums;
    private List<Map<String, Object>> depNums;
    private List<Map<String, Object>> allotNums;
    private List<Map<String, Object>> storeEndNums;
    private List<Map<String, Object>> storeEndDays;
    private List<Map<String, Object>> storeNums;
    private List<Map<String, Object>> storeCofig;

    public void buildParam(Map<String, KeyValue> storeNameMap, Map<String, KeyValue> matNameMap, Map<String, KeyValue> factoryNameMap) {
        this.storeNameMap = storeNameMap;
        this.matNameMap = matNameMap;
        this.factoryNameMap = factoryNameMap;
    }

    public void buildPickupDays(List<Integer> days) {
        this.pickupDays = new LinkedList<String>();
        Comparator<Integer> comparator = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1 - 2;
            }
        };
        Collections.sort(days, comparator);
        for (int i = 0; i < days.size(); ++i) {
            this.pickupDays.add("day" + days.get(i));
        }
    }

    public void addPredictNums(List<NormalSPredictVO> getPropredictPlans) {
        this.predictNums = new ArrayList<Map<String, Object>>();
        HashMap newMap = new HashMap();
        for (NormalSPredictVO item : getPropredictPlans) {
            String key = item.getFactoryId() + "|" + item.getPredictStoreId() + "|" + item.getMatId() + "|" + item.getFreshiness();
            if (newMap.containsKey(key)) {
                ((Map)newMap.get(key)).put("day" + MyDateUtil.getDateInt(item.getPickupDate()), item.getQty());
                continue;
            }
            HashMap<String, Object> report = new HashMap<String, Object>();
            report.put("factoryId", item.getFactoryId());
            report.put("factoryName", this.factoryNameMap.get(item.getFactoryId()).getValueFiled());
            report.put("storeId", item.getPredictStoreId());
            report.put("storeName", this.storeNameMap.get(item.getPredictStoreId()).getValueFiled());
            report.put("matId", item.getMatId());
            report.put("matName", this.matNameMap.get(item.getMatId()).getValueFiled());
            report.put("freshnessEnd", item.getFreshiness());
            report.put("day" + MyDateUtil.getDateInt(item.getPickupDate()), item.getQty());
            newMap.put(key, report);
        }
        this.predictNums = newMap.values().stream().collect(Collectors.toList());
        Comparator<Map<String, Object>> comparator = this.Getcomparator();
        Collections.sort(this.predictNums, comparator);
    }

    public void addAllNums(List<NormalPlanEntity> history, List<NormalPlanEntity> listOldTemp) {
        Map<String, List<NormalPlanEntity>> historyMap = history.stream().collect(Collectors.groupingBy(item -> item.getFactoryId() + "|" + item.getStoreId() + "|" + item.getMatId() + item.getFreshnessEnd()));
        this.depNums = new ArrayList<Map<String, Object>>();
        this.allotNums = new ArrayList<Map<String, Object>>();
        this.storeEndNums = new ArrayList<Map<String, Object>>();
        this.storeEndDays = new ArrayList<Map<String, Object>>();
        for (NormalPlanEntity item2 : listOldTemp) {
            String key = item2.getFactoryId() + "|" + item2.getStoreId() + "|" + item2.getMatId() + item2.getFreshnessEnd();
            HashMap<String, Object> report = new HashMap<String, Object>();
            report.put("factoryId", item2.getFactoryId());
            report.put("factoryName", this.factoryNameMap.get(item2.getFactoryId()).getValueFiled());
            report.put("storeId", item2.getStoreId());
            report.put("storeName", this.storeNameMap.get(item2.getStoreId()).getValueFiled());
            report.put("matId", item2.getMatId());
            report.put("matName", this.matNameMap.get(item2.getMatId()).getValueFiled());
            report.put("freshnessStart", item2.getFreshnessStart());
            report.put("freshnessEnd", item2.getFreshnessEnd());
            Map report_DepNum = MyCopy.deepCopy(report);
            Map report_AllotNum = MyCopy.deepCopy(report);
            Map report_StoreNum = MyCopy.deepCopy(report);
            Map report_StoreDays = MyCopy.deepCopy(report);
            if (null != historyMap.get(key)) {
                List<NormalPlanEntity> historykey = historyMap.get(key);
                for (NormalPlanEntity m : historykey) {
                    Integer day = MyDateUtil.getDateInt(m.getWeekDate());
                    if (Decimal.get(m.getDepNum()).doubleValue() != 0.0) {
                        report_DepNum.put("day" + day, m.getDepNum());
                    }
                    if (Decimal.get(m.getAllotNum()).doubleValue() != 0.0) {
                        report_AllotNum.put("day" + day, m.getAllotNum());
                    }
                    if (Decimal.get(m.getStoreNum()).doubleValue() != 0.0) {
                        report_StoreNum.put("day" + day, m.getStoreNum());
                    }
                    if (Decimal.get(m.getStoreDays()).doubleValue() == 0.0) continue;
                    report_StoreDays.put("day" + day, m.getStoreDays());
                }
            }
            this.depNums.add(report_DepNum);
            this.allotNums.add(report_AllotNum);
            this.storeEndNums.add(report_StoreNum);
            this.storeEndDays.add(report_StoreDays);
        }
        Comparator<Map<String, Object>> comparator = this.Getcomparator();
        Collections.sort(this.depNums, comparator);
        Collections.sort(this.allotNums, comparator);
        Collections.sort(this.storeEndNums, comparator);
        Collections.sort(this.storeEndDays, comparator);
    }

    public void addStoreCofig() {
    }

    public List<String> getPickupDays() {
        return this.pickupDays;
    }

    public void setPickupDays(List<String> pickupDays) {
        this.pickupDays = pickupDays;
    }

    public List<Map<String, Object>> getPredictNums() {
        return this.predictNums;
    }

    public void setPredictNums(List<Map<String, Object>> predictNums) {
        this.predictNums = predictNums;
    }

    public List<Map<String, Object>> getDepNums() {
        return this.depNums;
    }

    public void setDepNums(List<Map<String, Object>> depNums) {
        this.depNums = depNums;
    }

    public List<Map<String, Object>> getAllotNums() {
        return this.allotNums;
    }

    public void setAllotNums(List<Map<String, Object>> allotNums) {
        this.allotNums = allotNums;
    }

    public List<Map<String, Object>> getStoreEndNums() {
        return this.storeEndNums;
    }

    public void setStoreEndNums(List<Map<String, Object>> storeEndNums) {
        this.storeEndNums = storeEndNums;
    }

    public List<Map<String, Object>> getStoreEndDays() {
        return this.storeEndDays;
    }

    public void setStoreEndDays(List<Map<String, Object>> storeEndDays) {
        this.storeEndDays = storeEndDays;
    }

    public List<Map<String, Object>> getStoreCofig() {
        return this.storeCofig;
    }

    public void setStoreCofig(List<Map<String, Object>> storeCofig) {
        this.storeCofig = storeCofig;
    }

    private Comparator<Map<String, Object>> Getcomparator() {
        Comparator<Map<String, Object>> comparator = new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                int result = 0;
                if (null != o1.get("factoryId") || null != o2.get("factoryId")) {
                    o1.get("factoryId").toString().compareTo(o2.get("factoryId").toString());
                }
                if (result == 0 && (result = o1.get("storeId").toString().compareTo(o2.get("storeId").toString())) == 0 && (result = o1.get("matId").toString().compareTo(o2.get("matId").toString())) == 0) {
                    result = Integer.valueOf(o1.get("freshnessEnd").toString()).compareTo(Integer.valueOf(o2.get("freshnessEnd").toString()));
                }
                return result;
            }
        };
        return comparator;
    }

    public void addStoreNums(List<NormalStoreVO> normalStores) {
        this.storeNums = new ArrayList<Map<String, Object>>();
        HashMap newMap = new HashMap();
        for (NormalStoreVO item : normalStores) {
            String key = item.getStoreId() + "|" + item.getMatId() + "|" + MyDateUtil.getDateInt(item.getProDate());
            if (newMap.containsKey(key)) continue;
            HashMap<String, Object> report = new HashMap<String, Object>();
            report.put("storeId", item.getStoreId());
            report.put("storeName", this.storeNameMap.get(item.getStoreId()).getValueFiled());
            report.put("matId", item.getMatId());
            report.put("matName", this.matNameMap.get(item.getMatId()).getValueFiled());
            report.put("proDate", MyDateUtil.getDateStr(item.getProDate()));
            report.put("qity", item.getQtity());
            report.put("freshnessEnd", DateUtils.getDateDiff((Date)item.getProDate(), (Date)MyDateUtil.getDate(1)));
            newMap.put(key, report);
        }
        this.storeNums = newMap.values().stream().collect(Collectors.toList());
        Comparator<Map<String, Object>> comparator = new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                int result = o1.get("storeId").toString().compareTo(o2.get("storeId").toString());
                if (result == 0 && (result = o1.get("storeId").toString().compareTo(o2.get("storeId").toString())) == 0 && (result = o1.get("matId").toString().compareTo(o2.get("matId").toString())) == 0) {
                    result = Integer.valueOf(o2.get("freshnessEnd").toString()).compareTo(Integer.valueOf(o1.get("freshnessEnd").toString()));
                }
                return result;
            }
        };
        Collections.sort(this.storeNums, comparator);
    }

    public List<Map<String, Object>> getStoreNums() {
        return this.storeNums;
    }

    public void setStoreNums(List<Map<String, Object>> storeNums) {
        this.storeNums = storeNums;
    }
}

