/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.sys.entity.print;

import cc.lechun.sys.entity.print.util.PDFPrinter;
import cc.lechun.sys.entity.print.util.ThreeSections;
import java.util.LinkedList;

public class BillPrintFormat<E>
extends PDFPrinter {
    private LinkedList<ThreeSections.Entry> heads;
    private LinkedList<ThreeSections.Entry> foots;
    private LinkedList<ThreeSections.Entry> remarks;
    private ThreeSections.Entry title;
    private ThreeSections.Query query;
    private Iterable<E> iterable;
    private String fontPath;
    private String fontEncoding;
    private float[] colWidths_head = null;
    private float[] colWidths_foot = null;
    private float[] colWidths_remark = null;
    private int colWidths_data = 1;
    private int colWidths_title = 1;

    public BillPrintFormat() {
    }

    public BillPrintFormat(ThreeSections.Query query) {
        this.query = query;
    }

    public BillPrintFormat(LinkedList<ThreeSections.Entry> heads, LinkedList<ThreeSections.Entry> foots, LinkedList<ThreeSections.Entry> remarks, ThreeSections.Query query) {
        this.heads = heads;
        this.foots = foots;
        this.remarks = remarks;
        this.query = query;
    }

    public BillPrintFormat<E> addEntry(ThreeSections.Entry entry, Type type) {
        if (entry != null) {
            switch (type) {
                case HEAD: {
                    this.addHead(entry);
                    break;
                }
                case FOOT: {
                    this.addFoot(entry);
                    break;
                }
                case REMARK: {
                    this.addRemark(entry);
                    break;
                }
                case TITLE: {
                    this.addTitle(entry);
                    break;
                }
                default: {
                    throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b".concat(type.name()));
                }
            }
        }
        return this;
    }

    public BillPrintFormat<E> addEntry(String name, float width_name, String value, float width_value, Type type) {
        ThreeSections.Entry entry = new ThreeSections.Entry(name, width_name, value, width_value);
        return this.addEntry(entry, type);
    }

    BillPrintFormat<E> addHead(ThreeSections.Entry entry) {
        if (entry == null) {
            return this;
        }
        if (this.heads == null) {
            this.heads = new LinkedList();
        }
        this.heads.add(entry);
        return this;
    }

    BillPrintFormat<E> addFoot(ThreeSections.Entry entry) {
        if (entry == null) {
            return this;
        }
        if (this.foots == null) {
            this.foots = new LinkedList();
        }
        this.foots.add(entry);
        return this;
    }

    BillPrintFormat<E> addRemark(ThreeSections.Entry entry) {
        if (entry == null) {
            return this;
        }
        if (this.remarks == null) {
            this.remarks = new LinkedList();
        }
        this.remarks.add(entry);
        return this;
    }

    BillPrintFormat<E> addTitle(ThreeSections.Entry entry) {
        if (entry == null) {
            return this;
        }
        if (this.title == null) {
            this.title = new ThreeSections.Entry("\u9ed8\u8ba4\u516c\u53f8:", 0.0f, "\u9ed8\u8ba4\u5355\u636e\u6253\u5370", 0.0f);
        }
        this.title = entry;
        return this;
    }

    public LinkedList<ThreeSections.Entry> getHeads() {
        return this.heads;
    }

    public BillPrintFormat<E> setHeads(LinkedList<ThreeSections.Entry> heads) {
        this.heads = heads;
        return this;
    }

    public LinkedList<ThreeSections.Entry> getFoots() {
        return this.foots;
    }

    public ThreeSections.Entry getTitle() {
        return this.title;
    }

    public BillPrintFormat setFoots(LinkedList<ThreeSections.Entry> foots) {
        this.foots = foots;
        return this;
    }

    public LinkedList<ThreeSections.Entry> getRemarks() {
        return this.remarks;
    }

    public BillPrintFormat<E> setRemarks(LinkedList<ThreeSections.Entry> remarks) {
        this.remarks = remarks;
        return this;
    }

    public Iterable<E> getIterable() {
        return this.iterable;
    }

    public BillPrintFormat<E> setIterable(Iterable<E> iterable) {
        this.iterable = iterable;
        return this;
    }

    public ThreeSections.Query getQuery() {
        return this.query;
    }

    public BillPrintFormat<E> setQuery(ThreeSections.Query query) {
        this.query = query;
        return this;
    }

    public String getFontPath() {
        return this.fontPath;
    }

    public BillPrintFormat<E> setFontPath(String fontPath) {
        this.fontPath = fontPath;
        return this;
    }

    public String getFontEncoding() {
        return this.fontEncoding;
    }

    public BillPrintFormat<E> setFontEncoding(String fontEncoding) {
        this.fontEncoding = fontEncoding;
        return this;
    }

    public float[] getColWidths_head() {
        return this.colWidths_head;
    }

    public BillPrintFormat<E> setColWidths_head(float[] colWidths_head) {
        this.colWidths_head = colWidths_head;
        return this;
    }

    public float[] getColWidths_foot() {
        return this.colWidths_foot;
    }

    public BillPrintFormat<E> setColWidths_foot(float[] colWidths_foot) {
        this.colWidths_foot = colWidths_foot;
        return this;
    }

    public float[] getColWidths_remark() {
        return this.colWidths_remark;
    }

    public BillPrintFormat<E> setColWidths_remark(float[] colWidths_remark) {
        this.colWidths_remark = colWidths_remark;
        return this;
    }

    public int getColWidths_data() {
        return this.colWidths_data;
    }

    public BillPrintFormat<E> setColWidths_data(int colWidths_data) {
        this.colWidths_data = colWidths_data;
        return this;
    }

    public BillPrintFormat<E> setColWidths_title(int colWidths_title) {
        this.colWidths_title = colWidths_title;
        return this;
    }

    public int getColWidths_title() {
        return this.colWidths_title;
    }

    public static enum Type {
        HEAD,
        FOOT,
        REMARK,
        TITLE;

    }
}

