package cc.lechun.sys.entity.grid;

import cc.lechun.sys.entity.GridEntity;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.TypeReference;
import io.micrometer.common.util.StringUtils;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.util.List;

public class Grid extends GridEntity implements Serializable {
    public GridEntity copy(){
        GridEntity target=new GridEntity();
        BeanUtils.copyProperties(this,target);
        target.setGridColumns(JSONObject.toJSONString(getColumns()));
        return target;
    }
    private List<Column> columns;
    public List<Column> getColumns() {
        if(this.columns==null) {
            if(StringUtils.isNotBlank(super.getGridColumns())) {
                this.columns= JSON.parseObject(super.getGridColumns(), new TypeReference<List<Column>>() {});
            }
        }
         return this.columns;
    }

    public void setColumns(List<Column> columns) {
        if(null != columns) {
            super.setGridColumns(JSONObject.toJSONString(columns));
        }
        this.columns = columns;
    }
}
