/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.api;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import weixin.popular.api.API;
import weixin.popular.api.BaseAPI;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.payservice.StaffInfo;
import weixin.popular.bean.payservice.StaffResult;
import weixin.popular.bean.payservice.StaffUserIdResult;
import weixin.popular.client.LocalHttpClient;

public class PayServiceAPI
extends BaseAPI {
    public static StaffResult regGuides(String store_id, String corpid, String name, String mobile, String qr_code, String sub_mchid, String avatar, String userid, String certPath) throws IllegalBlockSizeException, IOException {
        X509Certificate cert = PayServiceAPI.getX509Certificate(certPath);
        if (cert != null) {
            name = PayServiceAPI.rsaEncryptOAEP(name, cert);
            mobile = PayServiceAPI.rsaEncryptOAEP(mobile, cert);
            HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.mch.weixin.qq.com/v3/smartguide/guides").addParameter("sub_mchid", sub_mchid).addParameter("corpid", corpid).addParameter("store_id", store_id).addParameter("userid", userid).addParameter("name", name).addParameter("mobile", mobile).addParameter("qr_code", qr_code).addParameter("avatar", avatar).build();
            return LocalHttpClient.executeJsonResult(httpUriRequest, StaffResult.class);
        }
        throw new RuntimeException("\u8bfb\u53d6\u8bc1\u4e66\u5931\u8d25");
    }

    public static BaseResult setAssign(String guide_id, String sub_mchid, String out_trade_no) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.mch.weixin.qq.com" + "/v3/smartguide/guides/{guide_id}/assign".replace("{guide_id}", guide_id)).addParameter("sub_mchid", sub_mchid).addParameter("out_trade_no", out_trade_no).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static StaffUserIdResult getStaffUserId(String access_token, String mobile) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://qyapi.weixin.qq.com/cgi-bin/user/getuserid").addParameter("access_token", API.accessToken(access_token)).addParameter("mobile", mobile).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, StaffUserIdResult.class);
    }

    public static StaffInfo getStaff(String access_token, String userId) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://qyapi.weixin.qq.com/cgi-bin/user/get").addParameter("access_token", API.accessToken(access_token)).addParameter("userid", userId).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, StaffInfo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate getX509Certificate(String publicKeyPath) {
        if (publicKeyPath == null) {
            return null;
        }
        Object pk = null;
        FileInputStream bais = null;
        try {
            X509Certificate cert;
            CertificateFactory certificatefactory = CertificateFactory.getInstance("X.509");
            bais = new FileInputStream(publicKeyPath);
            X509Certificate x509Certificate = cert = (X509Certificate)certificatefactory.generateCertificate(bais);
            return x509Certificate;
        }
        catch (CertificateException certificateException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static String rsaEncryptOAEP(String message, X509Certificate certificate) throws IllegalBlockSizeException, IOException {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
            cipher.init(1, certificate.getPublicKey());
            byte[] data = message.getBytes("utf-8");
            byte[] cipherdata = cipher.doFinal(data);
            return Base64.getEncoder().encodeToString(cipherdata);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException("\u5f53\u524dJava\u73af\u5883\u4e0d\u652f\u6301RSA v1.5/OAEP", e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u8bc1\u4e66", e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalBlockSizeException("\u52a0\u5bc6\u539f\u4e32\u7684\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7214\u5b57\u8282");
        }
    }
}

