/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.api.qy;

import com.qq.weixin.mp.aes.AesException;
import com.qq.weixin.mp.aes.WXBizMsgCrypt;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import weixin.popular.api.API;
import weixin.popular.api.BaseAPI;
import weixin.popular.bean.qy.ExternalContactUserIdListResult;
import weixin.popular.bean.qy.FollowUserContactResult;
import weixin.popular.bean.qy.FollowUserInfoResult;
import weixin.popular.bean.qy.FollowUserResult;
import weixin.popular.bean.qy.UserResult;
import weixin.popular.client.LocalHttpClient;
import weixin.popular.util.JsonUtil;
import weixin.popular.util.StreamUtils;

public class FollowUserAPI
extends BaseAPI {
    public static FollowUserResult getFollowUserList(String access_token) {
        StringBuilder sb = new StringBuilder("https://qyapi.weixin.qq.com");
        sb.append("/cgi-bin/externalcontact/get_follow_user_list?").append("access_token").append("=").append(API.accessToken(access_token));
        HttpUriRequest httpUriRequest = RequestBuilder.get().setHeader(jsonHeader).setUri(sb.toString()).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, FollowUserResult.class);
    }

    public static ExternalContactUserIdListResult getExternalContactUserIdList(String access_token, String followUserId) {
        StringBuilder sb = new StringBuilder("https://qyapi.weixin.qq.com");
        sb.append("/cgi-bin/externalcontact/list?").append("access_token").append("=").append(API.accessToken(access_token)).append("&userid=").append(followUserId);
        HttpUriRequest httpUriRequest = RequestBuilder.get().setHeader(jsonHeader).setUri(sb.toString()).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, ExternalContactUserIdListResult.class);
    }

    public static FollowUserInfoResult getFollowUserInfoBatch(String access_token, List<String> userIds, String cursor) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        String[] userIdsArray = new String[userIds.size()];
        userIds.toArray(userIdsArray);
        param.put("userid_list", userIds.toString());
        param.put("cursor", cursor);
        param.put("limit", 50);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://qyapi.weixin.qq.com/cgi-bin/externalcontact/batch/get_by_user?access_token=" + access_token).setEntity((HttpEntity)new StringEntity(JsonUtil.toJSONString(param), Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, FollowUserInfoResult.class);
    }

    public static void main(String[] args) {
        ArrayList<String> userIds = new ArrayList<String>(){
            {
                this.add("A");
                this.add("B");
                this.add("C");
            }
        };
        String[] a = new String[userIds.size()];
        String[] objects = userIds.toArray(a);
        System.out.println(a);
        System.out.println(objects);
    }

    public static FollowUserContactResult getFollowUserInfo(String access_token, String externalUserid) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("external_userid", externalUserid);
        param.put("cursor", "");
        StringBuilder sb = new StringBuilder("https://qyapi.weixin.qq.com");
        sb.append("/cgi-bin/externalcontact/get?").append("access_token").append("=").append(API.accessToken(access_token)).append("&external_userid=").append(externalUserid).append("&cursor=");
        HttpUriRequest httpUriRequest = RequestBuilder.get().setHeader(jsonHeader).setUri(sb.toString()).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, FollowUserContactResult.class);
    }

    public static UserResult getUser(String access_token, String userId) {
        StringBuilder sb = new StringBuilder("https://qyapi.weixin.qq.com");
        sb.append("/cgi-bin/user/get?").append("access_token").append("=").append(API.accessToken(access_token)).append("&userid=").append(userId);
        HttpUriRequest httpUriRequest = RequestBuilder.get().setHeader(jsonHeader).setUri(sb.toString()).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, UserResult.class);
    }

    public static String verifyFirstTime(String access_token, HttpServletRequest request, HttpServletResponse response) throws IOException, AesException {
        String sToken = "6YmuO";
        String sCorpID = "wwc2a973e34f38f9e5";
        String sEncodingAESKey = "NnOsLbLDAeGNtjSlkQzHKwh8ImAhge8EdMpzizTUIJf";
        ServletInputStream inputStream = request.getInputStream();
        ServletOutputStream outputStream = response.getOutputStream();
        String signature = request.getParameter("msg_signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        String echostr = request.getParameter("echostr");
        WXBizMsgCrypt wxcpt = new WXBizMsgCrypt(sToken, sEncodingAESKey, sCorpID);
        try {
            echostr = URLDecoder.decode(echostr, "utf-8");
            String sEchoStr = wxcpt.verifyUrl(signature, timestamp, nonce, echostr);
            System.out.println("verifyurl echostr: " + sEchoStr);
            return sEchoStr;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static Map<String, String> addContactEvent(String access_token, HttpServletRequest request, HttpServletResponse response) throws IOException, AesException {
        String sToken = "6YmuO";
        String sCorpID = "wwc2a973e34f38f9e5";
        String sEncodingAESKey = "NnOsLbLDAeGNtjSlkQzHKwh8ImAhge8EdMpzizTUIJf";
        ServletInputStream inputStream = request.getInputStream();
        ServletOutputStream outputStream = response.getOutputStream();
        String signature = request.getParameter("msg_signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        String postData = StreamUtils.copyToString((InputStream)inputStream, Charset.forName("utf-8"));
        WXBizMsgCrypt wxcpt = new WXBizMsgCrypt(sToken, sEncodingAESKey, sCorpID);
        String sMsg = wxcpt.decryptMsg(signature, timestamp, nonce, postData);
        try {
            System.out.println("after decrypt msg: " + sMsg);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            StringReader sr = new StringReader(sMsg);
            InputSource is = new InputSource(sr);
            Document document = db.parse(is);
            Element root = document.getDocumentElement();
            NodeList UserIdNodeList = root.getElementsByTagName("UserID");
            String userId = UserIdNodeList.item(0).getTextContent();
            System.out.println("userId\uff1a" + userId);
            NodeList ExternalUserIDNodeList = root.getElementsByTagName("ExternalUserID");
            String externalUserID = ExternalUserIDNodeList.item(0).getTextContent();
            System.out.println("externalUserID\uff1a" + externalUserID);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("userId", userId);
            map.put("externalUserID", externalUserID);
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

