/*
 * Decompiled with CFR 0.152.
 */
package chapters.appenders;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.util.StatusPrinter;
import chapters.appenders.OtherIO;
import org.slf4j.Logger;

public class IOPerformance
extends Thread {
    static String MSG = "ABCDEGHIJKLMNOPQRSTUVWXYZabcdeghijklmnopqrstuvwxyz1234567890";
    static String LOG_FILE;
    public static String PARALLEL_FILE;
    static int NUM_THREADS;
    static long l;
    long len;
    boolean immediateFlush;
    Logger logger;
    LoggerContext context;
    double throughput;

    public IOPerformance(boolean _immediateFlush, long _len) {
        this.len = _len;
        this.immediateFlush = _immediateFlush;
        this.context = new LoggerContext();
        this.logger = this.context.getLogger("logger-" + this.getName());
        FileAppender fa = new FileAppender();
        fa.setName("FILE");
        PatternLayoutEncoder pa = new PatternLayoutEncoder();
        pa.setPattern("%r %5p %c [%t] - %m%n");
        pa.setContext((Context)this.context);
        pa.start();
        fa.setEncoder((Encoder)pa);
        fa.setFile(LOG_FILE);
        fa.setAppend(true);
        fa.setContext((Context)this.context);
        fa.start();
        ((ch.qos.logback.classic.Logger)this.logger).addAppender((Appender)fa);
        StatusPrinter.print((Context)this.context);
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length != 3) {
            IOPerformance.usage("Wrong number of arguments.");
        }
        l = Integer.parseInt(argv[0]);
        LOG_FILE = argv[1];
        PARALLEL_FILE = argv[2];
        IOPerformance.perfCase(true, l);
        IOPerformance.perfCase(false, l);
    }

    static void usage(String msg) {
        System.err.println(msg);
        System.err.println("Usage: java " + IOPerformance.class.getName() + " runLength logFile otherFile\n" + "   runLength (integer) the number of logs to generate perthread\n" + "   logFile path to a logFile\n" + "   otherFile path to a second file\n");
        System.exit(1);
    }

    static void perfCase(boolean immediateFlush, long len) throws Exception {
        int i;
        IOPerformance[] threads = new IOPerformance[NUM_THREADS];
        OtherIO otherIOThread = new OtherIO();
        otherIOThread.start();
        for (i = 0; i < NUM_THREADS; ++i) {
            threads[i] = new IOPerformance(immediateFlush, len);
        }
        for (i = 0; i < NUM_THREADS; ++i) {
            threads[i].start();
        }
        double sum = 0.0;
        for (int i2 = 0; i2 < NUM_THREADS; ++i2) {
            threads[i2].join();
            sum += threads[i2].throughput;
        }
        otherIOThread.interrupted = true;
        otherIOThread.join();
        System.out.println("On total throughput of " + sum + " logs per microsecond.");
        System.out.println("------------------------------------------------");
    }

    @Override
    public void run() {
        long before = System.nanoTime();
        int i = 0;
        while ((long)i < this.len) {
            this.logger.debug(MSG);
            ++i;
        }
        this.throughput = (double)this.len * 1.0 / (double)((System.nanoTime() - before) / 1000L);
        System.out.println(this.getName() + ", immediateFlush: " + this.immediateFlush + ", throughput: " + this.throughput + " logs per microsecond.");
    }

    static {
        NUM_THREADS = 1;
    }
}

