/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.core.BaseConnection;
import com.kingbase8.jdbc.AbstractBlobClob;
import com.kingbase8.largeobject.LargeObject;
import com.kingbase8.util.TraceLogger;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.logging.Level;

public class KbBlob
extends AbstractBlobClob
implements Blob {
    public KbBlob(BaseConnection _conn, long oid) throws SQLException {
        super(_conn, oid);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    @Override
    public synchronized InputStream getBinaryStream(long position, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkHasFreed();
        LargeObject subLO = this.getLo(false).copy();
        this.addSubLO(subLO);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (position > Integer.MAX_VALUE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            subLO.seek64(position - 1L, 0);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            subLO.seek((int)position - 1, 0);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return subLO.getInputStream(length);
    }

    @Override
    public synchronized int setBytes(long position, byte[] _bytes) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.setBytes(position, _bytes, 0, _bytes.length);
    }

    @Override
    public synchronized int setBytes(long position, byte[] _bytes, int _offset, int leng) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.assertPosition(position);
        this.getLo(true).seek((int)(position - 1L));
        this.getLo(true).write(_bytes, _offset, leng);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return leng;
    }
}

