/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.ssl;

import com.kingbase8.util.GT;
import com.kingbase8.util.KBLOGGER;
import com.kingbase8.util.TraceLogger;
import java.net.IDN;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public class KBjdbcHostnameVerifier
implements HostnameVerifier {
    public static final KBjdbcHostnameVerifier INSTANCE = new KBjdbcHostnameVerifier();
    private static final int TYPE_DNS_NAME = 2;
    private static final int TYPE_IP_ADDRESS = 7;
    public static final Comparator<String> HOSTNAME_PATTERN_COMPARATOR = new Comparator<String>(){

        private int _countChars(String _value, char chr) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int _count = 0;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int position = -1;
            while (true) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                position = _value.indexOf(chr, position + 1);
                if (position == -1) break;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ++_count;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return _count;
        }

        @Override
        public int compare(String o1, String o2) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int d1 = this._countChars(o1, '.');
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int d2 = this._countChars(o2, '.');
            if (d1 != d2) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return d1 > d2 ? 1 : -1;
            }
            int s1 = this._countChars(o1, '*');
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int s2 = this._countChars(o2, '*');
            if (s1 != s2) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return s1 < s2 ? 1 : -1;
            }
            int length1 = o1.length();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int l2 = o2.length();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (length1 != l2) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return length1 > l2 ? 1 : -1;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 0;
        }
    };

    @Override
    public boolean verify(String _hostname, SSLSession session) {
        Object s1;
        LdapName dnT;
        Collection<List<?>> subAltNamesT;
        String canonicalHostnameT;
        X509Certificate[] peerCertsT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            peerCertsT = (X509Certificate[])session.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String s12 = "Unable to parse X509Certificate for _hostname {0}";
            KBLOGGER.log(Level.SEVERE, GT.tr(s12, _hostname), e);
            return false;
        }
        if (peerCertsT == null || peerCertsT.length == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String s13 = "No certificates found for _hostname {0}";
            KBLOGGER.log(Level.SEVERE, GT.tr(s13, _hostname), new Object[0]);
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_hostname.startsWith("[") && _hostname.endsWith("]")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            canonicalHostnameT = _hostname.substring(1, _hostname.length() - 1);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                canonicalHostnameT = IDN.toASCII(_hostname);
                if (KBLOGGER.isLoggable(Level.FINEST)) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    String s14 = "Canonical _host name for {0} is {1}";
                    KBLOGGER.log(Level.FINEST, s14, _hostname, canonicalHostnameT);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String s15 = "Hostname {0} is invalid";
                KBLOGGER.log(Level.SEVERE, GT.tr(s15, _hostname), illegalArgumentException);
                return false;
            }
        }
        X509Certificate serverCert = peerCertsT[0];
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            subAltNamesT = serverCert.getSubjectAlternativeNames();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (subAltNamesT == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                subAltNamesT = Collections.emptyList();
            }
        }
        catch (CertificateParsingException certificateParsingException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.SEVERE, GT.tr("Unable to parse certificates for _hostname {0}", _hostname), certificateParsingException);
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean anyDnsSubAltNameT = false;
        for (List<?> sanItemList : subAltNamesT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (sanItemList.size() != 2) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                continue;
            }
            Integer subAltNameTypeT = (Integer)sanItemList.get(0);
            if (subAltNameTypeT == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                continue;
            }
            if (subAltNameTypeT != 7 && subAltNameTypeT != 2) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                continue;
            }
            String sanT = (String)sanItemList.get(1);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (subAltNameTypeT == 7 && sanT.startsWith("*")) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                continue;
            }
            anyDnsSubAltNameT |= subAltNameTypeT == 2;
            if (!this.verifyHostName(canonicalHostnameT, sanT)) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (KBLOGGER.isLoggable(Level.FINEST)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String s16 = "Server name validation pass for {0}, subjectAltName {1}";
                KBLOGGER.log(Level.FINEST, GT.tr(s16, _hostname, sanT), new Object[0]);
            }
            return true;
        }
        if (anyDnsSubAltNameT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String s17 = "Server name validation failed: certificate for _host {0} dNSName entries subjectAltName,";
            String s2 = " but none of them match. Assuming server name validation failed";
            KBLOGGER.log(Level.SEVERE, GT.tr(s17 + s2, _hostname), new Object[0]);
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            dnT = new LdapName(serverCert.getSubjectX500Principal().getName("RFC2253"));
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        catch (InvalidNameException invalidNameException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            s1 = "Server name validation failed: unable to extract common name";
            KBLOGGER.log(Level.SEVERE, GT.tr((String)s1 + " from X509Certificate for _hostname {0}", _hostname), invalidNameException);
            return false;
        }
        ArrayList<String> commonNamesList = new ArrayList<String>(1);
        for (Rdn rdnT : dnT.getRdns()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (!"CN".equals(rdnT.getType())) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            commonNamesList.add((String)rdnT.getValue());
        }
        if (commonNamesList.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            s1 = "Server name validation failed: certificate for _hostname {0} has no DNS subAltNames,";
            KBLOGGER.log(Level.SEVERE, GT.tr((String)s1 + " and it CommonName is missing as well", _hostname), new Object[0]);
            return false;
        }
        if (commonNamesList.size() > 1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Collections.sort(commonNamesList, HOSTNAME_PATTERN_COMPARATOR);
        }
        String commonNameT = (String)commonNamesList.get(commonNamesList.size() - 1);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean _result = this.verifyHostName(canonicalHostnameT, commonNameT);
        if (!_result) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.SEVERE, GT.tr("Server name validation failed: _hostname {0} does not match common name {1}", _hostname, commonNameT), new Object[0]);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return _result;
    }

    public boolean verifyHostName(String _hostname, String pat) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_hostname == null || pat == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        int lastStar = pat.lastIndexOf(42);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (lastStar == -1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return _hostname.equalsIgnoreCase(pat);
        }
        if (lastStar > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        if (pat.indexOf(46) == -1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        if (_hostname.length() < pat.length() - 1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        boolean ignoreCase = true;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int t_offset = _hostname.length() - pat.length() + 1;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_hostname.lastIndexOf(46, t_offset - 1) >= 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return _hostname.regionMatches(true, t_offset, pat, 1, pat.length() - 1);
    }
}

