/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.ssl;

import com.kingbase8.KBProperty;
import com.kingbase8.jdbc.SslMode;
import com.kingbase8.ssl.LazyKeyManager;
import com.kingbase8.ssl.NonValidatingFactory;
import com.kingbase8.ssl.PKCS12KeyManager;
import com.kingbase8.ssl.WrappedFactory;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.ObjectFactory;
import com.kingbase8.util.TraceLogger;
import java.io.Console;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Properties;
import java.util.logging.Level;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class LibKCIFactory
extends WrappedFactory {
    KeyManager keyManagerT;
    boolean defaultfileT;

    private CallbackHandler getCallbackHandler(Properties info) throws KSQLException {
        CallbackHandler callbackHandlerT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String sslpasswordcallbackT = KBProperty.SSL_PASSWORD_CALLBACK.get(info);
        if (sslpasswordcallbackT != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                callbackHandlerT = ObjectFactory.instantiate(CallbackHandler.class, sslpasswordcallbackT, info, false, null);
            }
            catch (Exception exception) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String e1 = "The password callback class provided {0} could not be instantiated.";
                throw new KSQLException(GT.tr(e1, sslpasswordcallbackT), KSQLState.CONNECTION_FAILURE, (Throwable)exception);
            }
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            callbackHandlerT = new ConsoleCallbackHandler(KBProperty.SSL_PASSWORD.get(info));
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return callbackHandlerT;
    }

    private void initPk8(String sslkeyfileT, String defaultdirT, Properties info) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String sslcertfileT = KBProperty.SSL_CERT.get(info);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (sslcertfileT == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.defaultfileT = true;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sslcertfileT = defaultdirT + "kingbase8.crt";
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String empty = "";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.keyManagerT = new LazyKeyManager(empty.equals(sslcertfileT) ? null : sslcertfileT, empty.equals(sslkeyfileT) ? null : sslkeyfileT, this.getCallbackHandler(info), this.defaultfileT);
    }

    private void initP12(String sslkeyfileT, Properties infoProps) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        CallbackHandler callbackHandler = this.getCallbackHandler(infoProps);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.keyManagerT = new PKCS12KeyManager(sslkeyfileT, callbackHandler);
    }

    public LibKCIFactory(Properties infoProps) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TrustManager[] trustManagers;
            String defaultdirT;
            SSLContext sslContext = SSLContext.getInstance("TLS");
            String pathsepT = System.getProperty("file.separator");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                defaultdirT = System.getenv("APPDATA") + pathsepT + "kingbase8" + pathsepT;
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                defaultdirT = System.getProperty("user.home") + pathsepT + ".kingbase8" + pathsepT;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String sslkeyfileT = KBProperty.SSL_KEY.get(infoProps);
            if (sslkeyfileT == null) {
                this.defaultfileT = true;
                sslkeyfileT = defaultdirT + "kingbase8.pk8";
            }
            if (sslkeyfileT.endsWith("pk8")) {
                this.initPk8(sslkeyfileT, defaultdirT, infoProps);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (sslkeyfileT.endsWith("p12")) {
                this.initP12(sslkeyfileT, infoProps);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            SslMode sslModeT = SslMode.of(infoProps);
            if (!sslModeT.verifyCertificate()) {
                trustManagers = new TrustManager[]{new NonValidatingFactory.NonValidatingTM()};
            } else {
                FileInputStream fileInputStream;
                KeyStore _keyStore;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
                try {
                    _keyStore = KeyStore.getInstance("jks");
                }
                catch (KeyStoreException keyStoreException) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    throw new NoSuchAlgorithmException("jks KeyStore not available");
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String sslrootcertfileT = KBProperty.SSL_ROOT_CERT.get(infoProps);
                if (sslrootcertfileT == null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    sslrootcertfileT = defaultdirT + "root.crt";
                }
                try {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    fileInputStream = new FileInputStream(sslrootcertfileT);
                }
                catch (FileNotFoundException ex) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    String e1 = "Could not open SSL root certificate file {0}.";
                    throw new KSQLException(GT.tr(e1, sslrootcertfileT), KSQLState.CONNECTION_FAILURE, (Throwable)ex);
                }
                try {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    Certificate[] certificates = certificateFactory.generateCertificates(fileInputStream).toArray(new Certificate[0]);
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _keyStore.load(null, null);
                    for (int i = 0; i < certificates.length; ++i) {
                        _keyStore.setCertificateEntry("cert" + i, certificates[i]);
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    trustManagerFactory.init(_keyStore);
                }
                catch (IOException ioException) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    String e1 = "Could not read SSL root certificate file {0}.";
                    throw new KSQLException(GT.tr(e1, sslrootcertfileT), KSQLState.CONNECTION_FAILURE, (Throwable)ioException);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    String e1 = "Loading the SSL root certificate {0} into a TrustManager failed.";
                    throw new KSQLException(GT.tr(e1, sslrootcertfileT), KSQLState.CONNECTION_FAILURE, (Throwable)generalSecurityException);
                }
                finally {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    try {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        fileInputStream.close();
                    }
                    catch (IOException ioException) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    }
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                trustManagers = trustManagerFactory.getTrustManagers();
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                sslContext.init(new KeyManager[]{this.keyManagerT}, trustManagers, null);
            }
            catch (KeyManagementException keyManagementException) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String e1 = "Could not initialize SSL context.";
                throw new KSQLException(GT.tr(e1, new Object[0]), KSQLState.CONNECTION_FAILURE, (Throwable)keyManagementException);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.sslSocketFactory = sslContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String e1 = "Could not find a java cryptographic algorithm: {0}.";
            throw new KSQLException(GT.tr(e1, noSuchAlgorithmException.getMessage()), KSQLState.CONNECTION_FAILURE, (Throwable)noSuchAlgorithmException);
        }
    }

    public void throwKeyManagerException() throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.keyManagerT != null) {
            if (this.keyManagerT instanceof LazyKeyManager) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ((LazyKeyManager)this.keyManagerT).throwKeyManagerException();
            }
            if (this.keyManagerT instanceof PKCS12KeyManager) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ((PKCS12KeyManager)this.keyManagerT).throwKeyManagerException();
            }
        }
    }

    public static class ConsoleCallbackHandler
    implements CallbackHandler {
        private char[] passwordT = null;

        public ConsoleCallbackHandler(String password) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (password != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.passwordT = password.toCharArray();
            }
        }

        @Override
        public void handle(Callback[] _callbacks) throws IOException, UnsupportedCallbackException {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Console console = System.console();
            if (console == null && this.passwordT == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String e1 = "Console is not available";
                throw new UnsupportedCallbackException(_callbacks[0], e1);
            }
            for (Callback _callback : _callbacks) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (!(_callback instanceof PasswordCallback)) {
                    throw new UnsupportedCallbackException(_callback);
                }
                PasswordCallback pwdCallbackT = (PasswordCallback)_callback;
                if (this.passwordT != null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    pwdCallbackT.setPassword(this.passwordT);
                    continue;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                pwdCallbackT.setPassword(console.readPassword("%s", pwdCallbackT.getPrompt()));
            }
        }
    }
}

