/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.sspi;

import com.kingbase8.core.KBStream;
import com.kingbase8.sspi.ISSPIClient;
import com.kingbase8.sspi.NTDSAPIWrapper;
import com.kingbase8.util.HostSpec;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import com.sun.jna.LastErrorException;
import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Sspi;
import com.sun.jna.platform.win32.Win32Exception;
import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import waffle.windows.auth.IWindowsCredentialsHandle;
import waffle.windows.auth.impl.WindowsCredentialsHandleImpl;
import waffle.windows.auth.impl.WindowsSecurityContextImpl;

public class SSPIClient
implements ISSPIClient {
    public static final String SSPI_DEFAULT_SPN_SERVICE_CLS = "POSTGRES";
    private final KBStream kbStream;
    private static final Logger loggerT = Logger.getLogger(SSPIClient.class.getName());
    private final boolean enNegotiateT;
    private final String spnServiceCls;
    private IWindowsCredentialsHandle clientCredentialsT;
    private String targetNameStr;
    private WindowsSecurityContextImpl SSPIContextT;

    public SSPIClient(KBStream kbStream, String spnServiceClass, boolean enNegotiate) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream = kbStream;
        if (spnServiceClass == null || spnServiceClass.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            spnServiceClass = SSPI_DEFAULT_SPN_SERVICE_CLS;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.spnServiceCls = spnServiceClass;
        this.enNegotiateT = enNegotiate;
    }

    @Override
    public boolean isSSPISupported() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            if (!Platform.isWindows()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                loggerT.log(Level.FINE, "SSPI not supported: non-Windows _host");
                return false;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Class.forName("waffle.windows.auth.impl.WindowsSecurityContextImpl");
            return true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            loggerT.log(Level.WARNING, "SSPI unavailable (no Waffle/JNA libraries?)", noClassDefFoundError);
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            loggerT.log(Level.WARNING, "SSPI unavailable (no Waffle/JNA libraries?)", classNotFoundException);
            return false;
        }
    }

    private String makeSPN() throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        HostSpec hostSpec = this.kbStream.getHostSpec();
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return NTDSAPIWrapper.instanceT.DsMakeSpn(this.spnServiceCls, hostSpec.getHost(), null, (short)hostSpec.getPort(), null);
        }
        catch (LastErrorException lastErrorException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException("SSPI setup failed to determine SPN", KSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)lastErrorException);
        }
    }

    @Override
    public void startSSPI() throws SQLException, IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String securityPackageT = this.enNegotiateT ? "negotiate" : "kerberos";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        loggerT.log(Level.FINEST, "Beginning SSPI/Kerberos negotiation with SSPI package: {0}", securityPackageT);
        try {
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.clientCredentialsT = WindowsCredentialsHandleImpl.getCurrent((String)securityPackageT);
                this.clientCredentialsT.initialize();
            }
            catch (Win32Exception win32Exception) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException("Could not obtain local Windows credentials for SSPI", KSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)win32Exception);
            }
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.targetNameStr = this.makeSPN();
                loggerT.log(Level.FINEST, "SSPI target name: {0}", this.targetNameStr);
                this.SSPIContextT = new WindowsSecurityContextImpl();
                this.SSPIContextT.setPrincipalName(this.targetNameStr);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.SSPIContextT.setCredentialsHandle(this.clientCredentialsT);
                this.SSPIContextT.setSecurityPackage(securityPackageT);
                this.SSPIContextT.initialize(null, null, this.targetNameStr);
            }
            catch (Win32Exception win32Exception) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException("Could not initialize SSPI security context", KSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)win32Exception);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.sendSSPIResponse_(this.SSPIContextT.getToken());
            loggerT.log(Level.FINEST, "Sent first SSPI negotiation message");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException("SSPI cannot be used, Waffle or its dependencies are missing from the classpath", KSQLState.NOT_IMPLEMENTED, (Throwable)noClassDefFoundError);
        }
    }

    @Override
    public void continueSSPI(int msgLen) throws SQLException, IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.SSPIContextT == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalStateException("Cannot continue SSPI authentication that we didn't begin");
        }
        loggerT.log(Level.FINEST, "Continuing SSPI negotiation");
        byte[] receivedTokenT = this.kbStream.receive(msgLen);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Sspi.SecBufferDesc continueTokenT = new Sspi.SecBufferDesc(2, receivedTokenT);
        this.SSPIContextT.initialize(this.SSPIContextT.getHandle(), continueTokenT, this.targetNameStr);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[] responseTokenT = this.SSPIContextT.getToken();
        if (responseTokenT.length > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.sendSSPIResponse_(responseTokenT);
            loggerT.log(Level.FINEST, "Sent SSPI negotiation continuation message");
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            loggerT.log(Level.FINEST, "SSPI authentication complete, no reply required");
        }
    }

    private void sendSSPIResponse_(byte[] outToken) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream.sendChar(112);
        this.kbStream.sendInteger4(4 + outToken.length);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream.send(outToken);
        this.kbStream.flush();
    }

    @Override
    public void dispose() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.SSPIContextT != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.SSPIContextT.dispose();
            this.SSPIContextT = null;
        }
        if (this.clientCredentialsT != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.clientCredentialsT.dispose();
            this.clientCredentialsT = null;
        }
    }
}

