/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.dsctn.persist;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.db.api.pojo.druid.DruidProperties;
import cn.stylefeng.roses.kernel.dsctn.api.exception.DatasourceContainerException;
import cn.stylefeng.roses.kernel.dsctn.api.exception.enums.DatasourceContainerExceptionEnum;
import cn.stylefeng.roses.kernel.dsctn.persist.sqladapter.AddDatabaseInfoSql;
import cn.stylefeng.roses.kernel.dsctn.persist.sqladapter.DatabaseListSql;
import cn.stylefeng.roses.kernel.dsctn.persist.sqladapter.DeleteDatabaseInfoSql;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataBaseInfoPersistence {
    private static final Logger log = LoggerFactory.getLogger(DataBaseInfoPersistence.class);
    private final DruidProperties druidProperties;

    public DataBaseInfoPersistence(DruidProperties druidProperties) {
        this.druidProperties = druidProperties;
    }

    public Map<String, DruidProperties> getAllDataBaseInfo() {
        HashMap<String, DruidProperties> hashMap;
        HashMap<String, DruidProperties> dataSourceList = new HashMap<String, DruidProperties>(16);
        Connection conn = null;
        try {
            Class.forName(this.druidProperties.getDriverClassName());
            conn = DriverManager.getConnection(this.druidProperties.getUrl(), this.druidProperties.getUsername(), this.druidProperties.getPassword());
            PreparedStatement preparedStatement = conn.prepareStatement(new DatabaseListSql().getSql(this.druidProperties.getUrl()));
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                DruidProperties druidProperties = this.createDruidProperties(resultSet);
                String dbName = resultSet.getString("db_name");
                dataSourceList.put(dbName, druidProperties);
            }
            hashMap = dataSourceList;
        }
        catch (Exception exception) {
            try {
                log.error("\u67e5\u8be2\u6570\u636e\u6e90\u4fe1\u606f\u9519\u8bef\uff01", (Throwable)exception);
                String userTip = StrUtil.format((CharSequence)DatasourceContainerExceptionEnum.QUERY_DBS_DAO_ERROR.getUserTip(), (Object[])new Object[]{exception.getMessage()});
                throw new DatasourceContainerException((AbstractExceptionEnum)DatasourceContainerExceptionEnum.QUERY_DBS_DAO_ERROR, new Object[]{userTip});
            }
            catch (Throwable throwable) {
                IoUtil.close(conn);
                throw throwable;
            }
        }
        IoUtil.close((AutoCloseable)conn);
        return hashMap;
    }

    public void createMasterDatabaseInfo() {
        Connection conn = null;
        try {
            Class.forName(this.druidProperties.getDriverClassName());
            conn = DriverManager.getConnection(this.druidProperties.getUrl(), this.druidProperties.getUsername(), this.druidProperties.getPassword());
            PreparedStatement preparedStatement = conn.prepareStatement(new AddDatabaseInfoSql().getSql(this.druidProperties.getUrl()));
            preparedStatement.setLong(1, IdWorker.getId());
            preparedStatement.setString(2, "master");
            preparedStatement.setString(3, this.druidProperties.getDriverClassName());
            preparedStatement.setString(4, this.druidProperties.getUrl());
            preparedStatement.setString(5, this.druidProperties.getUsername());
            preparedStatement.setString(6, this.druidProperties.getPassword());
            preparedStatement.setString(7, "\u4e3b\u6570\u636e\u6e90\uff0c\u9879\u76ee\u542f\u52a8\u6570\u636e\u6e90\uff01");
            preparedStatement.setString(8, DateUtil.formatDateTime((Date)new Date()));
            int i = preparedStatement.executeUpdate();
            log.info("\u521d\u59cb\u5316master\u7684databaseInfo\u4fe1\u606f\uff01\u521d\u59cb\u5316" + i + "\u6761\uff01");
        }
        catch (Exception exception) {
            try {
                log.error("\u521d\u59cb\u5316master\u7684databaseInfo\u4fe1\u606f\u9519\u8bef\uff01", (Throwable)exception);
                String userTip = StrUtil.format((CharSequence)DatasourceContainerExceptionEnum.INSERT_DBS_DAO_ERROR.getUserTip(), (Object[])new Object[]{exception.getMessage()});
                throw new DatasourceContainerException((AbstractExceptionEnum)DatasourceContainerExceptionEnum.INSERT_DBS_DAO_ERROR, new Object[]{userTip});
            }
            catch (Throwable throwable) {
                IoUtil.close(conn);
                throw throwable;
            }
        }
        IoUtil.close((AutoCloseable)conn);
    }

    public void deleteMasterDatabaseInfo() {
        Connection conn = null;
        try {
            Class.forName(this.druidProperties.getDriverClassName());
            conn = DriverManager.getConnection(this.druidProperties.getUrl(), this.druidProperties.getUsername(), this.druidProperties.getPassword());
            PreparedStatement preparedStatement = conn.prepareStatement(new DeleteDatabaseInfoSql().getSql(this.druidProperties.getUrl()));
            preparedStatement.setString(1, "master");
            int i = preparedStatement.executeUpdate();
            log.info("\u5220\u9664master\u7684databaseInfo\u4fe1\u606f\uff01\u5220\u9664" + i + "\u6761\uff01");
        }
        catch (Exception exception) {
            try {
                log.info("\u5220\u9664master\u7684databaseInfo\u4fe1\u606f\u5931\u8d25\uff01", (Throwable)exception);
                String userTip = StrUtil.format((CharSequence)DatasourceContainerExceptionEnum.DELETE_DBS_DAO_ERROR.getUserTip(), (Object[])new Object[]{exception.getMessage()});
                throw new DatasourceContainerException((AbstractExceptionEnum)DatasourceContainerExceptionEnum.DELETE_DBS_DAO_ERROR, new Object[]{userTip});
            }
            catch (Throwable throwable) {
                IoUtil.close(conn);
                throw throwable;
            }
        }
        IoUtil.close((AutoCloseable)conn);
    }

    private DruidProperties createDruidProperties(ResultSet resultSet) {
        DruidProperties newDruidProperties = new DruidProperties();
        BeanUtil.copyProperties((Object)this.druidProperties, (Object)newDruidProperties, (CopyOptions)CopyOptions.create().ignoreError());
        try {
            newDruidProperties.setDriverClassName(resultSet.getString("jdbc_driver"));
            newDruidProperties.setUrl(resultSet.getString("jdbc_url"));
            newDruidProperties.setUsername(resultSet.getString("username"));
            newDruidProperties.setPassword(resultSet.getString("password"));
        }
        catch (SQLException exception) {
            log.info("\u6839\u636e\u6570\u636e\u5e93\u67e5\u8be2\u7ed3\u679c\uff0c\u521b\u5efaDruidProperties\u5931\u8d25\uff01", (Throwable)exception);
            String userTip = StrUtil.format((CharSequence)DatasourceContainerExceptionEnum.CREATE_PROP_DAO_ERROR.getUserTip(), (Object[])new Object[]{exception.getMessage()});
            throw new DatasourceContainerException((AbstractExceptionEnum)DatasourceContainerExceptionEnum.CREATE_PROP_DAO_ERROR, new Object[]{userTip});
        }
        return newDruidProperties;
    }
}

