/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.log.api.context;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.log.api.pojo.entity.SysLogBusiness;
import java.util.LinkedList;
import java.util.List;

public class BusinessLogHolder {
    private static final ThreadLocal<SysLogBusiness> BUSINESS_LOG_CONTEXT = new ThreadLocal();
    private static final ThreadLocal<List<String>> CONTENT_LIST = new ThreadLocal();

    public static void setContext(SysLogBusiness sysLogBusiness) {
        BUSINESS_LOG_CONTEXT.set(sysLogBusiness);
    }

    public static SysLogBusiness getContext() {
        return BUSINESS_LOG_CONTEXT.get();
    }

    public static void clearContext() {
        BUSINESS_LOG_CONTEXT.remove();
        CONTENT_LIST.remove();
    }

    public static void addContent(String contentStr) {
        List<String> contentList = CONTENT_LIST.get();
        if (ObjectUtil.isEmpty(contentList)) {
            contentList = new LinkedList<String>();
        }
        contentList.add(contentStr);
        CONTENT_LIST.set(contentList);
    }

    public static List<String> getContent() {
        return CONTENT_LIST.get();
    }

    public static void setLogTitle(String logTitle) {
        SysLogBusiness sysLogBusiness = BUSINESS_LOG_CONTEXT.get();
        if (sysLogBusiness == null) {
            return;
        }
        sysLogBusiness.setLogTitle(logTitle);
        BUSINESS_LOG_CONTEXT.set(sysLogBusiness);
    }
}

