/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.stat.modular.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.stat.api.callback.ClickStatusCallback;
import cn.stylefeng.roses.kernel.stat.modular.entity.ClickStatus;
import cn.stylefeng.roses.kernel.stat.modular.enums.ClickStatusExceptionEnum;
import cn.stylefeng.roses.kernel.stat.modular.mapper.ClickStatusMapper;
import cn.stylefeng.roses.kernel.stat.modular.request.ClickStatusRequest;
import cn.stylefeng.roses.kernel.stat.modular.service.ClickStatusService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ClickStatusServiceImpl
extends ServiceImpl<ClickStatusMapper, ClickStatus>
implements ClickStatusService {
    @Override
    public void add(ClickStatusRequest portalClickStatusRequest) {
        ClickStatus portalClickStatus = new ClickStatus();
        BeanUtil.copyProperties((Object)((Object)portalClickStatusRequest), (Object)((Object)portalClickStatus), (String[])new String[0]);
        this.save((Object)portalClickStatus);
    }

    @Override
    public void del(ClickStatusRequest portalClickStatusRequest) {
        ClickStatus portalClickStatus = this.queryPortalClickStatus(portalClickStatusRequest);
        this.removeById(portalClickStatus.getClickStatusId());
    }

    @Override
    public void edit(ClickStatusRequest portalClickStatusRequest) {
        ClickStatus portalClickStatus = this.queryPortalClickStatus(portalClickStatusRequest);
        BeanUtil.copyProperties((Object)((Object)portalClickStatusRequest), (Object)((Object)portalClickStatus), (String[])new String[0]);
        this.updateById((Object)portalClickStatus);
    }

    @Override
    public ClickStatus detail(ClickStatusRequest portalClickStatusRequest) {
        return this.queryPortalClickStatus(portalClickStatusRequest);
    }

    @Override
    public PageResult<ClickStatus> findPage(ClickStatusRequest portalClickStatusRequest) {
        LambdaQueryWrapper<ClickStatus> wrapper = this.createWrapper(portalClickStatusRequest);
        Page sysRolePage = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)sysRolePage);
    }

    @Override
    public boolean getUserBusinessClickFlag(Long userId, Long businessId) {
        LambdaQueryWrapper portalClickStatusLambdaQueryWrapper = new LambdaQueryWrapper();
        portalClickStatusLambdaQueryWrapper.eq(ClickStatus::getUserId, (Object)userId);
        portalClickStatusLambdaQueryWrapper.eq(ClickStatus::getBusinessKeyId, (Object)businessId);
        long count = this.count((Wrapper)portalClickStatusLambdaQueryWrapper);
        return count > 0L;
    }

    @Override
    public List<ClickStatus> findList(ClickStatusRequest portalClickStatusRequest) {
        LambdaQueryWrapper<ClickStatus> wrapper = this.createWrapper(portalClickStatusRequest);
        return this.list((Wrapper)wrapper);
    }

    public <T extends ClickStatusCallback> void calcClickStatus(List<T> clickStatusCallbackList) {
        if (ObjectUtil.isEmpty(clickStatusCallbackList)) {
            return;
        }
        for (ClickStatusCallback clickStatusCallback : clickStatusCallbackList) {
            Long businessId;
            Long userId = clickStatusCallback.getUserId();
            boolean userBusinessClickFlag = this.getUserBusinessClickFlag(userId, businessId = clickStatusCallback.getBusinessId());
            if (!userBusinessClickFlag) continue;
            clickStatusCallback.addClickStatus();
        }
    }

    public void addClickStatus(ClickStatusCallback clickStatusCallback) {
        Long businessId;
        Long userId = clickStatusCallback.getUserId();
        boolean userBusinessClickFlag = this.getUserBusinessClickFlag(userId, businessId = clickStatusCallback.getBusinessId());
        if (userBusinessClickFlag) {
            return;
        }
        ClickStatus portalClickStatus = new ClickStatus();
        portalClickStatus.setUserId(userId);
        portalClickStatus.setBusinessType(clickStatusCallback.getBusinessTypeCode());
        portalClickStatus.setBusinessKeyId(businessId);
        this.save((Object)portalClickStatus);
    }

    private ClickStatus queryPortalClickStatus(ClickStatusRequest portalClickStatusRequest) {
        ClickStatus portalClickStatus = (ClickStatus)((Object)this.getById(portalClickStatusRequest.getClickStatusId()));
        if (ObjectUtil.isEmpty((Object)((Object)portalClickStatus))) {
            throw new ServiceException((AbstractExceptionEnum)ClickStatusExceptionEnum.PORTAL_CLICK_STATUS_NOT_EXISTED);
        }
        return portalClickStatus;
    }

    private LambdaQueryWrapper<ClickStatus> createWrapper(ClickStatusRequest portalClickStatusRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        Long clickStatusId = portalClickStatusRequest.getClickStatusId();
        Long userId = portalClickStatusRequest.getUserId();
        Long businessKeyId = portalClickStatusRequest.getBusinessKeyId();
        String businessType = portalClickStatusRequest.getBusinessType();
        queryWrapper.eq(ObjectUtil.isNotNull((Object)clickStatusId), ClickStatus::getClickStatusId, (Object)clickStatusId);
        queryWrapper.eq(ObjectUtil.isNotNull((Object)userId), ClickStatus::getUserId, (Object)userId);
        queryWrapper.eq(ObjectUtil.isNotNull((Object)businessKeyId), ClickStatus::getBusinessKeyId, (Object)businessKeyId);
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)businessType), ClickStatus::getBusinessType, (Object)businessType);
        return queryWrapper;
    }
}

