/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.async.pipeline.valve;

import com.alibaba.citrus.async.pipeline.valve.AsyncCallbackAdapter;
import com.alibaba.citrus.async.pipeline.valve.DoPerformRunnableValve;
import com.alibaba.citrus.service.pipeline.Pipeline;
import com.alibaba.citrus.service.pipeline.PipelineContext;
import com.alibaba.citrus.service.pipeline.Valve;
import com.alibaba.citrus.service.pipeline.impl.PipelineImpl;
import com.alibaba.citrus.service.pipeline.support.AbstractValveDefinitionParser;
import com.alibaba.citrus.service.requestcontext.RequestContext;
import com.alibaba.citrus.service.requestcontext.RequestContextChainingService;
import com.alibaba.citrus.service.requestcontext.util.RequestContextUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.turbine.pipeline.valve.AbstractInputOutputValve;
import com.alibaba.citrus.util.StringUtil;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.task.AsyncTaskExecutor;
import org.w3c.dom.Element;

public class PerformRunnableAsyncValve
extends AbstractInputOutputValve {
    static final String ASYNC_CALLBACK_KEY = "_async_callback_";
    private static final Logger log = LoggerFactory.getLogger(PerformRunnableAsyncValve.class);
    private long defaultTimeout = 0L;
    private long defaultCancelingTimeout = 1000L;
    @Autowired
    private RequestContextChainingService rccs;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private AsyncTaskExecutor executor;
    private Pipeline asyncPipeline;

    public long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public void setDefaultTimeout(long defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    public long getDefaultCancelingTimeout() {
        return this.defaultCancelingTimeout;
    }

    public void setDefaultCancelingTimeout(long defaultCancelingTimeout) {
        this.defaultCancelingTimeout = defaultCancelingTimeout;
    }

    public AsyncTaskExecutor getExecutor() {
        return this.executor;
    }

    public void setExecutor(AsyncTaskExecutor executor) {
        this.executor = executor;
    }

    public Pipeline getAsyncPipeline() {
        return this.asyncPipeline;
    }

    public void setAsyncPipeline(Pipeline asyncPipeline) {
        this.asyncPipeline = asyncPipeline;
    }

    protected String getDefaultOutputKey() {
        return ASYNC_CALLBACK_KEY;
    }

    protected boolean filterInputValue(Object inputValue) {
        return inputValue instanceof Callable || inputValue instanceof Runnable;
    }

    protected void init() throws Exception {
        if (this.asyncPipeline == null) {
            DoPerformRunnableValve valve = new DoPerformRunnableValve();
            valve.afterPropertiesSet();
            PipelineImpl pipeline = new PipelineImpl();
            pipeline.setValves(new Valve[]{valve});
            pipeline.afterPropertiesSet();
            this.asyncPipeline = pipeline;
        }
    }

    public void invoke(final PipelineContext pipelineContext) throws Exception {
        Object resultObject = this.consumeInputValue(pipelineContext);
        if (resultObject == null) {
            return;
        }
        RequestContext rc = RequestContextUtil.getRequestContext(this.request);
        final HttpServletRequest request = rc.getRequest();
        HttpServletResponse response = rc.getResponse();
        final AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        final AsyncCallbackAdapter callback = new AsyncCallbackAdapter(resultObject, asyncContext, this.getDefaultTimeout(), this.getDefaultCancelingTimeout());
        this.setOutputValue(pipelineContext, callback);
        asyncContext.setTimeout(callback.getTimeout());
        final CountDownLatch signal = new CountDownLatch(1);
        final Future future = this.executor.submit((Callable)new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() {
                try {
                    try {
                        PerformRunnableAsyncValve.this.rccs.bind(request);
                        PerformRunnableAsyncValve.this.asyncPipeline.newInvocation(pipelineContext).invoke();
                    }
                    finally {
                        PerformRunnableAsyncValve.this.rccs.unbind(request);
                    }
                }
                catch (Throwable e) {
                    log.error("[" + Thread.currentThread().getName() + "] Exception occurred while doing async task", e);
                }
                finally {
                    try {
                        asyncContext.complete();
                    }
                    catch (IllegalStateException e) {}
                    signal.countDown();
                }
                return null;
            }
        });
        asyncContext.addListener(new AsyncListener(){

            public void onComplete(AsyncEvent event) throws IOException {
            }

            public void onTimeout(AsyncEvent event) throws IOException {
                log.debug("Async task timed out.");
                future.cancel(true);
                try {
                    if (signal.await(callback.getCancelingTimeout(), TimeUnit.MILLISECONDS)) {
                        log.debug("Async task was cancelled");
                    } else {
                        log.debug("Async task is still running.  Tried to complete the task.");
                        try {
                            event.getAsyncContext().complete();
                        }
                        catch (IllegalStateException e) {}
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }

            public void onError(AsyncEvent event) throws IOException {
            }

            public void onStartAsync(AsyncEvent event) throws IOException {
            }
        });
        pipelineContext.invokeNext();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefinitionParser
    extends AbstractValveDefinitionParser<PerformRunnableAsyncValve> {
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            String executorRef;
            SpringExtUtil.attributesToProperties(element, builder, "input", "defaultTimeout", "defaultCancelingTimeout");
            Object asyncPipeline = this.parsePipeline(element, null, parserContext, null, true);
            if (asyncPipeline != null) {
                builder.addPropertyValue("asyncPipeline", asyncPipeline);
            }
            if ((executorRef = StringUtil.trimToNull(element.getAttribute("executor-ref"))) != null) {
                builder.addPropertyValue("executor", (Object)new RuntimeBeanReference(executorRef));
            }
        }
    }
}

