/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.jsp.impl;

import com.alibaba.citrus.service.AbstractService;
import com.alibaba.citrus.service.jsp.JspEngine;
import com.alibaba.citrus.service.jsp.impl.JspResponse;
import com.alibaba.citrus.service.jsp.impl.TemplateContextAdapter;
import com.alibaba.citrus.service.template.TemplateContext;
import com.alibaba.citrus.service.template.TemplateException;
import com.alibaba.citrus.service.template.TemplateNotFoundException;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.FileUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspEngineImpl
extends AbstractService<JspEngine>
implements JspEngine,
ResourceLoaderAware,
InitializingBean {
    private final ServletContext servletContext;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private ResourceLoader resourceLoader;
    private String contextRoot;
    private String path;

    public JspEngineImpl(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        this.servletContext = Assert.assertNotNull(servletContext, "servletContext", new Object[0]);
        this.request = SpringExtUtil.assertProxy(Assert.assertNotNull(request, "request", new Object[0]));
        this.response = SpringExtUtil.assertProxy(Assert.assertNotNull(response, "response", new Object[0]));
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setPath(String path) {
        this.path = StringUtil.trimToNull(path);
    }

    @Override
    protected void init() throws Exception {
        Assert.assertNotNull(this.resourceLoader, "resourceLoader", new Object[0]);
        if (this.path == null) {
            this.path = "/templates";
        }
        this.path = FileUtil.normalizeAbsolutePath(this.path + "/");
        URL url = this.servletContext.getResource("/");
        if (url != null) {
            this.contextRoot = url.toExternalForm();
        } else {
            String urlstr;
            url = this.servletContext.getResource("/WEB-INF/web.xml");
            if (url != null && (urlstr = url.toExternalForm()).endsWith("/WEB-INF/web.xml")) {
                this.contextRoot = urlstr.substring(0, urlstr.length() - "WEB-INF/web.xml".length());
            }
        }
        if (this.contextRoot == null) {
            throw new IllegalArgumentException("Could not find WEBROOT.  Are you sure you are in webapp?");
        }
        if (!this.contextRoot.endsWith("/")) {
            this.contextRoot = this.contextRoot + "/";
        }
        if (this.getLogger().isDebugEnabled()) {
            ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
            mb.append("path", this.path);
            mb.append("contextRoot", this.contextRoot);
            this.getLogger().debug(new ToStringBuilder().append("Initialized JSP Template Engine").append(mb).toString());
        }
    }

    @Override
    public String[] getDefaultExtensions() {
        return new String[]{"jsp", "jspx"};
    }

    @Override
    public boolean exists(String templateName) {
        return this.getPathWithinServletContextInternal(templateName) != null;
    }

    @Override
    public String getText(String template, TemplateContext context) throws TemplateException, IOException {
        String relativeTemplateName = this.getPathWithinServletContext(template);
        RequestDispatcher dispatcher = this.servletContext.getRequestDispatcher(relativeTemplateName);
        if (dispatcher == null) {
            throw new TemplateNotFoundException("Could not dispatch to JSP template " + template);
        }
        try {
            TemplateContextAdapter requestWrapper = new TemplateContextAdapter(this.request, context);
            JspResponse responseWrapper = new JspResponse(this.response);
            dispatcher.include((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
        }
        catch (ServletException e) {
            throw new TemplateException(e);
        }
        return "";
    }

    @Override
    public void writeTo(String templateName, TemplateContext context, OutputStream ostream) throws TemplateException, IOException {
        this.getText(templateName, context);
    }

    @Override
    public void writeTo(String templateName, TemplateContext context, Writer writer) throws TemplateException, IOException {
        this.getText(templateName, context);
    }

    @Override
    public String getPathWithinServletContext(String templateName) throws TemplateNotFoundException {
        String path = this.getPathWithinServletContextInternal(templateName);
        if (path == null) {
            throw new TemplateNotFoundException("Template " + templateName + " not found");
        }
        return path;
    }

    private String getPathWithinServletContextInternal(String templateName) {
        this.assertInitialized();
        String resourceName = this.path + (templateName.startsWith("/") ? templateName.substring(1) : templateName);
        Resource resource = this.resourceLoader.getResource(resourceName);
        String path = null;
        if (resource != null && resource.exists()) {
            try {
                String url = resource.getURL().toExternalForm();
                if (url.startsWith(this.contextRoot)) {
                    path = url.substring(this.contextRoot.length() - 1);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return path;
    }

    @Override
    public String toString() {
        return "JspEngine[" + this.path + "]";
    }
}

