/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.resource.impl;

import com.alibaba.citrus.service.resource.Resource;
import com.alibaba.citrus.service.resource.ResourceFilter;
import com.alibaba.citrus.service.resource.ResourceFilterChain;
import com.alibaba.citrus.service.resource.ResourceLoadingOption;
import com.alibaba.citrus.service.resource.ResourceMatchResult;
import com.alibaba.citrus.service.resource.ResourceNotFoundException;
import com.alibaba.citrus.service.resource.impl.ResourcePattern;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceFilterMapping
extends ResourcePattern {
    private static final Logger log = LoggerFactory.getLogger(ResourceFilterMapping.class);
    private ResourceFilter[] filters;

    public ResourceFilter[] getFilters() {
        return this.filters;
    }

    public void setFilters(ResourceFilter[] filters) {
        this.filters = filters;
    }

    public String getPatternType() {
        return "resource-filters";
    }

    protected void init() {
        if (this.filters == null) {
            this.filters = new ResourceFilter[0];
        }
        for (ResourceFilter filter : this.filters) {
            filter.init(this.getResourceLoadingService());
        }
    }

    public ResourceFilterChain getResourceFilterChain(final ResourceFilterChain root) {
        if (ArrayUtil.isEmptyArray(this.filters)) {
            return root;
        }
        return new ResourceFilterChain(){
            private int i = 0;

            @Override
            public Resource doFilter(ResourceMatchResult filterMatchResult, Set<ResourceLoadingOption> options) throws ResourceNotFoundException {
                if (this.i < ResourceFilterMapping.this.filters.length) {
                    ResourceFilter filter = ResourceFilterMapping.this.filters[this.i++];
                    String resourceName = filterMatchResult.getResourceName();
                    log.debug("Applying filter to resource \"{}\": {}", (Object)resourceName, (Object)filter);
                    return filter.doFilter(filterMatchResult, options, this);
                }
                return root.doFilter(filterMatchResult, options);
            }
        };
    }

    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        mb.append("pattern", this.getPatternName());
        mb.append("filters", this.getFilters());
        return new ToStringBuilder().append(this.getClass().getSimpleName()).append(mb).toString();
    }
}

